.module/ram/abs=0       Basci_Function_Demo;

{This program shows how the functions of the Basic Window are received}

.CONST  Sport1_Autobuf_Ctrl=    0x3fef;
.CONST  Sport1_Rfsdiv=          0x3ff0;
.CONST  Sport1_Sclkdiv=         0x3ff1;
.CONST  Sport1_Ctrl_Reg=        0x3ff2;
.CONST  Sport0_Autobuf_Ctrl=    0x3ff3;
.CONST  Sport0_Rfsdiv=          0x3ff4;
.CONST  Sport0_Sclkdiv=         0x3ff5;
.CONST  Sport0_Ctrl_Reg=        0x3ff6;
.CONST  Sport0_TX_Channels0=    0x3ff7;
.CONST  Sport0_TX_Channels1=    0x3ff8;
.CONST  Sport0_RX_Channels0=    0x3ff9;
.CONST  Sport0_RX_Channels1=    0x3ffa;
.CONST  Tscale_Reg=             0x3ffb;
.CONST  Tcount_Reg=             0x3ffc;
.CONST  Tperiod_Reg=            0x3ffd;
.CONST  DM_Wait_Reg=            0x3ffe;
.CONST  Sys_Ctrl_Reg=           0x3fff;
.CONST  BDMA_ctrl=              0x3fe3;
.CONST  BWCOUNT=                0x3fe4;
.CONST  BEAD=                   0x3fe2;
.CONST  BIAD=                   0X3FE1;
.CONST  BufferStart=		  0x000A;		

{monitor registers }
.Const FLAG		=0x03FDF;
.Const BYTE		=0x03FDE;
.Const CODES	=0x03FDD;
.Const STORE	=0x03FDC;
.Const BYTE1	=0x03FDB;
.Const WORD1	=0x03FDA;
.Const BYTE2	=0x03FD9;
.Const LATCH	=0x03FD8;
.Const VERSION	=0x03FD7;
.Const STACK1	=0x03FD6;
.Const STACK2	=0x03FD5;
.Const STACK3	=0x03FD4;




ISR_RESET:          jump start;	RTI; RTI; RTI;  
ISR_IRQ2:           RTI;		RTI; RTI; RTI;    
ISR_IRQ1:           RTI;		RTI; RTI; RTI;  
ISR_IRQ0:           RTI;		RTI; RTI; RTI;  
ISR_S0_TRANSMIT:    RTI;		RTI; RTI; RTI;  
ISR_S0_RECEIVE:     RTI;		RTI; RTI; RTI;  
ISR_IRQE:           i4=0x30ff; call (i4);RTI; RTI;  
ISR_BDMA:           RTI;		RTI; RTI; RTI;  
ISR_S1_TRANSMIT:    RTI;        	RTI; RTI; RTI;
ISR_S1_RECEIVE:     RTI;        	RTI; RTI; RTI;  
ISR_TIMER:          RTI;	      RTI; RTI; RTI;  
ISR_POWERDOWN:      RTI;		RTI; RTI; RTI;  




start: 		{set up the timer}
			ax0=0x6fff; dm(0x3ffd)=ax0; dm(0x3ffc)=ax0;
                  ax0=255; dm(0x3ffb)=ax0;
			{start the timer }{flash the LED a few times to indicate
			that the program has downloaded properly}
                  mstat=0x20; 
			imask=0x011; {enable the timer and IRQE interrupts}
			
			{flash the LED a few times to indicate
			that the program has downloaded properly}
			ax0=5; call flashled;

			{set memory map}
			dmovlay=0;







	{******* System and memory Setup *******}

	ax0=b#0001100000000000;       dm(Sys_Ctrl_Reg)=ax0;

	ifc=b#0000000011111111;
	icntl = b#00100;
	
{=========== now wait for the PC to send instructions ===================}

                 
GetCommand:		i4=0x302c; call (i4);		{call readstring command}
                  ax0=dm(byte2);    /* interpret command type */
                  ay1 = 0x0001; AR = AX0 - AY1; IF EQ jump sendversion;
                  ay1 = 0x0008; AR = AX0 - AY1; IF EQ jump 0x30ff; {reset command}
                  ay1 = 0x000A; AR = AX0 - AY1; IF EQ jump CommandSent;	
                  ay1 = 0x000B; AR = AX0 - AY1; IF EQ jump UploadData;
			jump GetCommand; {command not recognised}


SendVersion:	i4=0x3025; call(i4); 		{call sendversion function}
			jump GetCommand;

CommandSent:	{a command has been received by the DSP}
			ax0=dm(byte1); {This is the Identifier byte}
			ay0=dm(word1); {this is the Command Word}
			call FlashLED; {flash the led}

			jump GetCommand;





UploadData:		{get the start address}
			i1=dm(word1);l1=0;m1=1;
		
			i4=0x302c; call (i4);	{get the number of words to upload}
			ar=dm(word1);

			{begin uploadind data}
			ay1=1;		
			i4=0x30e1; 			{upload word function}

repeat:		ax0=dm(i1,m1);
			dm(store)=ax0;
			call (i4);
			ar=ar-ay1;
			if ne jump repeat;

			ax0=3; call flashLED;
			jump GetCommand;		{all done}	








FlashLED:		{this routine will flash the LED a number of times to indicate
			that an operation has been completed successfully. The number
			of times is determinded by AX0}
			ar=pass ax0; if ne jump NotZero;
			rts;
NotZero:		imask=0x011; {enable the timer and IRQE interrupts}
			cntr=ax0; do flash until ce;
			idle; toggle fl2;
			idle; 
Flash:		toggle fl2;
			imask=0x010;	{stop the timer interrupting}
			rts;


			

.endmod;






