.module/ram/abs=0       Read_4_Channels;

{this program reads data from ADC channel 1 ,2 ,3 & 4 }

.CONST  Sport1_Autobuf_Ctrl=    0x3fef;
.CONST  Sport1_Rfsdiv=          0x3ff0;
.CONST  Sport1_Sclkdiv=         0x3ff1;
.CONST  Sport1_Ctrl_Reg=        0x3ff2;
.CONST  Sport0_Autobuf_Ctrl=    0x3ff3;
.CONST  Sport0_Rfsdiv=          0x3ff4;
.CONST  Sport0_Sclkdiv=         0x3ff5;
.CONST  Sport0_Ctrl_Reg=        0x3ff6;
.CONST  Sport0_TX_Channels0=    0x3ff7;
.CONST  Sport0_TX_Channels1=    0x3ff8;
.CONST  Sport0_RX_Channels0=    0x3ff9;
.CONST  Sport0_RX_Channels1=    0x3ffa;
.CONST  Tscale_Reg=             0x3ffb;
.CONST  Tcount_Reg=             0x3ffc;
.CONST  Tperiod_Reg=            0x3ffd;
.CONST  DM_Wait_Reg=            0x3ffe;
.CONST  Sys_Ctrl_Reg=           0x3fff;
.CONST  BDMA_ctrl=              0x3fe3;
.CONST  BWCOUNT=                0x3fe4;
.CONST  BEAD=                   0x3fe2;
.CONST  BIAD=                   0X3FE1;
.CONST  BufferStart=		  0x000A;		

{monitor registers }
.Const FLAG		=0x03FDF;
.Const BYTE		=0x03FDE;
.Const CODES	=0x03FDD;
.Const STORE	=0x03FDC;
.Const BYTE1	=0x03FDB;
.Const WORD1	=0x03FDA;
.Const BYTE2	=0x03FD9;
.Const LATCH	=0x03FD8;
.Const VERSION	=0x03FD7;
.Const STACK1	=0x03FD6;
.Const STACK2	=0x03FD5;
.Const STACK3	=0x03FD4;




ISR_RESET:          jump start;	RTI; RTI; RTI;  
ISR_IRQ2:           RTI;		RTI; RTI; RTI;    
ISR_IRQ1:           RTI;		RTI; RTI; RTI;  
ISR_IRQ0:           RTI;		RTI; RTI; RTI;  
ISR_S0_TRANSMIT:    RTI;		RTI; RTI; RTI;  
ISR_S0_RECEIVE:     jump RxInt;	RTI; RTI; RTI;  
ISR_IRQE:           i4=0x30ff; call (i4);RTI; RTI;  
ISR_BDMA:           RTI;		RTI; RTI; RTI;  
ISR_S1_TRANSMIT:    RTI;        	RTI; RTI; RTI;
ISR_S1_RECEIVE:     RTI;        	RTI; RTI; RTI;  
ISR_TIMER:          jump isr;	      RTI; RTI; RTI;  
ISR_POWERDOWN:      RTI;		RTI; RTI; RTI;  

{This program will program and read data from channel 1 of the AD73360}



start: 		set fl2; {turn on led}
                  ax0=0x6fff; dm(0x3ffd)=ax0; dm(0x3ffc)=ax0;
                  ax0=255; dm(0x3ffb)=ax0;
                  mstat=0x20; imask=0x011; 
			dmovlay=0;
			i0=0;m0=1;l0=0;
			reset fl0;reset fl1;reset fl2;

			{**** load control words into memory *******}
			{CRB  5432109876543210}
			ax0=b#1000000100001111;dm(i0,m0)=ax0;
				{SCLK=MCLK=DMCLK,Fs=DMCLK/256=64KHz}
			{CRC}
			ax0=b#1000001001100000;dm(i0,m0)=ax0;
				{REFout Enabled,Ref PowerON}
			{CRD}
                        ax0=b#1000001110001000;dm(i0,m0)=ax0;
				{Channel 1 On, 2  On - Gain = 0dB}
			{CRE}
			ax0=b#1000010010001000;dm(i0,m0)=ax0;
				{Channel 3 On, 4 On - Gain = 0dB}
			{CRF}
                        ax0=b#1000010100000000;dm(i0,m0)=ax0;
                                {Channel 5 Off, 6  Off - Gain = 0dB}
			{CRG}
			ax0=b#1000011000000000;dm(i0,m0)=ax0;
				{All Channels Diff Ended}
			{CRH}
			ax0=b#1000011100000000;dm(i0,m0)=ax0;
				{No Channels Inverted}
			{CRA}
			ax0=b#1000000000000001;dm(i0,m0)=ax0;
				{Enable Data Mode}

{=============== setup the serial ports ==============================}			

	ax0=b#0000000000000000;       dm(SPORT0_Autobuf_Ctrl) = ax0;
	ax0=0;                        dm(SPORT0_RFSDIV) = ax0;
						dm(SPORT0_SCLKDIV) = ax0;
	ax0=b#0010100000001111;       dm(SPORT0_Ctrl_Reg) = ax0;
	ax0=b#0000000000000000;       dm(SPORT0_TX_Channels0) = ax0;
						dm(SPORT0_TX_Channels1) = ax0;
						dm(SPORT0_RX_Channels0) = ax0;
						dm(SPORT0_RX_Channels1) = ax0;

	{******** SPORT 1 Setup ********* }

	ax0=0;                        dm(SPORT1_Autobuf_Ctrl) = ax0;
						dm(SPORT1_RFSDIV) = ax0;
						dm(SPORT1_SCLKDIV) = ax0;
						dm(SPORT1_Ctrl_Reg) = ax0;


	{******* System and memory Setup *******}

	ax0=b#0001100000000000;       dm(Sys_Ctrl_Reg)=ax0;

	ifc=b#0000000011111111;
	icntl = b#00010;
	
{=========== now wait for the PC to send instructions ===================}

                 
GetCommand:		i4=0x302c; call (i4);		{call readstring command}
                  ax0=dm(byte2);    /* interpret command type */
                  ay1 = 0x0001; AR = AX0 - AY1; IF EQ jump sendversion;
                  ay1 = 0x0007; AR = AX0 - AY1; IF EQ jump takesamples;
                  ay1 = 0x0008; AR = AX0 - AY1; IF EQ jump 0x30ff;
			jump GetCommand;	{command not recognised}
			
SendVersion:	i4=0x3025; call(i4); 		{call sendversion function}
			jump GetCommand;

TakeSamples:	
			i0=0;	l0=8;	m0=1;
			i1=BufferStart; l1=0; m1=1;
			ax0=dm(0); tx0=ax0; {preload transmit register}
			imask=b#00000100000;	{stop led flashing}
			set fl1;set fl0;	{bring SE and RESET high}
			


LetRefSettle:	{take a load of samples and disguard them while
			the reference is powering up.}
			ar=4000; ay1=1;
LRS:			idle;		
			ar=ar-ay1;
			if ne jump LRS;

			{now take samples for real}
			set fl2; reset fl2;
                        i1=BufferStart; l1=0; m1=1;
			ay1=1; 

			call NumSamples; {get number of samples to take}			
                        ay0=100; ar=ar+ay0; {take a few extra samples}
FillMemory:		idle;	{wait for RxInterrupt}
			ar=ar-ay1;
			if ne jump fillmemory;

DataRead:
			reset fl1; reset fl0;

			i4=0x3074; call(i4);	{call showready function}

			{begin uploadind data}
                        i1=BufferStart+1;       {this is ADC1s first sample}
                        l1=0;m1=1;
			ay1=1;		
			i4=0x30e1; 			{upload word function}
			call NumSamples;

repeat:		ax0=dm(i1,m1);
			dm(store)=ax0;
			call (i4);
			ar=ar-ay1;
			if ne jump repeat;

			imask=0x011;		{restart LED flashing to indicate success}
			jump GetCommand;		{all done}	



isr:			toggle fl2; rti;

RxInt:		ax0=dm(i0,m0); tx0=ax0; {Transmit Control Word}
			ax0=rx0;	
			dm(i1,m1)=ax0; {Store Received Data}
			rti;




NumSamples:		{function returns the number of samples required in AR }
			ax0=dm(byte1); {number of channels}
			ar=0;
			cntr=ax0;
                  ay0=dm(word1);
                  do addchannels until ce;
                        ar=ar+ay0;
addchannels:		nop;
			{ar contains the number of samples to take}		
			rts;


.endmod;






