#!/usr/bin/env python3
import math
import re
import sys

# Local variables
tdqsq, dqs_en, lpbk_en, ext_lpbk_en, nand2_delay, flash_setup, tx_flash_setup, clk_period, board_delay = (0.4, 0, 1, 0, 30, 5, 1.8, 10, 5)
mini_dll_phy_ctrl, dll_phy_ctrl_reg, dll_phy_tsel_reg, dll_phy_tsel_reg, dll_phy_dq_timing_reg, dll_phy_dqs_timing_reg, dll_phy_gate_lpbk_ctrl_reg, dll_phy_dll_master_ctrl_reg, dll_phy_dll_slave_ctrl_reg = (0, 0, 0, 0, 0, 0, 0, 0, 0)
oe_start, oe_end, oe_end_dqsd, oe_start_data, oe_end_data, oe_end_dqsd_data, total_delay_in_dqs_driven_by_device, total_delay_in_dqs_toggle_by_device, dll_phy_gate_open_delay, gate_open_delay, dll_phy_rd_delay, rd_del_sel, phony_dqs_timing, rd_data_valid_delay, gate_close_delay, sum0, sum1, half_cycle_mode, use_dll_action, out_cycle_margin, quater_cycle_period, flash_setup_period, sdr_edge_active, dll_start_point, dll_start_point_required, each_delay_element, number_of_elements_required_tx, number_of_elements_required_rx, number_of_elements_tx, number_of_elements_rx, array = (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
debug = 0

try:
    INPUT = open("flash_phy_reg_input.txt", "r")
except IOError:
    sys.exit("cannot open the input file\n")

array = INPUT.readlines()
for array in array:
    array = array.rstrip("\n")
    m = re.match(r"^dqs_en\s+(\d+\.*\d*)$", array)
    if m:
        dqs_en = float(m.group(1))
        #print("dqs_en = {}".format(dqs_en))
    else:
        m = re.match(r"^lpbk_en\s+(\d+\.*\d*)$", array)
        if m:
            lpbk_en = float(m.group(1))
            #print("lpbk_en = {}".format(lpbk_en))
        else:
                m = re.match(r"^clk_period\s+(\d+\.*\d*)$", array)
                if m:
                    clk_period = float(m.group(1))
                    #print("clk_period = {}".format(clk_period))
                else:
                    m = re.match(r"^flash_setup\s+(\d+\.*\d*)$", array)
                    if m:
                        flash_setup = float(m.group(1))
                        #print("flash_setup = {}".format(flash_setup))
                    else:
                        m = re.match(r"^tx_flash_setup\s+(\d+\.*\d*)$", array)
                        if m:
                            tx_flash_setup = float(m.group(1))
                            #print("tx_flash_setup = {}".format(tx_flash_setup))
                        else:
                            m = re.match(r"^board_delay\s+(\d+\.*\d*)$", array)
                            if m:
                                board_delay1 = float(m.group(1))
                                board_delay = 1 + board_delay1
                            else:
                                m = re.match(r"^tdqsq\s+(\d+\.*\d*)$", array)
                                if m:
                                    tdqsq = float(m.group(1))
                                else:
                                    #print("Unsupported parameter or typo : {}".format(array))
                                    pass
INPUT.close()

nand2_delay = 42
ext_lpbk_en = 0
def modulo_real(dividend, divider):
    #sub modulo_real {
    if divider == 0 or dividend == 0:
        return 0
    else:
        return dividend/divider - int(dividend/divider)

def debug_proc(*args):
    #sub debug_proc{
    #my ($dbranch, $divider) = @_;
    for item in args:
        print(item)

def calculate_timing_cnt_for_reg(timing, clock):
    #sub calculate_timing_cnt_for_reg {
    if timing > 0:
        if modulo_real(timing, clock) > 0:
            return int(timing/clock)
        else:
            return int(timing/clock) - 1
    else:
        return 0

##---------------------------------------------------------------------------------------------------------
# xSPI with DQS value generation.
##---------------------------------------------------------------------------------------------------------

#############################################################################
if dqs_en == 1:
    gate_open_delay = 0
else:
    gate_open_delay = int(board_delay/clk_period)

if gate_open_delay > 15:
    dll_phy_gate_open_delay = 15
    print("ERROR : gate_open_delay overflow \n")
else:
    dll_phy_gate_open_delay = gate_open_delay
dll_phy_gate_open_delay = format(dll_phy_gate_open_delay, "x")  # %01x equivalent

dll_phy_rd_delay = math.ceil((board_delay)/clk_period)

if dll_phy_rd_delay <= 29:
    rd_del_sel = dll_phy_rd_delay + 3
else:
    print("ERROR : rd_del_sel overflow \n")

sum0 = format(rd_del_sel << 3, "02x")
temp_val = int("00" + sum0 + "003" + dll_phy_gate_open_delay, 16)
dll_phy_gate_lpbk_ctrl_reg = format(temp_val, "08x")

#check if clock period (in ps) is bigger than the delay of the whole delay line (with 10% margin - instead of checking 256 elements we check only 230)
if (clk_period * 1000) > int(230 * 2 * nand2_delay):
    half_cycle_mode = 1
else:
    half_cycle_mode = 0

# check if half clock period will be locked properly by the DLL - minimum requirement to lock
if ((clk_period * 1000)/2) < int(230 * 2 * nand2_delay):
    use_dll_action = 1
else:
    use_dll_action = 0
quater_cycle_period = ((clk_period * 1000)/4)

#sampling shift is supposed to provide half clock cycle resolution to cover
#any flash transfer modes.

# maximum outside cycle margin assumed for the script
# is 0.4 ns. Pure Flash timings exceeding 1 cycle can still
# capture valid data if the capture edge will be negative
# as configurable by sdr_edge_active.
out_cycle_margin = 0.4

if dqs_en == 1:
    flash_setup_period = (tdqsq)/(clk_period)
elif lpbk_en == 1 or ext_lpbk_en == 1:
    if (flash_setup + out_cycle_margin) >= clk_period:
        flash_setup_period = flash_setup + out_cycle_margin - clk_period
        sdr_edge_active = 1
    elif flash_setup > (clk_period/2):
        flash_setup_period = flash_setup - (clk_period/2)
    else:
        flash_setup_period = 0
else: #default
    flash_setup_period = 0

each_delay_element = 2 * nand2_delay
dll_start_point_required = 0.8 * (clk_period * 1000) / each_delay_element  #80% of period is recommended by spec

if dqs_en == 1:
    number_of_elements_required_tx = math.ceil(quater_cycle_period/each_delay_element)
    if use_dll_action == 1:
        number_of_elements_required_rx = flash_setup_period * 256 + 0.01 * 256
    else:
        number_of_elements_required_rx = math.ceil((tdqsq * 1000)/each_delay_element) + 1
elif lpbk_en == 1 or ext_lpbk_en == 1:
    number_of_elements_required_tx = math.ceil(quater_cycle_period/each_delay_element)
    #Set sampling point after Flash setup + 10% of clock period.
    if use_dll_action == 1:
        if flash_setup_period == 0:
            #Take advantage of hold timing. Do not add margin.
            number_of_elements_required_rx = math.ceil(256 * ((flash_setup_period)/clk_period))
        else:
            #add 25 elements more to guarantee minimal skew.
            number_of_elements_required_rx = math.ceil(256 * ((flash_setup_period)/clk_period)) + 25
    else:
        number_of_elements_required_rx = math.ceil((flash_setup_period * 1000)/each_delay_element) + 1
else: #default
    number_of_elements_required_tx = math.ceil(quater_cycle_period/each_delay_element)
    number_of_elements_required_rx = math.ceil(quater_cycle_period/each_delay_element)

#TX direction
#(If input flash setup is greater than quarter of cycle - skew margin (assumed 1/20 of cycle),
#this value should be taken, otherwise assign quarter)
if math.ceil((tx_flash_setup * 1000)/each_delay_element) > (math.ceil(quater_cycle_period/each_delay_element) - math.ceil((quater_cycle_period/each_delay_element)/5)):
    number_of_elements_required_tx = math.ceil((tx_flash_setup * 1000)/each_delay_element) - math.ceil((quater_cycle_period/each_delay_element)/5)
else:
    number_of_elements_required_tx = math.ceil(quater_cycle_period/each_delay_element)

if number_of_elements_required_tx < 256:
    number_of_elements_tx = number_of_elements_required_tx
else:
    number_of_elements_tx = 255

if number_of_elements_required_rx < 256:
    number_of_elements_rx = number_of_elements_required_rx
else:
    number_of_elements_rx = 255

if dll_start_point_required < 256:
    dll_start_point = dll_start_point_required
else:
    dll_start_point = 255

number_of_elements_tx = format(int(number_of_elements_tx), "02x")
number_of_elements_rx = format(int(number_of_elements_rx), "02x")
dll_start_point = format(int(dll_start_point), "02x")

dll_phy_ctrl_reg = format(int("00004000", 16), "08x")
dll_phy_tsel_reg = format(int("00000000", 16), "08x")

#----------------------------------------------------------------------
oe_end = 4
oe_end = format(oe_end, "x")

oe_start = 0
oe_start = format(oe_start, "x")
#----------------------------------------------------------------------

oe_end_data = 1
oe_end_data = format(oe_end_data, "x")
#----------------------------------------------------------------------

dll_phy_dq_timing_reg = format(int("0000" + oe_start + oe_end_data + oe_start + oe_end_data, 16), "08x")
if dqs_en == 1:
    dll_phy_dqs_timing_reg = int("0000" + oe_start + oe_end + oe_start + oe_end, 16)
elif lpbk_en == 1:
    dll_phy_dqs_timing_reg = int("0030" + oe_start + oe_end + oe_start + oe_end, 16)
elif ext_lpbk_en == 1:
    dll_phy_dqs_timing_reg = int("0070" + oe_start + oe_end + oe_start + oe_end, 16)
else:
    dll_phy_dqs_timing_reg = int("0030" + oe_start + oe_end + oe_start + oe_end, 16)
dll_phy_dqs_timing_reg = format(dll_phy_dqs_timing_reg, "08x")

if use_dll_action:
    dll_phy_dll_master_ctrl_reg = format(int(("0014_00" .replace("_", "") + dll_start_point), 16), "08x")
    if dqs_en == 1:
        if math.ceil((tx_flash_setup * 1000)/each_delay_element) > math.ceil(quater_cycle_period/each_delay_element):
            dll_phy_dll_slave_ctrl_reg = int("000015" + number_of_elements_rx, 16)
        else:
            dll_phy_dll_slave_ctrl_reg = int("000033" + number_of_elements_rx, 16)
    else:
        if math.ceil((tx_flash_setup * 1000)/each_delay_element) > math.ceil(quater_cycle_period/each_delay_element):
            dll_phy_dll_slave_ctrl_reg = int("000015" + number_of_elements_rx, 16)
        else:
            dll_phy_dll_slave_ctrl_reg = int("000033" + number_of_elements_rx, 16)
    dll_phy_dll_slave_ctrl_reg = format(dll_phy_dll_slave_ctrl_reg, "08x")
else:
    dll_phy_dll_master_ctrl_reg = format(int("00800000", 16), "08x")
    # It is assumed that for low speeds data is stable after half cycle of the clock
    if dqs_en == 1:
        # (tx_flash_setup > quarter + some margin)
        if math.ceil((tx_flash_setup * 1000)/each_delay_element) > math.ceil(quater_cycle_period/each_delay_element) - 5:
            dll_phy_dll_slave_ctrl_reg = int("000005" + number_of_elements_rx, 16)
        else:
            dll_phy_dll_slave_ctrl_reg = int("0000" + number_of_elements_tx + number_of_elements_rx, 16)
    else:
        # (tx_flash_setup > quarter + some margin)
        if math.ceil((tx_flash_setup * 1000)/each_delay_element) > math.ceil(quater_cycle_period/each_delay_element) - 5:
            dll_phy_dll_slave_ctrl_reg = int("000005" + number_of_elements_rx, 16)
        else:
            dll_phy_dll_slave_ctrl_reg = int("0000" + number_of_elements_tx + number_of_elements_rx, 16)
    dll_phy_dll_slave_ctrl_reg = format(dll_phy_dll_slave_ctrl_reg, "08x")

if sdr_edge_active == 0:
    mini_dll_phy_ctrl = format(int("00000707", 16), "08x")
else:
    mini_dll_phy_ctrl = format(int("00200707", 16), "08x")

# From file\n
DLL_PHY_CTRL_XSPI = int(mini_dll_phy_ctrl, 16) 
PHY_CTRL_REG_XSPI = int(dll_phy_ctrl_reg, 16) 
PHY_TSEL_REG_XSPI = int(dll_phy_tsel_reg, 16)
PHY_DQ_TIMING_REG_XSPI = int(dll_phy_dq_timing_reg, 16) 
PHY_DQS_TIMING_REG_XSPI = int(dll_phy_dqs_timing_reg, 16) 
PHY_GATE_LPBK_CTRL_REG_XSPI = int(dll_phy_gate_lpbk_ctrl_reg, 16) 
PHY_DLL_MASTER_CTRL_REG_XSPI = int(dll_phy_dll_master_ctrl_reg, 16) 
PHY_DLL_SLAVE_CTRL_REG_XSPI = int(dll_phy_dll_slave_ctrl_reg, 16) 


#Word0 bit position\n")
BITP_PHYCONFIG_WORD0_SDR_EDGE_ACTIVE = 30
BITP_PHYCONFIG_WORD0_DQS_LASTDROP_EN = 29
BITP_PHYCONFIG_WORD0_DATA_CLKPER_DELAY = 28
BITP_PHYCONFIG_WORD0_RESYNC_HIWAIT_CNT = 24
BITP_PHYCONFIG_WORD0_RESYNC_IDLE_CNT = 16
BITP_PHYCONFIG_WORD0_DATA_TSEL_START = 12
BITP_PHYCONFIG_WORD0_DATA_TSEL_END = 8
BITP_PHYCONFIG_WORD0_DATA_OE_START = 5
BITP_PHYCONFIG_WORD0_DATA_OE_END = 2
BITP_PHYCONFIG_WORD0_USE_LPBK_DQS = 1
BITP_PHYCONFIG_WORD0_PHONY_DQS_SEL = 0
#Word1 bit position
BITP_PHYCONFIG_WORD1_READ_DELAY_SEL_EMPTY = 30
BITP_PHYCONFIG_WORD1_READ_DELAY_SEL = 25
BITP_PHYCONFIG_WORD1_DQS_TSEL_START = 21
BITP_PHYCONFIG_WORD1_DQS_TSEL_END = 17
BITP_PHYCONFIG_WORD1_LPBK_ERRCHK_TIMING = 14
BITP_PHYCONFIG_WORD1_LPBK_FAIL_MUXSEL = 13
BITP_PHYCONFIG_WORD1_LPBK_CONTROL = 11
BITP_PHYCONFIG_WORD1_LPBK_INTERNAL = 10
BITP_PHYCONFIG_WORD1_LPBK_EN = 9
BITP_PHYCONFIG_WORD1_GATE_CFG_CLOSE = 5
BITP_PHYCONFIG_WORD1_GATE_CFG = 1
BITP_PHYCONFIG_WORD1_RESERVED_BIT0 = 0
#Word2 bit position
BITP_PHYCONFIG_WORD2_DLL_BYPASS_EN = 31
BITP_PHYCONFIG_WORD2_DLL_LOCK_NUM = 28
BITP_PHYCONFIG_WORD2_DLL_START = 20
BITP_PHYCONFIG_WORD2_CLK_WR_DELAY = 12
BITP_PHYCONFIG_WORD2_READ_DQS_DLEAY = 4
BITP_PHYCONFIG_WORD2_IE_ALWAYS_ON = 3
BITP_PHYCONFIG_WORD2_PHASE_DETECT_SEL = 0
# Initialize variables
XspiPhyWord0 = 0
XspiPhyWord1 = 0
XspiPhyWord2 = 0
XspiPhyWord3 = 0
# PHY WORD 0 Configuration
XspiPhyWord0 = 0
# SDR_EDGE_ACTIVE
temp = (DLL_PHY_CTRL_XSPI & 0x00200000) >> 21
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_SDR_EDGE_ACTIVE
# DQS_LASTDROP_EN
temp = (DLL_PHY_CTRL_XSPI & 0x00100000) >> 20
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DQS_LASTDROP_EN
# DATA_CLKPER_DELAY
temp = (PHY_DQ_TIMING_REG_XSPI & 0x00010000) >> 16
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DATA_CLKPER_DELAY
# RESYNC_HIWAIT_CN
temp = (DLL_PHY_CTRL_XSPI & 0x00000F00) >> 8
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_RESYNC_HIWAIT_CNT
# RESYNC_IDLE_CNT
temp = (DLL_PHY_CTRL_XSPI & 0x000000FF) >> 0
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_RESYNC_IDLE_CNT
# DATA_TSEL_START
temp = (PHY_DQ_TIMING_REG_XSPI & 0x0000F000) >> 12
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DATA_TSEL_START
# DATA_TSEL_END
temp = (PHY_DQ_TIMING_REG_XSPI & 0x00000F00) >> 8
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DATA_TSEL_END
# DATA_OE_START
temp = (PHY_DQ_TIMING_REG_XSPI & 0x00000070) >> 4
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DATA_OE_START
# DATA_OE_END
temp = (PHY_DQ_TIMING_REG_XSPI & 0x00000007) >> 0
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_DATA_OE_END
# USE_LPBK_DQS
temp = (PHY_DQS_TIMING_REG_XSPI & 0x00200000) >> 21
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_USE_LPBK_DQS
# PHONY_DQS_SEL
temp = (PHY_DQS_TIMING_REG_XSPI & 0x00010000) >> 16
XspiPhyWord0 |= temp << BITP_PHYCONFIG_WORD0_PHONY_DQS_SEL
# PHY WORD 1 Configuration
XspiPhyWord1 = 0
# DELAY_SEL
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00F80000) >> 19
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_READ_DELAY_SEL
# DQS_TSEL_START
temp = (PHY_DQS_TIMING_REG_XSPI & 0x0000F000) >> 12
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_DQS_TSEL_START
# DQS_TSEL_END
temp = (PHY_DQS_TIMING_REG_XSPI & 0x00000F00) >> 8
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_DQS_TSEL_END
# LPBK_ERRCHK_TIMING
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x0000E000) >> 13
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_LPBK_ERRCHK_TIMING
# LPBK_FAIL_MUXSEL
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00001000) >> 12
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_LPBK_FAIL_MUXSEL
# LPBK_CONTROL
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00000C00) >> 10
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_LPBK_CONTROL
# LPBK_INTERNAL
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00000200) >> 9
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_LPBK_INTERNAL
# LPBK_EN
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00000100) >> 8
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_LPBK_EN
# GATE_CFG_CLOSE
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x00000030) >> 4
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_GATE_CFG_CLOSE
# GATE_CFG
temp = (PHY_GATE_LPBK_CTRL_REG_XSPI & 0x0000000F) >> 0
XspiPhyWord1 |= temp << BITP_PHYCONFIG_WORD1_GATE_CFG
# PHY WORD 2 Configuration
XspiPhyWord2 = 0
# DLL_BYPASS_EN
temp = (PHY_DLL_MASTER_CTRL_REG_XSPI & 0x00800000) >> 23
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_DLL_BYPASS_EN
# DLL_LOCK_NUM
temp = (PHY_DLL_MASTER_CTRL_REG_XSPI & 0x00070000) >> 16
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_DLL_LOCK_NUM
# DLL_START
temp = (PHY_DLL_MASTER_CTRL_REG_XSPI & 0x000000FF) >> 0
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_DLL_START
# CLK_WR_DELAY
temp = (PHY_DLL_SLAVE_CTRL_REG_XSPI & 0x0000FF00) >> 8
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_CLK_WR_DELAY
# READ_DQS_DLEAY
temp = (PHY_DLL_SLAVE_CTRL_REG_XSPI & 0x000000FF) >> 0
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_READ_DQS_DLEAY
# IE_ALWAYS_ON
XspiPhyWord2 |= 1 << BITP_PHYCONFIG_WORD2_IE_ALWAYS_ON
# PHASE_DETECT_SEL
temp = (PHY_DLL_MASTER_CTRL_REG_XSPI & 0x00700000) >> 20
XspiPhyWord2 |= temp << BITP_PHYCONFIG_WORD2_PHASE_DETECT_SEL
# PHY WORD 3 Configuration
XspiPhyWord3 = 0
# Print Phy Configuration SSLD Structure Format
print(f"PHY CONFIG word0  = 0x{XspiPhyWord0:x}")
print(f"PHY CONFIG word1  = 0x{XspiPhyWord1:x}")
print(f"PHY CONFIG word2  = 0x{XspiPhyWord2:x}")
print(f"PHY CONFIG word3  = 0x{XspiPhyWord3:x}")
