/*****************************************************************************
 * Stress_Test1_Core0.h
 *****************************************************************************/

#ifndef __STRESS_TEST1_CORE0_H__
#define __STRESS_TEST1_CORE0_H__

#include "adi_initialize.h"
#include <sys/platform.h>
#include <sys/adi_core.h>
#include "time.h"
#include "stdio.h"

//Macro to configure MDMA
#define MDMA_CONFIG(S_MDMA_CHANNEL,S_CFG, S_ADDRSTART, S_MOD, S_COUNT,D_MDMA_CHANNEL,D_CFG, D_ADDRSTART, D_MOD, D_COUNT)\
		*pREG_DMA##S_MDMA_CHANNEL##_CFG = S_CFG;\
		*pREG_DMA##S_MDMA_CHANNEL##_ADDRSTART = S_ADDRSTART;\
		*pREG_DMA##S_MDMA_CHANNEL##_XCNT = S_COUNT;\
		*pREG_DMA##S_MDMA_CHANNEL##_XMOD = S_MOD;\
		*pREG_DMA##D_MDMA_CHANNEL##_CFG = D_CFG;\
		*pREG_DMA##D_MDMA_CHANNEL##_ADDRSTART = D_ADDRSTART;\
		*pREG_DMA##D_MDMA_CHANNEL##_XCNT = D_COUNT;\
		*pREG_DMA##D_MDMA_CHANNEL##_XMOD = D_MOD;\
		*pREG_DMA##D_MDMA_CHANNEL##_CFG|= 0x1;\
		*pREG_DMA##S_MDMA_CHANNEL##_CFG|= 0x1;

//Macro to disable the MDMAs
#define DISABLE_MDMAs(S_MDMA_CHANNEL, D_MDMA_CHANNEL)\
		*pREG_DMA##S_MDMA_CHANNEL##_CFG = 0;\
		*pREG_DMA##D_MDMA_CHANNEL##_CFG = 0;

#define ENABLE_SPORT_DMA_62_5MBPS
#define ENABLE_MDMA0_DMA_2000MBPS
#define ENABLE_MDMA1_DMA_2000MBPS
#define ENABLE_MDMA2_DMA_2000MBPS
#define ENABLE_MDMA3_DMA_4000MBPS

#define PAGE_SIZE 2048
#define ROWS_PER_BANK 16384
#define BANK_SIZE PAGE_SIZE*ROWS_PER_BANK

#define SOURCE_MSIZE_MDMA0 32

//#define USE_SINGLE_BANK

//T1
#define USE_MULTIPLE_BANKS


//T2
//#define LIMIT_MDMA0_BW 200
//#define LIMIT_MDMA1_BW 200
//#define LIMIT_MDMA2_BW 300
//#define LIMIT_MDMA3_BW 400

//T3
#define LIMIT_MDMA0_BW 100
#define LIMIT_MDMA1_BW 100
#define LIMIT_MDMA2_BW 400
#define LIMIT_MDMA3_BW 500



#ifdef USE_MULTIPLE_BANKS
	#define PPI0_DMA_DMC_START_ADDRESS  0x80000000+0*BANK_SIZE
	#define MDMA2_DMA_DMC_START_ADDRESS 0x80000000+1*BANK_SIZE
	#define MDMA3_DMA_DMC_START_ADDRESS 0x80000000+2*BANK_SIZE
	#define MDMA1_DMA_DMC_START_ADDRESS 0x80000000+3*BANK_SIZE
	#define MDMA0_DMA_DMC_START_ADDRESS 0x80000000+4*BANK_SIZE
#endif

#ifdef USE_SINGLE_BANK
	#define SPORT_DMA_DMC_START_ADDRESS	0x80000000
	#define MDMA2_DMA_DMC_START_ADDRESS 0x80000000+4*1*PAGE_SIZE*4
	#define MDMA3_DMA_DMC_START_ADDRESS 0x80000000+4*2*PAGE_SIZE*4
	#define MDMA1_DMA_DMC_START_ADDRESS 0x80000000+4*3*PAGE_SIZE*4
	#define MDMA0_DMA_DMC_START_ADDRESS 0x80000000+4*4*PAGE_SIZE*4
#endif


#define SOURCE_MDMA_CHANNEL 18
#define DEST_MDMA_CHANNEL 19


#define SOURCE_PSIZE_MDMA0 		 4
#define DEST_PSIZE_MDMA0   		 4
#define SOURCE_MSIZE_MDMA0		 32
#define DEST_MSIZE_MDMA0  		 32
#define SOURCE_DMA_CFG_MDMA0 	 ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO
#define DEST_DMA_CFG_MDMA0		 BITM_DMA_CFG_WNR|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO


#define SOURCE_PSIZE_MDMA1 		 4
#define DEST_PSIZE_MDMA1   		 4
#define SOURCE_MSIZE_MDMA1		 32
#define DEST_MSIZE_MDMA1  		 32
#define SOURCE_DMA_CFG_MDMA1 	 ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO
#define DEST_DMA_CFG_MDMA1		 BITM_DMA_CFG_WNR|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO


#define SOURCE_PSIZE_MDMA2 		 4
#define DEST_PSIZE_MDMA2   		 4
#define SOURCE_MSIZE_MDMA2		 32
#define DEST_MSIZE_MDMA2  		 32
#define SOURCE_DMA_CFG_MDMA2 	 ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO
#define DEST_DMA_CFG_MDMA2		 BITM_DMA_CFG_WNR|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO

#define SOURCE_PSIZE_MDMA3		 8
#define DEST_PSIZE_MDMA3   		 8
#define SOURCE_MSIZE_MDMA3 		 32
#define DEST_MSIZE_MDMA3   		 32
#define SOURCE_DMA_CFG_MDMA3 	 ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_PSIZE08|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO
#define DEST_DMA_CFG_MDMA3 		 BITM_DMA_CFG_WNR|ENUM_DMA_CFG_PSIZE08|ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_XCNT_INT|ENUM_DMA_CFG_AUTO

#define CCLK_SPEED 1000
#define SYSCLK_SPEED 500.0
#define SCLK_SPEED 125.0

#define MAX_SIZE 4*PAGE_SIZE


#endif
