/* This example code can be used to measure MMR latency for different peripheral registers defined in "registers.dat" file */
#include "MMR_Latency.h"
#include <sys/platform.h>
#include "adi_initialize.h"
#include "stdio.h"

/** 
 * If you want to use command program arguments, then place them in the following string. 
 */
char __argv_string[] = "";


volatile uint32_t* pRegisterArray[]=
{
	#include "registers.dat"
};

clock_t cycle_start;
clock_t cycle_stop;
int cycles_write;
int cycles_read;


int main(int argc, char *argv[])
{
	adi_initComponents();
	
	int final_count1,start_count1,final_count2,start_count2,temp;

	START_CYCLE_COUNT
	for(int i=0; i<TOTAL_REGISTERS; i++)
	{
		TAKE_CYCLE_SNAPSHOT_WRITE
			*pRegisterArray[i]=0;
			asm("sync;");
		TAKE_CYCLE_SNAPSHOT_WRITE


		TAKE_CYCLE_SNAPSHOT_READ
			temp = *pRegisterArray[i] ;
		TAKE_CYCLE_SNAPSHOT_READ

		PRINT_CYCLES

	}

	return 0;
}

