#ifndef __MAIN_H__
#define __MAIN_H__

/*=============  INCLUDES  =============*/
#include <services/dma/adi_dma.h>
#include <services/spu/adi_spu.h>
#include <services/tru/adi_tru.h>
#include <services/pwr/adi_pwr.h>
#include <stdio.h>
#include "adi_initialize.h"
#include <sys/platform.h>
#include "math.h"
#include "stdlib.h"

/*=============  DEFINES   =============*/
/* Enable macro to display debug information */
#define ENABLE_DEBUG_INFO

/* Memory Copy time out value */
#define MEMCOPY_TIME_OUT_VAL        (0x7FFFFFFu)

#define MDMA0_SRC_DMA8_SPU_PID      (110u)
#define MDMA0_DST_DMA9_SPU_PID      (111u)
#define MDMA1_SRC_DMA18_SPU_PID      (112u)
#define MDMA1_DST_DMA19_SPU_PID      (113u)
#define MDMA2_SRC_DMA39_SPU_PID      (101u)
#define MDMA3_SRC_DMA43_SPU_PID      (102u)

#define SOFT0_TRIGGER_MASTER_ID		 (68u)

#define MDMA0_SRC_TRIGGER_SLAVE_ID		 (88u)
#define MDMA0_DST_TRIGGER_SLAVE_ID		 (89u)
#define MDMA1_SRC_TRIGGER_SLAVE_ID		 (90u)
#define MDMA1_DST_TRIGGER_SLAVE_ID		 (91u)
#define MDMA2_SRC_TRIGGER_SLAVE_ID		 (92u)
#define MDMA2_DST_TRIGGER_SLAVE_ID		 (93u)
#define MDMA3_SRC_TRIGGER_SLAVE_ID		 (94u)
#define MDMA3_DST_TRIGGER_SLAVE_ID		 (95u)

#define TRU0_SLV0_TRIGGER_SLAVE_ID		 (78u)

/* Maximum transfer size in bytes */
#define MAX_MEMCOPY_BUF_SIZE	16384

/* IF (Debug info enabled) */
#if defined(ENABLE_DEBUG_INFO)
#define DBG_MSG                     printf
#else
#define DBG_MSG(...)
#endif

/* Maximum number of test combinations */
#define MAX_TEST_COMBINATIONS 1000

/* Change the test parameter input file name here if required */
#define TEST_PARAM_INPUT_FILE "testparam.dat"

/* Enumeration for different type of memories */
typedef enum MEMTYPE
{
	L1MEM,
	L2MEM,
	L3MEM
} MEMTYPE;

typedef struct TEST_PARAM
{
	int32_t 			TestIndex;			/* Test index */
	ADI_DMA_STREAM_ID 	eStreamID;			/* Stream ID */
	MEMTYPE  			eSourceMem;			/* Source memory type (L1/L2/L3) or direct address */
	MEMTYPE 			eDestMem;			/* Destination memory type (L1/L2/L3) or direct address */
	uint32_t			BuffCount;			/* Buffer count in MSIZE unit */
	ADI_DMA_MSIZE		eMsizeCfg;			/* Element width or MSIZE configuration to be used */
} TEST_PARAM;

typedef struct FAILURE_INFO
{
	uint32_t		TestIndex;
	ADI_DMA_RESULT	ErrorCode;
}FAILURE_INFO;

typedef struct TEST_INFO
{
	TEST_PARAM 		*pTestParamList;
	uint32_t 		FailCount;
	FAILURE_INFO	FailedTestInfo[MAX_TEST_COMBINATIONS];
}TEST_INFO;



#endif /* __MAIN_H__ */
