#ifndef __MAIN_H__
#define __MAIN_H__

/*=============  INCLUDES  =============*/
#include <services/dma/adi_dma.h>
#include <services/spu/adi_spu.h>
#include <services/pwr/adi_pwr.h>
#include <stdio.h>
#include "adi_initialize.h"
#include <sys/platform.h>
#include "math.h"
#include "stdlib.h"
#include "time.h"

/*=============  DEFINES   =============*/
/* Memory Copy time out value */
#define MEMCOPY_TIME_OUT_VAL        (0x7FFFFFFu)

#define MDMA3_SPU_PID      			(102u)
#define EMDMA_SPU_PID      			(121u)

/* Maximum transfer size in bytes */
#define MEMCOPY_BUF_SIZE	4096

/* MDMA MSIZE */
#define MDMA_MSIZE_BYTES	4

/* Start address offset for circular buffer transfer */
#define INDEX_OFFSET 1024

/* IF (Debug info enabled) */
#if defined(ENABLE_DEBUG_INFO)
#define DBG_MSG                     printf
#else
#define DBG_MSG(...)
#endif

#define ENABLE_EMDMA_CIRCULAR 			/* Enable this macro to enable circular EMDMA transfer */
#define ENABLE_MDMA_MSIZE4_CIRCULAR		/* Enable this macro to enable emulated circular MDMA transfer with MSIZE 4 bytes */
#define ENABLE_MDMA_MSIZE32_CIRCULAR	/* Enable this macro to enable emulated circular MDMA transfer with MSIZE 32 btyes */

#define CHECK_RESULT(eResult) \
        if(eResult != 0)\
		{\
			DBG_MSG("CHECK_RESULT failed at line %d of file %s \n",__LINE__,__FILE__);\
			;\
        }

#endif /* __MAIN_H__ */
