/*********************************************************************************

Copyright(c) 2018 Analog Devices, Inc. All Rights Reserved.

This software is proprietary and confidential.  By using this software you agree
to the terms of the associated Analog Devices License Agreement.

*********************************************************************************/
#ifndef __MAIN_H__
#define __MAIN_H__

/*=============  INCLUDES  =============*/
#include <services/dma/adi_dma.h>
#include <services/spu/adi_spu.h>
#include <services/tru/adi_tru.h>
#include <stdio.h>
#include "adi_initialize.h"
#include <sys/platform.h>
#include "math.h"
#include "stdlib.h"
#include "time.h"

/*=============  DEFINES   =============*/
/* Enable macro to display debug information */
#define ENABLE_DEBUG_INFO

/* Enable this macro to use mdma1DAuto API instead of mdma1D */
//#define USE_MDMA1D_AUTO

#define SYSCLK 1000

/* Memory Copy time out value */
#define MEMCOPY_TIME_OUT_VAL        (0x7FFFFFFu)

#define MDMA0_SRC_DMA8_SPU_PID      (110u)
#define MDMA0_DST_DMA9_SPU_PID      (111u)
#define MDMA1_SRC_DMA18_SPU_PID      (112u)
#define MDMA1_DST_DMA19_SPU_PID      (113u)
#define MDMA2_SRC_DMA39_SPU_PID      (101u)
#define MDMA3_SRC_DMA43_SPU_PID      (102u)

#define SOFT0_TRIGGER_MASTER_ID		 (68u)

#define MDMA0_SRC_TRIGGER_SLAVE_ID		 (88u)
#define MDMA0_DST_TRIGGER_SLAVE_ID		 (89u)
#define MDMA1_SRC_TRIGGER_SLAVE_ID		 (90u)
#define MDMA1_DST_TRIGGER_SLAVE_ID		 (91u)
#define MDMA2_SRC_TRIGGER_SLAVE_ID		 (92u)
#define MDMA2_DST_TRIGGER_SLAVE_ID		 (93u)
#define MDMA3_SRC_TRIGGER_SLAVE_ID		 (94u)
#define MDMA3_DST_TRIGGER_SLAVE_ID		 (95u)

#define TRU0_SLV0_TRIGGER_SLAVE_ID		 (78u)

/* Maximum transfer size in bytes */
#define MAX_MEMCOPY_BUF_SIZE	16384

/* IF (Debug info enabled) */
#if defined(ENABLE_DEBUG_INFO)
#define DBG_MSG                     printf
#else
#define DBG_MSG(...)
#endif

/* Maximum number of test combinations */
#define MAX_TEST_COMBINATIONS 1000

/* Change the test parameter input file name here if required */
#if 1
	#define TEST_PARAM_INPUT_FILE "testparam.dat"
#else
	#define TEST_PARAM_INPUT_FILE "testparam_cache.dat"
#endif

/* Enumeration for different type of memories */
typedef enum MEMTYPE
{
	L1MEM,
	L2MEM,
	L3MEM
} MEMTYPE;

typedef struct TEST_PARAM
{
	int32_t 			TestIndex;			/* Test index */
	ADI_DMA_STREAM_ID 	eStreamID;			/* Stream ID */
	MEMTYPE  			eSourceMem;			/* Source memory type (L1/L2/L3) or direct address */
	MEMTYPE 			eDestMem;			/* Destination memory type (L1/L2/L3) or direct address */
	uint32_t			BuffCount;			/* Buffer count in MSIZE unit */
	ADI_DMA_MSIZE		eMsizeCfg;			/* Element width or MSIZE configuration to be used */
	bool				bEnableCallback;	/* Use interrupt of polling method to check for the MDMA completion */
} TEST_PARAM;

typedef struct FAILURE_INFO
{
	uint32_t		TestIndex;
	ADI_DMA_RESULT	ErrorCode;
}FAILURE_INFO;

typedef struct TEST_INFO
{
	TEST_PARAM 		*pTestParamList;
	uint32_t 		FailCount;
	FAILURE_INFO	FailedTestInfo[MAX_TEST_COMBINATIONS];
}TEST_INFO;

volatile int cycle_count;
volatile int cycles_array[1000];
volatile clock_t clock_stop;
volatile clock_t clock_start;

#define START_CYCLE_COUNT\
		cycle_count=0;\
		clock_start = clock();

#define TAKE_CYCLE_SNAPSHOT\
	clock_stop = clock();\
	cycles_array[cycle_count] = clock_stop - clock_start;\
	cycle_count++;\
	clock_start = clock_stop;\

#define PRINT_CYCLES\
	int cc1;\
	for(cc1=0;cc1<cycle_count;cc1++)\
	{ \
		printf("\nCycle count for snapshot %d = %d \n",cc1,cycles_array[cc1]);\
	}


#define PRINT_DRIVER_OVERHEAD\
		int cc, j, k=0,  m;\
		j=cycles_array[1];\
		printf("\nAPI Overhead = %d, ",cycles_array[3]);\
		for(cc=5;cc<cycle_count;cc++)\
		{\
			if(cycles_array[cc]>(j+10))\
			{\
				if(k==0)\
					k=cycles_array[cc];\
			}\
		}\
		m=k-j;\
		printf("Interrupt Overhead = %d \n",m);\

#endif /* __MAIN_H__ */
