#ifndef __MAIN_H__
#define __MAIN_H__

/*=============  INCLUDES  =============*/
#include <services/dma/adi_dma.h>
#include <services/spu/adi_spu.h>
#include <services/tru/adi_tru.h>
#include <stdio.h>
#include "adi_initialize.h"
#include <sys/platform.h>
#include "math.h"
#include "time.h"
#include "stdlib.h"
/*=============  DEFINES   =============*/
/* Enable macro to display debug information */
#define ENABLE_DEBUG_INFO

/* Memory Copy time out value */
#define MEMCOPY_TIME_OUT_VAL        (0x7FFFFFFu)

/* SPU PID for MDMA0 Source */
#define EMDMA_SPU_PID      (121u)

/* Maximum number of descriptors */
#define MAX_DESCRIPTORS 32

/* Maximum transfer size in bytes */
#define MAX_MEMCOPY_BUF_SIZE	4096

/* IF (Debug info enabled) */
#if defined(ENABLE_DEBUG_INFO)
#define DBG_MSG                     printf
#else
#define DBG_MSG(...)
#endif

#define SCLK_SPEED 1000.0

/* Maximum number of test combinations */
#define MAX_TEST_COMBINATIONS 1000

/* Change the test parameter input file name here if required */
#define TEST_PARAM_INPUT_FILE "testparam.dat"

/* Enumeration for different type of memories */
typedef enum MEMTYPE
{
	L1MEM,
	L2MEM,
	L3MEM
} MEMTYPE;

typedef struct TEST_PARAM
{
	int32_t 				TestIndex;			/* Test index */
	ADI_EMDMA_STREAM_ID		eStreamID;			/* Stream ID */
	MEMTYPE  				eIntMem;			/* Internal memory type (L1/L2/L3) or direct address */
	MEMTYPE 				eExtMem;			/* External memory type (L1/L2/L3) or direct address */
	ADI_EMDMA_TRANSFER_MODE	eMode;				/* Mode */
	uint32_t				BuffCount;			/* Buffer count in 32 bit words */
} TEST_PARAM;

typedef struct FAILURE_INFO
{
	uint32_t		TestIndex;
	ADI_EMDMA_RESULT	ErrorCode;
}FAILURE_INFO;

typedef struct TEST_INFO
{
	TEST_PARAM 		*pTestParamList;
	uint32_t 		FailCount;
	FAILURE_INFO	FailedTestInfo[MAX_TEST_COMBINATIONS];
}TEST_INFO;



#endif /* __MAIN_H__ */
