#define SOURCE_PSIZE 8
#define DEST_PSIZE  8
#define SOURCE_MSIZE 32
#define DEST_MSIZE   32
#define SOURCE_DMA_CFG ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_PSIZE04
#define DEST_DMA_CFG BITM_DMA_CFG_WNR|ENUM_DMA_CFG_PSIZE04|ENUM_DMA_CFG_MSIZE32|ENUM_DMA_CFG_XCNT_INT

#define MAX_SIZE 8*1024

#define CCLK_SPEED 1000
#define MDMA_SPEED 500

#define DMC0_BANK0_START_ADDRESS 0x80000000
#define DMC0_BANK1_START_ADDRESS 0x88000000

//#define ADD_ANOTHER_MDMA

//Macro to configure MDMA
#define MDMA_CONFIG(S_MDMA_CHANNEL,S_CFG, S_ADDRSTART, S_MOD, S_COUNT,D_MDMA_CHANNEL,D_CFG, D_ADDRSTART, D_MOD, D_COUNT)\
		*pREG_DMA##S_MDMA_CHANNEL##_CFG = S_CFG;\
		*pREG_DMA##S_MDMA_CHANNEL##_ADDRSTART = S_ADDRSTART;\
		*pREG_DMA##S_MDMA_CHANNEL##_XCNT = S_COUNT;\
		*pREG_DMA##S_MDMA_CHANNEL##_XMOD = S_MOD;\
		*pREG_DMA##D_MDMA_CHANNEL##_CFG = D_CFG;\
		*pREG_DMA##D_MDMA_CHANNEL##_ADDRSTART = D_ADDRSTART;\
		*pREG_DMA##D_MDMA_CHANNEL##_XCNT = D_COUNT;\
		*pREG_DMA##D_MDMA_CHANNEL##_XMOD = D_MOD;

//Macro to wait for DMA done
#define WAIT_FOR_DMADONE(DMA_CHANNEL)\
		while(!(*pREG_DMA##DMA_CHANNEL##_STAT & ENUM_DMA_STAT_IRQDONE));

//Macro to disable the MDMA
#define DISABLE_DMAs(S_MDMA_CHANNEL, D_MDMA_CHANNEL)\

void CGUInit(void);
