/********************************************************************/
/*                                                                  */
/*      FIQ ISR                                                     */
/*                                                                  */
/********************************************************************/

#include <ADuC7020.h>
#include "common.h"
  
void FIQ_Handler (void) __fiq __ram {

    static BYTE byte_addr0 = 0x00;
    static BYTE byte_addr2 = 0x00;
    unsigned int status = I2CSSTA; 

    /***** Slave TX *****/
    if((status & 0x0004) == 0x0004){                    // slave transmitter interrupt?
        I2C0FSTA |= 0x100;                              // flush TX FIFO
        if((status&0x1800)==0){                         // ID decode bit is 00?
       	    I2CSTX = A0h[byte_addr0];                   // set TX data
       	    byte_addr0++;                               // increment byte address
       	    I2CSTX = A0h[byte_addr0];                   // set TX data
        }
        else{
       	    I2CSTX = A2h[byte_addr2];                   // set TX data
       	    byte_addr2++;                               // increment byte address
       	    I2CSTX = A2h[byte_addr2];                   // set TX data
        }
        I2CCFG = 0x4001;                                // clear bit9, enable Slave Tx FIFO request interrupt
   }        

    /***** Slave RX *****/
    if((status & 0x0008) == 0x0008){                    // slave receiver intterupt

        if(i2c_first == TRUE){                          // first slave-receiver INT?
            if((status&0x1800)==0) byte_addr0 = I2CSRX;// get byte address
            else byte_addr2 = I2CSRX;                   
            i2c_first = FALSE;
        }

        else{
            if((status&0x1800)==0){
                A0h[byte_addr0] = I2CSRX;               // get byte data
                byte_addr0++;                           // increment address
            }
            else{
                A2h[byte_addr2] = I2CSRX;              // save received byte data
                byte_addr2++;
            }
        }
    }

    /***** Stop Condition *****/
    if((status & 0x0400) == 0x0400){                   // STOP detect
        I2C0FSTA |= 0x100;                              // flush TX FIFO
        i2c_first = TRUE;
        if(I2CCFG == 0x4001){
            if((status&0x1800)==0)byte_addr0--;       // decrement byte address
            else byte_addr2--; 
            I2CCFG = 0x4201;                            // set bit9, clear Slave Tx FIFO request interrupt 
        }
    }

    return;

}
