% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_TxGetInst(...
    txnum, JCOM_parameters_in, JCOM_parameters_out, msg ...
) %#ok<INUSL>
    global JCOM_TX_OBJS__;
    pathstr = fileparts(mfilename('fullpath'));
    [~, dirstr] = fileparts(pathstr);
    mdir = dirstr(2:end);
    try
        eval(...
            sprintf(...
                'JCOM_TX_OBJS__{txnum+1} = %s.Tx(txnum, JCOM_parameters_in);',...
                mdir ...
            )...
        );
        JCOM_TX_OBJ__ = JCOM_TX_OBJS__{txnum+1};
        out = [...
            '(TX_PROPS ' ...
            sprintf('(NAME "%s") ', JCOM_TX_OBJ__.name) ...
            sprintf('(FB_MAX %f) ', JCOM_TX_OBJ__.fb_max/1E9) ...
            sprintf('(AV_RANGE %s) ', cfg_vector(JCOM_TX_OBJ__.A_v_range, 'f')) ...
            sprintf('(SNDR %f) ', JCOM_TX_OBJ__.sndr) ...
            sprintf('(FILTER_TYPE "%s") ', JCOM_TX_OBJ__.filter_type) ...
            sprintf('(FILTER_SETTING_VMIN %s) ', cfg_vector(JCOM_TX_OBJ__.filter_setting_vmin, 'f')) ...
            sprintf('(FILTER_SETTING_VMAX %s) ', cfg_vector(JCOM_TX_OBJ__.filter_setting_vmax, 'f')) ...
            sprintf('(LANES %d) ', JCOM_TX_OBJ__.lanes) ...
            sprintf('(LANES_FILTER %s) ', cfg_vector(JCOM_TX_OBJ__.lanes_filter, 'd')) ...
            sprintf('(LOCK %s)', iif(JCOM_TX_OBJ__.lock, 'True', 'False')) ...
            ')' ...
        ];
        JCOM_parameters_out.value = {out};
    catch ME
        msg.value = {['JCOM_MODEL_ERROR(JCOM_TxGetInst: ' ME.message ')']};
    end
    ret = 1;
end
