% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_TxGetFilter(...
    txnum, ir_ptr, len, tstep, tbit, lane_idx, ffe_idx, msg_ptr ...
)
    global JCOM_TX_OBJS__
    ret = 1;
    if ~txdef(txnum)
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_TxGetFilter: Model not initialized'...
        };
        return;
    end
    if isempty(ir_ptr)
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_TxGetFilter: Null frequency pointer'...
        };
        return;
    end
    if len == 0
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_TxGetFilter: Empty frequency vector'...
        };
        return;
    end
    if isempty(ir_ptr)
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_TxGetFilter: Null output pointer'...
        };
        return;
    end
    try
        ir_out = JCOM_TX_OBJS__{txnum+1}.filter(...
            ir_ptr.value, tstep, tbit, lane_idx, ffe_idx...
        );
        ir_ptr.value = ir_out;
    catch ME
        msg_ptr.value = {...
            ['JCOM_MODEL_ERROR(JCOM_TxGetFilter: ' ME.message ')']...
        };
    end
end
