% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_TxDelInst(txnum, msg)
    global JCOM_TX_OBJS__
    if ~txdef(txnum)
        msg.value = {'JCOM_MODEL_ERROR(JCOM_TxDelInst: Model not initialized'};
        ret = 1;
        return;
    end
    try
        if has_delete(JCOM_TX_OBJS__{txnum+1})
            delete(JCOM_TX_OBJS__{txnum+1});
        end
        clear -global JCOM_TX_OBJS__{txnum+1};
    catch ME
        msg.value = {['JCOM_MODEL_ERROR(JCOM_TxDelInst: ' ME.message ')']};
    end
    ret = 1;
end
