% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_RxGetPkg(rxnum, freq, len, lane_idx, out, msg)
    global JCOM_RX_OBJS__
    ret = 1;
    if ~rxdef(rxnum)
        msg.value = {'JCOM_MODEL_ERROR(JCOM_RxGetPkg: Model not initialized'};
        return;
    end
    if isempty(freq)
        msg.value = {'JCOM_MODEL_ERROR(JCOM_RxGetPkg: Null frequency pointer'};
        return;
    end
    if len == 0
        msg.value = {'JCOM_MODEL_ERROR(JCOM_RxGetPkg: Empty frequency vector'};
        return;
    end
    if isempty(out)
        msg.value = {'JCOM_MODEL_ERROR(JCOM_RxGetPkg: Null output pointer'};
        return;
    end
    try
        [s11, s12, s21, s22] = JCOM_RX_OBJS__{rxnum+1}.pkg(freq.value, lane_idx);
        out.value = s2ptr(s11, s12, s21, s22);
    catch ME
        msg.value = {['JCOM_MODEL_ERROR(JCOM_RxGetPkg: ' ME.message ')']};
    end
end
