% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_RxGetInst(...
    rxnum, JCOM_parameters_in, JCOM_parameters_out, msg ...
) %#ok<INUSL>
    global JCOM_RX_OBJS__;
    pathstr = fileparts(mfilename('fullpath'));
    [~, dirstr] = fileparts(pathstr);
    mdir = dirstr(2:end);
    try
        eval(...
            sprintf(...
                'JCOM_RX_OBJS__{rxnum+1} = %s.Rx(rxnum, JCOM_parameters_in);',...
                mdir ...
            )...
        );
        JCOM_RX_OBJ__ = JCOM_RX_OBJS__{rxnum+1};
        out = [...
            '(RX_PROPS ' ...
            sprintf('(CLS "%s") ', JCOM_RX_OBJ__.cls) ...
            sprintf('(NAME "%s") ', JCOM_RX_OBJ__.name) ...
            sprintf('(FB_MAX %f) ', JCOM_RX_OBJ__.fb_max/1E9) ...
            sprintf('(SIGMA_RJ %f) ', JCOM_RX_OBJ__.sigma_rj) ...
            sprintf('(A_DD %f) ', JCOM_RX_OBJ__.a_dd) ...
            sprintf('(FILTER_TYPE "%s") ', JCOM_RX_OBJ__.filter_type) ...
            sprintf('(FILTER_SETTING_VMIN %s) ', cfg_vector(JCOM_RX_OBJ__.filter_setting_vmin, 'f')) ...
            sprintf('(FILTER_SETTING_VMAX %s) ', cfg_vector(JCOM_RX_OBJ__.filter_setting_vmax, 'f')) ...
            sprintf('(NDFE %d) ', JCOM_RX_OBJ__.ndfe) ...
            sprintf('(DFE_B1 %f) ', JCOM_RX_OBJ__.dfe_b1) ...
            sprintf('(DFE_BREST %f) ', JCOM_RX_OBJ__.dfe_brest) ...
            sprintf('(LANES %d) ', JCOM_RX_OBJ__.lanes) ...
            sprintf('(LANES_FILTER %s) ', cfg_vector(JCOM_RX_OBJ__.lanes_filter, 'd')) ...
            sprintf('(LOCK %s)', iif(JCOM_RX_OBJ__.lock, 'True', 'False')) ...
            ')' ...
        ];
        JCOM_parameters_out.value = {out};
    catch ME
        msg.value = {['JCOM_MODEL_ERROR(JCOM_RxGetInst: ' ME.message ')']};
    end
    ret = 1;
end
