% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_RxGetFilterOutputNoise(...
    rxnum, freq, len, ctle_setting, out, msg ...
)
    global JCOM_RX_OBJS__
    ret = 1;
    if ~rxdef(rxnum)
        msg.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilterOutputNoise: '...
            'Model not initialized'...
        };
        return;
    end
    if isempty(freq)
        msg.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilterOutputNoise: '...
            'Null frequency pointer'...
        };
        return;
    end
    if len == 0
        msg.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilterOutputNoise: '...
            'Empty frequency vector'...
        };
        return;
    end
    if isempty(out)
        msg.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilterOutputNoise: '...
            'Null output pointer'...
        };
        return;
    end
    try
        ret = JCOM_RX_OBJS__{rxnum+1}.ctle_noise(freq.value, ctle_setting);
        out.value = ret;
    catch ME
        msg.value = {...
            [...
                'JCOM_MODEL_ERROR(JCOM_RxGetFilterOutputNoise: '...
                ME.message ...
                ')'...
            ]...
        };
    end
end
