% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_RxGetFilter(...
    rxnum, ir, len, tstep, tbit, ctle_setting, msg_ptr ...
)
    global JCOM_RX_OBJS__
    ret = 1;
    if ~rxdef(rxnum)
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilter: Model not initialized'...
        };
        return;
    end
    if isempty(ir)
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilter: Null frequency pointer'...
        };
        return;
    end
    if len == 0
        msg_ptr.value = {...
            'JCOM_MODEL_ERROR(JCOM_RxGetFilter: Empty frequency vector'...
        };
        return;
    end
    try
        ir_out = JCOM_RX_OBJS__{rxnum+1}.filter(...
            ir.value, tstep, tbit, ctle_setting ...
        );
        ir.value = ir_out;
    catch ME
        msg_ptr.value = {['JCOM_MODEL_ERROR(JCOM_RxGetFilter: ' ME.message ')']};
    end
end
