% Copyright (c) 2015-2019 Analog Devices, Inc.
% See Clear_BSD_LICENSE file for details

function ret = JCOM_RxDelInst(rxnum, msg)
    global JCOM_RX_OBJS__
    if ~rxdef(rxnum)
        msg.value = {'JCOM_MODEL_ERROR(JCOM_RxDelInst: Model not initialized'};
    end
    try
        if has_delete(JCOM_RX_OBJS__{rxnum+1})
            delete(JCOM_RX_OBJS__{rxnum+1})
        end
        clear -global JCOM_RX_OBJS__{rxnum+1}
    catch ME
        msg.value = {['JCOM_MODEL_ERROR(JCOM_RxDelInst: ' ME.message ')']};
    end
    ret = 1;
end
