/*
LTC2607
16-bit, Dual Rail-to-Rail DAC

I2C DATA FORMAT (MSB First):

       Byte #1                                    Byte #2                       Byte #3                             Byte #4
                                                                         MSB                                 LSB
START  SA6 SA5 SA4 SA3 SA2 SA1 SA0 W SACK  C3 C2 C1 C0 A3 A2 A1 A0 SACK  D15 D14 D13 D12 D11 D10 D9 D8 SACK  D7 D6 D5 D4 D3  D2  D1  D0  SACK  STOP

Sx   : Address Select Bit
Cx   : Command Bit
Ax   : DAC Address
Dx   : Data Bits

REVISION HISTORY
 $Revision: 1362 $
 $Date: 2013-03-09 20:44:22 -0800 (Sat, 09 Mar 2013) $

LICENSE
Permission to freely use, copy, modify, and distribute this software for any
purpose with or without fee is hereby granted, provided that the below
copyright notice and this permission notice appear in all copies:

THIS SOFTWARE IS PROVIDED "AS IS" AND LTC DISCLAIMS ALL WARRANTIES
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL LTC BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM ANY USE OF SAME, INCLUDING
ANY LOSS OF USE OR DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Copyright 2013 Nuvation Research Corporation
Copyright 2013 Linear Technology Corp. (LTC)
*/

#ifndef LTC2607_H
#define LTC2607_H

// Address Choices:
// To choose an address, comment out all options except the
// configuration on the demo board.

//  Address assignment
// LTC2607 I2C Address                 //  AD2       AD1       AD0
// #define LTC2607_I2C_ADDRESS 0x10    //  LOW       LOW       LOW
// #define LTC2607_I2C_ADDRESS 0x11    //  LOW       LOW       Float
// #define LTC2607_I2C_ADDRESS 0x12    //  LOW       LOW       HIGH
// #define LTC2607_I2C_ADDRESS 0x13    //  LOW       Float     LOW
// #define LTC2607_I2C_ADDRESS 0x20    //  LOW       Float     Float
// #define LTC2607_I2C_ADDRESS 0x21    //  LOW       Float     High
// #define LTC2607_I2C_ADDRESS 0x22    //  LOW       HIGH      LOW
// #define LTC2607_I2C_ADDRESS 0x23    //  LOW       HIGH      Float
// #define LTC2607_I2C_ADDRESS 0x30    //  LOW       High      HIGH
// #define LTC2607_I2C_ADDRESS 0x32    //  Float     LOW       LOW
// #define LTC2607_I2C_ADDRESS 0x32    //  Float     LOW       Float
// #define LTC2607_I2C_ADDRESS 0x33    //  Float     LOW       HIGH
// #define LTC2607_I2C_ADDRESS 0x40    //  Float     Float     LOW
// #define LTC2607_I2C_ADDRESS 0x41    //  Float     Float     Float
// #define LTC2607_I2C_ADDRESS 0x42    //  Float     Float     HIGH
// #define LTC2607_I2C_ADDRESS 0x43    //  Float     High      LOW
// #define LTC2607_I2C_ADDRESS 0x50    //  Float     High      Float
// #define LTC2607_I2C_ADDRESS 0x51    //  Float     High      HIGH
// #define LTC2607_I2C_ADDRESS 0x52    //  High      LOW       LOW
// #define LTC2607_I2C_ADDRESS 0x53    //  High      LOW       Float
// #define LTC2607_I2C_ADDRESS 0x60    //  High      LOW       High
// #define LTC2607_I2C_ADDRESS 0x61    //  High      Float     LOW
// #define LTC2607_I2C_ADDRESS 0x62    //  High      Float     Float
// #define LTC2607_I2C_ADDRESS 0x63    //  High      Float     High
// #define LTC2607_I2C_ADDRESS 0x70    //  High      High      LOW
// #define LTC2607_I2C_ADDRESS 0x71    //  High      High      Float
// #define LTC2607_I2C_ADDRESS 0x72    //  High      High      High

#define LTC2607_I2C_ADDRESS 0x73    //  Global Address


// DAC Command
#define LTC2607_WRITE_COMMAND             0x00
#define LTC2607_UPDATE_COMMAND            0x10
#define LTC2607_WRITE_UPDATE_COMMAND      0x30
#define LTC2607_POWER_DOWN_COMMAND        0x40

// DAC Address
#define LTC2607_DAC_A                     0x00
#define LTC2607_DAC_B                     0x01
#define LTC2607_ALL_DACS                  0x0F

// Set the device name for the I2C device
void LTC2607_set_device_name(char *device);

// Query the device name for the I2C device
char *LTC2607_get_device_name();

// Commands
// Construct a DAC command by ORing one choice from the command and one
// choice from the DAC address.

// Example - write and update register for both DACS
// dac_command = LTC2607_write_update_command | LTC2607_all_dacs;

// Write a 16-bit dac_code to the LTC2607.
// Returns the status of the I2C Address write. 0=successful, 1=unsuccessful.
int8_t LTC2607_write(uint8_t i2c_address, uint8_t dac_command, uint8_t dac_address, uint16_t dac_code);

// Calculate a LTC2607 DAC code given the desired output voltage
// Returns the DAC code
uint16_t LTC2607_code(float dac_voltage, float LTC2607_lsb, float LTC2607_offset);

// Calculate the LTC2607 offset and LSB voltages given two measured voltages and their corresponding codes
void LTC2607_calibrate(uint16_t dac_code1, uint16_t dac_code2, float voltage1, float voltage2, float *LTC2607_lsb, float *LTC2607_offset);

#endif  // LTC2607_H
