/*
GPIO

Functions to control the Cyclone HPS GPIO. Requires the the appropriate
driver modules are loaded:
  % cd /lib/modules/3.7.0/kernel/drivers/gpio
  % insmod gpio-generic.ko
  % insmod gpio-dw.ko

REVISION HISTORY
 $Revision: $
 $Date: 2013-04-04 $

LICENSE
Permission to freely use, copy, modify, and distribute this software for any
purpose with or without fee is hereby granted, provided that the below
copyright notice and this permission notice appear in all copies:

THIS SOFTWARE IS PROVIDED "AS IS" AND LTC DISCLAIMS ALL WARRANTIES
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL LTC BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM ANY USE OF SAME, INCLUDING
ANY LOSS OF USE OR DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

Copyright 2013 Nuvation Research Corporation
*/

#ifndef GPIO_H
#define GPIO_H

#include <stdint.h>

// Initialize the GPIO.
// This function will export the specified GPIO if required and configure
// it for output.
// id - the GPIO id number
// Returns a status. 0=successful, 1=unsuccessful.
int gpio_init(int id);

// Sets the state of a GPIO
// id - the GPIO id number
// high - if true, the GPIO is set high. It is set low otherwise.
// Returns a status. 0=successful, 1=unsuccessful.
int gpio_set_value(int id, int high);

#endif  //  GPIO_H
