/*!*****************************************************************************
*
* LTC3351: Super Capacitor Backup Controller with HotSwap
*
* @verbatim
* LTC3351 supercap charger with hotswap
* @endverbatim
*
* http://www.linear.com/product/LTC3351
*
* http://www.linear.com/product/LTC3351#demoboards
*
* REVISION HISTORY
* $Revision: 164 $
* $Date: 2018-04-02 18:29:52 -0400 (Mon, 02 Apr 2018) $
*
* Copyright (c) 2018 Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
* The Linear Technology Linduino is not affiliated with the official Arduino
* team. However, the Linduino is only possible because of the Arduino team's
* commitment to the open-source community. Please, visit http://www.arduino.cc
* and http://store.arduino.cc, and consider a purchase that will help fund
* their ongoing work.
*
* Generated on: 2018-04-02
*
******************************************************************************/

/*! @file
 *  @ingroup LTC3351
 *  @brief LTC3351 Register Map Definition Header
 *
 *
 *  This file contains LTC3351 definitions for each command_code as well as
 *  each individual bit field for the case when a register contains multiple
 *  bit-packed fields smaller than the register width.
 *
 *  Each bit field name is prepended with LTC3351_.
 *  Each bit field has individual definitions for its _SIZE, _OFFSET (LSB) and _MASK,
 *  as well as the three fields stored in a single 16-bit word for use with the access
 *  functions provided by LTC3351.c and LTC3351.h.
 *
 *  Additionally, each bit field contains a _DECODE macro to unpack multiple individual
 *  bit fields from a single copy of complete register data.
 *
 *  In the case that the bit field contents represent an enumeration, _ENUM
 *  definitions exist to translate from human readable format to the encoded value.
 *
 *  In the case that the bit field contents represent scalar data,
 *  macros exist in LTC3351_formats.h to translate from real units to integer values and back again.
 *  Real to integer conversions of literals should generally be optimized away at compile time
 *  without impact on execution speed or code size.
 *
 *  See @ref LTC3351_register_map for detailed descriptions of each bit field.
 *  See @ref LTC3351_formats for detailed descriptions of each data formatting macro.
 */

/*! @defgroup LTC3351_register_map LTC3351 Register Map Definitions
 *  @ingroup LTC3351
 */

#ifndef LTC3351_REG_DEFS_H_
#define LTC3351_REG_DEFS_H_

#define LTC3351_ADDR_09 0x9u //!<LTC3351 I2C address in 7-bit format

#define LTC3351_WORD_SIZE 16u

/*! @defgroup LTC3351_CTL_REG CTL_REG
 *  @ingroup LTC3351_register_map
 *  @brief CTL_REG Register
 *
 * | 15:11 |                   10 |   9 |                 8 |                     7 |                   6 |                   5 |                 4 |             3 |                     2 |                 1 |                      0 |
 * |:-----:|:--------------------:|:---:|:-----------------:|:---------------------:|:-------------------:|:-------------------:|:-----------------:|:-------------:|:---------------------:|:-----------------:|:----------------------:|
 * |   n/a | CTL_DISABLE_BALANCER | n/a | CTL_FORCE_ITST_ON | CTL_FORCE_CHARGER_OFF | CTL_FORCE_BOOST_OFF | CTL_HOTSWAP_DISABLE | CTL_DISABLE_SHUNT | CTL_CAP_SCALE | CTL_STOP_CAP_ESR_MEAS | CTL_GPI_BUFFER_EN | CTL_START_CAP_ESR_MEAS |
 *
 * Control Register: Several independent control bits are grouped into this register.
 *   - CommandCode: 0
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CTL_START_CAP_ESR_MEAS "CTL_START_CAP_ESR_MEAS" : Begin a capacitance and ESR measurement when possible; this bit clears itself once a measurement cycle begins or becomes pending.
 *     + @ref LTC3351_CTL_GPI_BUFFER_EN "CTL_GPI_BUFFER_EN" : A one in this bit location enables the input buffer on the GPI pin. With a zero in this location the GPI pin is measured without the buffer.
 *     + @ref LTC3351_CTL_STOP_CAP_ESR_MEAS "CTL_STOP_CAP_ESR_MEAS" : Stops an active capacitance/ESR measurement; this bit clears itself once a measurement cycle has been stopped.
 *     + @ref LTC3351_CTL_CAP_SCALE "CTL_CAP_SCALE" : Increases capacitor measurement resolution 100 times, this is used when measuring smaller capacitors.
 *     + @ref LTC3351_CTL_DISABLE_SHUNT "CTL_DISABLE_SHUNT" : Disables the shunt feature.
 *     + @ref LTC3351_CTL_HOTSWAP_DISABLE "CTL_HOTSWAP_DISABLE" : Disables the HotSwap controller. The gate of the hotswap FET is forced low, disconnecting VIN and VOUT and forcing the switcher into backup mode. This can be used to simulate a power failure for testing.
 *     + @ref LTC3351_CTL_FORCE_BOOST_OFF "CTL_FORCE_BOOST_OFF" : This bit disables the boost.
 *     + @ref LTC3351_CTL_FORCE_CHARGER_OFF "CTL_FORCE_CHARGER_OFF" : This bit disables the charger.
 *     + @ref LTC3351_CTL_FORCE_ITST_ON "CTL_FORCE_ITST_ON" : This bit forces the ITST current on. This can be used to discharge the capacitor stack or manually measure capacitance. Note that this only enables the test current, it does not disable the charger. Set ctl_force_charger_off to disable the charger.
 *     + @ref LTC3351_CTL_DISABLE_BALANCER "CTL_DISABLE_BALANCER" : Disables the balancer.
*/

//!@{
#define LTC3351_CTL_REG_SUBADDR 0u
#define LTC3351_CTL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CTL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_START_CAP_ESR_MEAS CTL_START_CAP_ESR_MEAS
 *  @ingroup LTC3351_register_map
 *  @brief CTL_START_CAP_ESR_MEAS Bit Field
 *
 *  Begin a capacitance and ESR measurement when possible; this bit clears itself once a measurement cycle begins or becomes pending.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_START_CAP_ESR_MEAS_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_START_CAP_ESR_MEAS "CTL_START_CAP_ESR_MEAS"
#define LTC3351_CTL_START_CAP_ESR_MEAS_SIZE 1u
#define LTC3351_CTL_START_CAP_ESR_MEAS_OFFSET 0u
#define LTC3351_CTL_START_CAP_ESR_MEAS_MASK 0x0001u
#define LTC3351_CTL_START_CAP_ESR_MEAS_DEFAULT 0u
#define LTC3351_CTL_START_CAP_ESR_MEAS_DECODE(register_data) (((register_data) & LTC3351_CTL_START_CAP_ESR_MEAS_MASK) >> LTC3351_CTL_START_CAP_ESR_MEAS_OFFSET)
#define LTC3351_CTL_START_CAP_ESR_MEAS (LTC3351_CTL_START_CAP_ESR_MEAS_OFFSET << 12 | (LTC3351_CTL_START_CAP_ESR_MEAS_SIZE - 1) << 8 | LTC3351_CTL_START_CAP_ESR_MEAS_SUBADDR)
#define LTC3351_CTL_START_CAP_ESR_MEAS_ENUM_START_MEASUREMENT 1u
//!@}
/*! @defgroup LTC3351_CTL_GPI_BUFFER_EN CTL_GPI_BUFFER_EN
 *  @ingroup LTC3351_register_map
 *  @brief CTL_GPI_BUFFER_EN Bit Field
 *
 *  A one in this bit location enables the input buffer on the GPI pin. With a zero in this location the GPI pin is measured without the buffer.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_GPI_BUFFER_EN_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_GPI_BUFFER_EN "CTL_GPI_BUFFER_EN"
#define LTC3351_CTL_GPI_BUFFER_EN_SIZE 1u
#define LTC3351_CTL_GPI_BUFFER_EN_OFFSET 1u
#define LTC3351_CTL_GPI_BUFFER_EN_MASK 0x0002u
#define LTC3351_CTL_GPI_BUFFER_EN_DEFAULT 0u
#define LTC3351_CTL_GPI_BUFFER_EN_DECODE(register_data) (((register_data) & LTC3351_CTL_GPI_BUFFER_EN_MASK) >> LTC3351_CTL_GPI_BUFFER_EN_OFFSET)
#define LTC3351_CTL_GPI_BUFFER_EN (LTC3351_CTL_GPI_BUFFER_EN_OFFSET << 12 | (LTC3351_CTL_GPI_BUFFER_EN_SIZE - 1) << 8 | LTC3351_CTL_GPI_BUFFER_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_STOP_CAP_ESR_MEAS CTL_STOP_CAP_ESR_MEAS
 *  @ingroup LTC3351_register_map
 *  @brief CTL_STOP_CAP_ESR_MEAS Bit Field
 *
 *  Stops an active capacitance/ESR measurement; this bit clears itself once a measurement cycle has been stopped.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_STOP_CAP_ESR_MEAS "CTL_STOP_CAP_ESR_MEAS"
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_SIZE 1u
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_OFFSET 2u
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_MASK 0x0004u
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_DEFAULT 0u
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_DECODE(register_data) (((register_data) & LTC3351_CTL_STOP_CAP_ESR_MEAS_MASK) >> LTC3351_CTL_STOP_CAP_ESR_MEAS_OFFSET)
#define LTC3351_CTL_STOP_CAP_ESR_MEAS (LTC3351_CTL_STOP_CAP_ESR_MEAS_OFFSET << 12 | (LTC3351_CTL_STOP_CAP_ESR_MEAS_SIZE - 1) << 8 | LTC3351_CTL_STOP_CAP_ESR_MEAS_SUBADDR)
#define LTC3351_CTL_STOP_CAP_ESR_MEAS_ENUM_STOP_MEASUREMENT 1u
//!@}
/*! @defgroup LTC3351_CTL_CAP_SCALE CTL_CAP_SCALE
 *  @ingroup LTC3351_register_map
 *  @brief CTL_CAP_SCALE Bit Field
 *
 *  Increases capacitor measurement resolution 100 times, this is used when measuring smaller capacitors.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_CAP_SCALE_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_CAP_SCALE "CTL_CAP_SCALE"
#define LTC3351_CTL_CAP_SCALE_SIZE 1u
#define LTC3351_CTL_CAP_SCALE_OFFSET 3u
#define LTC3351_CTL_CAP_SCALE_MASK 0x0008u
#define LTC3351_CTL_CAP_SCALE_DEFAULT 0u
#define LTC3351_CTL_CAP_SCALE_DECODE(register_data) (((register_data) & LTC3351_CTL_CAP_SCALE_MASK) >> LTC3351_CTL_CAP_SCALE_OFFSET)
#define LTC3351_CTL_CAP_SCALE (LTC3351_CTL_CAP_SCALE_OFFSET << 12 | (LTC3351_CTL_CAP_SCALE_SIZE - 1) << 8 | LTC3351_CTL_CAP_SCALE_SUBADDR)
#define LTC3351_CTL_CAP_SCALE_ENUM_LARGE_CAP 0u
#define LTC3351_CTL_CAP_SCALE_ENUM_SMALL_CAP 1u
//!@}
/*! @defgroup LTC3351_CTL_DISABLE_SHUNT CTL_DISABLE_SHUNT
 *  @ingroup LTC3351_register_map
 *  @brief CTL_DISABLE_SHUNT Bit Field
 *
 *  Disables the shunt feature.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_DISABLE_SHUNT_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_DISABLE_SHUNT "CTL_DISABLE_SHUNT"
#define LTC3351_CTL_DISABLE_SHUNT_SIZE 1u
#define LTC3351_CTL_DISABLE_SHUNT_OFFSET 4u
#define LTC3351_CTL_DISABLE_SHUNT_MASK 0x0010u
#define LTC3351_CTL_DISABLE_SHUNT_DEFAULT 0u
#define LTC3351_CTL_DISABLE_SHUNT_DECODE(register_data) (((register_data) & LTC3351_CTL_DISABLE_SHUNT_MASK) >> LTC3351_CTL_DISABLE_SHUNT_OFFSET)
#define LTC3351_CTL_DISABLE_SHUNT (LTC3351_CTL_DISABLE_SHUNT_OFFSET << 12 | (LTC3351_CTL_DISABLE_SHUNT_SIZE - 1) << 8 | LTC3351_CTL_DISABLE_SHUNT_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_HOTSWAP_DISABLE CTL_HOTSWAP_DISABLE
 *  @ingroup LTC3351_register_map
 *  @brief CTL_HOTSWAP_DISABLE Bit Field
 *
 *  Disables the HotSwap controller. The gate of the hotswap FET is forced low, disconnecting VIN and VOUT and forcing the switcher into backup mode. This can be used to simulate a power failure for testing.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_HOTSWAP_DISABLE_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_HOTSWAP_DISABLE "CTL_HOTSWAP_DISABLE"
#define LTC3351_CTL_HOTSWAP_DISABLE_SIZE 1u
#define LTC3351_CTL_HOTSWAP_DISABLE_OFFSET 5u
#define LTC3351_CTL_HOTSWAP_DISABLE_MASK 0x0020u
#define LTC3351_CTL_HOTSWAP_DISABLE_DEFAULT 0u
#define LTC3351_CTL_HOTSWAP_DISABLE_DECODE(register_data) (((register_data) & LTC3351_CTL_HOTSWAP_DISABLE_MASK) >> LTC3351_CTL_HOTSWAP_DISABLE_OFFSET)
#define LTC3351_CTL_HOTSWAP_DISABLE (LTC3351_CTL_HOTSWAP_DISABLE_OFFSET << 12 | (LTC3351_CTL_HOTSWAP_DISABLE_SIZE - 1) << 8 | LTC3351_CTL_HOTSWAP_DISABLE_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_FORCE_BOOST_OFF CTL_FORCE_BOOST_OFF
 *  @ingroup LTC3351_register_map
 *  @brief CTL_FORCE_BOOST_OFF Bit Field
 *
 *  This bit disables the boost.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_FORCE_BOOST_OFF_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_FORCE_BOOST_OFF "CTL_FORCE_BOOST_OFF"
#define LTC3351_CTL_FORCE_BOOST_OFF_SIZE 1u
#define LTC3351_CTL_FORCE_BOOST_OFF_OFFSET 6u
#define LTC3351_CTL_FORCE_BOOST_OFF_MASK 0x0040u
#define LTC3351_CTL_FORCE_BOOST_OFF_DEFAULT 0u
#define LTC3351_CTL_FORCE_BOOST_OFF_DECODE(register_data) (((register_data) & LTC3351_CTL_FORCE_BOOST_OFF_MASK) >> LTC3351_CTL_FORCE_BOOST_OFF_OFFSET)
#define LTC3351_CTL_FORCE_BOOST_OFF (LTC3351_CTL_FORCE_BOOST_OFF_OFFSET << 12 | (LTC3351_CTL_FORCE_BOOST_OFF_SIZE - 1) << 8 | LTC3351_CTL_FORCE_BOOST_OFF_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_FORCE_CHARGER_OFF CTL_FORCE_CHARGER_OFF
 *  @ingroup LTC3351_register_map
 *  @brief CTL_FORCE_CHARGER_OFF Bit Field
 *
 *  This bit disables the charger.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_FORCE_CHARGER_OFF_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_FORCE_CHARGER_OFF "CTL_FORCE_CHARGER_OFF"
#define LTC3351_CTL_FORCE_CHARGER_OFF_SIZE 1u
#define LTC3351_CTL_FORCE_CHARGER_OFF_OFFSET 7u
#define LTC3351_CTL_FORCE_CHARGER_OFF_MASK 0x0080u
#define LTC3351_CTL_FORCE_CHARGER_OFF_DEFAULT 0u
#define LTC3351_CTL_FORCE_CHARGER_OFF_DECODE(register_data) (((register_data) & LTC3351_CTL_FORCE_CHARGER_OFF_MASK) >> LTC3351_CTL_FORCE_CHARGER_OFF_OFFSET)
#define LTC3351_CTL_FORCE_CHARGER_OFF (LTC3351_CTL_FORCE_CHARGER_OFF_OFFSET << 12 | (LTC3351_CTL_FORCE_CHARGER_OFF_SIZE - 1) << 8 | LTC3351_CTL_FORCE_CHARGER_OFF_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_FORCE_ITST_ON CTL_FORCE_ITST_ON
 *  @ingroup LTC3351_register_map
 *  @brief CTL_FORCE_ITST_ON Bit Field
 *
 *  This bit forces the ITST current on. This can be used to discharge the capacitor stack or manually measure capacitance. Note that this only enables the test current, it does not disable the charger. Set ctl_force_charger_off to disable the charger.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_FORCE_ITST_ON_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_FORCE_ITST_ON "CTL_FORCE_ITST_ON"
#define LTC3351_CTL_FORCE_ITST_ON_SIZE 1u
#define LTC3351_CTL_FORCE_ITST_ON_OFFSET 8u
#define LTC3351_CTL_FORCE_ITST_ON_MASK 0x0100u
#define LTC3351_CTL_FORCE_ITST_ON_DEFAULT 0u
#define LTC3351_CTL_FORCE_ITST_ON_DECODE(register_data) (((register_data) & LTC3351_CTL_FORCE_ITST_ON_MASK) >> LTC3351_CTL_FORCE_ITST_ON_OFFSET)
#define LTC3351_CTL_FORCE_ITST_ON (LTC3351_CTL_FORCE_ITST_ON_OFFSET << 12 | (LTC3351_CTL_FORCE_ITST_ON_SIZE - 1) << 8 | LTC3351_CTL_FORCE_ITST_ON_SUBADDR)
//!@}
/*! @defgroup LTC3351_CTL_DISABLE_BALANCER CTL_DISABLE_BALANCER
 *  @ingroup LTC3351_register_map
 *  @brief CTL_DISABLE_BALANCER Bit Field
 *
 *  Disables the balancer.
 *   - Register: @ref LTC3351_CTL_REG "CTL_REG"
 *   - CommandCode: 0
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_CTL_DISABLE_BALANCER_SUBADDR LTC3351_CTL_REG_SUBADDR //!< @ref LTC3351_CTL_DISABLE_BALANCER "CTL_DISABLE_BALANCER"
#define LTC3351_CTL_DISABLE_BALANCER_SIZE 1u
#define LTC3351_CTL_DISABLE_BALANCER_OFFSET 10u
#define LTC3351_CTL_DISABLE_BALANCER_MASK 0x0400u
#define LTC3351_CTL_DISABLE_BALANCER_DEFAULT 0u
#define LTC3351_CTL_DISABLE_BALANCER_DECODE(register_data) (((register_data) & LTC3351_CTL_DISABLE_BALANCER_MASK) >> LTC3351_CTL_DISABLE_BALANCER_OFFSET)
#define LTC3351_CTL_DISABLE_BALANCER (LTC3351_CTL_DISABLE_BALANCER_OFFSET << 12 | (LTC3351_CTL_DISABLE_BALANCER_SIZE - 1) << 8 | LTC3351_CTL_DISABLE_BALANCER_SUBADDR)
//!@}

/*! @defgroup LTC3351_ALARM_MASK_REG ALARM_MASK_REG
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_MASK_REG Register
 *
 * |                15 |                14 |                13 |                12 |                11 |                 10 |                    9 |                     8 |                  7 |                  6 |                  5 |                  4 |                 3 |                 2 |                 1 |                 0 |
 * |:-----------------:|:-----------------:|:-----------------:|:-----------------:|:-----------------:|:------------------:|:--------------------:|:---------------------:|:------------------:|:------------------:|:------------------:|:------------------:|:-----------------:|:-----------------:|:-----------------:|:-----------------:|
 * | MASK_ALARM_ESR_HI | MASK_ALARM_CAP_LO | MASK_ALARM_CAP_OV | MASK_ALARM_CAP_UV | MASK_ALARM_IIN_OC | MASK_ALARM_ICHG_UC | MASK_ALARM_DTEMP_HOT | MASK_ALARM_DTEMP_COLD | MASK_ALARM_VOUT_OV | MASK_ALARM_VOUT_UV | MASK_ALARM_VCAP_OV | MASK_ALARM_VCAP_UV | MASK_ALARM_VIN_OV | MASK_ALARM_VIN_UV | MASK_ALARM_GPI_OV | MASK_ALARM_GPI_UV |
 *
 * Mask Alarms Register: Writing a one to any bit in this register enables a rising edge of its respective bit in alarm_reg to trigger an SMBALERT.
 *   - CommandCode: 1
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MASK_ALARM_GPI_UV "MASK_ALARM_GPI_UV" : GPI Under Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_GPI_OV "MASK_ALARM_GPI_OV" : GPI Over Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VIN_UV "MASK_ALARM_VIN_UV" : VIN Under Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VIN_OV "MASK_ALARM_VIN_OV" : VIN Over Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VCAP_UV "MASK_ALARM_VCAP_UV" : VCAP Under Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VCAP_OV "MASK_ALARM_VCAP_OV" : VCAP Over Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VOUT_UV "MASK_ALARM_VOUT_UV" : VOUT Under Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_VOUT_OV "MASK_ALARM_VOUT_OV" : VOUT Over Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_DTEMP_COLD "MASK_ALARM_DTEMP_COLD" : Die temperature cold alarm mask
 *     + @ref LTC3351_MASK_ALARM_DTEMP_HOT "MASK_ALARM_DTEMP_HOT" : Die temperature hot alarm mask
 *     + @ref LTC3351_MASK_ALARM_ICHG_UC "MASK_ALARM_ICHG_UC" : Charge undercurrent alarm mask
 *     + @ref LTC3351_MASK_ALARM_IIN_OC "MASK_ALARM_IIN_OC" : Input overcurrent alarm mask
 *     + @ref LTC3351_MASK_ALARM_CAP_UV "MASK_ALARM_CAP_UV" : Capacitor Under Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_CAP_OV "MASK_ALARM_CAP_OV" : Capacitor Over Voltage alarm mask
 *     + @ref LTC3351_MASK_ALARM_CAP_LO "MASK_ALARM_CAP_LO" : Capacitance low alarm mask
 *     + @ref LTC3351_MASK_ALARM_ESR_HI "MASK_ALARM_ESR_HI" : ESR high alarm mask
*/

//!@{
#define LTC3351_ALARM_MASK_REG_SUBADDR 1u
#define LTC3351_ALARM_MASK_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ALARM_MASK_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_GPI_UV MASK_ALARM_GPI_UV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_GPI_UV Bit Field
 *
 *  GPI Under Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_GPI_UV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_GPI_UV "MASK_ALARM_GPI_UV"
#define LTC3351_MASK_ALARM_GPI_UV_SIZE 1u
#define LTC3351_MASK_ALARM_GPI_UV_OFFSET 0u
#define LTC3351_MASK_ALARM_GPI_UV_MASK 0x0001u
#define LTC3351_MASK_ALARM_GPI_UV_DEFAULT 0u
#define LTC3351_MASK_ALARM_GPI_UV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_GPI_UV_MASK) >> LTC3351_MASK_ALARM_GPI_UV_OFFSET)
#define LTC3351_MASK_ALARM_GPI_UV (LTC3351_MASK_ALARM_GPI_UV_OFFSET << 12 | (LTC3351_MASK_ALARM_GPI_UV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_GPI_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_GPI_OV MASK_ALARM_GPI_OV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_GPI_OV Bit Field
 *
 *  GPI Over Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_GPI_OV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_GPI_OV "MASK_ALARM_GPI_OV"
#define LTC3351_MASK_ALARM_GPI_OV_SIZE 1u
#define LTC3351_MASK_ALARM_GPI_OV_OFFSET 1u
#define LTC3351_MASK_ALARM_GPI_OV_MASK 0x0002u
#define LTC3351_MASK_ALARM_GPI_OV_DEFAULT 0u
#define LTC3351_MASK_ALARM_GPI_OV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_GPI_OV_MASK) >> LTC3351_MASK_ALARM_GPI_OV_OFFSET)
#define LTC3351_MASK_ALARM_GPI_OV (LTC3351_MASK_ALARM_GPI_OV_OFFSET << 12 | (LTC3351_MASK_ALARM_GPI_OV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_GPI_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VIN_UV MASK_ALARM_VIN_UV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VIN_UV Bit Field
 *
 *  VIN Under Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VIN_UV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VIN_UV "MASK_ALARM_VIN_UV"
#define LTC3351_MASK_ALARM_VIN_UV_SIZE 1u
#define LTC3351_MASK_ALARM_VIN_UV_OFFSET 2u
#define LTC3351_MASK_ALARM_VIN_UV_MASK 0x0004u
#define LTC3351_MASK_ALARM_VIN_UV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VIN_UV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VIN_UV_MASK) >> LTC3351_MASK_ALARM_VIN_UV_OFFSET)
#define LTC3351_MASK_ALARM_VIN_UV (LTC3351_MASK_ALARM_VIN_UV_OFFSET << 12 | (LTC3351_MASK_ALARM_VIN_UV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VIN_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VIN_OV MASK_ALARM_VIN_OV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VIN_OV Bit Field
 *
 *  VIN Over Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VIN_OV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VIN_OV "MASK_ALARM_VIN_OV"
#define LTC3351_MASK_ALARM_VIN_OV_SIZE 1u
#define LTC3351_MASK_ALARM_VIN_OV_OFFSET 3u
#define LTC3351_MASK_ALARM_VIN_OV_MASK 0x0008u
#define LTC3351_MASK_ALARM_VIN_OV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VIN_OV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VIN_OV_MASK) >> LTC3351_MASK_ALARM_VIN_OV_OFFSET)
#define LTC3351_MASK_ALARM_VIN_OV (LTC3351_MASK_ALARM_VIN_OV_OFFSET << 12 | (LTC3351_MASK_ALARM_VIN_OV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VIN_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VCAP_UV MASK_ALARM_VCAP_UV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VCAP_UV Bit Field
 *
 *  VCAP Under Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VCAP_UV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VCAP_UV "MASK_ALARM_VCAP_UV"
#define LTC3351_MASK_ALARM_VCAP_UV_SIZE 1u
#define LTC3351_MASK_ALARM_VCAP_UV_OFFSET 4u
#define LTC3351_MASK_ALARM_VCAP_UV_MASK 0x0010u
#define LTC3351_MASK_ALARM_VCAP_UV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VCAP_UV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VCAP_UV_MASK) >> LTC3351_MASK_ALARM_VCAP_UV_OFFSET)
#define LTC3351_MASK_ALARM_VCAP_UV (LTC3351_MASK_ALARM_VCAP_UV_OFFSET << 12 | (LTC3351_MASK_ALARM_VCAP_UV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VCAP_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VCAP_OV MASK_ALARM_VCAP_OV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VCAP_OV Bit Field
 *
 *  VCAP Over Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VCAP_OV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VCAP_OV "MASK_ALARM_VCAP_OV"
#define LTC3351_MASK_ALARM_VCAP_OV_SIZE 1u
#define LTC3351_MASK_ALARM_VCAP_OV_OFFSET 5u
#define LTC3351_MASK_ALARM_VCAP_OV_MASK 0x0020u
#define LTC3351_MASK_ALARM_VCAP_OV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VCAP_OV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VCAP_OV_MASK) >> LTC3351_MASK_ALARM_VCAP_OV_OFFSET)
#define LTC3351_MASK_ALARM_VCAP_OV (LTC3351_MASK_ALARM_VCAP_OV_OFFSET << 12 | (LTC3351_MASK_ALARM_VCAP_OV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VCAP_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VOUT_UV MASK_ALARM_VOUT_UV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VOUT_UV Bit Field
 *
 *  VOUT Under Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VOUT_UV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VOUT_UV "MASK_ALARM_VOUT_UV"
#define LTC3351_MASK_ALARM_VOUT_UV_SIZE 1u
#define LTC3351_MASK_ALARM_VOUT_UV_OFFSET 6u
#define LTC3351_MASK_ALARM_VOUT_UV_MASK 0x0040u
#define LTC3351_MASK_ALARM_VOUT_UV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VOUT_UV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VOUT_UV_MASK) >> LTC3351_MASK_ALARM_VOUT_UV_OFFSET)
#define LTC3351_MASK_ALARM_VOUT_UV (LTC3351_MASK_ALARM_VOUT_UV_OFFSET << 12 | (LTC3351_MASK_ALARM_VOUT_UV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VOUT_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_VOUT_OV MASK_ALARM_VOUT_OV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_VOUT_OV Bit Field
 *
 *  VOUT Over Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_VOUT_OV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_VOUT_OV "MASK_ALARM_VOUT_OV"
#define LTC3351_MASK_ALARM_VOUT_OV_SIZE 1u
#define LTC3351_MASK_ALARM_VOUT_OV_OFFSET 7u
#define LTC3351_MASK_ALARM_VOUT_OV_MASK 0x0080u
#define LTC3351_MASK_ALARM_VOUT_OV_DEFAULT 0u
#define LTC3351_MASK_ALARM_VOUT_OV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_VOUT_OV_MASK) >> LTC3351_MASK_ALARM_VOUT_OV_OFFSET)
#define LTC3351_MASK_ALARM_VOUT_OV (LTC3351_MASK_ALARM_VOUT_OV_OFFSET << 12 | (LTC3351_MASK_ALARM_VOUT_OV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_VOUT_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_DTEMP_COLD MASK_ALARM_DTEMP_COLD
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_DTEMP_COLD Bit Field
 *
 *  Die temperature cold alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_DTEMP_COLD_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_DTEMP_COLD "MASK_ALARM_DTEMP_COLD"
#define LTC3351_MASK_ALARM_DTEMP_COLD_SIZE 1u
#define LTC3351_MASK_ALARM_DTEMP_COLD_OFFSET 8u
#define LTC3351_MASK_ALARM_DTEMP_COLD_MASK 0x0100u
#define LTC3351_MASK_ALARM_DTEMP_COLD_DEFAULT 0u
#define LTC3351_MASK_ALARM_DTEMP_COLD_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_DTEMP_COLD_MASK) >> LTC3351_MASK_ALARM_DTEMP_COLD_OFFSET)
#define LTC3351_MASK_ALARM_DTEMP_COLD (LTC3351_MASK_ALARM_DTEMP_COLD_OFFSET << 12 | (LTC3351_MASK_ALARM_DTEMP_COLD_SIZE - 1) << 8 | LTC3351_MASK_ALARM_DTEMP_COLD_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_DTEMP_HOT MASK_ALARM_DTEMP_HOT
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_DTEMP_HOT Bit Field
 *
 *  Die temperature hot alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_DTEMP_HOT_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_DTEMP_HOT "MASK_ALARM_DTEMP_HOT"
#define LTC3351_MASK_ALARM_DTEMP_HOT_SIZE 1u
#define LTC3351_MASK_ALARM_DTEMP_HOT_OFFSET 9u
#define LTC3351_MASK_ALARM_DTEMP_HOT_MASK 0x0200u
#define LTC3351_MASK_ALARM_DTEMP_HOT_DEFAULT 0u
#define LTC3351_MASK_ALARM_DTEMP_HOT_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_DTEMP_HOT_MASK) >> LTC3351_MASK_ALARM_DTEMP_HOT_OFFSET)
#define LTC3351_MASK_ALARM_DTEMP_HOT (LTC3351_MASK_ALARM_DTEMP_HOT_OFFSET << 12 | (LTC3351_MASK_ALARM_DTEMP_HOT_SIZE - 1) << 8 | LTC3351_MASK_ALARM_DTEMP_HOT_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_ICHG_UC MASK_ALARM_ICHG_UC
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_ICHG_UC Bit Field
 *
 *  Charge undercurrent alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_ICHG_UC_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_ICHG_UC "MASK_ALARM_ICHG_UC"
#define LTC3351_MASK_ALARM_ICHG_UC_SIZE 1u
#define LTC3351_MASK_ALARM_ICHG_UC_OFFSET 10u
#define LTC3351_MASK_ALARM_ICHG_UC_MASK 0x0400u
#define LTC3351_MASK_ALARM_ICHG_UC_DEFAULT 0u
#define LTC3351_MASK_ALARM_ICHG_UC_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_ICHG_UC_MASK) >> LTC3351_MASK_ALARM_ICHG_UC_OFFSET)
#define LTC3351_MASK_ALARM_ICHG_UC (LTC3351_MASK_ALARM_ICHG_UC_OFFSET << 12 | (LTC3351_MASK_ALARM_ICHG_UC_SIZE - 1) << 8 | LTC3351_MASK_ALARM_ICHG_UC_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_IIN_OC MASK_ALARM_IIN_OC
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_IIN_OC Bit Field
 *
 *  Input overcurrent alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_IIN_OC_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_IIN_OC "MASK_ALARM_IIN_OC"
#define LTC3351_MASK_ALARM_IIN_OC_SIZE 1u
#define LTC3351_MASK_ALARM_IIN_OC_OFFSET 11u
#define LTC3351_MASK_ALARM_IIN_OC_MASK 0x0800u
#define LTC3351_MASK_ALARM_IIN_OC_DEFAULT 0u
#define LTC3351_MASK_ALARM_IIN_OC_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_IIN_OC_MASK) >> LTC3351_MASK_ALARM_IIN_OC_OFFSET)
#define LTC3351_MASK_ALARM_IIN_OC (LTC3351_MASK_ALARM_IIN_OC_OFFSET << 12 | (LTC3351_MASK_ALARM_IIN_OC_SIZE - 1) << 8 | LTC3351_MASK_ALARM_IIN_OC_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_CAP_UV MASK_ALARM_CAP_UV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_CAP_UV Bit Field
 *
 *  Capacitor Under Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 12
 *   - MSB: 12
 *   - MASK: 0x1000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_CAP_UV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_CAP_UV "MASK_ALARM_CAP_UV"
#define LTC3351_MASK_ALARM_CAP_UV_SIZE 1u
#define LTC3351_MASK_ALARM_CAP_UV_OFFSET 12u
#define LTC3351_MASK_ALARM_CAP_UV_MASK 0x1000u
#define LTC3351_MASK_ALARM_CAP_UV_DEFAULT 0u
#define LTC3351_MASK_ALARM_CAP_UV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_CAP_UV_MASK) >> LTC3351_MASK_ALARM_CAP_UV_OFFSET)
#define LTC3351_MASK_ALARM_CAP_UV (LTC3351_MASK_ALARM_CAP_UV_OFFSET << 12 | (LTC3351_MASK_ALARM_CAP_UV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_CAP_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_CAP_OV MASK_ALARM_CAP_OV
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_CAP_OV Bit Field
 *
 *  Capacitor Over Voltage alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 13
 *   - MSB: 13
 *   - MASK: 0x2000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_CAP_OV_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_CAP_OV "MASK_ALARM_CAP_OV"
#define LTC3351_MASK_ALARM_CAP_OV_SIZE 1u
#define LTC3351_MASK_ALARM_CAP_OV_OFFSET 13u
#define LTC3351_MASK_ALARM_CAP_OV_MASK 0x2000u
#define LTC3351_MASK_ALARM_CAP_OV_DEFAULT 0u
#define LTC3351_MASK_ALARM_CAP_OV_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_CAP_OV_MASK) >> LTC3351_MASK_ALARM_CAP_OV_OFFSET)
#define LTC3351_MASK_ALARM_CAP_OV (LTC3351_MASK_ALARM_CAP_OV_OFFSET << 12 | (LTC3351_MASK_ALARM_CAP_OV_SIZE - 1) << 8 | LTC3351_MASK_ALARM_CAP_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_CAP_LO MASK_ALARM_CAP_LO
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_CAP_LO Bit Field
 *
 *  Capacitance low alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 14
 *   - MSB: 14
 *   - MASK: 0x4000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_CAP_LO_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_CAP_LO "MASK_ALARM_CAP_LO"
#define LTC3351_MASK_ALARM_CAP_LO_SIZE 1u
#define LTC3351_MASK_ALARM_CAP_LO_OFFSET 14u
#define LTC3351_MASK_ALARM_CAP_LO_MASK 0x4000u
#define LTC3351_MASK_ALARM_CAP_LO_DEFAULT 0u
#define LTC3351_MASK_ALARM_CAP_LO_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_CAP_LO_MASK) >> LTC3351_MASK_ALARM_CAP_LO_OFFSET)
#define LTC3351_MASK_ALARM_CAP_LO (LTC3351_MASK_ALARM_CAP_LO_OFFSET << 12 | (LTC3351_MASK_ALARM_CAP_LO_SIZE - 1) << 8 | LTC3351_MASK_ALARM_CAP_LO_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_ALARM_ESR_HI MASK_ALARM_ESR_HI
 *  @ingroup LTC3351_register_map
 *  @brief MASK_ALARM_ESR_HI Bit Field
 *
 *  ESR high alarm mask
 *   - Register: @ref LTC3351_ALARM_MASK_REG "ALARM_MASK_REG"
 *   - CommandCode: 1
 *   - Size: 1
 *   - Offset: 15
 *   - MSB: 15
 *   - MASK: 0x8000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_ALARM_ESR_HI_SUBADDR LTC3351_ALARM_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_ALARM_ESR_HI "MASK_ALARM_ESR_HI"
#define LTC3351_MASK_ALARM_ESR_HI_SIZE 1u
#define LTC3351_MASK_ALARM_ESR_HI_OFFSET 15u
#define LTC3351_MASK_ALARM_ESR_HI_MASK 0x8000u
#define LTC3351_MASK_ALARM_ESR_HI_DEFAULT 0u
#define LTC3351_MASK_ALARM_ESR_HI_DECODE(register_data) (((register_data) & LTC3351_MASK_ALARM_ESR_HI_MASK) >> LTC3351_MASK_ALARM_ESR_HI_OFFSET)
#define LTC3351_MASK_ALARM_ESR_HI (LTC3351_MASK_ALARM_ESR_HI_OFFSET << 12 | (LTC3351_MASK_ALARM_ESR_HI_SIZE - 1) << 8 | LTC3351_MASK_ALARM_ESR_HI_SUBADDR)
//!@}

/*! @defgroup LTC3351_MONITOR_STATUS_MASK_REG MONITOR_STATUS_MASK_REG
 *  @ingroup LTC3351_register_map
 *  @brief MONITOR_STATUS_MASK_REG Register
 *
 * |  15 |                     14 |                13 |                 12 |                      11 |                    10 |                        9 |                        8 |                        7 |   6 |                    5 |                 4 |                 3 |                       2 |   1 |                    0 |
 * |:---:|:----------------------:|:-----------------:|:------------------:|:-----------------------:|:---------------------:|:------------------------:|:------------------------:|:------------------------:|:---:|:--------------------:|:-----------------:|:-----------------:|:-----------------------:|:---:|:--------------------:|
 * | n/a | MASK_MON_CAP_PRECHARGE | MASK_MON_SHUNTING | MASK_MON_BALANCING | MASK_MON_POWER_RETURNED | MASK_MON_POWER_FAILED | MASK_MON_ESR_MEAS_ACTIVE | MASK_MON_CAP_MEAS_ACTIVE | MASK_MON_DISABLE_CHARGER | n/a | MASK_MON_MEAS_FAILED | MASK_MON_ESR_DONE | MASK_MON_CAP_DONE | MASK_MON_CAPESR_PENDING | n/a | MASK_MON_MEAS_ACTIVE |
 *
 * Mask Monitor Status Register: Writing a one to any bit in this register enables a rising edge of its respective bit in monitor_status_reg to trigger an SMBALERT.
 *   - CommandCode: 2
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MASK_MON_MEAS_ACTIVE "MASK_MON_MEAS_ACTIVE" : Set the SMBALERT when there is a rising edge on mon_meas_active
 *     + @ref LTC3351_MASK_MON_CAPESR_PENDING "MASK_MON_CAPESR_PENDING" : Set the SMBALERT when there is a rising edge on mon_capesr_pending
 *     + @ref LTC3351_MASK_MON_CAP_DONE "MASK_MON_CAP_DONE" : Set the SMBALERT when there is a rising edge on mon_cap_done
 *     + @ref LTC3351_MASK_MON_ESR_DONE "MASK_MON_ESR_DONE" : Set the SMBALERT when there is a rising edge on mon_esr_done
 *     + @ref LTC3351_MASK_MON_MEAS_FAILED "MASK_MON_MEAS_FAILED" : Set the SMBALERT when there is a rising edge on mon_meas_failed
 *     + @ref LTC3351_MASK_MON_DISABLE_CHARGER "MASK_MON_DISABLE_CHARGER" : Set the SMBALERT when there is a rising edge on mon_disable_charger
 *     + @ref LTC3351_MASK_MON_CAP_MEAS_ACTIVE "MASK_MON_CAP_MEAS_ACTIVE" : Set the SMBALERT when there is a rising edge on mon_cap_meas_active
 *     + @ref LTC3351_MASK_MON_ESR_MEAS_ACTIVE "MASK_MON_ESR_MEAS_ACTIVE" : Set the SMBALERT when there is a rising edge on mon_esr_meas_active
 *     + @ref LTC3351_MASK_MON_POWER_FAILED "MASK_MON_POWER_FAILED" : Set the SMBALERT when there is a rising edge on mon_power_failed
 *     + @ref LTC3351_MASK_MON_POWER_RETURNED "MASK_MON_POWER_RETURNED" : Set the SMBALERT when there is a rising edge on mon_power_returned
 *     + @ref LTC3351_MASK_MON_BALANCING "MASK_MON_BALANCING" : Set the SMBALERT when there is a rising edge on mon_balancing
 *     + @ref LTC3351_MASK_MON_SHUNTING "MASK_MON_SHUNTING" : Set the SMBALERT when there is a rising edge on mon_shunting
 *     + @ref LTC3351_MASK_MON_CAP_PRECHARGE "MASK_MON_CAP_PRECHARGE" : Set the SMBALERT when there is a rising edge on mon_cap_precharge
*/

//!@{
#define LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR 2u
#define LTC3351_MONITOR_STATUS_MASK_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_MEAS_ACTIVE MASK_MON_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_MEAS_ACTIVE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_meas_active
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_MEAS_ACTIVE "MASK_MON_MEAS_ACTIVE"
#define LTC3351_MASK_MON_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MASK_MON_MEAS_ACTIVE_OFFSET 0u
#define LTC3351_MASK_MON_MEAS_ACTIVE_MASK 0x0001u
#define LTC3351_MASK_MON_MEAS_ACTIVE_DEFAULT 0u
#define LTC3351_MASK_MON_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_MEAS_ACTIVE_MASK) >> LTC3351_MASK_MON_MEAS_ACTIVE_OFFSET)
#define LTC3351_MASK_MON_MEAS_ACTIVE (LTC3351_MASK_MON_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MASK_MON_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MASK_MON_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_CAPESR_PENDING MASK_MON_CAPESR_PENDING
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_CAPESR_PENDING Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_capesr_pending
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_CAPESR_PENDING_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_CAPESR_PENDING "MASK_MON_CAPESR_PENDING"
#define LTC3351_MASK_MON_CAPESR_PENDING_SIZE 1u
#define LTC3351_MASK_MON_CAPESR_PENDING_OFFSET 2u
#define LTC3351_MASK_MON_CAPESR_PENDING_MASK 0x0004u
#define LTC3351_MASK_MON_CAPESR_PENDING_DEFAULT 0u
#define LTC3351_MASK_MON_CAPESR_PENDING_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_CAPESR_PENDING_MASK) >> LTC3351_MASK_MON_CAPESR_PENDING_OFFSET)
#define LTC3351_MASK_MON_CAPESR_PENDING (LTC3351_MASK_MON_CAPESR_PENDING_OFFSET << 12 | (LTC3351_MASK_MON_CAPESR_PENDING_SIZE - 1) << 8 | LTC3351_MASK_MON_CAPESR_PENDING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_CAP_DONE MASK_MON_CAP_DONE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_CAP_DONE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_cap_done
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_CAP_DONE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_CAP_DONE "MASK_MON_CAP_DONE"
#define LTC3351_MASK_MON_CAP_DONE_SIZE 1u
#define LTC3351_MASK_MON_CAP_DONE_OFFSET 3u
#define LTC3351_MASK_MON_CAP_DONE_MASK 0x0008u
#define LTC3351_MASK_MON_CAP_DONE_DEFAULT 0u
#define LTC3351_MASK_MON_CAP_DONE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_CAP_DONE_MASK) >> LTC3351_MASK_MON_CAP_DONE_OFFSET)
#define LTC3351_MASK_MON_CAP_DONE (LTC3351_MASK_MON_CAP_DONE_OFFSET << 12 | (LTC3351_MASK_MON_CAP_DONE_SIZE - 1) << 8 | LTC3351_MASK_MON_CAP_DONE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_ESR_DONE MASK_MON_ESR_DONE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_ESR_DONE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_esr_done
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_ESR_DONE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_ESR_DONE "MASK_MON_ESR_DONE"
#define LTC3351_MASK_MON_ESR_DONE_SIZE 1u
#define LTC3351_MASK_MON_ESR_DONE_OFFSET 4u
#define LTC3351_MASK_MON_ESR_DONE_MASK 0x0010u
#define LTC3351_MASK_MON_ESR_DONE_DEFAULT 0u
#define LTC3351_MASK_MON_ESR_DONE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_ESR_DONE_MASK) >> LTC3351_MASK_MON_ESR_DONE_OFFSET)
#define LTC3351_MASK_MON_ESR_DONE (LTC3351_MASK_MON_ESR_DONE_OFFSET << 12 | (LTC3351_MASK_MON_ESR_DONE_SIZE - 1) << 8 | LTC3351_MASK_MON_ESR_DONE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_MEAS_FAILED MASK_MON_MEAS_FAILED
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_MEAS_FAILED Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_meas_failed
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_MEAS_FAILED_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_MEAS_FAILED "MASK_MON_MEAS_FAILED"
#define LTC3351_MASK_MON_MEAS_FAILED_SIZE 1u
#define LTC3351_MASK_MON_MEAS_FAILED_OFFSET 5u
#define LTC3351_MASK_MON_MEAS_FAILED_MASK 0x0020u
#define LTC3351_MASK_MON_MEAS_FAILED_DEFAULT 0u
#define LTC3351_MASK_MON_MEAS_FAILED_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_MEAS_FAILED_MASK) >> LTC3351_MASK_MON_MEAS_FAILED_OFFSET)
#define LTC3351_MASK_MON_MEAS_FAILED (LTC3351_MASK_MON_MEAS_FAILED_OFFSET << 12 | (LTC3351_MASK_MON_MEAS_FAILED_SIZE - 1) << 8 | LTC3351_MASK_MON_MEAS_FAILED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_DISABLE_CHARGER MASK_MON_DISABLE_CHARGER
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_DISABLE_CHARGER Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_disable_charger
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_DISABLE_CHARGER_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_DISABLE_CHARGER "MASK_MON_DISABLE_CHARGER"
#define LTC3351_MASK_MON_DISABLE_CHARGER_SIZE 1u
#define LTC3351_MASK_MON_DISABLE_CHARGER_OFFSET 7u
#define LTC3351_MASK_MON_DISABLE_CHARGER_MASK 0x0080u
#define LTC3351_MASK_MON_DISABLE_CHARGER_DEFAULT 0u
#define LTC3351_MASK_MON_DISABLE_CHARGER_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_DISABLE_CHARGER_MASK) >> LTC3351_MASK_MON_DISABLE_CHARGER_OFFSET)
#define LTC3351_MASK_MON_DISABLE_CHARGER (LTC3351_MASK_MON_DISABLE_CHARGER_OFFSET << 12 | (LTC3351_MASK_MON_DISABLE_CHARGER_SIZE - 1) << 8 | LTC3351_MASK_MON_DISABLE_CHARGER_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_CAP_MEAS_ACTIVE MASK_MON_CAP_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_CAP_MEAS_ACTIVE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_cap_meas_active
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_CAP_MEAS_ACTIVE "MASK_MON_CAP_MEAS_ACTIVE"
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_OFFSET 8u
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_MASK 0x0100u
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_DEFAULT 0u
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_CAP_MEAS_ACTIVE_MASK) >> LTC3351_MASK_MON_CAP_MEAS_ACTIVE_OFFSET)
#define LTC3351_MASK_MON_CAP_MEAS_ACTIVE (LTC3351_MASK_MON_CAP_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MASK_MON_CAP_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MASK_MON_CAP_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_ESR_MEAS_ACTIVE MASK_MON_ESR_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_ESR_MEAS_ACTIVE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_esr_meas_active
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_ESR_MEAS_ACTIVE "MASK_MON_ESR_MEAS_ACTIVE"
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_OFFSET 9u
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_MASK 0x0200u
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_DEFAULT 0u
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_ESR_MEAS_ACTIVE_MASK) >> LTC3351_MASK_MON_ESR_MEAS_ACTIVE_OFFSET)
#define LTC3351_MASK_MON_ESR_MEAS_ACTIVE (LTC3351_MASK_MON_ESR_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MASK_MON_ESR_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MASK_MON_ESR_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_POWER_FAILED MASK_MON_POWER_FAILED
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_POWER_FAILED Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_power_failed
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_POWER_FAILED_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_POWER_FAILED "MASK_MON_POWER_FAILED"
#define LTC3351_MASK_MON_POWER_FAILED_SIZE 1u
#define LTC3351_MASK_MON_POWER_FAILED_OFFSET 10u
#define LTC3351_MASK_MON_POWER_FAILED_MASK 0x0400u
#define LTC3351_MASK_MON_POWER_FAILED_DEFAULT 0u
#define LTC3351_MASK_MON_POWER_FAILED_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_POWER_FAILED_MASK) >> LTC3351_MASK_MON_POWER_FAILED_OFFSET)
#define LTC3351_MASK_MON_POWER_FAILED (LTC3351_MASK_MON_POWER_FAILED_OFFSET << 12 | (LTC3351_MASK_MON_POWER_FAILED_SIZE - 1) << 8 | LTC3351_MASK_MON_POWER_FAILED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_POWER_RETURNED MASK_MON_POWER_RETURNED
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_POWER_RETURNED Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_power_returned
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_POWER_RETURNED_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_POWER_RETURNED "MASK_MON_POWER_RETURNED"
#define LTC3351_MASK_MON_POWER_RETURNED_SIZE 1u
#define LTC3351_MASK_MON_POWER_RETURNED_OFFSET 11u
#define LTC3351_MASK_MON_POWER_RETURNED_MASK 0x0800u
#define LTC3351_MASK_MON_POWER_RETURNED_DEFAULT 0u
#define LTC3351_MASK_MON_POWER_RETURNED_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_POWER_RETURNED_MASK) >> LTC3351_MASK_MON_POWER_RETURNED_OFFSET)
#define LTC3351_MASK_MON_POWER_RETURNED (LTC3351_MASK_MON_POWER_RETURNED_OFFSET << 12 | (LTC3351_MASK_MON_POWER_RETURNED_SIZE - 1) << 8 | LTC3351_MASK_MON_POWER_RETURNED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_BALANCING MASK_MON_BALANCING
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_BALANCING Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_balancing
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 12
 *   - MSB: 12
 *   - MASK: 0x1000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_BALANCING_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_BALANCING "MASK_MON_BALANCING"
#define LTC3351_MASK_MON_BALANCING_SIZE 1u
#define LTC3351_MASK_MON_BALANCING_OFFSET 12u
#define LTC3351_MASK_MON_BALANCING_MASK 0x1000u
#define LTC3351_MASK_MON_BALANCING_DEFAULT 0u
#define LTC3351_MASK_MON_BALANCING_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_BALANCING_MASK) >> LTC3351_MASK_MON_BALANCING_OFFSET)
#define LTC3351_MASK_MON_BALANCING (LTC3351_MASK_MON_BALANCING_OFFSET << 12 | (LTC3351_MASK_MON_BALANCING_SIZE - 1) << 8 | LTC3351_MASK_MON_BALANCING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_SHUNTING MASK_MON_SHUNTING
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_SHUNTING Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_shunting
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 13
 *   - MSB: 13
 *   - MASK: 0x2000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_SHUNTING_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_SHUNTING "MASK_MON_SHUNTING"
#define LTC3351_MASK_MON_SHUNTING_SIZE 1u
#define LTC3351_MASK_MON_SHUNTING_OFFSET 13u
#define LTC3351_MASK_MON_SHUNTING_MASK 0x2000u
#define LTC3351_MASK_MON_SHUNTING_DEFAULT 0u
#define LTC3351_MASK_MON_SHUNTING_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_SHUNTING_MASK) >> LTC3351_MASK_MON_SHUNTING_OFFSET)
#define LTC3351_MASK_MON_SHUNTING (LTC3351_MASK_MON_SHUNTING_OFFSET << 12 | (LTC3351_MASK_MON_SHUNTING_SIZE - 1) << 8 | LTC3351_MASK_MON_SHUNTING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MASK_MON_CAP_PRECHARGE MASK_MON_CAP_PRECHARGE
 *  @ingroup LTC3351_register_map
 *  @brief MASK_MON_CAP_PRECHARGE Bit Field
 *
 *  Set the SMBALERT when there is a rising edge on mon_cap_precharge
 *   - Register: @ref LTC3351_MONITOR_STATUS_MASK_REG "MONITOR_STATUS_MASK_REG"
 *   - CommandCode: 2
 *   - Size: 1
 *   - Offset: 14
 *   - MSB: 14
 *   - MASK: 0x4000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_MASK_MON_CAP_PRECHARGE_SUBADDR LTC3351_MONITOR_STATUS_MASK_REG_SUBADDR //!< @ref LTC3351_MASK_MON_CAP_PRECHARGE "MASK_MON_CAP_PRECHARGE"
#define LTC3351_MASK_MON_CAP_PRECHARGE_SIZE 1u
#define LTC3351_MASK_MON_CAP_PRECHARGE_OFFSET 14u
#define LTC3351_MASK_MON_CAP_PRECHARGE_MASK 0x4000u
#define LTC3351_MASK_MON_CAP_PRECHARGE_DEFAULT 0u
#define LTC3351_MASK_MON_CAP_PRECHARGE_DECODE(register_data) (((register_data) & LTC3351_MASK_MON_CAP_PRECHARGE_MASK) >> LTC3351_MASK_MON_CAP_PRECHARGE_OFFSET)
#define LTC3351_MASK_MON_CAP_PRECHARGE (LTC3351_MASK_MON_CAP_PRECHARGE_OFFSET << 12 | (LTC3351_MASK_MON_CAP_PRECHARGE_SIZE - 1) << 8 | LTC3351_MASK_MON_CAP_PRECHARGE_SUBADDR)
//!@}

/*! @defgroup LTC3351_VCAPFB_DAC_REG VCAPFB_DAC_REG
 *  @ingroup LTC3351_register_map
 *  @brief VCAPFB_DAC_REG Register
 *
 * | 15:4 |        3:0 |
 * |:----:|:----------:|
 * |  n/a | VCAPFB_DAC |
 *
 *   - CommandCode: 3
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VCAPFB_DAC "VCAPFB_DAC" : VCAP Regulation Reference: This register is used to program the capacitor voltage feedback loop's reference voltage. Only bits 3:0 are active. VCAPFB_DAC = 37.5mV * vcapfb_dac + 637.5mV
*/

//!@{
#define LTC3351_VCAPFB_DAC_REG_SUBADDR 3u
#define LTC3351_VCAPFB_DAC_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VCAPFB_DAC_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VCAPFB_DAC VCAPFB_DAC
 *  @ingroup LTC3351_register_map
 *  @brief VCAPFB_DAC Bit Field
 *
 *  VCAP Regulation Reference: This register is used to program the capacitor voltage feedback loop's reference voltage. Only bits 3:0 are active. VCAPFB_DAC = 37.5mV * vcapfb_dac + 637.5mV
 *   - Register: @ref LTC3351_VCAPFB_DAC_REG "VCAPFB_DAC_REG"
 *   - CommandCode: 3
 *   - Size: 4
 *   - Offset: 0
 *   - MSB: 3
 *   - MASK: 0x000F
 *   - Access: R/W
 *   - Default: 10
 *   - Format: LTC3351_VCAPFB_DAC_FORMAT
 */
//!@{
#define LTC3351_VCAPFB_DAC_SUBADDR LTC3351_VCAPFB_DAC_REG_SUBADDR //!< @ref LTC3351_VCAPFB_DAC "VCAPFB_DAC"
#define LTC3351_VCAPFB_DAC_SIZE 4u
#define LTC3351_VCAPFB_DAC_OFFSET 0u
#define LTC3351_VCAPFB_DAC_MASK 0x000Fu
#define LTC3351_VCAPFB_DAC_DEFAULT 10u
#define LTC3351_VCAPFB_DAC_DECODE(register_data) (((register_data) & LTC3351_VCAPFB_DAC_MASK) >> LTC3351_VCAPFB_DAC_OFFSET)
#define LTC3351_VCAPFB_DAC (LTC3351_VCAPFB_DAC_OFFSET << 12 | (LTC3351_VCAPFB_DAC_SIZE - 1) << 8 | LTC3351_VCAPFB_DAC_SUBADDR)
//!@}

/*! @defgroup LTC3351_VSHUNT_REG VSHUNT_REG
 *  @ingroup LTC3351_register_map
 *  @brief VSHUNT_REG Register
 *
 * |   15:0 |
 * |:------:|
 * | VSHUNT |
 *
 *   - CommandCode: 5
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VSHUNT "VSHUNT" : Shunt Voltage Register: This register programs the shunt voltage for each capacitor in the stack. When set below 3.6V, the charger will limit current and the active shunts will shunt current to prevent this voltage from being exceeded. As a capacitor voltage nears this level, the charge current will be reduced. Current will be shunted when the capacitor voltage is within 25mV of vshunt. Vshunt should be programmed at least 50mV higher than the intended final balanced individual capacitor voltage. When programmed above 3.6V no current will be shunted, however the charge current will be reduced as described. 182.8µV per LSB.
*/

//!@{
#define LTC3351_VSHUNT_REG_SUBADDR 5u
#define LTC3351_VSHUNT_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VSHUNT_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VSHUNT VSHUNT
 *  @ingroup LTC3351_register_map
 *  @brief VSHUNT Bit Field
 *
 *  Shunt Voltage Register: This register programs the shunt voltage for each capacitor in the stack. When set below 3.6V, the charger will limit current and the active shunts will shunt current to prevent this voltage from being exceeded. As a capacitor voltage nears this level, the charge current will be reduced. Current will be shunted when the capacitor voltage is within 25mV of vshunt. Vshunt should be programmed at least 50mV higher than the intended final balanced individual capacitor voltage. When programmed above 3.6V no current will be shunted, however the charge current will be reduced as described. 182.8µV per LSB.
 *   - Register: @ref LTC3351_VSHUNT_REG "VSHUNT_REG"
 *   - CommandCode: 5
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 14744
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_VSHUNT_SUBADDR LTC3351_VSHUNT_REG_SUBADDR //!< @ref LTC3351_VSHUNT "VSHUNT"
#define LTC3351_VSHUNT_SIZE 16u
#define LTC3351_VSHUNT_OFFSET 0u
#define LTC3351_VSHUNT_MASK 0xFFFFu
#define LTC3351_VSHUNT_DEFAULT 14744u
#define LTC3351_VSHUNT_DECODE(register_data) (register_data)
#define LTC3351_VSHUNT (LTC3351_VSHUNT_OFFSET << 12 | (LTC3351_VSHUNT_SIZE - 1) << 8 | LTC3351_VSHUNT_SUBADDR)
//!@}

/*! @defgroup LTC3351_ADC_VIN_CH_EN_REG ADC_VIN_CH_EN_REG
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_CH_EN_REG Register
 *
 * | 15:12 |               11 |               10 |                9 |                8 |              7 |               6 |               5 |              4 |              3 |                2 |               1 |
 * |:-----:|:----------------:|:----------------:|:----------------:|:----------------:|:--------------:|:---------------:|:---------------:|:--------------:|:--------------:|:----------------:|:---------------:|
 * |   n/a | ADC_VIN_VCAP4_EN | ADC_VIN_VCAP3_EN | ADC_VIN_VCAP2_EN | ADC_VIN_VCAP1_EN | ADC_VIN_VIN_EN | ADC_VIN_VCAP_EN | ADC_VIN_VOUT_EN | ADC_VIN_IIN_EN | ADC_VIN_GPI_EN | ADC_VIN_DTEMP_EN | ADC_VIN_ICHG_EN |
 *
 *   - CommandCode: 6
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ADC_VIN_ICHG_EN "ADC_VIN_ICHG_EN" : Enables ADC measurement of charge current while in charging mode.
 *     + @ref LTC3351_ADC_VIN_DTEMP_EN "ADC_VIN_DTEMP_EN" : Enables ADC measurement of die temperature while in charging mode.
 *     + @ref LTC3351_ADC_VIN_GPI_EN "ADC_VIN_GPI_EN" : Enables ADC measurement of GPI (general purpose input) while in charging mode.
 *     + @ref LTC3351_ADC_VIN_IIN_EN "ADC_VIN_IIN_EN" : Enables ADC measurement of input current while in charging mode.
 *     + @ref LTC3351_ADC_VIN_VOUT_EN "ADC_VIN_VOUT_EN" : Enables ADC measurement of vout while in charging mode.
 *     + @ref LTC3351_ADC_VIN_VCAP_EN "ADC_VIN_VCAP_EN" : Enables ADC measurement of vcap while in charging mode.
 *     + @ref LTC3351_ADC_VIN_VIN_EN "ADC_VIN_VIN_EN" : Enables ADC measurement of vin while in charging mode.
 *     + @ref LTC3351_ADC_VIN_VCAP1_EN "ADC_VIN_VCAP1_EN" : Enables ADC measurement of vcap1 while in charging mode. This bit must be set for capacitance and ESR measurement.
 *     + @ref LTC3351_ADC_VIN_VCAP2_EN "ADC_VIN_VCAP2_EN" : Enables ADC measurement of vcap2 while in charging mode. This bit must be set for capacitance and ESR measurement if there are two or more capacitors in the stack.
 *     + @ref LTC3351_ADC_VIN_VCAP3_EN "ADC_VIN_VCAP3_EN" : Enables ADC measurement of vcap3 while in charging mode. This bit must be set for capacitance and ESR measurement if there are three or more capacitors in the stack
 *     + @ref LTC3351_ADC_VIN_VCAP4_EN "ADC_VIN_VCAP4_EN" : Enables ADC measurement of vcap4 while in charging mode. This bit must be set for capacitance and ESR measurement if there are four capacitors in the stack
*/

//!@{
#define LTC3351_ADC_VIN_CH_EN_REG_SUBADDR 6u
#define LTC3351_ADC_VIN_CH_EN_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ADC_VIN_CH_EN_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_ICHG_EN ADC_VIN_ICHG_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_ICHG_EN Bit Field
 *
 *  Enables ADC measurement of charge current while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R/W
 *   - Default: 1
 */
//!@{
#define LTC3351_ADC_VIN_ICHG_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_ICHG_EN "ADC_VIN_ICHG_EN"
#define LTC3351_ADC_VIN_ICHG_EN_SIZE 1u
#define LTC3351_ADC_VIN_ICHG_EN_OFFSET 1u
#define LTC3351_ADC_VIN_ICHG_EN_MASK 0x0002u
#define LTC3351_ADC_VIN_ICHG_EN_DEFAULT 1u
#define LTC3351_ADC_VIN_ICHG_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_ICHG_EN_MASK) >> LTC3351_ADC_VIN_ICHG_EN_OFFSET)
#define LTC3351_ADC_VIN_ICHG_EN (LTC3351_ADC_VIN_ICHG_EN_OFFSET << 12 | (LTC3351_ADC_VIN_ICHG_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_ICHG_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_DTEMP_EN ADC_VIN_DTEMP_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_DTEMP_EN Bit Field
 *
 *  Enables ADC measurement of die temperature while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_DTEMP_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_DTEMP_EN "ADC_VIN_DTEMP_EN"
#define LTC3351_ADC_VIN_DTEMP_EN_SIZE 1u
#define LTC3351_ADC_VIN_DTEMP_EN_OFFSET 2u
#define LTC3351_ADC_VIN_DTEMP_EN_MASK 0x0004u
#define LTC3351_ADC_VIN_DTEMP_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_DTEMP_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_DTEMP_EN_MASK) >> LTC3351_ADC_VIN_DTEMP_EN_OFFSET)
#define LTC3351_ADC_VIN_DTEMP_EN (LTC3351_ADC_VIN_DTEMP_EN_OFFSET << 12 | (LTC3351_ADC_VIN_DTEMP_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_DTEMP_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_GPI_EN ADC_VIN_GPI_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_GPI_EN Bit Field
 *
 *  Enables ADC measurement of GPI (general purpose input) while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_GPI_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_GPI_EN "ADC_VIN_GPI_EN"
#define LTC3351_ADC_VIN_GPI_EN_SIZE 1u
#define LTC3351_ADC_VIN_GPI_EN_OFFSET 3u
#define LTC3351_ADC_VIN_GPI_EN_MASK 0x0008u
#define LTC3351_ADC_VIN_GPI_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_GPI_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_GPI_EN_MASK) >> LTC3351_ADC_VIN_GPI_EN_OFFSET)
#define LTC3351_ADC_VIN_GPI_EN (LTC3351_ADC_VIN_GPI_EN_OFFSET << 12 | (LTC3351_ADC_VIN_GPI_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_GPI_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_IIN_EN ADC_VIN_IIN_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_IIN_EN Bit Field
 *
 *  Enables ADC measurement of input current while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_IIN_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_IIN_EN "ADC_VIN_IIN_EN"
#define LTC3351_ADC_VIN_IIN_EN_SIZE 1u
#define LTC3351_ADC_VIN_IIN_EN_OFFSET 4u
#define LTC3351_ADC_VIN_IIN_EN_MASK 0x0010u
#define LTC3351_ADC_VIN_IIN_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_IIN_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_IIN_EN_MASK) >> LTC3351_ADC_VIN_IIN_EN_OFFSET)
#define LTC3351_ADC_VIN_IIN_EN (LTC3351_ADC_VIN_IIN_EN_OFFSET << 12 | (LTC3351_ADC_VIN_IIN_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_IIN_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VOUT_EN ADC_VIN_VOUT_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VOUT_EN Bit Field
 *
 *  Enables ADC measurement of vout while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_VOUT_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VOUT_EN "ADC_VIN_VOUT_EN"
#define LTC3351_ADC_VIN_VOUT_EN_SIZE 1u
#define LTC3351_ADC_VIN_VOUT_EN_OFFSET 5u
#define LTC3351_ADC_VIN_VOUT_EN_MASK 0x0020u
#define LTC3351_ADC_VIN_VOUT_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_VOUT_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VOUT_EN_MASK) >> LTC3351_ADC_VIN_VOUT_EN_OFFSET)
#define LTC3351_ADC_VIN_VOUT_EN (LTC3351_ADC_VIN_VOUT_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VOUT_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VOUT_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VCAP_EN ADC_VIN_VCAP_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VCAP_EN Bit Field
 *
 *  Enables ADC measurement of vcap while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_VCAP_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VCAP_EN "ADC_VIN_VCAP_EN"
#define LTC3351_ADC_VIN_VCAP_EN_SIZE 1u
#define LTC3351_ADC_VIN_VCAP_EN_OFFSET 6u
#define LTC3351_ADC_VIN_VCAP_EN_MASK 0x0040u
#define LTC3351_ADC_VIN_VCAP_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_VCAP_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VCAP_EN_MASK) >> LTC3351_ADC_VIN_VCAP_EN_OFFSET)
#define LTC3351_ADC_VIN_VCAP_EN (LTC3351_ADC_VIN_VCAP_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VCAP_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VCAP_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VIN_EN ADC_VIN_VIN_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VIN_EN Bit Field
 *
 *  Enables ADC measurement of vin while in charging mode.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_VIN_VIN_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VIN_EN "ADC_VIN_VIN_EN"
#define LTC3351_ADC_VIN_VIN_EN_SIZE 1u
#define LTC3351_ADC_VIN_VIN_EN_OFFSET 7u
#define LTC3351_ADC_VIN_VIN_EN_MASK 0x0080u
#define LTC3351_ADC_VIN_VIN_EN_DEFAULT 0u
#define LTC3351_ADC_VIN_VIN_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VIN_EN_MASK) >> LTC3351_ADC_VIN_VIN_EN_OFFSET)
#define LTC3351_ADC_VIN_VIN_EN (LTC3351_ADC_VIN_VIN_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VIN_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VIN_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VCAP1_EN ADC_VIN_VCAP1_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VCAP1_EN Bit Field
 *
 *  Enables ADC measurement of vcap1 while in charging mode. This bit must be set for capacitance and ESR measurement.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 1
 */
//!@{
#define LTC3351_ADC_VIN_VCAP1_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VCAP1_EN "ADC_VIN_VCAP1_EN"
#define LTC3351_ADC_VIN_VCAP1_EN_SIZE 1u
#define LTC3351_ADC_VIN_VCAP1_EN_OFFSET 8u
#define LTC3351_ADC_VIN_VCAP1_EN_MASK 0x0100u
#define LTC3351_ADC_VIN_VCAP1_EN_DEFAULT 1u
#define LTC3351_ADC_VIN_VCAP1_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VCAP1_EN_MASK) >> LTC3351_ADC_VIN_VCAP1_EN_OFFSET)
#define LTC3351_ADC_VIN_VCAP1_EN (LTC3351_ADC_VIN_VCAP1_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VCAP1_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VCAP1_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VCAP2_EN ADC_VIN_VCAP2_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VCAP2_EN Bit Field
 *
 *  Enables ADC measurement of vcap2 while in charging mode. This bit must be set for capacitance and ESR measurement if there are two or more capacitors in the stack.
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R/W
 *   - Default: 1
 */
//!@{
#define LTC3351_ADC_VIN_VCAP2_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VCAP2_EN "ADC_VIN_VCAP2_EN"
#define LTC3351_ADC_VIN_VCAP2_EN_SIZE 1u
#define LTC3351_ADC_VIN_VCAP2_EN_OFFSET 9u
#define LTC3351_ADC_VIN_VCAP2_EN_MASK 0x0200u
#define LTC3351_ADC_VIN_VCAP2_EN_DEFAULT 1u
#define LTC3351_ADC_VIN_VCAP2_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VCAP2_EN_MASK) >> LTC3351_ADC_VIN_VCAP2_EN_OFFSET)
#define LTC3351_ADC_VIN_VCAP2_EN (LTC3351_ADC_VIN_VCAP2_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VCAP2_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VCAP2_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VCAP3_EN ADC_VIN_VCAP3_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VCAP3_EN Bit Field
 *
 *  Enables ADC measurement of vcap3 while in charging mode. This bit must be set for capacitance and ESR measurement if there are three or more capacitors in the stack
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 1
 */
//!@{
#define LTC3351_ADC_VIN_VCAP3_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VCAP3_EN "ADC_VIN_VCAP3_EN"
#define LTC3351_ADC_VIN_VCAP3_EN_SIZE 1u
#define LTC3351_ADC_VIN_VCAP3_EN_OFFSET 10u
#define LTC3351_ADC_VIN_VCAP3_EN_MASK 0x0400u
#define LTC3351_ADC_VIN_VCAP3_EN_DEFAULT 1u
#define LTC3351_ADC_VIN_VCAP3_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VCAP3_EN_MASK) >> LTC3351_ADC_VIN_VCAP3_EN_OFFSET)
#define LTC3351_ADC_VIN_VCAP3_EN (LTC3351_ADC_VIN_VCAP3_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VCAP3_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VCAP3_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_VIN_VCAP4_EN ADC_VIN_VCAP4_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_VIN_VCAP4_EN Bit Field
 *
 *  Enables ADC measurement of vcap4 while in charging mode. This bit must be set for capacitance and ESR measurement if there are four capacitors in the stack
 *   - Register: @ref LTC3351_ADC_VIN_CH_EN_REG "ADC_VIN_CH_EN_REG"
 *   - CommandCode: 6
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R/W
 *   - Default: 1
 */
//!@{
#define LTC3351_ADC_VIN_VCAP4_EN_SUBADDR LTC3351_ADC_VIN_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_VIN_VCAP4_EN "ADC_VIN_VCAP4_EN"
#define LTC3351_ADC_VIN_VCAP4_EN_SIZE 1u
#define LTC3351_ADC_VIN_VCAP4_EN_OFFSET 11u
#define LTC3351_ADC_VIN_VCAP4_EN_MASK 0x0800u
#define LTC3351_ADC_VIN_VCAP4_EN_DEFAULT 1u
#define LTC3351_ADC_VIN_VCAP4_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_VIN_VCAP4_EN_MASK) >> LTC3351_ADC_VIN_VCAP4_EN_OFFSET)
#define LTC3351_ADC_VIN_VCAP4_EN (LTC3351_ADC_VIN_VCAP4_EN_OFFSET << 12 | (LTC3351_ADC_VIN_VCAP4_EN_SIZE - 1) << 8 | LTC3351_ADC_VIN_VCAP4_EN_SUBADDR)
//!@}

/*! @defgroup LTC3351_ADC_BACKUP_CH_EN_REG ADC_BACKUP_CH_EN_REG
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_CH_EN_REG Register
 *
 * | 15:12 |                  11 |                  10 |                   9 |                   8 |                 7 |                  6 |                  5 |                 4 |                 3 |                   2 |                  1 |
 * |:-----:|:-------------------:|:-------------------:|:-------------------:|:-------------------:|:-----------------:|:------------------:|:------------------:|:-----------------:|:-----------------:|:-------------------:|:------------------:|
 * |   n/a | ADC_BACKUP_VCAP4_EN | ADC_BACKUP_VCAP3_EN | ADC_BACKUP_VCAP2_EN | ADC_BACKUP_VCAP1_EN | ADC_BACKUP_VIN_EN | ADC_BACKUP_VCAP_EN | ADC_BACKUP_VOUT_EN | ADC_BACKUP_IIN_EN | ADC_BACKUP_GPI_EN | ADC_BACKUP_DTEMP_EN | ADC_BACKUP_ICHG_EN |
 *
 *   - CommandCode: 7
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ADC_BACKUP_ICHG_EN "ADC_BACKUP_ICHG_EN" : Enables ADC measurement of charge current while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_DTEMP_EN "ADC_BACKUP_DTEMP_EN" : Enables ADC measurement of die temperature while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_GPI_EN "ADC_BACKUP_GPI_EN" : Enables ADC measurement of GPI (general purpose input) while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_IIN_EN "ADC_BACKUP_IIN_EN" : Enables ADC measurement of input current while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VOUT_EN "ADC_BACKUP_VOUT_EN" : Enables ADC measurement of vout while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VCAP_EN "ADC_BACKUP_VCAP_EN" : Enables ADC measurement of vcap while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VIN_EN "ADC_BACKUP_VIN_EN" : Enables ADC measurement of vin while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VCAP1_EN "ADC_BACKUP_VCAP1_EN" : Enables ADC measurement of vcap1 while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VCAP2_EN "ADC_BACKUP_VCAP2_EN" : Enables ADC measurement of vcap2 while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VCAP3_EN "ADC_BACKUP_VCAP3_EN" : Enables ADC measurement of vcap3 while in backup mode.
 *     + @ref LTC3351_ADC_BACKUP_VCAP4_EN "ADC_BACKUP_VCAP4_EN" : Enables ADC measurement of vcap4 while in backup mode.
*/

//!@{
#define LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR 7u
#define LTC3351_ADC_BACKUP_CH_EN_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_ICHG_EN ADC_BACKUP_ICHG_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_ICHG_EN Bit Field
 *
 *  Enables ADC measurement of charge current while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_ICHG_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_ICHG_EN "ADC_BACKUP_ICHG_EN"
#define LTC3351_ADC_BACKUP_ICHG_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_ICHG_EN_OFFSET 1u
#define LTC3351_ADC_BACKUP_ICHG_EN_MASK 0x0002u
#define LTC3351_ADC_BACKUP_ICHG_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_ICHG_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_ICHG_EN_MASK) >> LTC3351_ADC_BACKUP_ICHG_EN_OFFSET)
#define LTC3351_ADC_BACKUP_ICHG_EN (LTC3351_ADC_BACKUP_ICHG_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_ICHG_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_ICHG_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_DTEMP_EN ADC_BACKUP_DTEMP_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_DTEMP_EN Bit Field
 *
 *  Enables ADC measurement of die temperature while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_DTEMP_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_DTEMP_EN "ADC_BACKUP_DTEMP_EN"
#define LTC3351_ADC_BACKUP_DTEMP_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_DTEMP_EN_OFFSET 2u
#define LTC3351_ADC_BACKUP_DTEMP_EN_MASK 0x0004u
#define LTC3351_ADC_BACKUP_DTEMP_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_DTEMP_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_DTEMP_EN_MASK) >> LTC3351_ADC_BACKUP_DTEMP_EN_OFFSET)
#define LTC3351_ADC_BACKUP_DTEMP_EN (LTC3351_ADC_BACKUP_DTEMP_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_DTEMP_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_DTEMP_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_GPI_EN ADC_BACKUP_GPI_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_GPI_EN Bit Field
 *
 *  Enables ADC measurement of GPI (general purpose input) while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_GPI_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_GPI_EN "ADC_BACKUP_GPI_EN"
#define LTC3351_ADC_BACKUP_GPI_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_GPI_EN_OFFSET 3u
#define LTC3351_ADC_BACKUP_GPI_EN_MASK 0x0008u
#define LTC3351_ADC_BACKUP_GPI_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_GPI_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_GPI_EN_MASK) >> LTC3351_ADC_BACKUP_GPI_EN_OFFSET)
#define LTC3351_ADC_BACKUP_GPI_EN (LTC3351_ADC_BACKUP_GPI_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_GPI_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_GPI_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_IIN_EN ADC_BACKUP_IIN_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_IIN_EN Bit Field
 *
 *  Enables ADC measurement of input current while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_IIN_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_IIN_EN "ADC_BACKUP_IIN_EN"
#define LTC3351_ADC_BACKUP_IIN_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_IIN_EN_OFFSET 4u
#define LTC3351_ADC_BACKUP_IIN_EN_MASK 0x0010u
#define LTC3351_ADC_BACKUP_IIN_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_IIN_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_IIN_EN_MASK) >> LTC3351_ADC_BACKUP_IIN_EN_OFFSET)
#define LTC3351_ADC_BACKUP_IIN_EN (LTC3351_ADC_BACKUP_IIN_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_IIN_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_IIN_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VOUT_EN ADC_BACKUP_VOUT_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VOUT_EN Bit Field
 *
 *  Enables ADC measurement of vout while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VOUT_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VOUT_EN "ADC_BACKUP_VOUT_EN"
#define LTC3351_ADC_BACKUP_VOUT_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VOUT_EN_OFFSET 5u
#define LTC3351_ADC_BACKUP_VOUT_EN_MASK 0x0020u
#define LTC3351_ADC_BACKUP_VOUT_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VOUT_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VOUT_EN_MASK) >> LTC3351_ADC_BACKUP_VOUT_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VOUT_EN (LTC3351_ADC_BACKUP_VOUT_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VOUT_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VOUT_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VCAP_EN ADC_BACKUP_VCAP_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VCAP_EN Bit Field
 *
 *  Enables ADC measurement of vcap while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VCAP_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VCAP_EN "ADC_BACKUP_VCAP_EN"
#define LTC3351_ADC_BACKUP_VCAP_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VCAP_EN_OFFSET 6u
#define LTC3351_ADC_BACKUP_VCAP_EN_MASK 0x0040u
#define LTC3351_ADC_BACKUP_VCAP_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VCAP_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VCAP_EN_MASK) >> LTC3351_ADC_BACKUP_VCAP_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VCAP_EN (LTC3351_ADC_BACKUP_VCAP_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VCAP_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VCAP_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VIN_EN ADC_BACKUP_VIN_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VIN_EN Bit Field
 *
 *  Enables ADC measurement of vin while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VIN_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VIN_EN "ADC_BACKUP_VIN_EN"
#define LTC3351_ADC_BACKUP_VIN_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VIN_EN_OFFSET 7u
#define LTC3351_ADC_BACKUP_VIN_EN_MASK 0x0080u
#define LTC3351_ADC_BACKUP_VIN_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VIN_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VIN_EN_MASK) >> LTC3351_ADC_BACKUP_VIN_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VIN_EN (LTC3351_ADC_BACKUP_VIN_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VIN_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VIN_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VCAP1_EN ADC_BACKUP_VCAP1_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VCAP1_EN Bit Field
 *
 *  Enables ADC measurement of vcap1 while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VCAP1_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VCAP1_EN "ADC_BACKUP_VCAP1_EN"
#define LTC3351_ADC_BACKUP_VCAP1_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VCAP1_EN_OFFSET 8u
#define LTC3351_ADC_BACKUP_VCAP1_EN_MASK 0x0100u
#define LTC3351_ADC_BACKUP_VCAP1_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VCAP1_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VCAP1_EN_MASK) >> LTC3351_ADC_BACKUP_VCAP1_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VCAP1_EN (LTC3351_ADC_BACKUP_VCAP1_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VCAP1_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VCAP1_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VCAP2_EN ADC_BACKUP_VCAP2_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VCAP2_EN Bit Field
 *
 *  Enables ADC measurement of vcap2 while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VCAP2_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VCAP2_EN "ADC_BACKUP_VCAP2_EN"
#define LTC3351_ADC_BACKUP_VCAP2_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VCAP2_EN_OFFSET 9u
#define LTC3351_ADC_BACKUP_VCAP2_EN_MASK 0x0200u
#define LTC3351_ADC_BACKUP_VCAP2_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VCAP2_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VCAP2_EN_MASK) >> LTC3351_ADC_BACKUP_VCAP2_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VCAP2_EN (LTC3351_ADC_BACKUP_VCAP2_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VCAP2_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VCAP2_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VCAP3_EN ADC_BACKUP_VCAP3_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VCAP3_EN Bit Field
 *
 *  Enables ADC measurement of vcap3 while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VCAP3_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VCAP3_EN "ADC_BACKUP_VCAP3_EN"
#define LTC3351_ADC_BACKUP_VCAP3_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VCAP3_EN_OFFSET 10u
#define LTC3351_ADC_BACKUP_VCAP3_EN_MASK 0x0400u
#define LTC3351_ADC_BACKUP_VCAP3_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VCAP3_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VCAP3_EN_MASK) >> LTC3351_ADC_BACKUP_VCAP3_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VCAP3_EN (LTC3351_ADC_BACKUP_VCAP3_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VCAP3_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VCAP3_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_BACKUP_VCAP4_EN ADC_BACKUP_VCAP4_EN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_BACKUP_VCAP4_EN Bit Field
 *
 *  Enables ADC measurement of vcap4 while in backup mode.
 *   - Register: @ref LTC3351_ADC_BACKUP_CH_EN_REG "ADC_BACKUP_CH_EN_REG"
 *   - CommandCode: 7
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ADC_BACKUP_VCAP4_EN_SUBADDR LTC3351_ADC_BACKUP_CH_EN_REG_SUBADDR //!< @ref LTC3351_ADC_BACKUP_VCAP4_EN "ADC_BACKUP_VCAP4_EN"
#define LTC3351_ADC_BACKUP_VCAP4_EN_SIZE 1u
#define LTC3351_ADC_BACKUP_VCAP4_EN_OFFSET 11u
#define LTC3351_ADC_BACKUP_VCAP4_EN_MASK 0x0800u
#define LTC3351_ADC_BACKUP_VCAP4_EN_DEFAULT 0u
#define LTC3351_ADC_BACKUP_VCAP4_EN_DECODE(register_data) (((register_data) & LTC3351_ADC_BACKUP_VCAP4_EN_MASK) >> LTC3351_ADC_BACKUP_VCAP4_EN_OFFSET)
#define LTC3351_ADC_BACKUP_VCAP4_EN (LTC3351_ADC_BACKUP_VCAP4_EN_OFFSET << 12 | (LTC3351_ADC_BACKUP_VCAP4_EN_SIZE - 1) << 8 | LTC3351_ADC_BACKUP_VCAP4_EN_SUBADDR)
//!@}

/*! @defgroup LTC3351_ADC_WAIT_VIN_REG ADC_WAIT_VIN_REG
 *  @ingroup LTC3351_register_map
 *  @brief ADC_WAIT_VIN_REG Register
 *
 * |         15:0 |
 * |:------------:|
 * | ADC_WAIT_VIN |
 *
 *   - CommandCode: 8
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ADC_WAIT_VIN "ADC_WAIT_VIN" : Sets the wait time between ADC measurement groups while in charging mode. The LSB of this register has a weight of 400uS. The ADC measures all enabled channels then waits this time before measuring all channels again. The ADC data is used for balancing and shunting, increasing this time reduces the shunt and balancer update rate and is not typically recommended if shunting or balancing is enabled. If shunting or measuring capacitance/ESR this time may be ignored by the ADC. 400uS per LSB
*/

//!@{
#define LTC3351_ADC_WAIT_VIN_REG_SUBADDR 8u
#define LTC3351_ADC_WAIT_VIN_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ADC_WAIT_VIN_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_WAIT_VIN ADC_WAIT_VIN
 *  @ingroup LTC3351_register_map
 *  @brief ADC_WAIT_VIN Bit Field
 *
 *  Sets the wait time between ADC measurement groups while in charging mode. The LSB of this register has a weight of 400uS. The ADC measures all enabled channels then waits this time before measuring all channels again. The ADC data is used for balancing and shunting, increasing this time reduces the shunt and balancer update rate and is not typically recommended if shunting or balancing is enabled. If shunting or measuring capacitance/ESR this time may be ignored by the ADC. 400uS per LSB
 *   - Register: @ref LTC3351_ADC_WAIT_VIN_REG "ADC_WAIT_VIN_REG"
 *   - CommandCode: 8
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 100
 */
//!@{
#define LTC3351_ADC_WAIT_VIN_SUBADDR LTC3351_ADC_WAIT_VIN_REG_SUBADDR //!< @ref LTC3351_ADC_WAIT_VIN "ADC_WAIT_VIN"
#define LTC3351_ADC_WAIT_VIN_SIZE 16u
#define LTC3351_ADC_WAIT_VIN_OFFSET 0u
#define LTC3351_ADC_WAIT_VIN_MASK 0xFFFFu
#define LTC3351_ADC_WAIT_VIN_DEFAULT 100u
#define LTC3351_ADC_WAIT_VIN_DECODE(register_data) (register_data)
#define LTC3351_ADC_WAIT_VIN (LTC3351_ADC_WAIT_VIN_OFFSET << 12 | (LTC3351_ADC_WAIT_VIN_SIZE - 1) << 8 | LTC3351_ADC_WAIT_VIN_SUBADDR)
//!@}

/*! @defgroup LTC3351_ADC_WAIT_BACKUP_REG ADC_WAIT_BACKUP_REG
 *  @ingroup LTC3351_register_map
 *  @brief ADC_WAIT_BACKUP_REG Register
 *
 * |            15:0 |
 * |:---------------:|
 * | ADC_WAIT_BACKUP |
 *
 *   - CommandCode: 9
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ADC_WAIT_BACKUP "ADC_WAIT_BACKUP" : Sets the wait time between ADC measurement groups while in backup mode. The LSB of this register has a weight of 400uS. The ADC measures all enabled channels then waits this time before measuring all channels again. 400uS per LSB
*/

//!@{
#define LTC3351_ADC_WAIT_BACKUP_REG_SUBADDR 9u
#define LTC3351_ADC_WAIT_BACKUP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ADC_WAIT_BACKUP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ADC_WAIT_BACKUP ADC_WAIT_BACKUP
 *  @ingroup LTC3351_register_map
 *  @brief ADC_WAIT_BACKUP Bit Field
 *
 *  Sets the wait time between ADC measurement groups while in backup mode. The LSB of this register has a weight of 400uS. The ADC measures all enabled channels then waits this time before measuring all channels again. 400uS per LSB
 *   - Register: @ref LTC3351_ADC_WAIT_BACKUP_REG "ADC_WAIT_BACKUP_REG"
 *   - CommandCode: 9
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 100
 */
//!@{
#define LTC3351_ADC_WAIT_BACKUP_SUBADDR LTC3351_ADC_WAIT_BACKUP_REG_SUBADDR //!< @ref LTC3351_ADC_WAIT_BACKUP "ADC_WAIT_BACKUP"
#define LTC3351_ADC_WAIT_BACKUP_SIZE 16u
#define LTC3351_ADC_WAIT_BACKUP_OFFSET 0u
#define LTC3351_ADC_WAIT_BACKUP_MASK 0xFFFFu
#define LTC3351_ADC_WAIT_BACKUP_DEFAULT 100u
#define LTC3351_ADC_WAIT_BACKUP_DECODE(register_data) (register_data)
#define LTC3351_ADC_WAIT_BACKUP (LTC3351_ADC_WAIT_BACKUP_OFFSET << 12 | (LTC3351_ADC_WAIT_BACKUP_SIZE - 1) << 8 | LTC3351_ADC_WAIT_BACKUP_SUBADDR)
//!@}

/*! @defgroup LTC3351_GPI_UV_LVL_REG GPI_UV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief GPI_UV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | GPI_UV_LVL |
 *
 *   - CommandCode: 10
 *   - Contains Bit Fields:
 *     + @ref LTC3351_GPI_UV_LVL "GPI_UV_LVL" : General Purpose Input Under Voltage Level: This is an alarm threshold for the GPI pin. If enabled, the GPI pin voltage falling below this level will trigger an alarm and an SMBALERT. 182.8µV per LSB
*/

//!@{
#define LTC3351_GPI_UV_LVL_REG_SUBADDR 10u
#define LTC3351_GPI_UV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_GPI_UV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_GPI_UV_LVL GPI_UV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief GPI_UV_LVL Bit Field
 *
 *  General Purpose Input Under Voltage Level: This is an alarm threshold for the GPI pin. If enabled, the GPI pin voltage falling below this level will trigger an alarm and an SMBALERT. 182.8µV per LSB
 *   - Register: @ref LTC3351_GPI_UV_LVL_REG "GPI_UV_LVL_REG"
 *   - CommandCode: 10
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_GPI_UV_LVL_SUBADDR LTC3351_GPI_UV_LVL_REG_SUBADDR //!< @ref LTC3351_GPI_UV_LVL "GPI_UV_LVL"
#define LTC3351_GPI_UV_LVL_SIZE 16u
#define LTC3351_GPI_UV_LVL_OFFSET 0u
#define LTC3351_GPI_UV_LVL_MASK 0xFFFFu
#define LTC3351_GPI_UV_LVL_DEFAULT 0u
#define LTC3351_GPI_UV_LVL_DECODE(register_data) (register_data)
#define LTC3351_GPI_UV_LVL (LTC3351_GPI_UV_LVL_OFFSET << 12 | (LTC3351_GPI_UV_LVL_SIZE - 1) << 8 | LTC3351_GPI_UV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_GPI_OV_LVL_REG GPI_OV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief GPI_OV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | GPI_OV_LVL |
 *
 *   - CommandCode: 11
 *   - Contains Bit Fields:
 *     + @ref LTC3351_GPI_OV_LVL "GPI_OV_LVL" : General Purpose Input Over Voltage Level: This is an alarm threshold for the GPI pin. If enabled, the GPI pin voltage rising above this level will trigger an alarm and an SMBALERT. 182.8µV per LSB 
*/

//!@{
#define LTC3351_GPI_OV_LVL_REG_SUBADDR 11u
#define LTC3351_GPI_OV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_GPI_OV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_GPI_OV_LVL GPI_OV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief GPI_OV_LVL Bit Field
 *
 *  General Purpose Input Over Voltage Level: This is an alarm threshold for the GPI pin. If enabled, the GPI pin voltage rising above this level will trigger an alarm and an SMBALERT. 182.8µV per LSB 
 *   - Register: @ref LTC3351_GPI_OV_LVL_REG "GPI_OV_LVL_REG"
 *   - CommandCode: 11
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_GPI_OV_LVL_SUBADDR LTC3351_GPI_OV_LVL_REG_SUBADDR //!< @ref LTC3351_GPI_OV_LVL "GPI_OV_LVL"
#define LTC3351_GPI_OV_LVL_SIZE 16u
#define LTC3351_GPI_OV_LVL_OFFSET 0u
#define LTC3351_GPI_OV_LVL_MASK 0xFFFFu
#define LTC3351_GPI_OV_LVL_DEFAULT 0u
#define LTC3351_GPI_OV_LVL_DECODE(register_data) (register_data)
#define LTC3351_GPI_OV_LVL (LTC3351_GPI_OV_LVL_OFFSET << 12 | (LTC3351_GPI_OV_LVL_SIZE - 1) << 8 | LTC3351_GPI_OV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VIN_UV_LVL_REG VIN_UV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VIN_UV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | VIN_UV_LVL |
 *
 *   - CommandCode: 12
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VIN_UV_LVL "VIN_UV_LVL" : VIN Under Voltage Level: This is an alarm threshold for the input voltage. If enabled, the input pin voltage falling below this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
*/

//!@{
#define LTC3351_VIN_UV_LVL_REG_SUBADDR 12u
#define LTC3351_VIN_UV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VIN_UV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VIN_UV_LVL VIN_UV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VIN_UV_LVL Bit Field
 *
 *  VIN Under Voltage Level: This is an alarm threshold for the input voltage. If enabled, the input pin voltage falling below this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
 *   - Register: @ref LTC3351_VIN_UV_LVL_REG "VIN_UV_LVL_REG"
 *   - CommandCode: 12
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VIN_FORMAT
 */
//!@{
#define LTC3351_VIN_UV_LVL_SUBADDR LTC3351_VIN_UV_LVL_REG_SUBADDR //!< @ref LTC3351_VIN_UV_LVL "VIN_UV_LVL"
#define LTC3351_VIN_UV_LVL_SIZE 16u
#define LTC3351_VIN_UV_LVL_OFFSET 0u
#define LTC3351_VIN_UV_LVL_MASK 0xFFFFu
#define LTC3351_VIN_UV_LVL_DEFAULT 0u
#define LTC3351_VIN_UV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VIN_UV_LVL (LTC3351_VIN_UV_LVL_OFFSET << 12 | (LTC3351_VIN_UV_LVL_SIZE - 1) << 8 | LTC3351_VIN_UV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VIN_OV_LVL_REG VIN_OV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VIN_OV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | VIN_OV_LVL |
 *
 *   - CommandCode: 13
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VIN_OV_LVL "VIN_OV_LVL" : VIN Over Voltage Level: This is an alarm threshold for the input voltage. If enabled, the input pin voltage rising above this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
*/

//!@{
#define LTC3351_VIN_OV_LVL_REG_SUBADDR 13u
#define LTC3351_VIN_OV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VIN_OV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VIN_OV_LVL VIN_OV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VIN_OV_LVL Bit Field
 *
 *  VIN Over Voltage Level: This is an alarm threshold for the input voltage. If enabled, the input pin voltage rising above this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
 *   - Register: @ref LTC3351_VIN_OV_LVL_REG "VIN_OV_LVL_REG"
 *   - CommandCode: 13
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VIN_FORMAT
 */
//!@{
#define LTC3351_VIN_OV_LVL_SUBADDR LTC3351_VIN_OV_LVL_REG_SUBADDR //!< @ref LTC3351_VIN_OV_LVL "VIN_OV_LVL"
#define LTC3351_VIN_OV_LVL_SIZE 16u
#define LTC3351_VIN_OV_LVL_OFFSET 0u
#define LTC3351_VIN_OV_LVL_MASK 0xFFFFu
#define LTC3351_VIN_OV_LVL_DEFAULT 0u
#define LTC3351_VIN_OV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VIN_OV_LVL (LTC3351_VIN_OV_LVL_OFFSET << 12 | (LTC3351_VIN_OV_LVL_SIZE - 1) << 8 | LTC3351_VIN_OV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VCAP_UV_LVL_REG VCAP_UV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VCAP_UV_LVL_REG Register
 *
 * |        15:0 |
 * |:-----------:|
 * | VCAP_UV_LVL |
 *
 *   - CommandCode: 14
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VCAP_UV_LVL "VCAP_UV_LVL" : VCAP Under Voltage Level: This is an alarm threshold for the capacitor stack voltage. If enabled, the VCAP pin voltage falling below this level will trigger an alarm and an SMBALERT. 1.46mV per LSB 
*/

//!@{
#define LTC3351_VCAP_UV_LVL_REG_SUBADDR 14u
#define LTC3351_VCAP_UV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VCAP_UV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VCAP_UV_LVL VCAP_UV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VCAP_UV_LVL Bit Field
 *
 *  VCAP Under Voltage Level: This is an alarm threshold for the capacitor stack voltage. If enabled, the VCAP pin voltage falling below this level will trigger an alarm and an SMBALERT. 1.46mV per LSB 
 *   - Register: @ref LTC3351_VCAP_UV_LVL_REG "VCAP_UV_LVL_REG"
 *   - CommandCode: 14
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VCAP_FORMAT
 */
//!@{
#define LTC3351_VCAP_UV_LVL_SUBADDR LTC3351_VCAP_UV_LVL_REG_SUBADDR //!< @ref LTC3351_VCAP_UV_LVL "VCAP_UV_LVL"
#define LTC3351_VCAP_UV_LVL_SIZE 16u
#define LTC3351_VCAP_UV_LVL_OFFSET 0u
#define LTC3351_VCAP_UV_LVL_MASK 0xFFFFu
#define LTC3351_VCAP_UV_LVL_DEFAULT 0u
#define LTC3351_VCAP_UV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VCAP_UV_LVL (LTC3351_VCAP_UV_LVL_OFFSET << 12 | (LTC3351_VCAP_UV_LVL_SIZE - 1) << 8 | LTC3351_VCAP_UV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VCAP_OV_LVL_REG VCAP_OV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VCAP_OV_LVL_REG Register
 *
 * |        15:0 |
 * |:-----------:|
 * | VCAP_OV_LVL |
 *
 *   - CommandCode: 15
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VCAP_OV_LVL "VCAP_OV_LVL" : VCAP Over Voltage Level: This is an alarm threshold for the capacitor stack voltage. If enabled, the VCAP pin voltage rising above this level will trigger an alarm and an SMBALERT. 1.46mV per LSB
*/

//!@{
#define LTC3351_VCAP_OV_LVL_REG_SUBADDR 15u
#define LTC3351_VCAP_OV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VCAP_OV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VCAP_OV_LVL VCAP_OV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VCAP_OV_LVL Bit Field
 *
 *  VCAP Over Voltage Level: This is an alarm threshold for the capacitor stack voltage. If enabled, the VCAP pin voltage rising above this level will trigger an alarm and an SMBALERT. 1.46mV per LSB
 *   - Register: @ref LTC3351_VCAP_OV_LVL_REG "VCAP_OV_LVL_REG"
 *   - CommandCode: 15
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VCAP_FORMAT
 */
//!@{
#define LTC3351_VCAP_OV_LVL_SUBADDR LTC3351_VCAP_OV_LVL_REG_SUBADDR //!< @ref LTC3351_VCAP_OV_LVL "VCAP_OV_LVL"
#define LTC3351_VCAP_OV_LVL_SIZE 16u
#define LTC3351_VCAP_OV_LVL_OFFSET 0u
#define LTC3351_VCAP_OV_LVL_MASK 0xFFFFu
#define LTC3351_VCAP_OV_LVL_DEFAULT 0u
#define LTC3351_VCAP_OV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VCAP_OV_LVL (LTC3351_VCAP_OV_LVL_OFFSET << 12 | (LTC3351_VCAP_OV_LVL_SIZE - 1) << 8 | LTC3351_VCAP_OV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VOUT_UV_LVL_REG VOUT_UV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VOUT_UV_LVL_REG Register
 *
 * |        15:0 |
 * |:-----------:|
 * | VOUT_UV_LVL |
 *
 *   - CommandCode: 16
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VOUT_UV_LVL "VOUT_UV_LVL" : VOUT Under Voltage Level: This is an alarm threshold for the output voltage. If enabled, the VOUT pin voltage falling below this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
*/

//!@{
#define LTC3351_VOUT_UV_LVL_REG_SUBADDR 16u
#define LTC3351_VOUT_UV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VOUT_UV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VOUT_UV_LVL VOUT_UV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VOUT_UV_LVL Bit Field
 *
 *  VOUT Under Voltage Level: This is an alarm threshold for the output voltage. If enabled, the VOUT pin voltage falling below this level will trigger an alarm and an SMBALERT. 2.19mV per LSB 
 *   - Register: @ref LTC3351_VOUT_UV_LVL_REG "VOUT_UV_LVL_REG"
 *   - CommandCode: 16
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VOUT_FORMAT
 */
//!@{
#define LTC3351_VOUT_UV_LVL_SUBADDR LTC3351_VOUT_UV_LVL_REG_SUBADDR //!< @ref LTC3351_VOUT_UV_LVL "VOUT_UV_LVL"
#define LTC3351_VOUT_UV_LVL_SIZE 16u
#define LTC3351_VOUT_UV_LVL_OFFSET 0u
#define LTC3351_VOUT_UV_LVL_MASK 0xFFFFu
#define LTC3351_VOUT_UV_LVL_DEFAULT 0u
#define LTC3351_VOUT_UV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VOUT_UV_LVL (LTC3351_VOUT_UV_LVL_OFFSET << 12 | (LTC3351_VOUT_UV_LVL_SIZE - 1) << 8 | LTC3351_VOUT_UV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_VOUT_OV_LVL_REG VOUT_OV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief VOUT_OV_LVL_REG Register
 *
 * |        15:0 |
 * |:-----------:|
 * | VOUT_OV_LVL |
 *
 *   - CommandCode: 17
 *   - Contains Bit Fields:
 *     + @ref LTC3351_VOUT_OV_LVL "VOUT_OV_LVL" : VOUT Over Voltage Level: This is an alarm threshold for the output voltage. If enabled, the VOUT pin voltage rising above this level will trigger an alarm and an SMBALERT. 2.19mV per LSB
*/

//!@{
#define LTC3351_VOUT_OV_LVL_REG_SUBADDR 17u
#define LTC3351_VOUT_OV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_VOUT_OV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_VOUT_OV_LVL VOUT_OV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief VOUT_OV_LVL Bit Field
 *
 *  VOUT Over Voltage Level: This is an alarm threshold for the output voltage. If enabled, the VOUT pin voltage rising above this level will trigger an alarm and an SMBALERT. 2.19mV per LSB
 *   - Register: @ref LTC3351_VOUT_OV_LVL_REG "VOUT_OV_LVL_REG"
 *   - CommandCode: 17
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VOUT_FORMAT
 */
//!@{
#define LTC3351_VOUT_OV_LVL_SUBADDR LTC3351_VOUT_OV_LVL_REG_SUBADDR //!< @ref LTC3351_VOUT_OV_LVL "VOUT_OV_LVL"
#define LTC3351_VOUT_OV_LVL_SIZE 16u
#define LTC3351_VOUT_OV_LVL_OFFSET 0u
#define LTC3351_VOUT_OV_LVL_MASK 0xFFFFu
#define LTC3351_VOUT_OV_LVL_DEFAULT 0u
#define LTC3351_VOUT_OV_LVL_DECODE(register_data) (register_data)
#define LTC3351_VOUT_OV_LVL (LTC3351_VOUT_OV_LVL_OFFSET << 12 | (LTC3351_VOUT_OV_LVL_SIZE - 1) << 8 | LTC3351_VOUT_OV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_DTEMP_COLD_LVL_REG DTEMP_COLD_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief DTEMP_COLD_LVL_REG Register
 *
 * |           15:0 |
 * |:--------------:|
 * | DTEMP_COLD_LVL |
 *
 *   - CommandCode: 18
 *   - Contains Bit Fields:
 *     + @ref LTC3351_DTEMP_COLD_LVL "DTEMP_COLD_LVL" : Die Temperature Cold Level: This is an alarm threshold for the die temperature. If enabled, the die temperature falling below this level will trigger an alarm and an SMBALERT. Temperature = 0.0295C per LSB - 274C
*/

//!@{
#define LTC3351_DTEMP_COLD_LVL_REG_SUBADDR 18u
#define LTC3351_DTEMP_COLD_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_DTEMP_COLD_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_DTEMP_COLD_LVL DTEMP_COLD_LVL
 *  @ingroup LTC3351_register_map
 *  @brief DTEMP_COLD_LVL Bit Field
 *
 *  Die Temperature Cold Level: This is an alarm threshold for the die temperature. If enabled, the die temperature falling below this level will trigger an alarm and an SMBALERT. Temperature = 0.0295C per LSB - 274C
 *   - Register: @ref LTC3351_DTEMP_COLD_LVL_REG "DTEMP_COLD_LVL_REG"
 *   - CommandCode: 18
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_DTEMP_FORMAT
 */
//!@{
#define LTC3351_DTEMP_COLD_LVL_SUBADDR LTC3351_DTEMP_COLD_LVL_REG_SUBADDR //!< @ref LTC3351_DTEMP_COLD_LVL "DTEMP_COLD_LVL"
#define LTC3351_DTEMP_COLD_LVL_SIZE 16u
#define LTC3351_DTEMP_COLD_LVL_OFFSET 0u
#define LTC3351_DTEMP_COLD_LVL_MASK 0xFFFFu
#define LTC3351_DTEMP_COLD_LVL_DEFAULT 0u
#define LTC3351_DTEMP_COLD_LVL_DECODE(register_data) (register_data)
#define LTC3351_DTEMP_COLD_LVL (LTC3351_DTEMP_COLD_LVL_OFFSET << 12 | (LTC3351_DTEMP_COLD_LVL_SIZE - 1) << 8 | LTC3351_DTEMP_COLD_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_DTEMP_HOT_LVL_REG DTEMP_HOT_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief DTEMP_HOT_LVL_REG Register
 *
 * |          15:0 |
 * |:-------------:|
 * | DTEMP_HOT_LVL |
 *
 *   - CommandCode: 19
 *   - Contains Bit Fields:
 *     + @ref LTC3351_DTEMP_HOT_LVL "DTEMP_HOT_LVL" : Die Temperature Hot Level: This is an alarm threshold for the die temperature. If enabled, the die temperature rising above this level will trigger an alarm and an SMBALERT. Temperature = 0.0295C per LSB - 274C
*/

//!@{
#define LTC3351_DTEMP_HOT_LVL_REG_SUBADDR 19u
#define LTC3351_DTEMP_HOT_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_DTEMP_HOT_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_DTEMP_HOT_LVL DTEMP_HOT_LVL
 *  @ingroup LTC3351_register_map
 *  @brief DTEMP_HOT_LVL Bit Field
 *
 *  Die Temperature Hot Level: This is an alarm threshold for the die temperature. If enabled, the die temperature rising above this level will trigger an alarm and an SMBALERT. Temperature = 0.0295C per LSB - 274C
 *   - Register: @ref LTC3351_DTEMP_HOT_LVL_REG "DTEMP_HOT_LVL_REG"
 *   - CommandCode: 19
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_DTEMP_FORMAT
 */
//!@{
#define LTC3351_DTEMP_HOT_LVL_SUBADDR LTC3351_DTEMP_HOT_LVL_REG_SUBADDR //!< @ref LTC3351_DTEMP_HOT_LVL "DTEMP_HOT_LVL"
#define LTC3351_DTEMP_HOT_LVL_SIZE 16u
#define LTC3351_DTEMP_HOT_LVL_OFFSET 0u
#define LTC3351_DTEMP_HOT_LVL_MASK 0xFFFFu
#define LTC3351_DTEMP_HOT_LVL_DEFAULT 0u
#define LTC3351_DTEMP_HOT_LVL_DECODE(register_data) (register_data)
#define LTC3351_DTEMP_HOT_LVL (LTC3351_DTEMP_HOT_LVL_OFFSET << 12 | (LTC3351_DTEMP_HOT_LVL_SIZE - 1) << 8 | LTC3351_DTEMP_HOT_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_ICHG_UC_LVL_REG ICHG_UC_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief ICHG_UC_LVL_REG Register
 *
 * |        15:0 |
 * |:-----------:|
 * | ICHG_UC_LVL |
 *
 *   - CommandCode: 20
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ICHG_UC_LVL "ICHG_UC_LVL" : Charge Undercurrent Level: This is an alarm threshold for the charge current. If enabled, the charge current falling below this level will trigger an alarm and an SMBALERT. 1.955µV/Rsnsc per LSB
*/

//!@{
#define LTC3351_ICHG_UC_LVL_REG_SUBADDR 20u
#define LTC3351_ICHG_UC_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ICHG_UC_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ICHG_UC_LVL ICHG_UC_LVL
 *  @ingroup LTC3351_register_map
 *  @brief ICHG_UC_LVL Bit Field
 *
 *  Charge Undercurrent Level: This is an alarm threshold for the charge current. If enabled, the charge current falling below this level will trigger an alarm and an SMBALERT. 1.955µV/Rsnsc per LSB
 *   - Register: @ref LTC3351_ICHG_UC_LVL_REG "ICHG_UC_LVL_REG"
 *   - CommandCode: 20
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_ICHARGE_FORMAT
 */
//!@{
#define LTC3351_ICHG_UC_LVL_SUBADDR LTC3351_ICHG_UC_LVL_REG_SUBADDR //!< @ref LTC3351_ICHG_UC_LVL "ICHG_UC_LVL"
#define LTC3351_ICHG_UC_LVL_SIZE 16u
#define LTC3351_ICHG_UC_LVL_OFFSET 0u
#define LTC3351_ICHG_UC_LVL_MASK 0xFFFFu
#define LTC3351_ICHG_UC_LVL_DEFAULT 0u
#define LTC3351_ICHG_UC_LVL_DECODE(register_data) (register_data)
#define LTC3351_ICHG_UC_LVL (LTC3351_ICHG_UC_LVL_OFFSET << 12 | (LTC3351_ICHG_UC_LVL_SIZE - 1) << 8 | LTC3351_ICHG_UC_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_IIN_OC_LVL_REG IIN_OC_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief IIN_OC_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | IIN_OC_LVL |
 *
 *   - CommandCode: 21
 *   - Contains Bit Fields:
 *     + @ref LTC3351_IIN_OC_LVL "IIN_OC_LVL" : Input Overcurrent Level: This is an alarm threshold for the input current. If enabled, the input current rising above this level will trigger an alarm and an SMBALERT. 1.955µV/Rsnsi per LSB
*/

//!@{
#define LTC3351_IIN_OC_LVL_REG_SUBADDR 21u
#define LTC3351_IIN_OC_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_IIN_OC_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_IIN_OC_LVL IIN_OC_LVL
 *  @ingroup LTC3351_register_map
 *  @brief IIN_OC_LVL Bit Field
 *
 *  Input Overcurrent Level: This is an alarm threshold for the input current. If enabled, the input current rising above this level will trigger an alarm and an SMBALERT. 1.955µV/Rsnsi per LSB
 *   - Register: @ref LTC3351_IIN_OC_LVL_REG "IIN_OC_LVL_REG"
 *   - CommandCode: 21
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_IIN_FORMAT
 */
//!@{
#define LTC3351_IIN_OC_LVL_SUBADDR LTC3351_IIN_OC_LVL_REG_SUBADDR //!< @ref LTC3351_IIN_OC_LVL "IIN_OC_LVL"
#define LTC3351_IIN_OC_LVL_SIZE 16u
#define LTC3351_IIN_OC_LVL_OFFSET 0u
#define LTC3351_IIN_OC_LVL_MASK 0xFFFFu
#define LTC3351_IIN_OC_LVL_DEFAULT 0u
#define LTC3351_IIN_OC_LVL_DECODE(register_data) (register_data)
#define LTC3351_IIN_OC_LVL (LTC3351_IIN_OC_LVL_OFFSET << 12 | (LTC3351_IIN_OC_LVL_SIZE - 1) << 8 | LTC3351_IIN_OC_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_UV_LVL_REG CAP_UV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_UV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_UV_LVL |
 *
 *   - CommandCode: 22
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_UV_LVL "CAP_UV_LVL" : Capacitor Under Voltage Level: This is an alarm threshold for each individual capacitor voltage in the stack. If enabled, any capacitor voltage falling below this level will trigger an alarm and an SMBALERT. 182.8µV per LSB.
*/

//!@{
#define LTC3351_CAP_UV_LVL_REG_SUBADDR 22u
#define LTC3351_CAP_UV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_UV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_UV_LVL CAP_UV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief CAP_UV_LVL Bit Field
 *
 *  Capacitor Under Voltage Level: This is an alarm threshold for each individual capacitor voltage in the stack. If enabled, any capacitor voltage falling below this level will trigger an alarm and an SMBALERT. 182.8µV per LSB.
 *   - Register: @ref LTC3351_CAP_UV_LVL_REG "CAP_UV_LVL_REG"
 *   - CommandCode: 22
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_CAP_UV_LVL_SUBADDR LTC3351_CAP_UV_LVL_REG_SUBADDR //!< @ref LTC3351_CAP_UV_LVL "CAP_UV_LVL"
#define LTC3351_CAP_UV_LVL_SIZE 16u
#define LTC3351_CAP_UV_LVL_OFFSET 0u
#define LTC3351_CAP_UV_LVL_MASK 0xFFFFu
#define LTC3351_CAP_UV_LVL_DEFAULT 0u
#define LTC3351_CAP_UV_LVL_DECODE(register_data) (register_data)
#define LTC3351_CAP_UV_LVL (LTC3351_CAP_UV_LVL_OFFSET << 12 | (LTC3351_CAP_UV_LVL_SIZE - 1) << 8 | LTC3351_CAP_UV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_OV_LVL_REG CAP_OV_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_OV_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_OV_LVL |
 *
 *   - CommandCode: 23
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_OV_LVL "CAP_OV_LVL" : Capacitor Over Voltage Level: This is an alarm threshold for each individual capacitor in the stack. If enabled, any capacitor voltage rising above this level will trigger an alarm and an SMBALERT. 182.8µV per LSB 
*/

//!@{
#define LTC3351_CAP_OV_LVL_REG_SUBADDR 23u
#define LTC3351_CAP_OV_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_OV_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_OV_LVL CAP_OV_LVL
 *  @ingroup LTC3351_register_map
 *  @brief CAP_OV_LVL Bit Field
 *
 *  Capacitor Over Voltage Level: This is an alarm threshold for each individual capacitor in the stack. If enabled, any capacitor voltage rising above this level will trigger an alarm and an SMBALERT. 182.8µV per LSB 
 *   - Register: @ref LTC3351_CAP_OV_LVL_REG "CAP_OV_LVL_REG"
 *   - CommandCode: 23
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_CAP_OV_LVL_SUBADDR LTC3351_CAP_OV_LVL_REG_SUBADDR //!< @ref LTC3351_CAP_OV_LVL "CAP_OV_LVL"
#define LTC3351_CAP_OV_LVL_SIZE 16u
#define LTC3351_CAP_OV_LVL_OFFSET 0u
#define LTC3351_CAP_OV_LVL_MASK 0xFFFFu
#define LTC3351_CAP_OV_LVL_DEFAULT 0u
#define LTC3351_CAP_OV_LVL_DECODE(register_data) (register_data)
#define LTC3351_CAP_OV_LVL (LTC3351_CAP_OV_LVL_OFFSET << 12 | (LTC3351_CAP_OV_LVL_SIZE - 1) << 8 | LTC3351_CAP_OV_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_LO_LVL_REG CAP_LO_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_LO_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_LO_LVL |
 *
 *   - CommandCode: 24
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_LO_LVL "CAP_LO_LVL" : Capacitance Low Level: This is an alarm threshold for the measured stack capacitance. If the measured stack capacitance is less than this level it will trigger an alarm and an SMBALERT, if enabled. When ctl_cap_scale is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When ctl_cap_scale is set to 0 it is 336µF * RT/RTST per LSB.
*/

//!@{
#define LTC3351_CAP_LO_LVL_REG_SUBADDR 24u
#define LTC3351_CAP_LO_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_LO_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_LO_LVL CAP_LO_LVL
 *  @ingroup LTC3351_register_map
 *  @brief CAP_LO_LVL Bit Field
 *
 *  Capacitance Low Level: This is an alarm threshold for the measured stack capacitance. If the measured stack capacitance is less than this level it will trigger an alarm and an SMBALERT, if enabled. When ctl_cap_scale is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When ctl_cap_scale is set to 0 it is 336µF * RT/RTST per LSB.
 *   - Register: @ref LTC3351_CAP_LO_LVL_REG "CAP_LO_LVL_REG"
 *   - CommandCode: 24
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CAP_FORMAT
 */
//!@{
#define LTC3351_CAP_LO_LVL_SUBADDR LTC3351_CAP_LO_LVL_REG_SUBADDR //!< @ref LTC3351_CAP_LO_LVL "CAP_LO_LVL"
#define LTC3351_CAP_LO_LVL_SIZE 16u
#define LTC3351_CAP_LO_LVL_OFFSET 0u
#define LTC3351_CAP_LO_LVL_MASK 0xFFFFu
#define LTC3351_CAP_LO_LVL_DEFAULT 0u
#define LTC3351_CAP_LO_LVL_DECODE(register_data) (register_data)
#define LTC3351_CAP_LO_LVL (LTC3351_CAP_LO_LVL_OFFSET << 12 | (LTC3351_CAP_LO_LVL_SIZE - 1) << 8 | LTC3351_CAP_LO_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_HI_LVL_REG ESR_HI_LVL_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_HI_LVL_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_HI_LVL |
 *
 *   - CommandCode: 25
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_HI_LVL "ESR_HI_LVL" : ESR High Level: This is an alarm threshold for the measured stack ESR. If enabled, a measurement of stack ESR exceeding this level will trigger an alarm and an SMBALERT. Rsnsc/64 per LSB.
*/

//!@{
#define LTC3351_ESR_HI_LVL_REG_SUBADDR 25u
#define LTC3351_ESR_HI_LVL_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_HI_LVL_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_HI_LVL ESR_HI_LVL
 *  @ingroup LTC3351_register_map
 *  @brief ESR_HI_LVL Bit Field
 *
 *  ESR High Level: This is an alarm threshold for the measured stack ESR. If enabled, a measurement of stack ESR exceeding this level will trigger an alarm and an SMBALERT. Rsnsc/64 per LSB.
 *   - Register: @ref LTC3351_ESR_HI_LVL_REG "ESR_HI_LVL_REG"
 *   - CommandCode: 25
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_ESR_FORMAT
 */
//!@{
#define LTC3351_ESR_HI_LVL_SUBADDR LTC3351_ESR_HI_LVL_REG_SUBADDR //!< @ref LTC3351_ESR_HI_LVL "ESR_HI_LVL"
#define LTC3351_ESR_HI_LVL_SIZE 16u
#define LTC3351_ESR_HI_LVL_OFFSET 0u
#define LTC3351_ESR_HI_LVL_MASK 0xFFFFu
#define LTC3351_ESR_HI_LVL_DEFAULT 0u
#define LTC3351_ESR_HI_LVL_DECODE(register_data) (register_data)
#define LTC3351_ESR_HI_LVL (LTC3351_ESR_HI_LVL_OFFSET << 12 | (LTC3351_ESR_HI_LVL_SIZE - 1) << 8 | LTC3351_ESR_HI_LVL_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_I_ON_SETTLING_REG ESR_I_ON_SETTLING_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_ON_SETTLING_REG Register
 *
 * |              15:0 |
 * |:-----------------:|
 * | ESR_I_ON_SETTLING |
 *
 *   - CommandCode: 26
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_I_ON_SETTLING "ESR_I_ON_SETTLING" : Time to allow the charging current to settle before measuring the charge voltage and current for ESR. Each LSB is 1024 switcher periods.
*/

//!@{
#define LTC3351_ESR_I_ON_SETTLING_REG_SUBADDR 26u
#define LTC3351_ESR_I_ON_SETTLING_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_I_ON_SETTLING_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_I_ON_SETTLING ESR_I_ON_SETTLING
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_ON_SETTLING Bit Field
 *
 *  Time to allow the charging current to settle before measuring the charge voltage and current for ESR. Each LSB is 1024 switcher periods.
 *   - Register: @ref LTC3351_ESR_I_ON_SETTLING_REG "ESR_I_ON_SETTLING_REG"
 *   - CommandCode: 26
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 2
 */
//!@{
#define LTC3351_ESR_I_ON_SETTLING_SUBADDR LTC3351_ESR_I_ON_SETTLING_REG_SUBADDR //!< @ref LTC3351_ESR_I_ON_SETTLING "ESR_I_ON_SETTLING"
#define LTC3351_ESR_I_ON_SETTLING_SIZE 16u
#define LTC3351_ESR_I_ON_SETTLING_OFFSET 0u
#define LTC3351_ESR_I_ON_SETTLING_MASK 0xFFFFu
#define LTC3351_ESR_I_ON_SETTLING_DEFAULT 2u
#define LTC3351_ESR_I_ON_SETTLING_DECODE(register_data) (register_data)
#define LTC3351_ESR_I_ON_SETTLING (LTC3351_ESR_I_ON_SETTLING_OFFSET << 12 | (LTC3351_ESR_I_ON_SETTLING_SIZE - 1) << 8 | LTC3351_ESR_I_ON_SETTLING_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_I_OFF_SETTLING_REG ESR_I_OFF_SETTLING_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_OFF_SETTLING_REG Register
 *
 * |               15:0 |
 * |:------------------:|
 * | ESR_I_OFF_SETTLING |
 *
 *   - CommandCode: 27
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_I_OFF_SETTLING "ESR_I_OFF_SETTLING" : Time to wait after turning the charge current off before measuring the charge voltage and current for ESR. Each LSB is 1024 switcher periods.
*/

//!@{
#define LTC3351_ESR_I_OFF_SETTLING_REG_SUBADDR 27u
#define LTC3351_ESR_I_OFF_SETTLING_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_I_OFF_SETTLING_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_I_OFF_SETTLING ESR_I_OFF_SETTLING
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_OFF_SETTLING Bit Field
 *
 *  Time to wait after turning the charge current off before measuring the charge voltage and current for ESR. Each LSB is 1024 switcher periods.
 *   - Register: @ref LTC3351_ESR_I_OFF_SETTLING_REG "ESR_I_OFF_SETTLING_REG"
 *   - CommandCode: 27
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 8
 */
//!@{
#define LTC3351_ESR_I_OFF_SETTLING_SUBADDR LTC3351_ESR_I_OFF_SETTLING_REG_SUBADDR //!< @ref LTC3351_ESR_I_OFF_SETTLING "ESR_I_OFF_SETTLING"
#define LTC3351_ESR_I_OFF_SETTLING_SIZE 16u
#define LTC3351_ESR_I_OFF_SETTLING_OFFSET 0u
#define LTC3351_ESR_I_OFF_SETTLING_MASK 0xFFFFu
#define LTC3351_ESR_I_OFF_SETTLING_DEFAULT 8u
#define LTC3351_ESR_I_OFF_SETTLING_DECODE(register_data) (register_data)
#define LTC3351_ESR_I_OFF_SETTLING (LTC3351_ESR_I_OFF_SETTLING_OFFSET << 12 | (LTC3351_ESR_I_OFF_SETTLING_SIZE - 1) << 8 | LTC3351_ESR_I_OFF_SETTLING_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_I_OVERRIDE_REG ESR_I_OVERRIDE_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_OVERRIDE_REG Register
 *
 * |           15:0 |
 * |:--------------:|
 * | ESR_I_OVERRIDE |
 *
 *   - CommandCode: 28
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_I_OVERRIDE "ESR_I_OVERRIDE" : This value overrides the LTC3351's adaptive test current selection for the ESR test. If this register is non-zero, the lower 8 bits will be used as an 8 bit DAC value to set the charge current during the ESR test. Typically this register will not need to be set. ITEST = 32mV * (esr_i_override[7:0] + 1) / 256 / Rsnsc
*/

//!@{
#define LTC3351_ESR_I_OVERRIDE_REG_SUBADDR 28u
#define LTC3351_ESR_I_OVERRIDE_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_I_OVERRIDE_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_I_OVERRIDE ESR_I_OVERRIDE
 *  @ingroup LTC3351_register_map
 *  @brief ESR_I_OVERRIDE Bit Field
 *
 *  This value overrides the LTC3351's adaptive test current selection for the ESR test. If this register is non-zero, the lower 8 bits will be used as an 8 bit DAC value to set the charge current during the ESR test. Typically this register will not need to be set. ITEST = 32mV * (esr_i_override[7:0] + 1) / 256 / Rsnsc
 *   - Register: @ref LTC3351_ESR_I_OVERRIDE_REG "ESR_I_OVERRIDE_REG"
 *   - CommandCode: 28
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ESR_I_OVERRIDE_SUBADDR LTC3351_ESR_I_OVERRIDE_REG_SUBADDR //!< @ref LTC3351_ESR_I_OVERRIDE "ESR_I_OVERRIDE"
#define LTC3351_ESR_I_OVERRIDE_SIZE 16u
#define LTC3351_ESR_I_OVERRIDE_OFFSET 0u
#define LTC3351_ESR_I_OVERRIDE_MASK 0xFFFFu
#define LTC3351_ESR_I_OVERRIDE_DEFAULT 0u
#define LTC3351_ESR_I_OVERRIDE_DECODE(register_data) (register_data)
#define LTC3351_ESR_I_OVERRIDE (LTC3351_ESR_I_OVERRIDE_OFFSET << 12 | (LTC3351_ESR_I_OVERRIDE_SIZE - 1) << 8 | LTC3351_ESR_I_OVERRIDE_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_I_ON_SETTLING_REG CAP_I_ON_SETTLING_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_I_ON_SETTLING_REG Register
 *
 * |              15:0 |
 * |:-----------------:|
 * | CAP_I_ON_SETTLING |
 *
 *   - CommandCode: 29
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_I_ON_SETTLING "CAP_I_ON_SETTLING" : Time to wait after turning the test current on before measuring the first voltage of the capacitance measurement. Each LSB is 1024 switcher periods.
*/

//!@{
#define LTC3351_CAP_I_ON_SETTLING_REG_SUBADDR 29u
#define LTC3351_CAP_I_ON_SETTLING_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_I_ON_SETTLING_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_I_ON_SETTLING CAP_I_ON_SETTLING
 *  @ingroup LTC3351_register_map
 *  @brief CAP_I_ON_SETTLING Bit Field
 *
 *  Time to wait after turning the test current on before measuring the first voltage of the capacitance measurement. Each LSB is 1024 switcher periods.
 *   - Register: @ref LTC3351_CAP_I_ON_SETTLING_REG "CAP_I_ON_SETTLING_REG"
 *   - CommandCode: 29
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 8
 */
//!@{
#define LTC3351_CAP_I_ON_SETTLING_SUBADDR LTC3351_CAP_I_ON_SETTLING_REG_SUBADDR //!< @ref LTC3351_CAP_I_ON_SETTLING "CAP_I_ON_SETTLING"
#define LTC3351_CAP_I_ON_SETTLING_SIZE 16u
#define LTC3351_CAP_I_ON_SETTLING_OFFSET 0u
#define LTC3351_CAP_I_ON_SETTLING_MASK 0xFFFFu
#define LTC3351_CAP_I_ON_SETTLING_DEFAULT 8u
#define LTC3351_CAP_I_ON_SETTLING_DECODE(register_data) (register_data)
#define LTC3351_CAP_I_ON_SETTLING (LTC3351_CAP_I_ON_SETTLING_OFFSET << 12 | (LTC3351_CAP_I_ON_SETTLING_SIZE - 1) << 8 | LTC3351_CAP_I_ON_SETTLING_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_DELTA_V_SETTING_REG CAP_DELTA_V_SETTING_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_DELTA_V_SETTING_REG Register
 *
 * |                15:0 |
 * |:-------------------:|
 * | CAP_DELTA_V_SETTING |
 *
 *   - CommandCode: 30
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_DELTA_V_SETTING "CAP_DELTA_V_SETTING" : The target delta V for the capacitance test. The scale is 182.8µV per LSB. The default is approximately 100mV.
*/

//!@{
#define LTC3351_CAP_DELTA_V_SETTING_REG_SUBADDR 30u
#define LTC3351_CAP_DELTA_V_SETTING_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_DELTA_V_SETTING_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_DELTA_V_SETTING CAP_DELTA_V_SETTING
 *  @ingroup LTC3351_register_map
 *  @brief CAP_DELTA_V_SETTING Bit Field
 *
 *  The target delta V for the capacitance test. The scale is 182.8µV per LSB. The default is approximately 100mV.
 *   - Register: @ref LTC3351_CAP_DELTA_V_SETTING_REG "CAP_DELTA_V_SETTING_REG"
 *   - CommandCode: 30
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 550
 */
//!@{
#define LTC3351_CAP_DELTA_V_SETTING_SUBADDR LTC3351_CAP_DELTA_V_SETTING_REG_SUBADDR //!< @ref LTC3351_CAP_DELTA_V_SETTING "CAP_DELTA_V_SETTING"
#define LTC3351_CAP_DELTA_V_SETTING_SIZE 16u
#define LTC3351_CAP_DELTA_V_SETTING_OFFSET 0u
#define LTC3351_CAP_DELTA_V_SETTING_MASK 0xFFFFu
#define LTC3351_CAP_DELTA_V_SETTING_DEFAULT 550u
#define LTC3351_CAP_DELTA_V_SETTING_DECODE(register_data) (register_data)
#define LTC3351_CAP_DELTA_V_SETTING (LTC3351_CAP_DELTA_V_SETTING_OFFSET << 12 | (LTC3351_CAP_DELTA_V_SETTING_SIZE - 1) << 8 | LTC3351_CAP_DELTA_V_SETTING_SUBADDR)
//!@}

/*! @defgroup LTC3351_MIN_BOOST_CAP_VOLTAGE_REG MIN_BOOST_CAP_VOLTAGE_REG
 *  @ingroup LTC3351_register_map
 *  @brief MIN_BOOST_CAP_VOLTAGE_REG Register
 *
 * |                  15:0 |
 * |:---------------------:|
 * | MIN_BOOST_CAP_VOLTAGE |
 *
 *   - CommandCode: 31
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MIN_BOOST_CAP_VOLTAGE "MIN_BOOST_CAP_VOLTAGE" : If this register is non-zero, it sets the minimum capacitor voltage the boost will operate at. If any capacitor voltage falls below this value in boost mode the boost will be forced off, the boost will not turn back on even if the capacitor voltage rises above this voltage. Only after input power returns will the boost be re-enabled. This prevents the boost from cycling on and off many times once the capacitors' voltage has discharged to the point it can no longer support the system load through the boost. To use this feature vcap[1:num_caps+1] measurements must be enabled in backup mode, see adc_backup_ch_en_reg. Also the capacitor voltages are only measured as often as set by adc_wait_backup.
*/

//!@{
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_REG_SUBADDR 31u
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MIN_BOOST_CAP_VOLTAGE_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MIN_BOOST_CAP_VOLTAGE MIN_BOOST_CAP_VOLTAGE
 *  @ingroup LTC3351_register_map
 *  @brief MIN_BOOST_CAP_VOLTAGE Bit Field
 *
 *  If this register is non-zero, it sets the minimum capacitor voltage the boost will operate at. If any capacitor voltage falls below this value in boost mode the boost will be forced off, the boost will not turn back on even if the capacitor voltage rises above this voltage. Only after input power returns will the boost be re-enabled. This prevents the boost from cycling on and off many times once the capacitors' voltage has discharged to the point it can no longer support the system load through the boost. To use this feature vcap[1:num_caps+1] measurements must be enabled in backup mode, see adc_backup_ch_en_reg. Also the capacitor voltages are only measured as often as set by adc_wait_backup.
 *   - Register: @ref LTC3351_MIN_BOOST_CAP_VOLTAGE_REG "MIN_BOOST_CAP_VOLTAGE_REG"
 *   - CommandCode: 31
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_SUBADDR LTC3351_MIN_BOOST_CAP_VOLTAGE_REG_SUBADDR //!< @ref LTC3351_MIN_BOOST_CAP_VOLTAGE "MIN_BOOST_CAP_VOLTAGE"
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_SIZE 16u
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_OFFSET 0u
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_MASK 0xFFFFu
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_DEFAULT 0u
#define LTC3351_MIN_BOOST_CAP_VOLTAGE_DECODE(register_data) (register_data)
#define LTC3351_MIN_BOOST_CAP_VOLTAGE (LTC3351_MIN_BOOST_CAP_VOLTAGE_OFFSET << 12 | (LTC3351_MIN_BOOST_CAP_VOLTAGE_SIZE - 1) << 8 | LTC3351_MIN_BOOST_CAP_VOLTAGE_SUBADDR)
//!@}

/*! @defgroup LTC3351_MIN_VOUT_HS_DISABLE_REG MIN_VOUT_HS_DISABLE_REG
 *  @ingroup LTC3351_register_map
 *  @brief MIN_VOUT_HS_DISABLE_REG Register
 *
 * |                15:0 |
 * |:-------------------:|
 * | MIN_VOUT_HS_DISABLE |
 *
 *   - CommandCode: 32
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MIN_VOUT_HS_DISABLE "MIN_VOUT_HS_DISABLE" : If this register is non-zero, it sets the minimum voltage VOUT is allowed to reach while the HotSwap is disabled. If the voltage falls below this level the ctl_hotswap_disable bit will be cleared, re-enabling the HotSwap controller.  To use this feature the VOUT measurement must be enabled in boost mode, see adc_backup_ch_en_reg. Also the VOUT voltage is only measured as often as set by adc_wait_backup. 
*/

//!@{
#define LTC3351_MIN_VOUT_HS_DISABLE_REG_SUBADDR 32u
#define LTC3351_MIN_VOUT_HS_DISABLE_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MIN_VOUT_HS_DISABLE_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MIN_VOUT_HS_DISABLE MIN_VOUT_HS_DISABLE
 *  @ingroup LTC3351_register_map
 *  @brief MIN_VOUT_HS_DISABLE Bit Field
 *
 *  If this register is non-zero, it sets the minimum voltage VOUT is allowed to reach while the HotSwap is disabled. If the voltage falls below this level the ctl_hotswap_disable bit will be cleared, re-enabling the HotSwap controller.  To use this feature the VOUT measurement must be enabled in boost mode, see adc_backup_ch_en_reg. Also the VOUT voltage is only measured as often as set by adc_wait_backup. 
 *   - Register: @ref LTC3351_MIN_VOUT_HS_DISABLE_REG "MIN_VOUT_HS_DISABLE_REG"
 *   - CommandCode: 32
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R/W
 *   - Default: 0
 *   - Format: LTC3351_VOUT_FORMAT
 */
//!@{
#define LTC3351_MIN_VOUT_HS_DISABLE_SUBADDR LTC3351_MIN_VOUT_HS_DISABLE_REG_SUBADDR //!< @ref LTC3351_MIN_VOUT_HS_DISABLE "MIN_VOUT_HS_DISABLE"
#define LTC3351_MIN_VOUT_HS_DISABLE_SIZE 16u
#define LTC3351_MIN_VOUT_HS_DISABLE_OFFSET 0u
#define LTC3351_MIN_VOUT_HS_DISABLE_MASK 0xFFFFu
#define LTC3351_MIN_VOUT_HS_DISABLE_DEFAULT 0u
#define LTC3351_MIN_VOUT_HS_DISABLE_DECODE(register_data) (register_data)
#define LTC3351_MIN_VOUT_HS_DISABLE (LTC3351_MIN_VOUT_HS_DISABLE_OFFSET << 12 | (LTC3351_MIN_VOUT_HS_DISABLE_SIZE - 1) << 8 | LTC3351_MIN_VOUT_HS_DISABLE_SUBADDR)
//!@}

/*! @defgroup LTC3351_ALARM_REG ALARM_REG
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_REG Register
 *
 * |           15 |           14 |           13 |           12 |           11 |            10 |               9 |                8 |             7 |             6 |             5 |             4 |            3 |            2 |            1 |            0 |
 * |:------------:|:------------:|:------------:|:------------:|:------------:|:-------------:|:---------------:|:----------------:|:-------------:|:-------------:|:-------------:|:-------------:|:------------:|:------------:|:------------:|:------------:|
 * | ALARM_ESR_HI | ALARM_CAP_LO | ALARM_CAP_OV | ALARM_CAP_UV | ALARM_IIN_OC | ALARM_ICHG_UC | ALARM_DTEMP_HOT | ALARM_DTEMP_COLD | ALARM_VOUT_OV | ALARM_VOUT_UV | ALARM_VCAP_OV | ALARM_VCAP_UV | ALARM_VIN_OV | ALARM_VIN_UV | ALARM_GPI_OV | ALARM_GPI_UV |
 *
 * Alarms Register: A one in any bit in the register indicates its respective alarm has triggered. All bits are active high. Alarms are cleared by clearing (writing 0) the appropriate bit in this register. Setting (writing 1) bits has no effect. For example to clear the alarm_gpi_uv alarm, write 0xFFFD.
 *   - CommandCode: 35
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ALARM_GPI_UV "ALARM_GPI_UV" : GPI Under Voltage alarm
 *     + @ref LTC3351_ALARM_GPI_OV "ALARM_GPI_OV" : GPI Over Voltage alarm
 *     + @ref LTC3351_ALARM_VIN_UV "ALARM_VIN_UV" : VIN Under Voltage alarm
 *     + @ref LTC3351_ALARM_VIN_OV "ALARM_VIN_OV" : VIN Over Voltage alarm
 *     + @ref LTC3351_ALARM_VCAP_UV "ALARM_VCAP_UV" : VCAP Under Voltage alarm
 *     + @ref LTC3351_ALARM_VCAP_OV "ALARM_VCAP_OV" : VCAP Over Voltage alarm
 *     + @ref LTC3351_ALARM_VOUT_UV "ALARM_VOUT_UV" : VOUT Under Voltage alarm
 *     + @ref LTC3351_ALARM_VOUT_OV "ALARM_VOUT_OV" : VOUT Over Voltage alarm
 *     + @ref LTC3351_ALARM_DTEMP_COLD "ALARM_DTEMP_COLD" : Die temperature cold alarm
 *     + @ref LTC3351_ALARM_DTEMP_HOT "ALARM_DTEMP_HOT" : Die temperature hot alarm
 *     + @ref LTC3351_ALARM_ICHG_UC "ALARM_ICHG_UC" : Charge undercurrent alarm
 *     + @ref LTC3351_ALARM_IIN_OC "ALARM_IIN_OC" : Input overcurrent alarm
 *     + @ref LTC3351_ALARM_CAP_UV "ALARM_CAP_UV" : Capacitor Under Voltage alarm
 *     + @ref LTC3351_ALARM_CAP_OV "ALARM_CAP_OV" : Capacitor Over Voltage alarm
 *     + @ref LTC3351_ALARM_CAP_LO "ALARM_CAP_LO" : Capacitance low alarm
 *     + @ref LTC3351_ALARM_ESR_HI "ALARM_ESR_HI" : ESR high alarm
*/

//!@{
#define LTC3351_ALARM_REG_SUBADDR 35u
#define LTC3351_ALARM_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ALARM_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_GPI_UV ALARM_GPI_UV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_GPI_UV Bit Field
 *
 *  GPI Under Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_GPI_UV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_GPI_UV "ALARM_GPI_UV"
#define LTC3351_ALARM_GPI_UV_SIZE 1u
#define LTC3351_ALARM_GPI_UV_OFFSET 0u
#define LTC3351_ALARM_GPI_UV_MASK 0x0001u
#define LTC3351_ALARM_GPI_UV_DEFAULT 0u
#define LTC3351_ALARM_GPI_UV_DECODE(register_data) (((register_data) & LTC3351_ALARM_GPI_UV_MASK) >> LTC3351_ALARM_GPI_UV_OFFSET)
#define LTC3351_ALARM_GPI_UV (LTC3351_ALARM_GPI_UV_OFFSET << 12 | (LTC3351_ALARM_GPI_UV_SIZE - 1) << 8 | LTC3351_ALARM_GPI_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_GPI_OV ALARM_GPI_OV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_GPI_OV Bit Field
 *
 *  GPI Over Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_GPI_OV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_GPI_OV "ALARM_GPI_OV"
#define LTC3351_ALARM_GPI_OV_SIZE 1u
#define LTC3351_ALARM_GPI_OV_OFFSET 1u
#define LTC3351_ALARM_GPI_OV_MASK 0x0002u
#define LTC3351_ALARM_GPI_OV_DEFAULT 0u
#define LTC3351_ALARM_GPI_OV_DECODE(register_data) (((register_data) & LTC3351_ALARM_GPI_OV_MASK) >> LTC3351_ALARM_GPI_OV_OFFSET)
#define LTC3351_ALARM_GPI_OV (LTC3351_ALARM_GPI_OV_OFFSET << 12 | (LTC3351_ALARM_GPI_OV_SIZE - 1) << 8 | LTC3351_ALARM_GPI_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VIN_UV ALARM_VIN_UV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VIN_UV Bit Field
 *
 *  VIN Under Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VIN_UV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VIN_UV "ALARM_VIN_UV"
#define LTC3351_ALARM_VIN_UV_SIZE 1u
#define LTC3351_ALARM_VIN_UV_OFFSET 2u
#define LTC3351_ALARM_VIN_UV_MASK 0x0004u
#define LTC3351_ALARM_VIN_UV_DEFAULT 0u
#define LTC3351_ALARM_VIN_UV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VIN_UV_MASK) >> LTC3351_ALARM_VIN_UV_OFFSET)
#define LTC3351_ALARM_VIN_UV (LTC3351_ALARM_VIN_UV_OFFSET << 12 | (LTC3351_ALARM_VIN_UV_SIZE - 1) << 8 | LTC3351_ALARM_VIN_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VIN_OV ALARM_VIN_OV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VIN_OV Bit Field
 *
 *  VIN Over Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VIN_OV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VIN_OV "ALARM_VIN_OV"
#define LTC3351_ALARM_VIN_OV_SIZE 1u
#define LTC3351_ALARM_VIN_OV_OFFSET 3u
#define LTC3351_ALARM_VIN_OV_MASK 0x0008u
#define LTC3351_ALARM_VIN_OV_DEFAULT 0u
#define LTC3351_ALARM_VIN_OV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VIN_OV_MASK) >> LTC3351_ALARM_VIN_OV_OFFSET)
#define LTC3351_ALARM_VIN_OV (LTC3351_ALARM_VIN_OV_OFFSET << 12 | (LTC3351_ALARM_VIN_OV_SIZE - 1) << 8 | LTC3351_ALARM_VIN_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VCAP_UV ALARM_VCAP_UV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VCAP_UV Bit Field
 *
 *  VCAP Under Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VCAP_UV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VCAP_UV "ALARM_VCAP_UV"
#define LTC3351_ALARM_VCAP_UV_SIZE 1u
#define LTC3351_ALARM_VCAP_UV_OFFSET 4u
#define LTC3351_ALARM_VCAP_UV_MASK 0x0010u
#define LTC3351_ALARM_VCAP_UV_DEFAULT 0u
#define LTC3351_ALARM_VCAP_UV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VCAP_UV_MASK) >> LTC3351_ALARM_VCAP_UV_OFFSET)
#define LTC3351_ALARM_VCAP_UV (LTC3351_ALARM_VCAP_UV_OFFSET << 12 | (LTC3351_ALARM_VCAP_UV_SIZE - 1) << 8 | LTC3351_ALARM_VCAP_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VCAP_OV ALARM_VCAP_OV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VCAP_OV Bit Field
 *
 *  VCAP Over Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VCAP_OV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VCAP_OV "ALARM_VCAP_OV"
#define LTC3351_ALARM_VCAP_OV_SIZE 1u
#define LTC3351_ALARM_VCAP_OV_OFFSET 5u
#define LTC3351_ALARM_VCAP_OV_MASK 0x0020u
#define LTC3351_ALARM_VCAP_OV_DEFAULT 0u
#define LTC3351_ALARM_VCAP_OV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VCAP_OV_MASK) >> LTC3351_ALARM_VCAP_OV_OFFSET)
#define LTC3351_ALARM_VCAP_OV (LTC3351_ALARM_VCAP_OV_OFFSET << 12 | (LTC3351_ALARM_VCAP_OV_SIZE - 1) << 8 | LTC3351_ALARM_VCAP_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VOUT_UV ALARM_VOUT_UV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VOUT_UV Bit Field
 *
 *  VOUT Under Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VOUT_UV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VOUT_UV "ALARM_VOUT_UV"
#define LTC3351_ALARM_VOUT_UV_SIZE 1u
#define LTC3351_ALARM_VOUT_UV_OFFSET 6u
#define LTC3351_ALARM_VOUT_UV_MASK 0x0040u
#define LTC3351_ALARM_VOUT_UV_DEFAULT 0u
#define LTC3351_ALARM_VOUT_UV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VOUT_UV_MASK) >> LTC3351_ALARM_VOUT_UV_OFFSET)
#define LTC3351_ALARM_VOUT_UV (LTC3351_ALARM_VOUT_UV_OFFSET << 12 | (LTC3351_ALARM_VOUT_UV_SIZE - 1) << 8 | LTC3351_ALARM_VOUT_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_VOUT_OV ALARM_VOUT_OV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_VOUT_OV Bit Field
 *
 *  VOUT Over Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_VOUT_OV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_VOUT_OV "ALARM_VOUT_OV"
#define LTC3351_ALARM_VOUT_OV_SIZE 1u
#define LTC3351_ALARM_VOUT_OV_OFFSET 7u
#define LTC3351_ALARM_VOUT_OV_MASK 0x0080u
#define LTC3351_ALARM_VOUT_OV_DEFAULT 0u
#define LTC3351_ALARM_VOUT_OV_DECODE(register_data) (((register_data) & LTC3351_ALARM_VOUT_OV_MASK) >> LTC3351_ALARM_VOUT_OV_OFFSET)
#define LTC3351_ALARM_VOUT_OV (LTC3351_ALARM_VOUT_OV_OFFSET << 12 | (LTC3351_ALARM_VOUT_OV_SIZE - 1) << 8 | LTC3351_ALARM_VOUT_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_DTEMP_COLD ALARM_DTEMP_COLD
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_DTEMP_COLD Bit Field
 *
 *  Die temperature cold alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_DTEMP_COLD_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_DTEMP_COLD "ALARM_DTEMP_COLD"
#define LTC3351_ALARM_DTEMP_COLD_SIZE 1u
#define LTC3351_ALARM_DTEMP_COLD_OFFSET 8u
#define LTC3351_ALARM_DTEMP_COLD_MASK 0x0100u
#define LTC3351_ALARM_DTEMP_COLD_DEFAULT 0u
#define LTC3351_ALARM_DTEMP_COLD_DECODE(register_data) (((register_data) & LTC3351_ALARM_DTEMP_COLD_MASK) >> LTC3351_ALARM_DTEMP_COLD_OFFSET)
#define LTC3351_ALARM_DTEMP_COLD (LTC3351_ALARM_DTEMP_COLD_OFFSET << 12 | (LTC3351_ALARM_DTEMP_COLD_SIZE - 1) << 8 | LTC3351_ALARM_DTEMP_COLD_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_DTEMP_HOT ALARM_DTEMP_HOT
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_DTEMP_HOT Bit Field
 *
 *  Die temperature hot alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_DTEMP_HOT_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_DTEMP_HOT "ALARM_DTEMP_HOT"
#define LTC3351_ALARM_DTEMP_HOT_SIZE 1u
#define LTC3351_ALARM_DTEMP_HOT_OFFSET 9u
#define LTC3351_ALARM_DTEMP_HOT_MASK 0x0200u
#define LTC3351_ALARM_DTEMP_HOT_DEFAULT 0u
#define LTC3351_ALARM_DTEMP_HOT_DECODE(register_data) (((register_data) & LTC3351_ALARM_DTEMP_HOT_MASK) >> LTC3351_ALARM_DTEMP_HOT_OFFSET)
#define LTC3351_ALARM_DTEMP_HOT (LTC3351_ALARM_DTEMP_HOT_OFFSET << 12 | (LTC3351_ALARM_DTEMP_HOT_SIZE - 1) << 8 | LTC3351_ALARM_DTEMP_HOT_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_ICHG_UC ALARM_ICHG_UC
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_ICHG_UC Bit Field
 *
 *  Charge undercurrent alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_ICHG_UC_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_ICHG_UC "ALARM_ICHG_UC"
#define LTC3351_ALARM_ICHG_UC_SIZE 1u
#define LTC3351_ALARM_ICHG_UC_OFFSET 10u
#define LTC3351_ALARM_ICHG_UC_MASK 0x0400u
#define LTC3351_ALARM_ICHG_UC_DEFAULT 0u
#define LTC3351_ALARM_ICHG_UC_DECODE(register_data) (((register_data) & LTC3351_ALARM_ICHG_UC_MASK) >> LTC3351_ALARM_ICHG_UC_OFFSET)
#define LTC3351_ALARM_ICHG_UC (LTC3351_ALARM_ICHG_UC_OFFSET << 12 | (LTC3351_ALARM_ICHG_UC_SIZE - 1) << 8 | LTC3351_ALARM_ICHG_UC_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_IIN_OC ALARM_IIN_OC
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_IIN_OC Bit Field
 *
 *  Input overcurrent alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_IIN_OC_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_IIN_OC "ALARM_IIN_OC"
#define LTC3351_ALARM_IIN_OC_SIZE 1u
#define LTC3351_ALARM_IIN_OC_OFFSET 11u
#define LTC3351_ALARM_IIN_OC_MASK 0x0800u
#define LTC3351_ALARM_IIN_OC_DEFAULT 0u
#define LTC3351_ALARM_IIN_OC_DECODE(register_data) (((register_data) & LTC3351_ALARM_IIN_OC_MASK) >> LTC3351_ALARM_IIN_OC_OFFSET)
#define LTC3351_ALARM_IIN_OC (LTC3351_ALARM_IIN_OC_OFFSET << 12 | (LTC3351_ALARM_IIN_OC_SIZE - 1) << 8 | LTC3351_ALARM_IIN_OC_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_CAP_UV ALARM_CAP_UV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_CAP_UV Bit Field
 *
 *  Capacitor Under Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 12
 *   - MSB: 12
 *   - MASK: 0x1000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_CAP_UV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_CAP_UV "ALARM_CAP_UV"
#define LTC3351_ALARM_CAP_UV_SIZE 1u
#define LTC3351_ALARM_CAP_UV_OFFSET 12u
#define LTC3351_ALARM_CAP_UV_MASK 0x1000u
#define LTC3351_ALARM_CAP_UV_DEFAULT 0u
#define LTC3351_ALARM_CAP_UV_DECODE(register_data) (((register_data) & LTC3351_ALARM_CAP_UV_MASK) >> LTC3351_ALARM_CAP_UV_OFFSET)
#define LTC3351_ALARM_CAP_UV (LTC3351_ALARM_CAP_UV_OFFSET << 12 | (LTC3351_ALARM_CAP_UV_SIZE - 1) << 8 | LTC3351_ALARM_CAP_UV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_CAP_OV ALARM_CAP_OV
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_CAP_OV Bit Field
 *
 *  Capacitor Over Voltage alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 13
 *   - MSB: 13
 *   - MASK: 0x2000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_CAP_OV_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_CAP_OV "ALARM_CAP_OV"
#define LTC3351_ALARM_CAP_OV_SIZE 1u
#define LTC3351_ALARM_CAP_OV_OFFSET 13u
#define LTC3351_ALARM_CAP_OV_MASK 0x2000u
#define LTC3351_ALARM_CAP_OV_DEFAULT 0u
#define LTC3351_ALARM_CAP_OV_DECODE(register_data) (((register_data) & LTC3351_ALARM_CAP_OV_MASK) >> LTC3351_ALARM_CAP_OV_OFFSET)
#define LTC3351_ALARM_CAP_OV (LTC3351_ALARM_CAP_OV_OFFSET << 12 | (LTC3351_ALARM_CAP_OV_SIZE - 1) << 8 | LTC3351_ALARM_CAP_OV_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_CAP_LO ALARM_CAP_LO
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_CAP_LO Bit Field
 *
 *  Capacitance low alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 14
 *   - MSB: 14
 *   - MASK: 0x4000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_CAP_LO_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_CAP_LO "ALARM_CAP_LO"
#define LTC3351_ALARM_CAP_LO_SIZE 1u
#define LTC3351_ALARM_CAP_LO_OFFSET 14u
#define LTC3351_ALARM_CAP_LO_MASK 0x4000u
#define LTC3351_ALARM_CAP_LO_DEFAULT 0u
#define LTC3351_ALARM_CAP_LO_DECODE(register_data) (((register_data) & LTC3351_ALARM_CAP_LO_MASK) >> LTC3351_ALARM_CAP_LO_OFFSET)
#define LTC3351_ALARM_CAP_LO (LTC3351_ALARM_CAP_LO_OFFSET << 12 | (LTC3351_ALARM_CAP_LO_SIZE - 1) << 8 | LTC3351_ALARM_CAP_LO_SUBADDR)
//!@}
/*! @defgroup LTC3351_ALARM_ESR_HI ALARM_ESR_HI
 *  @ingroup LTC3351_register_map
 *  @brief ALARM_ESR_HI Bit Field
 *
 *  ESR high alarm
 *   - Register: @ref LTC3351_ALARM_REG "ALARM_REG"
 *   - CommandCode: 35
 *   - Size: 1
 *   - Offset: 15
 *   - MSB: 15
 *   - MASK: 0x8000
 *   - Access: R/W
 *   - Default: 0
 */
//!@{
#define LTC3351_ALARM_ESR_HI_SUBADDR LTC3351_ALARM_REG_SUBADDR //!< @ref LTC3351_ALARM_ESR_HI "ALARM_ESR_HI"
#define LTC3351_ALARM_ESR_HI_SIZE 1u
#define LTC3351_ALARM_ESR_HI_OFFSET 15u
#define LTC3351_ALARM_ESR_HI_MASK 0x8000u
#define LTC3351_ALARM_ESR_HI_DEFAULT 0u
#define LTC3351_ALARM_ESR_HI_DECODE(register_data) (((register_data) & LTC3351_ALARM_ESR_HI_MASK) >> LTC3351_ALARM_ESR_HI_OFFSET)
#define LTC3351_ALARM_ESR_HI (LTC3351_ALARM_ESR_HI_OFFSET << 12 | (LTC3351_ALARM_ESR_HI_SIZE - 1) << 8 | LTC3351_ALARM_ESR_HI_SUBADDR)
//!@}

/*! @defgroup LTC3351_MONITOR_STATUS_REG MONITOR_STATUS_REG
 *  @ingroup LTC3351_register_map
 *  @brief MONITOR_STATUS_REG Register
 *
 * |        15 |                14 |           13 |            12 |                 11 |               10 |                   9 |                   8 |                   7 |                  6 |               5 |            4 |            3 |                  2 |                    1 |               0 |
 * |:---------:|:-----------------:|:------------:|:-------------:|:------------------:|:----------------:|:-------------------:|:-------------------:|:-------------------:|:------------------:|:---------------:|:------------:|:------------:|:------------------:|:--------------------:|:---------------:|
 * | MON_RESET | MON_CAP_PRECHARGE | MON_SHUNTING | MON_BALANCING | MON_POWER_RETURNED | MON_POWER_FAILED | MON_ESR_MEAS_ACTIVE | MON_CAP_MEAS_ACTIVE | MON_DISABLE_CHARGER | MON_BOOST_SHUTDOWN | MON_MEAS_FAILED | MON_ESR_DONE | MON_CAP_DONE | MON_CAPESR_PENDING | MON_CAPESR_SCHEDULED | MON_MEAS_ACTIVE |
 *
 * Monitor Status: This register provides real time status information about the state of the monitoring system. Each bit is active high.
 *   - CommandCode: 36
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MON_MEAS_ACTIVE "MON_MEAS_ACTIVE" : Capacitance/ESR measurement is active. This bit becomes one at the begining of a capacitance/ESR measurement and remains 1 after the measurement has completed until the capacitors have been discharged back to their regulation voltage.
 *     + @ref LTC3351_MON_CAPESR_SCHEDULED "MON_CAPESR_SCHEDULED" : Indicates that the LTC3351 is waiting programmed time to begin a capacitance/ESR measurement
 *     + @ref LTC3351_MON_CAPESR_PENDING "MON_CAPESR_PENDING" : Indicates that the LTC3351 is waiting for satisfactory conditions to begin a capacitance/ESR measurement
 *     + @ref LTC3351_MON_CAP_DONE "MON_CAP_DONE" : Indicates that the capacitance measurement has completed
 *     + @ref LTC3351_MON_ESR_DONE "MON_ESR_DONE" : Indicates that the ESR Measurement has completed
 *     + @ref LTC3351_MON_MEAS_FAILED "MON_MEAS_FAILED" : Indicates the last attempted capacitance and ESR measurement was unable to complete
 *     + @ref LTC3351_MON_BOOST_SHUTDOWN "MON_BOOST_SHUTDOWN" : This bit is set in boost mode when any capacitor falls below min_boost_cap_voltage_reg. It is cleared when power returns.
 *     + @ref LTC3351_MON_DISABLE_CHARGER "MON_DISABLE_CHARGER" : Indicates the capacitance and ESR measurement system has temporarily disabled the charger.
 *     + @ref LTC3351_MON_CAP_MEAS_ACTIVE "MON_CAP_MEAS_ACTIVE" : Indicates the capacitance and ESR measurement system is measuring capacitance.
 *     + @ref LTC3351_MON_ESR_MEAS_ACTIVE "MON_ESR_MEAS_ACTIVE" : Indicates the capacitance and ESR measurement system is measuring ESR.
 *     + @ref LTC3351_MON_POWER_FAILED "MON_POWER_FAILED" : This bit is set when VIN is outside the UV/OV range or the HotSwap controller is disabled by setting the ctl_hotswap_disable. It is cleared only when mon_power_returned is set.
 *     + @ref LTC3351_MON_POWER_RETURNED "MON_POWER_RETURNED" : This bit is set when the output is powered by the input and the charger is able to charge. It is cleared only when mon_power_failed is set.
 *     + @ref LTC3351_MON_BALANCING "MON_BALANCING" : Indicates the LTC3351 is balancing the capacitor voltage.
 *     + @ref LTC3351_MON_SHUNTING "MON_SHUNTING" : Indicates a capacitor voltage is approaching vshunt and a shunt is turned on.
 *     + @ref LTC3351_MON_CAP_PRECHARGE "MON_CAP_PRECHARGE" : Indicates the capacitor stack is being precharged for a capacitance measurement.
 *     + @ref LTC3351_MON_RESET "MON_RESET" : This bit is set during a power on reset. It is cleared on any I2C/SMBus write. It can be used to determine if the chip has reset during a power loss followed by a power return.
*/

//!@{
#define LTC3351_MONITOR_STATUS_REG_SUBADDR 36u
#define LTC3351_MONITOR_STATUS_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MONITOR_STATUS_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_MEAS_ACTIVE MON_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MON_MEAS_ACTIVE Bit Field
 *
 *  Capacitance/ESR measurement is active. This bit becomes one at the begining of a capacitance/ESR measurement and remains 1 after the measurement has completed until the capacitors have been discharged back to their regulation voltage.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_MEAS_ACTIVE "MON_MEAS_ACTIVE"
#define LTC3351_MON_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MON_MEAS_ACTIVE_OFFSET 0u
#define LTC3351_MON_MEAS_ACTIVE_MASK 0x0001u
#define LTC3351_MON_MEAS_ACTIVE_DEFAULT n/au
#define LTC3351_MON_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MON_MEAS_ACTIVE_MASK) >> LTC3351_MON_MEAS_ACTIVE_OFFSET)
#define LTC3351_MON_MEAS_ACTIVE (LTC3351_MON_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MON_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MON_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_CAPESR_SCHEDULED MON_CAPESR_SCHEDULED
 *  @ingroup LTC3351_register_map
 *  @brief MON_CAPESR_SCHEDULED Bit Field
 *
 *  Indicates that the LTC3351 is waiting programmed time to begin a capacitance/ESR measurement
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_CAPESR_SCHEDULED_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_CAPESR_SCHEDULED "MON_CAPESR_SCHEDULED"
#define LTC3351_MON_CAPESR_SCHEDULED_SIZE 1u
#define LTC3351_MON_CAPESR_SCHEDULED_OFFSET 1u
#define LTC3351_MON_CAPESR_SCHEDULED_MASK 0x0002u
#define LTC3351_MON_CAPESR_SCHEDULED_DEFAULT n/au
#define LTC3351_MON_CAPESR_SCHEDULED_DECODE(register_data) (((register_data) & LTC3351_MON_CAPESR_SCHEDULED_MASK) >> LTC3351_MON_CAPESR_SCHEDULED_OFFSET)
#define LTC3351_MON_CAPESR_SCHEDULED (LTC3351_MON_CAPESR_SCHEDULED_OFFSET << 12 | (LTC3351_MON_CAPESR_SCHEDULED_SIZE - 1) << 8 | LTC3351_MON_CAPESR_SCHEDULED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_CAPESR_PENDING MON_CAPESR_PENDING
 *  @ingroup LTC3351_register_map
 *  @brief MON_CAPESR_PENDING Bit Field
 *
 *  Indicates that the LTC3351 is waiting for satisfactory conditions to begin a capacitance/ESR measurement
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_CAPESR_PENDING_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_CAPESR_PENDING "MON_CAPESR_PENDING"
#define LTC3351_MON_CAPESR_PENDING_SIZE 1u
#define LTC3351_MON_CAPESR_PENDING_OFFSET 2u
#define LTC3351_MON_CAPESR_PENDING_MASK 0x0004u
#define LTC3351_MON_CAPESR_PENDING_DEFAULT n/au
#define LTC3351_MON_CAPESR_PENDING_DECODE(register_data) (((register_data) & LTC3351_MON_CAPESR_PENDING_MASK) >> LTC3351_MON_CAPESR_PENDING_OFFSET)
#define LTC3351_MON_CAPESR_PENDING (LTC3351_MON_CAPESR_PENDING_OFFSET << 12 | (LTC3351_MON_CAPESR_PENDING_SIZE - 1) << 8 | LTC3351_MON_CAPESR_PENDING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_CAP_DONE MON_CAP_DONE
 *  @ingroup LTC3351_register_map
 *  @brief MON_CAP_DONE Bit Field
 *
 *  Indicates that the capacitance measurement has completed
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_CAP_DONE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_CAP_DONE "MON_CAP_DONE"
#define LTC3351_MON_CAP_DONE_SIZE 1u
#define LTC3351_MON_CAP_DONE_OFFSET 3u
#define LTC3351_MON_CAP_DONE_MASK 0x0008u
#define LTC3351_MON_CAP_DONE_DEFAULT n/au
#define LTC3351_MON_CAP_DONE_DECODE(register_data) (((register_data) & LTC3351_MON_CAP_DONE_MASK) >> LTC3351_MON_CAP_DONE_OFFSET)
#define LTC3351_MON_CAP_DONE (LTC3351_MON_CAP_DONE_OFFSET << 12 | (LTC3351_MON_CAP_DONE_SIZE - 1) << 8 | LTC3351_MON_CAP_DONE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_ESR_DONE MON_ESR_DONE
 *  @ingroup LTC3351_register_map
 *  @brief MON_ESR_DONE Bit Field
 *
 *  Indicates that the ESR Measurement has completed
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_ESR_DONE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_ESR_DONE "MON_ESR_DONE"
#define LTC3351_MON_ESR_DONE_SIZE 1u
#define LTC3351_MON_ESR_DONE_OFFSET 4u
#define LTC3351_MON_ESR_DONE_MASK 0x0010u
#define LTC3351_MON_ESR_DONE_DEFAULT n/au
#define LTC3351_MON_ESR_DONE_DECODE(register_data) (((register_data) & LTC3351_MON_ESR_DONE_MASK) >> LTC3351_MON_ESR_DONE_OFFSET)
#define LTC3351_MON_ESR_DONE (LTC3351_MON_ESR_DONE_OFFSET << 12 | (LTC3351_MON_ESR_DONE_SIZE - 1) << 8 | LTC3351_MON_ESR_DONE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_MEAS_FAILED MON_MEAS_FAILED
 *  @ingroup LTC3351_register_map
 *  @brief MON_MEAS_FAILED Bit Field
 *
 *  Indicates the last attempted capacitance and ESR measurement was unable to complete
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_MEAS_FAILED_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_MEAS_FAILED "MON_MEAS_FAILED"
#define LTC3351_MON_MEAS_FAILED_SIZE 1u
#define LTC3351_MON_MEAS_FAILED_OFFSET 5u
#define LTC3351_MON_MEAS_FAILED_MASK 0x0020u
#define LTC3351_MON_MEAS_FAILED_DEFAULT n/au
#define LTC3351_MON_MEAS_FAILED_DECODE(register_data) (((register_data) & LTC3351_MON_MEAS_FAILED_MASK) >> LTC3351_MON_MEAS_FAILED_OFFSET)
#define LTC3351_MON_MEAS_FAILED (LTC3351_MON_MEAS_FAILED_OFFSET << 12 | (LTC3351_MON_MEAS_FAILED_SIZE - 1) << 8 | LTC3351_MON_MEAS_FAILED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_BOOST_SHUTDOWN MON_BOOST_SHUTDOWN
 *  @ingroup LTC3351_register_map
 *  @brief MON_BOOST_SHUTDOWN Bit Field
 *
 *  This bit is set in boost mode when any capacitor falls below min_boost_cap_voltage_reg. It is cleared when power returns.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 6
 *   - MSB: 6
 *   - MASK: 0x0040
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_BOOST_SHUTDOWN_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_BOOST_SHUTDOWN "MON_BOOST_SHUTDOWN"
#define LTC3351_MON_BOOST_SHUTDOWN_SIZE 1u
#define LTC3351_MON_BOOST_SHUTDOWN_OFFSET 6u
#define LTC3351_MON_BOOST_SHUTDOWN_MASK 0x0040u
#define LTC3351_MON_BOOST_SHUTDOWN_DEFAULT n/au
#define LTC3351_MON_BOOST_SHUTDOWN_DECODE(register_data) (((register_data) & LTC3351_MON_BOOST_SHUTDOWN_MASK) >> LTC3351_MON_BOOST_SHUTDOWN_OFFSET)
#define LTC3351_MON_BOOST_SHUTDOWN (LTC3351_MON_BOOST_SHUTDOWN_OFFSET << 12 | (LTC3351_MON_BOOST_SHUTDOWN_SIZE - 1) << 8 | LTC3351_MON_BOOST_SHUTDOWN_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_DISABLE_CHARGER MON_DISABLE_CHARGER
 *  @ingroup LTC3351_register_map
 *  @brief MON_DISABLE_CHARGER Bit Field
 *
 *  Indicates the capacitance and ESR measurement system has temporarily disabled the charger.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_DISABLE_CHARGER_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_DISABLE_CHARGER "MON_DISABLE_CHARGER"
#define LTC3351_MON_DISABLE_CHARGER_SIZE 1u
#define LTC3351_MON_DISABLE_CHARGER_OFFSET 7u
#define LTC3351_MON_DISABLE_CHARGER_MASK 0x0080u
#define LTC3351_MON_DISABLE_CHARGER_DEFAULT n/au
#define LTC3351_MON_DISABLE_CHARGER_DECODE(register_data) (((register_data) & LTC3351_MON_DISABLE_CHARGER_MASK) >> LTC3351_MON_DISABLE_CHARGER_OFFSET)
#define LTC3351_MON_DISABLE_CHARGER (LTC3351_MON_DISABLE_CHARGER_OFFSET << 12 | (LTC3351_MON_DISABLE_CHARGER_SIZE - 1) << 8 | LTC3351_MON_DISABLE_CHARGER_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_CAP_MEAS_ACTIVE MON_CAP_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MON_CAP_MEAS_ACTIVE Bit Field
 *
 *  Indicates the capacitance and ESR measurement system is measuring capacitance.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_CAP_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_CAP_MEAS_ACTIVE "MON_CAP_MEAS_ACTIVE"
#define LTC3351_MON_CAP_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MON_CAP_MEAS_ACTIVE_OFFSET 8u
#define LTC3351_MON_CAP_MEAS_ACTIVE_MASK 0x0100u
#define LTC3351_MON_CAP_MEAS_ACTIVE_DEFAULT n/au
#define LTC3351_MON_CAP_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MON_CAP_MEAS_ACTIVE_MASK) >> LTC3351_MON_CAP_MEAS_ACTIVE_OFFSET)
#define LTC3351_MON_CAP_MEAS_ACTIVE (LTC3351_MON_CAP_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MON_CAP_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MON_CAP_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_ESR_MEAS_ACTIVE MON_ESR_MEAS_ACTIVE
 *  @ingroup LTC3351_register_map
 *  @brief MON_ESR_MEAS_ACTIVE Bit Field
 *
 *  Indicates the capacitance and ESR measurement system is measuring ESR.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_ESR_MEAS_ACTIVE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_ESR_MEAS_ACTIVE "MON_ESR_MEAS_ACTIVE"
#define LTC3351_MON_ESR_MEAS_ACTIVE_SIZE 1u
#define LTC3351_MON_ESR_MEAS_ACTIVE_OFFSET 9u
#define LTC3351_MON_ESR_MEAS_ACTIVE_MASK 0x0200u
#define LTC3351_MON_ESR_MEAS_ACTIVE_DEFAULT n/au
#define LTC3351_MON_ESR_MEAS_ACTIVE_DECODE(register_data) (((register_data) & LTC3351_MON_ESR_MEAS_ACTIVE_MASK) >> LTC3351_MON_ESR_MEAS_ACTIVE_OFFSET)
#define LTC3351_MON_ESR_MEAS_ACTIVE (LTC3351_MON_ESR_MEAS_ACTIVE_OFFSET << 12 | (LTC3351_MON_ESR_MEAS_ACTIVE_SIZE - 1) << 8 | LTC3351_MON_ESR_MEAS_ACTIVE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_POWER_FAILED MON_POWER_FAILED
 *  @ingroup LTC3351_register_map
 *  @brief MON_POWER_FAILED Bit Field
 *
 *  This bit is set when VIN is outside the UV/OV range or the HotSwap controller is disabled by setting the ctl_hotswap_disable. It is cleared only when mon_power_returned is set.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 10
 *   - MSB: 10
 *   - MASK: 0x0400
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_POWER_FAILED_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_POWER_FAILED "MON_POWER_FAILED"
#define LTC3351_MON_POWER_FAILED_SIZE 1u
#define LTC3351_MON_POWER_FAILED_OFFSET 10u
#define LTC3351_MON_POWER_FAILED_MASK 0x0400u
#define LTC3351_MON_POWER_FAILED_DEFAULT n/au
#define LTC3351_MON_POWER_FAILED_DECODE(register_data) (((register_data) & LTC3351_MON_POWER_FAILED_MASK) >> LTC3351_MON_POWER_FAILED_OFFSET)
#define LTC3351_MON_POWER_FAILED (LTC3351_MON_POWER_FAILED_OFFSET << 12 | (LTC3351_MON_POWER_FAILED_SIZE - 1) << 8 | LTC3351_MON_POWER_FAILED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_POWER_RETURNED MON_POWER_RETURNED
 *  @ingroup LTC3351_register_map
 *  @brief MON_POWER_RETURNED Bit Field
 *
 *  This bit is set when the output is powered by the input and the charger is able to charge. It is cleared only when mon_power_failed is set.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_POWER_RETURNED_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_POWER_RETURNED "MON_POWER_RETURNED"
#define LTC3351_MON_POWER_RETURNED_SIZE 1u
#define LTC3351_MON_POWER_RETURNED_OFFSET 11u
#define LTC3351_MON_POWER_RETURNED_MASK 0x0800u
#define LTC3351_MON_POWER_RETURNED_DEFAULT n/au
#define LTC3351_MON_POWER_RETURNED_DECODE(register_data) (((register_data) & LTC3351_MON_POWER_RETURNED_MASK) >> LTC3351_MON_POWER_RETURNED_OFFSET)
#define LTC3351_MON_POWER_RETURNED (LTC3351_MON_POWER_RETURNED_OFFSET << 12 | (LTC3351_MON_POWER_RETURNED_SIZE - 1) << 8 | LTC3351_MON_POWER_RETURNED_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_BALANCING MON_BALANCING
 *  @ingroup LTC3351_register_map
 *  @brief MON_BALANCING Bit Field
 *
 *  Indicates the LTC3351 is balancing the capacitor voltage.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 12
 *   - MSB: 12
 *   - MASK: 0x1000
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_BALANCING_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_BALANCING "MON_BALANCING"
#define LTC3351_MON_BALANCING_SIZE 1u
#define LTC3351_MON_BALANCING_OFFSET 12u
#define LTC3351_MON_BALANCING_MASK 0x1000u
#define LTC3351_MON_BALANCING_DEFAULT n/au
#define LTC3351_MON_BALANCING_DECODE(register_data) (((register_data) & LTC3351_MON_BALANCING_MASK) >> LTC3351_MON_BALANCING_OFFSET)
#define LTC3351_MON_BALANCING (LTC3351_MON_BALANCING_OFFSET << 12 | (LTC3351_MON_BALANCING_SIZE - 1) << 8 | LTC3351_MON_BALANCING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_SHUNTING MON_SHUNTING
 *  @ingroup LTC3351_register_map
 *  @brief MON_SHUNTING Bit Field
 *
 *  Indicates a capacitor voltage is approaching vshunt and a shunt is turned on.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 13
 *   - MSB: 13
 *   - MASK: 0x2000
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_SHUNTING_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_SHUNTING "MON_SHUNTING"
#define LTC3351_MON_SHUNTING_SIZE 1u
#define LTC3351_MON_SHUNTING_OFFSET 13u
#define LTC3351_MON_SHUNTING_MASK 0x2000u
#define LTC3351_MON_SHUNTING_DEFAULT n/au
#define LTC3351_MON_SHUNTING_DECODE(register_data) (((register_data) & LTC3351_MON_SHUNTING_MASK) >> LTC3351_MON_SHUNTING_OFFSET)
#define LTC3351_MON_SHUNTING (LTC3351_MON_SHUNTING_OFFSET << 12 | (LTC3351_MON_SHUNTING_SIZE - 1) << 8 | LTC3351_MON_SHUNTING_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_CAP_PRECHARGE MON_CAP_PRECHARGE
 *  @ingroup LTC3351_register_map
 *  @brief MON_CAP_PRECHARGE Bit Field
 *
 *  Indicates the capacitor stack is being precharged for a capacitance measurement.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 14
 *   - MSB: 14
 *   - MASK: 0x4000
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_CAP_PRECHARGE_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_CAP_PRECHARGE "MON_CAP_PRECHARGE"
#define LTC3351_MON_CAP_PRECHARGE_SIZE 1u
#define LTC3351_MON_CAP_PRECHARGE_OFFSET 14u
#define LTC3351_MON_CAP_PRECHARGE_MASK 0x4000u
#define LTC3351_MON_CAP_PRECHARGE_DEFAULT n/au
#define LTC3351_MON_CAP_PRECHARGE_DECODE(register_data) (((register_data) & LTC3351_MON_CAP_PRECHARGE_MASK) >> LTC3351_MON_CAP_PRECHARGE_OFFSET)
#define LTC3351_MON_CAP_PRECHARGE (LTC3351_MON_CAP_PRECHARGE_OFFSET << 12 | (LTC3351_MON_CAP_PRECHARGE_SIZE - 1) << 8 | LTC3351_MON_CAP_PRECHARGE_SUBADDR)
//!@}
/*! @defgroup LTC3351_MON_RESET MON_RESET
 *  @ingroup LTC3351_register_map
 *  @brief MON_RESET Bit Field
 *
 *  This bit is set during a power on reset. It is cleared on any I2C/SMBus write. It can be used to determine if the chip has reset during a power loss followed by a power return.
 *   - Register: @ref LTC3351_MONITOR_STATUS_REG "MONITOR_STATUS_REG"
 *   - CommandCode: 36
 *   - Size: 1
 *   - Offset: 15
 *   - MSB: 15
 *   - MASK: 0x8000
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_MON_RESET_SUBADDR LTC3351_MONITOR_STATUS_REG_SUBADDR //!< @ref LTC3351_MON_RESET "MON_RESET"
#define LTC3351_MON_RESET_SIZE 1u
#define LTC3351_MON_RESET_OFFSET 15u
#define LTC3351_MON_RESET_MASK 0x8000u
#define LTC3351_MON_RESET_DEFAULT n/au
#define LTC3351_MON_RESET_DECODE(register_data) (((register_data) & LTC3351_MON_RESET_MASK) >> LTC3351_MON_RESET_OFFSET)
#define LTC3351_MON_RESET (LTC3351_MON_RESET_OFFSET << 12 | (LTC3351_MON_RESET_SIZE - 1) << 8 | LTC3351_MON_RESET_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_GPI_REG MEAS_GPI_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_GPI_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | MEAS_GPI |
 *
 *   - CommandCode: 37
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_GPI "MEAS_GPI" : Measurement of GPI pin voltage. 182.8µV per LSB
*/

//!@{
#define LTC3351_MEAS_GPI_REG_SUBADDR 37u
#define LTC3351_MEAS_GPI_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_GPI_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_GPI MEAS_GPI
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_GPI Bit Field
 *
 *  Measurement of GPI pin voltage. 182.8µV per LSB
 *   - Register: @ref LTC3351_MEAS_GPI_REG "MEAS_GPI_REG"
 *   - CommandCode: 37
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MEAS_GPI_SUBADDR LTC3351_MEAS_GPI_REG_SUBADDR //!< @ref LTC3351_MEAS_GPI "MEAS_GPI"
#define LTC3351_MEAS_GPI_SIZE 16u
#define LTC3351_MEAS_GPI_OFFSET 0u
#define LTC3351_MEAS_GPI_MASK 0xFFFFu
#define LTC3351_MEAS_GPI_DEFAULT n/au
#define LTC3351_MEAS_GPI_DECODE(register_data) (register_data)
#define LTC3351_MEAS_GPI (LTC3351_MEAS_GPI_OFFSET << 12 | (LTC3351_MEAS_GPI_SIZE - 1) << 8 | LTC3351_MEAS_GPI_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VIN_REG MEAS_VIN_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VIN_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | MEAS_VIN |
 *
 *   - CommandCode: 38
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VIN "MEAS_VIN" : Measured Input Voltage. 2.19mV per LSB
*/

//!@{
#define LTC3351_MEAS_VIN_REG_SUBADDR 38u
#define LTC3351_MEAS_VIN_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VIN_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VIN MEAS_VIN
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VIN Bit Field
 *
 *  Measured Input Voltage. 2.19mV per LSB
 *   - Register: @ref LTC3351_MEAS_VIN_REG "MEAS_VIN_REG"
 *   - CommandCode: 38
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_VIN_FORMAT
 */
//!@{
#define LTC3351_MEAS_VIN_SUBADDR LTC3351_MEAS_VIN_REG_SUBADDR //!< @ref LTC3351_MEAS_VIN "MEAS_VIN"
#define LTC3351_MEAS_VIN_SIZE 16u
#define LTC3351_MEAS_VIN_OFFSET 0u
#define LTC3351_MEAS_VIN_MASK 0xFFFFu
#define LTC3351_MEAS_VIN_DEFAULT n/au
#define LTC3351_MEAS_VIN_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VIN (LTC3351_MEAS_VIN_OFFSET << 12 | (LTC3351_MEAS_VIN_SIZE - 1) << 8 | LTC3351_MEAS_VIN_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VCAP_REG MEAS_VCAP_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP_REG Register
 *
 * |      15:0 |
 * |:---------:|
 * | MEAS_VCAP |
 *
 *   - CommandCode: 39
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VCAP "MEAS_VCAP" : Measured Capacitor Stack Voltage. 1.46mV per LSB.
*/

//!@{
#define LTC3351_MEAS_VCAP_REG_SUBADDR 39u
#define LTC3351_MEAS_VCAP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VCAP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VCAP MEAS_VCAP
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP Bit Field
 *
 *  Measured Capacitor Stack Voltage. 1.46mV per LSB.
 *   - Register: @ref LTC3351_MEAS_VCAP_REG "MEAS_VCAP_REG"
 *   - CommandCode: 39
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_VCAP_FORMAT
 */
//!@{
#define LTC3351_MEAS_VCAP_SUBADDR LTC3351_MEAS_VCAP_REG_SUBADDR //!< @ref LTC3351_MEAS_VCAP "MEAS_VCAP"
#define LTC3351_MEAS_VCAP_SIZE 16u
#define LTC3351_MEAS_VCAP_OFFSET 0u
#define LTC3351_MEAS_VCAP_MASK 0xFFFFu
#define LTC3351_MEAS_VCAP_DEFAULT n/au
#define LTC3351_MEAS_VCAP_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VCAP (LTC3351_MEAS_VCAP_OFFSET << 12 | (LTC3351_MEAS_VCAP_SIZE - 1) << 8 | LTC3351_MEAS_VCAP_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VOUT_REG MEAS_VOUT_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VOUT_REG Register
 *
 * |      15:0 |
 * |:---------:|
 * | MEAS_VOUT |
 *
 *   - CommandCode: 40
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VOUT "MEAS_VOUT" : Measured Output Voltage. 2.19mV per LSB.
*/

//!@{
#define LTC3351_MEAS_VOUT_REG_SUBADDR 40u
#define LTC3351_MEAS_VOUT_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VOUT_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VOUT MEAS_VOUT
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VOUT Bit Field
 *
 *  Measured Output Voltage. 2.19mV per LSB.
 *   - Register: @ref LTC3351_MEAS_VOUT_REG "MEAS_VOUT_REG"
 *   - CommandCode: 40
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_VOUT_FORMAT
 */
//!@{
#define LTC3351_MEAS_VOUT_SUBADDR LTC3351_MEAS_VOUT_REG_SUBADDR //!< @ref LTC3351_MEAS_VOUT "MEAS_VOUT"
#define LTC3351_MEAS_VOUT_SIZE 16u
#define LTC3351_MEAS_VOUT_OFFSET 0u
#define LTC3351_MEAS_VOUT_MASK 0xFFFFu
#define LTC3351_MEAS_VOUT_DEFAULT n/au
#define LTC3351_MEAS_VOUT_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VOUT (LTC3351_MEAS_VOUT_OFFSET << 12 | (LTC3351_MEAS_VOUT_SIZE - 1) << 8 | LTC3351_MEAS_VOUT_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_DTEMP_REG MEAS_DTEMP_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_DTEMP_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | MEAS_DTEMP |
 *
 *   - CommandCode: 41
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_DTEMP "MEAS_DTEMP" : Measured die temperature. Temperature = 0.0295°C per LSB - 274°C.
*/

//!@{
#define LTC3351_MEAS_DTEMP_REG_SUBADDR 41u
#define LTC3351_MEAS_DTEMP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_DTEMP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_DTEMP MEAS_DTEMP
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_DTEMP Bit Field
 *
 *  Measured die temperature. Temperature = 0.0295°C per LSB - 274°C.
 *   - Register: @ref LTC3351_MEAS_DTEMP_REG "MEAS_DTEMP_REG"
 *   - CommandCode: 41
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_DTEMP_FORMAT
 */
//!@{
#define LTC3351_MEAS_DTEMP_SUBADDR LTC3351_MEAS_DTEMP_REG_SUBADDR //!< @ref LTC3351_MEAS_DTEMP "MEAS_DTEMP"
#define LTC3351_MEAS_DTEMP_SIZE 16u
#define LTC3351_MEAS_DTEMP_OFFSET 0u
#define LTC3351_MEAS_DTEMP_MASK 0xFFFFu
#define LTC3351_MEAS_DTEMP_DEFAULT n/au
#define LTC3351_MEAS_DTEMP_DECODE(register_data) (register_data)
#define LTC3351_MEAS_DTEMP (LTC3351_MEAS_DTEMP_OFFSET << 12 | (LTC3351_MEAS_DTEMP_SIZE - 1) << 8 | LTC3351_MEAS_DTEMP_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_ICHG_REG MEAS_ICHG_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_ICHG_REG Register
 *
 * |      15:0 |
 * |:---------:|
 * | MEAS_ICHG |
 *
 *   - CommandCode: 42
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_ICHG "MEAS_ICHG" : Measured Charge Current. 1.955µV/Rsnsc per LSB
*/

//!@{
#define LTC3351_MEAS_ICHG_REG_SUBADDR 42u
#define LTC3351_MEAS_ICHG_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_ICHG_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_ICHG MEAS_ICHG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_ICHG Bit Field
 *
 *  Measured Charge Current. 1.955µV/Rsnsc per LSB
 *   - Register: @ref LTC3351_MEAS_ICHG_REG "MEAS_ICHG_REG"
 *   - CommandCode: 42
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_ICHARGE_FORMAT
 */
//!@{
#define LTC3351_MEAS_ICHG_SUBADDR LTC3351_MEAS_ICHG_REG_SUBADDR //!< @ref LTC3351_MEAS_ICHG "MEAS_ICHG"
#define LTC3351_MEAS_ICHG_SIZE 16u
#define LTC3351_MEAS_ICHG_OFFSET 0u
#define LTC3351_MEAS_ICHG_MASK 0xFFFFu
#define LTC3351_MEAS_ICHG_DEFAULT n/au
#define LTC3351_MEAS_ICHG_DECODE(register_data) (register_data)
#define LTC3351_MEAS_ICHG (LTC3351_MEAS_ICHG_OFFSET << 12 | (LTC3351_MEAS_ICHG_SIZE - 1) << 8 | LTC3351_MEAS_ICHG_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_IIN_REG MEAS_IIN_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_IIN_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | MEAS_IIN |
 *
 *   - CommandCode: 43
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_IIN "MEAS_IIN" : Measured Input Current. 1.955µV/Rsnsi per LSB
*/

//!@{
#define LTC3351_MEAS_IIN_REG_SUBADDR 43u
#define LTC3351_MEAS_IIN_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_IIN_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_IIN MEAS_IIN
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_IIN Bit Field
 *
 *  Measured Input Current. 1.955µV/Rsnsi per LSB
 *   - Register: @ref LTC3351_MEAS_IIN_REG "MEAS_IIN_REG"
 *   - CommandCode: 43
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_IIN_FORMAT
 */
//!@{
#define LTC3351_MEAS_IIN_SUBADDR LTC3351_MEAS_IIN_REG_SUBADDR //!< @ref LTC3351_MEAS_IIN "MEAS_IIN"
#define LTC3351_MEAS_IIN_SIZE 16u
#define LTC3351_MEAS_IIN_OFFSET 0u
#define LTC3351_MEAS_IIN_MASK 0xFFFFu
#define LTC3351_MEAS_IIN_DEFAULT n/au
#define LTC3351_MEAS_IIN_DECODE(register_data) (register_data)
#define LTC3351_MEAS_IIN (LTC3351_MEAS_IIN_OFFSET << 12 | (LTC3351_MEAS_IIN_SIZE - 1) << 8 | LTC3351_MEAS_IIN_SUBADDR)
//!@}

/*! @defgroup LTC3351_LO_VCAP_REG LO_VCAP_REG
 *  @ingroup LTC3351_register_map
 *  @brief LO_VCAP_REG Register
 *
 * |    15:0 |
 * |:-------:|
 * | LO_VCAP |
 *
 *   - CommandCode: 44
 *   - Contains Bit Fields:
 *     + @ref LTC3351_LO_VCAP "LO_VCAP" : The lowest measured capacitor voltage from the last measurement set.
*/

//!@{
#define LTC3351_LO_VCAP_REG_SUBADDR 44u
#define LTC3351_LO_VCAP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_LO_VCAP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_LO_VCAP LO_VCAP
 *  @ingroup LTC3351_register_map
 *  @brief LO_VCAP Bit Field
 *
 *  The lowest measured capacitor voltage from the last measurement set.
 *   - Register: @ref LTC3351_LO_VCAP_REG "LO_VCAP_REG"
 *   - CommandCode: 44
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_LO_VCAP_SUBADDR LTC3351_LO_VCAP_REG_SUBADDR //!< @ref LTC3351_LO_VCAP "LO_VCAP"
#define LTC3351_LO_VCAP_SIZE 16u
#define LTC3351_LO_VCAP_OFFSET 0u
#define LTC3351_LO_VCAP_MASK 0xFFFFu
#define LTC3351_LO_VCAP_DEFAULT n/au
#define LTC3351_LO_VCAP_DECODE(register_data) (register_data)
#define LTC3351_LO_VCAP (LTC3351_LO_VCAP_OFFSET << 12 | (LTC3351_LO_VCAP_SIZE - 1) << 8 | LTC3351_LO_VCAP_SUBADDR)
//!@}

/*! @defgroup LTC3351_HI_VCAP_REG HI_VCAP_REG
 *  @ingroup LTC3351_register_map
 *  @brief HI_VCAP_REG Register
 *
 * |    15:0 |
 * |:-------:|
 * | HI_VCAP |
 *
 *   - CommandCode: 45
 *   - Contains Bit Fields:
 *     + @ref LTC3351_HI_VCAP "HI_VCAP" : The highest measured capacitor voltage from the last measurement set.
*/

//!@{
#define LTC3351_HI_VCAP_REG_SUBADDR 45u
#define LTC3351_HI_VCAP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_HI_VCAP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_HI_VCAP HI_VCAP
 *  @ingroup LTC3351_register_map
 *  @brief HI_VCAP Bit Field
 *
 *  The highest measured capacitor voltage from the last measurement set.
 *   - Register: @ref LTC3351_HI_VCAP_REG "HI_VCAP_REG"
 *   - CommandCode: 45
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_HI_VCAP_SUBADDR LTC3351_HI_VCAP_REG_SUBADDR //!< @ref LTC3351_HI_VCAP "HI_VCAP"
#define LTC3351_HI_VCAP_SIZE 16u
#define LTC3351_HI_VCAP_OFFSET 0u
#define LTC3351_HI_VCAP_MASK 0xFFFFu
#define LTC3351_HI_VCAP_DEFAULT n/au
#define LTC3351_HI_VCAP_DECODE(register_data) (register_data)
#define LTC3351_HI_VCAP (LTC3351_HI_VCAP_OFFSET << 12 | (LTC3351_HI_VCAP_SIZE - 1) << 8 | LTC3351_HI_VCAP_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_CAP_REG MEAS_CAP_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_CAP_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | MEAS_CAP |
 *
 *   - CommandCode: 46
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_CAP "MEAS_CAP" : Measured capacitor stack capacitance value. When ctl_cap_scale is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When ctl_cap_scale is set to 0 it is 336µF * RT/RTST per LSB.
*/

//!@{
#define LTC3351_MEAS_CAP_REG_SUBADDR 46u
#define LTC3351_MEAS_CAP_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_CAP_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_CAP MEAS_CAP
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_CAP Bit Field
 *
 *  Measured capacitor stack capacitance value. When ctl_cap_scale is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When ctl_cap_scale is set to 0 it is 336µF * RT/RTST per LSB.
 *   - Register: @ref LTC3351_MEAS_CAP_REG "MEAS_CAP_REG"
 *   - CommandCode: 46
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CAP_FORMAT, LTC3351_CAP_ZS_FORMAT
 */
//!@{
#define LTC3351_MEAS_CAP_SUBADDR LTC3351_MEAS_CAP_REG_SUBADDR //!< @ref LTC3351_MEAS_CAP "MEAS_CAP"
#define LTC3351_MEAS_CAP_SIZE 16u
#define LTC3351_MEAS_CAP_OFFSET 0u
#define LTC3351_MEAS_CAP_MASK 0xFFFFu
#define LTC3351_MEAS_CAP_DEFAULT n/au
#define LTC3351_MEAS_CAP_DECODE(register_data) (register_data)
#define LTC3351_MEAS_CAP (LTC3351_MEAS_CAP_OFFSET << 12 | (LTC3351_MEAS_CAP_SIZE - 1) << 8 | LTC3351_MEAS_CAP_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_ESR_REG MEAS_ESR_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_ESR_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | MEAS_ESR |
 *
 *   - CommandCode: 47
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_ESR "MEAS_ESR" : Measured capacitor stack equivalent series resistance (ESR) value. Rsnsc/64 per LSB
*/

//!@{
#define LTC3351_MEAS_ESR_REG_SUBADDR 47u
#define LTC3351_MEAS_ESR_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_ESR_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_ESR MEAS_ESR
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_ESR Bit Field
 *
 *  Measured capacitor stack equivalent series resistance (ESR) value. Rsnsc/64 per LSB
 *   - Register: @ref LTC3351_MEAS_ESR_REG "MEAS_ESR_REG"
 *   - CommandCode: 47
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_ESR_FORMAT
 */
//!@{
#define LTC3351_MEAS_ESR_SUBADDR LTC3351_MEAS_ESR_REG_SUBADDR //!< @ref LTC3351_MEAS_ESR "MEAS_ESR"
#define LTC3351_MEAS_ESR_SIZE 16u
#define LTC3351_MEAS_ESR_OFFSET 0u
#define LTC3351_MEAS_ESR_MASK 0xFFFFu
#define LTC3351_MEAS_ESR_DEFAULT n/au
#define LTC3351_MEAS_ESR_DECODE(register_data) (register_data)
#define LTC3351_MEAS_ESR (LTC3351_MEAS_ESR_OFFSET << 12 | (LTC3351_MEAS_ESR_SIZE - 1) << 8 | LTC3351_MEAS_ESR_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VCAP1_REG MEAS_VCAP1_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | MEAS_VCAP1 |
 *
 *   - CommandCode: 48
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VCAP1 "MEAS_VCAP1" : Measured voltage between the CAP1 and CAPRTN pins. 182.8µV per LSB
*/

//!@{
#define LTC3351_MEAS_VCAP1_REG_SUBADDR 48u
#define LTC3351_MEAS_VCAP1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VCAP1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VCAP1 MEAS_VCAP1
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP1 Bit Field
 *
 *  Measured voltage between the CAP1 and CAPRTN pins. 182.8µV per LSB
 *   - Register: @ref LTC3351_MEAS_VCAP1_REG "MEAS_VCAP1_REG"
 *   - CommandCode: 48
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MEAS_VCAP1_SUBADDR LTC3351_MEAS_VCAP1_REG_SUBADDR //!< @ref LTC3351_MEAS_VCAP1 "MEAS_VCAP1"
#define LTC3351_MEAS_VCAP1_SIZE 16u
#define LTC3351_MEAS_VCAP1_OFFSET 0u
#define LTC3351_MEAS_VCAP1_MASK 0xFFFFu
#define LTC3351_MEAS_VCAP1_DEFAULT n/au
#define LTC3351_MEAS_VCAP1_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VCAP1 (LTC3351_MEAS_VCAP1_OFFSET << 12 | (LTC3351_MEAS_VCAP1_SIZE - 1) << 8 | LTC3351_MEAS_VCAP1_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VCAP2_REG MEAS_VCAP2_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | MEAS_VCAP2 |
 *
 *   - CommandCode: 49
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VCAP2 "MEAS_VCAP2" : Measured voltage between the CAP2 and CAP1 pins. 182.8µV per LSB
*/

//!@{
#define LTC3351_MEAS_VCAP2_REG_SUBADDR 49u
#define LTC3351_MEAS_VCAP2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VCAP2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VCAP2 MEAS_VCAP2
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP2 Bit Field
 *
 *  Measured voltage between the CAP2 and CAP1 pins. 182.8µV per LSB
 *   - Register: @ref LTC3351_MEAS_VCAP2_REG "MEAS_VCAP2_REG"
 *   - CommandCode: 49
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MEAS_VCAP2_SUBADDR LTC3351_MEAS_VCAP2_REG_SUBADDR //!< @ref LTC3351_MEAS_VCAP2 "MEAS_VCAP2"
#define LTC3351_MEAS_VCAP2_SIZE 16u
#define LTC3351_MEAS_VCAP2_OFFSET 0u
#define LTC3351_MEAS_VCAP2_MASK 0xFFFFu
#define LTC3351_MEAS_VCAP2_DEFAULT n/au
#define LTC3351_MEAS_VCAP2_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VCAP2 (LTC3351_MEAS_VCAP2_OFFSET << 12 | (LTC3351_MEAS_VCAP2_SIZE - 1) << 8 | LTC3351_MEAS_VCAP2_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VCAP3_REG MEAS_VCAP3_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | MEAS_VCAP3 |
 *
 *   - CommandCode: 50
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VCAP3 "MEAS_VCAP3" : Measured voltage between the CAP3 and CAP2 pins. 182.8µV per LSB
*/

//!@{
#define LTC3351_MEAS_VCAP3_REG_SUBADDR 50u
#define LTC3351_MEAS_VCAP3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VCAP3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VCAP3 MEAS_VCAP3
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP3 Bit Field
 *
 *  Measured voltage between the CAP3 and CAP2 pins. 182.8µV per LSB
 *   - Register: @ref LTC3351_MEAS_VCAP3_REG "MEAS_VCAP3_REG"
 *   - CommandCode: 50
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MEAS_VCAP3_SUBADDR LTC3351_MEAS_VCAP3_REG_SUBADDR //!< @ref LTC3351_MEAS_VCAP3 "MEAS_VCAP3"
#define LTC3351_MEAS_VCAP3_SIZE 16u
#define LTC3351_MEAS_VCAP3_OFFSET 0u
#define LTC3351_MEAS_VCAP3_MASK 0xFFFFu
#define LTC3351_MEAS_VCAP3_DEFAULT n/au
#define LTC3351_MEAS_VCAP3_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VCAP3 (LTC3351_MEAS_VCAP3_OFFSET << 12 | (LTC3351_MEAS_VCAP3_SIZE - 1) << 8 | LTC3351_MEAS_VCAP3_SUBADDR)
//!@}

/*! @defgroup LTC3351_MEAS_VCAP4_REG MEAS_VCAP4_REG
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | MEAS_VCAP4 |
 *
 *   - CommandCode: 51
 *   - Contains Bit Fields:
 *     + @ref LTC3351_MEAS_VCAP4 "MEAS_VCAP4" : Measured voltage between the CAP4 and CAP3 pins. 182.8µV per LSB. When the ITST current is on, either due to ctl_force_itst_on or during a capacitance measurement, this voltage measurement will temporarily be low due to the ITST current flowing in the shunt resistor. 
*/

//!@{
#define LTC3351_MEAS_VCAP4_REG_SUBADDR 51u
#define LTC3351_MEAS_VCAP4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_MEAS_VCAP4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_MEAS_VCAP4 MEAS_VCAP4
 *  @ingroup LTC3351_register_map
 *  @brief MEAS_VCAP4 Bit Field
 *
 *  Measured voltage between the CAP4 and CAP3 pins. 182.8µV per LSB. When the ITST current is on, either due to ctl_force_itst_on or during a capacitance measurement, this voltage measurement will temporarily be low due to the ITST current flowing in the shunt resistor. 
 *   - Register: @ref LTC3351_MEAS_VCAP4_REG "MEAS_VCAP4_REG"
 *   - CommandCode: 51
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 *   - Format: LTC3351_CELL_FORMAT
 */
//!@{
#define LTC3351_MEAS_VCAP4_SUBADDR LTC3351_MEAS_VCAP4_REG_SUBADDR //!< @ref LTC3351_MEAS_VCAP4 "MEAS_VCAP4"
#define LTC3351_MEAS_VCAP4_SIZE 16u
#define LTC3351_MEAS_VCAP4_OFFSET 0u
#define LTC3351_MEAS_VCAP4_MASK 0xFFFFu
#define LTC3351_MEAS_VCAP4_DEFAULT n/au
#define LTC3351_MEAS_VCAP4_DECODE(register_data) (register_data)
#define LTC3351_MEAS_VCAP4 (LTC3351_MEAS_VCAP4_OFFSET << 12 | (LTC3351_MEAS_VCAP4_SIZE - 1) << 8 | LTC3351_MEAS_VCAP4_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_M0_VC1_REG CAP_M0_VC1_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_M0_VC1 |
 *
 *   - CommandCode: 52
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_M0_VC1 "CAP_M0_VC1" : The voltage change on cap1 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
*/

//!@{
#define LTC3351_CAP_M0_VC1_REG_SUBADDR 52u
#define LTC3351_CAP_M0_VC1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_M0_VC1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_M0_VC1 CAP_M0_VC1
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC1 Bit Field
 *
 *  The voltage change on cap1 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
 *   - Register: @ref LTC3351_CAP_M0_VC1_REG "CAP_M0_VC1_REG"
 *   - CommandCode: 52
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CAP_M0_VC1_SUBADDR LTC3351_CAP_M0_VC1_REG_SUBADDR //!< @ref LTC3351_CAP_M0_VC1 "CAP_M0_VC1"
#define LTC3351_CAP_M0_VC1_SIZE 16u
#define LTC3351_CAP_M0_VC1_OFFSET 0u
#define LTC3351_CAP_M0_VC1_MASK 0xFFFFu
#define LTC3351_CAP_M0_VC1_DEFAULT n/au
#define LTC3351_CAP_M0_VC1_DECODE(register_data) (register_data)
#define LTC3351_CAP_M0_VC1 (LTC3351_CAP_M0_VC1_OFFSET << 12 | (LTC3351_CAP_M0_VC1_SIZE - 1) << 8 | LTC3351_CAP_M0_VC1_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_M0_VC2_REG CAP_M0_VC2_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_M0_VC2 |
 *
 *   - CommandCode: 53
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_M0_VC2 "CAP_M0_VC2" : The voltage change on cap2 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
*/

//!@{
#define LTC3351_CAP_M0_VC2_REG_SUBADDR 53u
#define LTC3351_CAP_M0_VC2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_M0_VC2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_M0_VC2 CAP_M0_VC2
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC2 Bit Field
 *
 *  The voltage change on cap2 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
 *   - Register: @ref LTC3351_CAP_M0_VC2_REG "CAP_M0_VC2_REG"
 *   - CommandCode: 53
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CAP_M0_VC2_SUBADDR LTC3351_CAP_M0_VC2_REG_SUBADDR //!< @ref LTC3351_CAP_M0_VC2 "CAP_M0_VC2"
#define LTC3351_CAP_M0_VC2_SIZE 16u
#define LTC3351_CAP_M0_VC2_OFFSET 0u
#define LTC3351_CAP_M0_VC2_MASK 0xFFFFu
#define LTC3351_CAP_M0_VC2_DEFAULT n/au
#define LTC3351_CAP_M0_VC2_DECODE(register_data) (register_data)
#define LTC3351_CAP_M0_VC2 (LTC3351_CAP_M0_VC2_OFFSET << 12 | (LTC3351_CAP_M0_VC2_SIZE - 1) << 8 | LTC3351_CAP_M0_VC2_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_M0_VC3_REG CAP_M0_VC3_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_M0_VC3 |
 *
 *   - CommandCode: 54
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_M0_VC3 "CAP_M0_VC3" : The voltage change on cap3 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
*/

//!@{
#define LTC3351_CAP_M0_VC3_REG_SUBADDR 54u
#define LTC3351_CAP_M0_VC3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_M0_VC3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_M0_VC3 CAP_M0_VC3
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC3 Bit Field
 *
 *  The voltage change on cap3 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
 *   - Register: @ref LTC3351_CAP_M0_VC3_REG "CAP_M0_VC3_REG"
 *   - CommandCode: 54
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CAP_M0_VC3_SUBADDR LTC3351_CAP_M0_VC3_REG_SUBADDR //!< @ref LTC3351_CAP_M0_VC3 "CAP_M0_VC3"
#define LTC3351_CAP_M0_VC3_SIZE 16u
#define LTC3351_CAP_M0_VC3_OFFSET 0u
#define LTC3351_CAP_M0_VC3_MASK 0xFFFFu
#define LTC3351_CAP_M0_VC3_DEFAULT n/au
#define LTC3351_CAP_M0_VC3_DECODE(register_data) (register_data)
#define LTC3351_CAP_M0_VC3 (LTC3351_CAP_M0_VC3_OFFSET << 12 | (LTC3351_CAP_M0_VC3_SIZE - 1) << 8 | LTC3351_CAP_M0_VC3_SUBADDR)
//!@}

/*! @defgroup LTC3351_CAP_M0_VC4_REG CAP_M0_VC4_REG
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | CAP_M0_VC4 |
 *
 *   - CommandCode: 55
 *   - Contains Bit Fields:
 *     + @ref LTC3351_CAP_M0_VC4 "CAP_M0_VC4" : The voltage change on cap4 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
*/

//!@{
#define LTC3351_CAP_M0_VC4_REG_SUBADDR 55u
#define LTC3351_CAP_M0_VC4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_CAP_M0_VC4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAP_M0_VC4 CAP_M0_VC4
 *  @ingroup LTC3351_register_map
 *  @brief CAP_M0_VC4 Bit Field
 *
 *  The voltage change on cap4 due to the capacitance measurement. The relative voltage change on each capacitor during the capacitance measurement and the total capacitance can be used to calculate the capacitance of each individual capacitor.
 *   - Register: @ref LTC3351_CAP_M0_VC4_REG "CAP_M0_VC4_REG"
 *   - CommandCode: 55
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CAP_M0_VC4_SUBADDR LTC3351_CAP_M0_VC4_REG_SUBADDR //!< @ref LTC3351_CAP_M0_VC4 "CAP_M0_VC4"
#define LTC3351_CAP_M0_VC4_SIZE 16u
#define LTC3351_CAP_M0_VC4_OFFSET 0u
#define LTC3351_CAP_M0_VC4_MASK 0xFFFFu
#define LTC3351_CAP_M0_VC4_DEFAULT n/au
#define LTC3351_CAP_M0_VC4_DECODE(register_data) (register_data)
#define LTC3351_CAP_M0_VC4 (LTC3351_CAP_M0_VC4_OFFSET << 12 | (LTC3351_CAP_M0_VC4_SIZE - 1) << 8 | LTC3351_CAP_M0_VC4_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M0_VC1_REG ESR_M0_VC1_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M0_VC1 |
 *
 *   - CommandCode: 56
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M0_VC1 "ESR_M0_VC1" : A measurement of VCAP1 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M0_VC1_REG_SUBADDR 56u
#define LTC3351_ESR_M0_VC1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M0_VC1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M0_VC1 ESR_M0_VC1
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC1 Bit Field
 *
 *  A measurement of VCAP1 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M0_VC1_REG "ESR_M0_VC1_REG"
 *   - CommandCode: 56
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M0_VC1_SUBADDR LTC3351_ESR_M0_VC1_REG_SUBADDR //!< @ref LTC3351_ESR_M0_VC1 "ESR_M0_VC1"
#define LTC3351_ESR_M0_VC1_SIZE 16u
#define LTC3351_ESR_M0_VC1_OFFSET 0u
#define LTC3351_ESR_M0_VC1_MASK 0xFFFFu
#define LTC3351_ESR_M0_VC1_DEFAULT n/au
#define LTC3351_ESR_M0_VC1_DECODE(register_data) (register_data)
#define LTC3351_ESR_M0_VC1 (LTC3351_ESR_M0_VC1_OFFSET << 12 | (LTC3351_ESR_M0_VC1_SIZE - 1) << 8 | LTC3351_ESR_M0_VC1_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M0_VC2_REG ESR_M0_VC2_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M0_VC2 |
 *
 *   - CommandCode: 57
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M0_VC2 "ESR_M0_VC2" : A measurement of VCAP2 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M0_VC2_REG_SUBADDR 57u
#define LTC3351_ESR_M0_VC2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M0_VC2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M0_VC2 ESR_M0_VC2
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC2 Bit Field
 *
 *  A measurement of VCAP2 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M0_VC2_REG "ESR_M0_VC2_REG"
 *   - CommandCode: 57
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M0_VC2_SUBADDR LTC3351_ESR_M0_VC2_REG_SUBADDR //!< @ref LTC3351_ESR_M0_VC2 "ESR_M0_VC2"
#define LTC3351_ESR_M0_VC2_SIZE 16u
#define LTC3351_ESR_M0_VC2_OFFSET 0u
#define LTC3351_ESR_M0_VC2_MASK 0xFFFFu
#define LTC3351_ESR_M0_VC2_DEFAULT n/au
#define LTC3351_ESR_M0_VC2_DECODE(register_data) (register_data)
#define LTC3351_ESR_M0_VC2 (LTC3351_ESR_M0_VC2_OFFSET << 12 | (LTC3351_ESR_M0_VC2_SIZE - 1) << 8 | LTC3351_ESR_M0_VC2_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M0_VC3_REG ESR_M0_VC3_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M0_VC3 |
 *
 *   - CommandCode: 58
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M0_VC3 "ESR_M0_VC3" : A measurement of VCAP3 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M0_VC3_REG_SUBADDR 58u
#define LTC3351_ESR_M0_VC3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M0_VC3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M0_VC3 ESR_M0_VC3
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC3 Bit Field
 *
 *  A measurement of VCAP3 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M0_VC3_REG "ESR_M0_VC3_REG"
 *   - CommandCode: 58
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M0_VC3_SUBADDR LTC3351_ESR_M0_VC3_REG_SUBADDR //!< @ref LTC3351_ESR_M0_VC3 "ESR_M0_VC3"
#define LTC3351_ESR_M0_VC3_SIZE 16u
#define LTC3351_ESR_M0_VC3_OFFSET 0u
#define LTC3351_ESR_M0_VC3_MASK 0xFFFFu
#define LTC3351_ESR_M0_VC3_DEFAULT n/au
#define LTC3351_ESR_M0_VC3_DECODE(register_data) (register_data)
#define LTC3351_ESR_M0_VC3 (LTC3351_ESR_M0_VC3_OFFSET << 12 | (LTC3351_ESR_M0_VC3_SIZE - 1) << 8 | LTC3351_ESR_M0_VC3_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M0_VC4_REG ESR_M0_VC4_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M0_VC4 |
 *
 *   - CommandCode: 59
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M0_VC4 "ESR_M0_VC4" : A measurement of VCAP4 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M0_VC4_REG_SUBADDR 59u
#define LTC3351_ESR_M0_VC4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M0_VC4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M0_VC4 ESR_M0_VC4
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M0_VC4 Bit Field
 *
 *  A measurement of VCAP4 just before turning current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M0_VC4_REG "ESR_M0_VC4_REG"
 *   - CommandCode: 59
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M0_VC4_SUBADDR LTC3351_ESR_M0_VC4_REG_SUBADDR //!< @ref LTC3351_ESR_M0_VC4 "ESR_M0_VC4"
#define LTC3351_ESR_M0_VC4_SIZE 16u
#define LTC3351_ESR_M0_VC4_OFFSET 0u
#define LTC3351_ESR_M0_VC4_MASK 0xFFFFu
#define LTC3351_ESR_M0_VC4_DEFAULT n/au
#define LTC3351_ESR_M0_VC4_DECODE(register_data) (register_data)
#define LTC3351_ESR_M0_VC4 (LTC3351_ESR_M0_VC4_OFFSET << 12 | (LTC3351_ESR_M0_VC4_SIZE - 1) << 8 | LTC3351_ESR_M0_VC4_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M1_VC1_REG ESR_M1_VC1_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M1_VC1 |
 *
 *   - CommandCode: 60
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M1_VC1 "ESR_M1_VC1" : The first VCAP1 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M1_VC1_REG_SUBADDR 60u
#define LTC3351_ESR_M1_VC1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M1_VC1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M1_VC1 ESR_M1_VC1
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC1 Bit Field
 *
 *  The first VCAP1 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M1_VC1_REG "ESR_M1_VC1_REG"
 *   - CommandCode: 60
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M1_VC1_SUBADDR LTC3351_ESR_M1_VC1_REG_SUBADDR //!< @ref LTC3351_ESR_M1_VC1 "ESR_M1_VC1"
#define LTC3351_ESR_M1_VC1_SIZE 16u
#define LTC3351_ESR_M1_VC1_OFFSET 0u
#define LTC3351_ESR_M1_VC1_MASK 0xFFFFu
#define LTC3351_ESR_M1_VC1_DEFAULT n/au
#define LTC3351_ESR_M1_VC1_DECODE(register_data) (register_data)
#define LTC3351_ESR_M1_VC1 (LTC3351_ESR_M1_VC1_OFFSET << 12 | (LTC3351_ESR_M1_VC1_SIZE - 1) << 8 | LTC3351_ESR_M1_VC1_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M1_VC2_REG ESR_M1_VC2_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M1_VC2 |
 *
 *   - CommandCode: 61
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M1_VC2 "ESR_M1_VC2" : The first VCAP2 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M1_VC2_REG_SUBADDR 61u
#define LTC3351_ESR_M1_VC2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M1_VC2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M1_VC2 ESR_M1_VC2
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC2 Bit Field
 *
 *  The first VCAP2 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M1_VC2_REG "ESR_M1_VC2_REG"
 *   - CommandCode: 61
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M1_VC2_SUBADDR LTC3351_ESR_M1_VC2_REG_SUBADDR //!< @ref LTC3351_ESR_M1_VC2 "ESR_M1_VC2"
#define LTC3351_ESR_M1_VC2_SIZE 16u
#define LTC3351_ESR_M1_VC2_OFFSET 0u
#define LTC3351_ESR_M1_VC2_MASK 0xFFFFu
#define LTC3351_ESR_M1_VC2_DEFAULT n/au
#define LTC3351_ESR_M1_VC2_DECODE(register_data) (register_data)
#define LTC3351_ESR_M1_VC2 (LTC3351_ESR_M1_VC2_OFFSET << 12 | (LTC3351_ESR_M1_VC2_SIZE - 1) << 8 | LTC3351_ESR_M1_VC2_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M1_VC3_REG ESR_M1_VC3_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M1_VC3 |
 *
 *   - CommandCode: 62
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M1_VC3 "ESR_M1_VC3" : The first VCAP3 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M1_VC3_REG_SUBADDR 62u
#define LTC3351_ESR_M1_VC3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M1_VC3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M1_VC3 ESR_M1_VC3
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC3 Bit Field
 *
 *  The first VCAP3 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M1_VC3_REG "ESR_M1_VC3_REG"
 *   - CommandCode: 62
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M1_VC3_SUBADDR LTC3351_ESR_M1_VC3_REG_SUBADDR //!< @ref LTC3351_ESR_M1_VC3 "ESR_M1_VC3"
#define LTC3351_ESR_M1_VC3_SIZE 16u
#define LTC3351_ESR_M1_VC3_OFFSET 0u
#define LTC3351_ESR_M1_VC3_MASK 0xFFFFu
#define LTC3351_ESR_M1_VC3_DEFAULT n/au
#define LTC3351_ESR_M1_VC3_DECODE(register_data) (register_data)
#define LTC3351_ESR_M1_VC3 (LTC3351_ESR_M1_VC3_OFFSET << 12 | (LTC3351_ESR_M1_VC3_SIZE - 1) << 8 | LTC3351_ESR_M1_VC3_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M1_VC4_REG ESR_M1_VC4_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M1_VC4 |
 *
 *   - CommandCode: 63
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M1_VC4 "ESR_M1_VC4" : The first VCAP4 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M1_VC4_REG_SUBADDR 63u
#define LTC3351_ESR_M1_VC4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M1_VC4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M1_VC4 ESR_M1_VC4
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_VC4 Bit Field
 *
 *  The first VCAP4 voltage measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M1_VC4_REG "ESR_M1_VC4_REG"
 *   - CommandCode: 63
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M1_VC4_SUBADDR LTC3351_ESR_M1_VC4_REG_SUBADDR //!< @ref LTC3351_ESR_M1_VC4 "ESR_M1_VC4"
#define LTC3351_ESR_M1_VC4_SIZE 16u
#define LTC3351_ESR_M1_VC4_OFFSET 0u
#define LTC3351_ESR_M1_VC4_MASK 0xFFFFu
#define LTC3351_ESR_M1_VC4_DEFAULT n/au
#define LTC3351_ESR_M1_VC4_DECODE(register_data) (register_data)
#define LTC3351_ESR_M1_VC4 (LTC3351_ESR_M1_VC4_OFFSET << 12 | (LTC3351_ESR_M1_VC4_SIZE - 1) << 8 | LTC3351_ESR_M1_VC4_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M1_I_REG ESR_M1_I_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_I_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | ESR_M1_I |
 *
 *   - CommandCode: 64
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M1_I "ESR_M1_I" : The first charge current measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M1_I_REG_SUBADDR 64u
#define LTC3351_ESR_M1_I_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M1_I_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M1_I ESR_M1_I
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M1_I Bit Field
 *
 *  The first charge current measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M1_I_REG "ESR_M1_I_REG"
 *   - CommandCode: 64
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M1_I_SUBADDR LTC3351_ESR_M1_I_REG_SUBADDR //!< @ref LTC3351_ESR_M1_I "ESR_M1_I"
#define LTC3351_ESR_M1_I_SIZE 16u
#define LTC3351_ESR_M1_I_OFFSET 0u
#define LTC3351_ESR_M1_I_MASK 0xFFFFu
#define LTC3351_ESR_M1_I_DEFAULT n/au
#define LTC3351_ESR_M1_I_DECODE(register_data) (register_data)
#define LTC3351_ESR_M1_I (LTC3351_ESR_M1_I_OFFSET << 12 | (LTC3351_ESR_M1_I_SIZE - 1) << 8 | LTC3351_ESR_M1_I_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M2_VC1_REG ESR_M2_VC1_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M2_VC1 |
 *
 *   - CommandCode: 65
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M2_VC1 "ESR_M2_VC1" : The second VCAP1 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M2_VC1_REG_SUBADDR 65u
#define LTC3351_ESR_M2_VC1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M2_VC1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M2_VC1 ESR_M2_VC1
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC1 Bit Field
 *
 *  The second VCAP1 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M2_VC1_REG "ESR_M2_VC1_REG"
 *   - CommandCode: 65
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M2_VC1_SUBADDR LTC3351_ESR_M2_VC1_REG_SUBADDR //!< @ref LTC3351_ESR_M2_VC1 "ESR_M2_VC1"
#define LTC3351_ESR_M2_VC1_SIZE 16u
#define LTC3351_ESR_M2_VC1_OFFSET 0u
#define LTC3351_ESR_M2_VC1_MASK 0xFFFFu
#define LTC3351_ESR_M2_VC1_DEFAULT n/au
#define LTC3351_ESR_M2_VC1_DECODE(register_data) (register_data)
#define LTC3351_ESR_M2_VC1 (LTC3351_ESR_M2_VC1_OFFSET << 12 | (LTC3351_ESR_M2_VC1_SIZE - 1) << 8 | LTC3351_ESR_M2_VC1_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M2_VC2_REG ESR_M2_VC2_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M2_VC2 |
 *
 *   - CommandCode: 66
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M2_VC2 "ESR_M2_VC2" : The second VCAP2 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M2_VC2_REG_SUBADDR 66u
#define LTC3351_ESR_M2_VC2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M2_VC2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M2_VC2 ESR_M2_VC2
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC2 Bit Field
 *
 *  The second VCAP2 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M2_VC2_REG "ESR_M2_VC2_REG"
 *   - CommandCode: 66
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M2_VC2_SUBADDR LTC3351_ESR_M2_VC2_REG_SUBADDR //!< @ref LTC3351_ESR_M2_VC2 "ESR_M2_VC2"
#define LTC3351_ESR_M2_VC2_SIZE 16u
#define LTC3351_ESR_M2_VC2_OFFSET 0u
#define LTC3351_ESR_M2_VC2_MASK 0xFFFFu
#define LTC3351_ESR_M2_VC2_DEFAULT n/au
#define LTC3351_ESR_M2_VC2_DECODE(register_data) (register_data)
#define LTC3351_ESR_M2_VC2 (LTC3351_ESR_M2_VC2_OFFSET << 12 | (LTC3351_ESR_M2_VC2_SIZE - 1) << 8 | LTC3351_ESR_M2_VC2_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M2_VC3_REG ESR_M2_VC3_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M2_VC3 |
 *
 *   - CommandCode: 67
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M2_VC3 "ESR_M2_VC3" : The second VCAP3 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M2_VC3_REG_SUBADDR 67u
#define LTC3351_ESR_M2_VC3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M2_VC3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M2_VC3 ESR_M2_VC3
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC3 Bit Field
 *
 *  The second VCAP3 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M2_VC3_REG "ESR_M2_VC3_REG"
 *   - CommandCode: 67
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M2_VC3_SUBADDR LTC3351_ESR_M2_VC3_REG_SUBADDR //!< @ref LTC3351_ESR_M2_VC3 "ESR_M2_VC3"
#define LTC3351_ESR_M2_VC3_SIZE 16u
#define LTC3351_ESR_M2_VC3_OFFSET 0u
#define LTC3351_ESR_M2_VC3_MASK 0xFFFFu
#define LTC3351_ESR_M2_VC3_DEFAULT n/au
#define LTC3351_ESR_M2_VC3_DECODE(register_data) (register_data)
#define LTC3351_ESR_M2_VC3 (LTC3351_ESR_M2_VC3_OFFSET << 12 | (LTC3351_ESR_M2_VC3_SIZE - 1) << 8 | LTC3351_ESR_M2_VC3_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M2_VC4_REG ESR_M2_VC4_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M2_VC4 |
 *
 *   - CommandCode: 68
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M2_VC4 "ESR_M2_VC4" : The second VCAP4 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M2_VC4_REG_SUBADDR 68u
#define LTC3351_ESR_M2_VC4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M2_VC4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M2_VC4 ESR_M2_VC4
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_VC4 Bit Field
 *
 *  The second VCAP4 voltage measurement with the charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M2_VC4_REG "ESR_M2_VC4_REG"
 *   - CommandCode: 68
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M2_VC4_SUBADDR LTC3351_ESR_M2_VC4_REG_SUBADDR //!< @ref LTC3351_ESR_M2_VC4 "ESR_M2_VC4"
#define LTC3351_ESR_M2_VC4_SIZE 16u
#define LTC3351_ESR_M2_VC4_OFFSET 0u
#define LTC3351_ESR_M2_VC4_MASK 0xFFFFu
#define LTC3351_ESR_M2_VC4_DEFAULT n/au
#define LTC3351_ESR_M2_VC4_DECODE(register_data) (register_data)
#define LTC3351_ESR_M2_VC4 (LTC3351_ESR_M2_VC4_OFFSET << 12 | (LTC3351_ESR_M2_VC4_SIZE - 1) << 8 | LTC3351_ESR_M2_VC4_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M2_I_REG ESR_M2_I_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_I_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | ESR_M2_I |
 *
 *   - CommandCode: 69
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M2_I "ESR_M2_I" : The second charge current measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M2_I_REG_SUBADDR 69u
#define LTC3351_ESR_M2_I_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M2_I_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M2_I ESR_M2_I
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M2_I Bit Field
 *
 *  The second charge current measurement with charge current on for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M2_I_REG "ESR_M2_I_REG"
 *   - CommandCode: 69
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M2_I_SUBADDR LTC3351_ESR_M2_I_REG_SUBADDR //!< @ref LTC3351_ESR_M2_I "ESR_M2_I"
#define LTC3351_ESR_M2_I_SIZE 16u
#define LTC3351_ESR_M2_I_OFFSET 0u
#define LTC3351_ESR_M2_I_MASK 0xFFFFu
#define LTC3351_ESR_M2_I_DEFAULT n/au
#define LTC3351_ESR_M2_I_DECODE(register_data) (register_data)
#define LTC3351_ESR_M2_I (LTC3351_ESR_M2_I_OFFSET << 12 | (LTC3351_ESR_M2_I_SIZE - 1) << 8 | LTC3351_ESR_M2_I_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M3_VC1_REG ESR_M3_VC1_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC1_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M3_VC1 |
 *
 *   - CommandCode: 70
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M3_VC1 "ESR_M3_VC1" : The VCAP1 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M3_VC1_REG_SUBADDR 70u
#define LTC3351_ESR_M3_VC1_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M3_VC1_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M3_VC1 ESR_M3_VC1
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC1 Bit Field
 *
 *  The VCAP1 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M3_VC1_REG "ESR_M3_VC1_REG"
 *   - CommandCode: 70
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M3_VC1_SUBADDR LTC3351_ESR_M3_VC1_REG_SUBADDR //!< @ref LTC3351_ESR_M3_VC1 "ESR_M3_VC1"
#define LTC3351_ESR_M3_VC1_SIZE 16u
#define LTC3351_ESR_M3_VC1_OFFSET 0u
#define LTC3351_ESR_M3_VC1_MASK 0xFFFFu
#define LTC3351_ESR_M3_VC1_DEFAULT n/au
#define LTC3351_ESR_M3_VC1_DECODE(register_data) (register_data)
#define LTC3351_ESR_M3_VC1 (LTC3351_ESR_M3_VC1_OFFSET << 12 | (LTC3351_ESR_M3_VC1_SIZE - 1) << 8 | LTC3351_ESR_M3_VC1_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M3_VC2_REG ESR_M3_VC2_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC2_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M3_VC2 |
 *
 *   - CommandCode: 71
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M3_VC2 "ESR_M3_VC2" : The VCAP2 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M3_VC2_REG_SUBADDR 71u
#define LTC3351_ESR_M3_VC2_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M3_VC2_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M3_VC2 ESR_M3_VC2
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC2 Bit Field
 *
 *  The VCAP2 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M3_VC2_REG "ESR_M3_VC2_REG"
 *   - CommandCode: 71
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M3_VC2_SUBADDR LTC3351_ESR_M3_VC2_REG_SUBADDR //!< @ref LTC3351_ESR_M3_VC2 "ESR_M3_VC2"
#define LTC3351_ESR_M3_VC2_SIZE 16u
#define LTC3351_ESR_M3_VC2_OFFSET 0u
#define LTC3351_ESR_M3_VC2_MASK 0xFFFFu
#define LTC3351_ESR_M3_VC2_DEFAULT n/au
#define LTC3351_ESR_M3_VC2_DECODE(register_data) (register_data)
#define LTC3351_ESR_M3_VC2 (LTC3351_ESR_M3_VC2_OFFSET << 12 | (LTC3351_ESR_M3_VC2_SIZE - 1) << 8 | LTC3351_ESR_M3_VC2_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M3_VC3_REG ESR_M3_VC3_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC3_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M3_VC3 |
 *
 *   - CommandCode: 72
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M3_VC3 "ESR_M3_VC3" : The VCAP3 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M3_VC3_REG_SUBADDR 72u
#define LTC3351_ESR_M3_VC3_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M3_VC3_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M3_VC3 ESR_M3_VC3
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC3 Bit Field
 *
 *  The VCAP3 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M3_VC3_REG "ESR_M3_VC3_REG"
 *   - CommandCode: 72
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M3_VC3_SUBADDR LTC3351_ESR_M3_VC3_REG_SUBADDR //!< @ref LTC3351_ESR_M3_VC3 "ESR_M3_VC3"
#define LTC3351_ESR_M3_VC3_SIZE 16u
#define LTC3351_ESR_M3_VC3_OFFSET 0u
#define LTC3351_ESR_M3_VC3_MASK 0xFFFFu
#define LTC3351_ESR_M3_VC3_DEFAULT n/au
#define LTC3351_ESR_M3_VC3_DECODE(register_data) (register_data)
#define LTC3351_ESR_M3_VC3 (LTC3351_ESR_M3_VC3_OFFSET << 12 | (LTC3351_ESR_M3_VC3_SIZE - 1) << 8 | LTC3351_ESR_M3_VC3_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M3_VC4_REG ESR_M3_VC4_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC4_REG Register
 *
 * |       15:0 |
 * |:----------:|
 * | ESR_M3_VC4 |
 *
 *   - CommandCode: 73
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M3_VC4 "ESR_M3_VC4" : The VCAP4 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M3_VC4_REG_SUBADDR 73u
#define LTC3351_ESR_M3_VC4_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M3_VC4_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M3_VC4 ESR_M3_VC4
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_VC4 Bit Field
 *
 *  The VCAP4 voltage measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M3_VC4_REG "ESR_M3_VC4_REG"
 *   - CommandCode: 73
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M3_VC4_SUBADDR LTC3351_ESR_M3_VC4_REG_SUBADDR //!< @ref LTC3351_ESR_M3_VC4 "ESR_M3_VC4"
#define LTC3351_ESR_M3_VC4_SIZE 16u
#define LTC3351_ESR_M3_VC4_OFFSET 0u
#define LTC3351_ESR_M3_VC4_MASK 0xFFFFu
#define LTC3351_ESR_M3_VC4_DEFAULT n/au
#define LTC3351_ESR_M3_VC4_DECODE(register_data) (register_data)
#define LTC3351_ESR_M3_VC4 (LTC3351_ESR_M3_VC4_OFFSET << 12 | (LTC3351_ESR_M3_VC4_SIZE - 1) << 8 | LTC3351_ESR_M3_VC4_SUBADDR)
//!@}

/*! @defgroup LTC3351_ESR_M3_I_REG ESR_M3_I_REG
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_I_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | ESR_M3_I |
 *
 *   - CommandCode: 74
 *   - Contains Bit Fields:
 *     + @ref LTC3351_ESR_M3_I "ESR_M3_I" : The charge current measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
*/

//!@{
#define LTC3351_ESR_M3_I_REG_SUBADDR 74u
#define LTC3351_ESR_M3_I_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_ESR_M3_I_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_ESR_M3_I ESR_M3_I
 *  @ingroup LTC3351_register_map
 *  @brief ESR_M3_I Bit Field
 *
 *  The charge current measurement with charge current off for the ESR measurement. This value is used by the LTC3351 in the calculation of meas_esr.
 *   - Register: @ref LTC3351_ESR_M3_I_REG "ESR_M3_I_REG"
 *   - CommandCode: 74
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_ESR_M3_I_SUBADDR LTC3351_ESR_M3_I_REG_SUBADDR //!< @ref LTC3351_ESR_M3_I "ESR_M3_I"
#define LTC3351_ESR_M3_I_SIZE 16u
#define LTC3351_ESR_M3_I_OFFSET 0u
#define LTC3351_ESR_M3_I_MASK 0xFFFFu
#define LTC3351_ESR_M3_I_DEFAULT n/au
#define LTC3351_ESR_M3_I_DECODE(register_data) (register_data)
#define LTC3351_ESR_M3_I (LTC3351_ESR_M3_I_OFFSET << 12 | (LTC3351_ESR_M3_I_SIZE - 1) << 8 | LTC3351_ESR_M3_I_SUBADDR)
//!@}

/*! @defgroup LTC3351_REV_REG REV_REG
 *  @ingroup LTC3351_register_map
 *  @brief REV_REG Register
 *
 * |     15:0 |
 * |:--------:|
 * | REV_CODE |
 *
 *   - CommandCode: 80
 *   - Contains Bit Fields:
 *     + @ref LTC3351_REV_CODE "REV_CODE" : The LTC3351 revision code.
*/

//!@{
#define LTC3351_REV_REG_SUBADDR 80u
#define LTC3351_REV_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_REV_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_REV_CODE REV_CODE
 *  @ingroup LTC3351_register_map
 *  @brief REV_CODE Bit Field
 *
 *  The LTC3351 revision code.
 *   - Register: @ref LTC3351_REV_REG "REV_REG"
 *   - CommandCode: 80
 *   - Size: 16
 *   - Offset: 0
 *   - MSB: 15
 *   - MASK: 0xFFFF
 *   - Access: R
 *   - Default: 5
 */
//!@{
#define LTC3351_REV_CODE_SUBADDR LTC3351_REV_REG_SUBADDR //!< @ref LTC3351_REV_CODE "REV_CODE"
#define LTC3351_REV_CODE_SIZE 16u
#define LTC3351_REV_CODE_OFFSET 0u
#define LTC3351_REV_CODE_MASK 0xFFFFu
#define LTC3351_REV_CODE_DEFAULT 5u
#define LTC3351_REV_CODE_DECODE(register_data) (register_data)
#define LTC3351_REV_CODE (LTC3351_REV_CODE_OFFSET << 12 | (LTC3351_REV_CODE_SIZE - 1) << 8 | LTC3351_REV_CODE_SUBADDR)
//!@}

/*! @defgroup LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT NEXT_ICHRG_CONTROL_TEST_CURRENT
 *  @ingroup LTC3351_register_map
 *  @brief NEXT_ICHRG_CONTROL_TEST_CURRENT Register
 *
 * | 15:8 |        7:0 |
 * |:----:|:----------:|
 * |  n/a | NEXT_ESR_I |
 *
 *   - CommandCode: 84
 *   - Contains Bit Fields:
 *     + @ref LTC3351_NEXT_ESR_I "NEXT_ESR_I" : The 8 bit DAC setting for the charge current that the LTC3351 has calculated for the next ESR measurement based on the previous ESR measurement. The first ESR measurement will use a setting of 32. If esr_i_override is non-zero, this register will be calculated but esr_i_override will be used instead. If non-zero ITEST = 32mV * (next_esr_i[7:0] + 1) / 256 / Rsnsc
*/

//!@{
#define LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT_SUBADDR 84u
#define LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT_SUBADDR)
//!@}
/*! @defgroup LTC3351_NEXT_ESR_I NEXT_ESR_I
 *  @ingroup LTC3351_register_map
 *  @brief NEXT_ESR_I Bit Field
 *
 *  The 8 bit DAC setting for the charge current that the LTC3351 has calculated for the next ESR measurement based on the previous ESR measurement. The first ESR measurement will use a setting of 32. If esr_i_override is non-zero, this register will be calculated but esr_i_override will be used instead. If non-zero ITEST = 32mV * (next_esr_i[7:0] + 1) / 256 / Rsnsc
 *   - Register: @ref LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT "NEXT_ICHRG_CONTROL_TEST_CURRENT"
 *   - CommandCode: 84
 *   - Size: 8
 *   - Offset: 0
 *   - MSB: 7
 *   - MASK: 0x00FF
 *   - Access: R
 *   - Default: 32
 */
//!@{
#define LTC3351_NEXT_ESR_I_SUBADDR LTC3351_NEXT_ICHRG_CONTROL_TEST_CURRENT_SUBADDR //!< @ref LTC3351_NEXT_ESR_I "NEXT_ESR_I"
#define LTC3351_NEXT_ESR_I_SIZE 8u
#define LTC3351_NEXT_ESR_I_OFFSET 0u
#define LTC3351_NEXT_ESR_I_MASK 0x00FFu
#define LTC3351_NEXT_ESR_I_DEFAULT 32u
#define LTC3351_NEXT_ESR_I_DECODE(register_data) (((register_data) & LTC3351_NEXT_ESR_I_MASK) >> LTC3351_NEXT_ESR_I_OFFSET)
#define LTC3351_NEXT_ESR_I (LTC3351_NEXT_ESR_I_OFFSET << 12 | (LTC3351_NEXT_ESR_I_SIZE - 1) << 8 | LTC3351_NEXT_ESR_I_SUBADDR)
//!@}

/*! @defgroup LTC3351_NUM_CAPS_REG NUM_CAPS_REG
 *  @ingroup LTC3351_register_map
 *  @brief NUM_CAPS_REG Register
 *
 * | 15:2 |      1:0 |
 * |:----:|:--------:|
 * |  n/a | NUM_CAPS |
 *
 *   - CommandCode: 237
 *   - Contains Bit Fields:
 *     + @ref LTC3351_NUM_CAPS "NUM_CAPS" : Number of Capacitors. This register shows the state of the CAP_SLCT1, CAP_SLCT0 pins. The value read in this register is the number of capacitors programmed minus one.
*/

//!@{
#define LTC3351_NUM_CAPS_REG_SUBADDR 237u
#define LTC3351_NUM_CAPS_REG (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_NUM_CAPS_REG_SUBADDR)
//!@}
/*! @defgroup LTC3351_NUM_CAPS NUM_CAPS
 *  @ingroup LTC3351_register_map
 *  @brief NUM_CAPS Bit Field
 *
 *  Number of Capacitors. This register shows the state of the CAP_SLCT1, CAP_SLCT0 pins. The value read in this register is the number of capacitors programmed minus one.
 *   - Register: @ref LTC3351_NUM_CAPS_REG "NUM_CAPS_REG"
 *   - CommandCode: 237
 *   - Size: 2
 *   - Offset: 0
 *   - MSB: 1
 *   - MASK: 0x0003
 *   - Access: R
 *   - Default: 0
 */
//!@{
#define LTC3351_NUM_CAPS_SUBADDR LTC3351_NUM_CAPS_REG_SUBADDR //!< @ref LTC3351_NUM_CAPS "NUM_CAPS"
#define LTC3351_NUM_CAPS_SIZE 2u
#define LTC3351_NUM_CAPS_OFFSET 0u
#define LTC3351_NUM_CAPS_MASK 0x0003u
#define LTC3351_NUM_CAPS_DEFAULT 0u
#define LTC3351_NUM_CAPS_DECODE(register_data) (((register_data) & LTC3351_NUM_CAPS_MASK) >> LTC3351_NUM_CAPS_OFFSET)
#define LTC3351_NUM_CAPS (LTC3351_NUM_CAPS_OFFSET << 12 | (LTC3351_NUM_CAPS_SIZE - 1) << 8 | LTC3351_NUM_CAPS_SUBADDR)
//!@}

/*! @defgroup LTC3351_SYS_STATUS SYS_STATUS
 *  @ingroup LTC3351_register_map
 *  @brief SYS_STATUS Register
 *
 * | 15:12 |    11 |  10 |       9 |       8 |        7 |   6 |     5 |               4 |         3 |       2 |           1 |             0 |
 * |:-----:|:-----:|:---:|:-------:|:-------:|:--------:|:---:|:-----:|:---------------:|:---------:|:-------:|:-----------:|:-------------:|
 * |   n/a | VINGD | n/a | CHRG_CI | BUCK_EN | BOOST_EN | n/a | CAPPG | CHRG_INPUT_ILIM | CHRG_UVLO | CHRG_CV | STEPUP_MODE | STEPDOWN_MODE |
 *
 * System Status Register: This register provides real time status information about the instantaneous state of the system. Each bit is active high. 
 *   - CommandCode: 238
 *   - Contains Bit Fields:
 *     + @ref LTC3351_STEPDOWN_MODE "STEPDOWN_MODE" : The synchronous controller is in step-down mode (charging)
 *     + @ref LTC3351_STEPUP_MODE "STEPUP_MODE" : The synchronous controller is in step-up mode (backup)
 *     + @ref LTC3351_CHRG_CV "CHRG_CV" : The charger is in constant voltage mode
 *     + @ref LTC3351_CHRG_UVLO "CHRG_UVLO" : The charger is in under-voltage lockout or has been disabled by ctl_force_charger_off.
 *     + @ref LTC3351_CHRG_INPUT_ILIM "CHRG_INPUT_ILIM" : The charger is in input current limit
 *     + @ref LTC3351_CAPPG "CAPPG" : The capacitor voltage is above power good threshold
 *     + @ref LTC3351_BOOST_EN "BOOST_EN" : Indicates the boost is enabled
 *     + @ref LTC3351_BUCK_EN "BUCK_EN" : Indicates the charger is enabled
 *     + @ref LTC3351_CHRG_CI "CHRG_CI" : Indicates the charger is in constant current mode
 *     + @ref LTC3351_VINGD "VINGD" : Indicates the input voltage is inside the UV/OV range.
*/

//!@{
#define LTC3351_SYS_STATUS_SUBADDR 238u
#define LTC3351_SYS_STATUS (0u << 12 | (LTC3351_WORD_SIZE - 1) << 8 | LTC3351_SYS_STATUS_SUBADDR)
//!@}
/*! @defgroup LTC3351_STEPDOWN_MODE STEPDOWN_MODE
 *  @ingroup LTC3351_register_map
 *  @brief STEPDOWN_MODE Bit Field
 *
 *  The synchronous controller is in step-down mode (charging)
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 0
 *   - MSB: 0
 *   - MASK: 0x0001
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_STEPDOWN_MODE_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_STEPDOWN_MODE "STEPDOWN_MODE"
#define LTC3351_STEPDOWN_MODE_SIZE 1u
#define LTC3351_STEPDOWN_MODE_OFFSET 0u
#define LTC3351_STEPDOWN_MODE_MASK 0x0001u
#define LTC3351_STEPDOWN_MODE_DEFAULT n/au
#define LTC3351_STEPDOWN_MODE_DECODE(register_data) (((register_data) & LTC3351_STEPDOWN_MODE_MASK) >> LTC3351_STEPDOWN_MODE_OFFSET)
#define LTC3351_STEPDOWN_MODE (LTC3351_STEPDOWN_MODE_OFFSET << 12 | (LTC3351_STEPDOWN_MODE_SIZE - 1) << 8 | LTC3351_STEPDOWN_MODE_SUBADDR)
//!@}
/*! @defgroup LTC3351_STEPUP_MODE STEPUP_MODE
 *  @ingroup LTC3351_register_map
 *  @brief STEPUP_MODE Bit Field
 *
 *  The synchronous controller is in step-up mode (backup)
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 1
 *   - MSB: 1
 *   - MASK: 0x0002
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_STEPUP_MODE_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_STEPUP_MODE "STEPUP_MODE"
#define LTC3351_STEPUP_MODE_SIZE 1u
#define LTC3351_STEPUP_MODE_OFFSET 1u
#define LTC3351_STEPUP_MODE_MASK 0x0002u
#define LTC3351_STEPUP_MODE_DEFAULT n/au
#define LTC3351_STEPUP_MODE_DECODE(register_data) (((register_data) & LTC3351_STEPUP_MODE_MASK) >> LTC3351_STEPUP_MODE_OFFSET)
#define LTC3351_STEPUP_MODE (LTC3351_STEPUP_MODE_OFFSET << 12 | (LTC3351_STEPUP_MODE_SIZE - 1) << 8 | LTC3351_STEPUP_MODE_SUBADDR)
//!@}
/*! @defgroup LTC3351_CHRG_CV CHRG_CV
 *  @ingroup LTC3351_register_map
 *  @brief CHRG_CV Bit Field
 *
 *  The charger is in constant voltage mode
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 2
 *   - MSB: 2
 *   - MASK: 0x0004
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CHRG_CV_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_CHRG_CV "CHRG_CV"
#define LTC3351_CHRG_CV_SIZE 1u
#define LTC3351_CHRG_CV_OFFSET 2u
#define LTC3351_CHRG_CV_MASK 0x0004u
#define LTC3351_CHRG_CV_DEFAULT n/au
#define LTC3351_CHRG_CV_DECODE(register_data) (((register_data) & LTC3351_CHRG_CV_MASK) >> LTC3351_CHRG_CV_OFFSET)
#define LTC3351_CHRG_CV (LTC3351_CHRG_CV_OFFSET << 12 | (LTC3351_CHRG_CV_SIZE - 1) << 8 | LTC3351_CHRG_CV_SUBADDR)
//!@}
/*! @defgroup LTC3351_CHRG_UVLO CHRG_UVLO
 *  @ingroup LTC3351_register_map
 *  @brief CHRG_UVLO Bit Field
 *
 *  The charger is in under-voltage lockout or has been disabled by ctl_force_charger_off.
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 3
 *   - MSB: 3
 *   - MASK: 0x0008
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CHRG_UVLO_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_CHRG_UVLO "CHRG_UVLO"
#define LTC3351_CHRG_UVLO_SIZE 1u
#define LTC3351_CHRG_UVLO_OFFSET 3u
#define LTC3351_CHRG_UVLO_MASK 0x0008u
#define LTC3351_CHRG_UVLO_DEFAULT n/au
#define LTC3351_CHRG_UVLO_DECODE(register_data) (((register_data) & LTC3351_CHRG_UVLO_MASK) >> LTC3351_CHRG_UVLO_OFFSET)
#define LTC3351_CHRG_UVLO (LTC3351_CHRG_UVLO_OFFSET << 12 | (LTC3351_CHRG_UVLO_SIZE - 1) << 8 | LTC3351_CHRG_UVLO_SUBADDR)
//!@}
/*! @defgroup LTC3351_CHRG_INPUT_ILIM CHRG_INPUT_ILIM
 *  @ingroup LTC3351_register_map
 *  @brief CHRG_INPUT_ILIM Bit Field
 *
 *  The charger is in input current limit
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 4
 *   - MSB: 4
 *   - MASK: 0x0010
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CHRG_INPUT_ILIM_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_CHRG_INPUT_ILIM "CHRG_INPUT_ILIM"
#define LTC3351_CHRG_INPUT_ILIM_SIZE 1u
#define LTC3351_CHRG_INPUT_ILIM_OFFSET 4u
#define LTC3351_CHRG_INPUT_ILIM_MASK 0x0010u
#define LTC3351_CHRG_INPUT_ILIM_DEFAULT n/au
#define LTC3351_CHRG_INPUT_ILIM_DECODE(register_data) (((register_data) & LTC3351_CHRG_INPUT_ILIM_MASK) >> LTC3351_CHRG_INPUT_ILIM_OFFSET)
#define LTC3351_CHRG_INPUT_ILIM (LTC3351_CHRG_INPUT_ILIM_OFFSET << 12 | (LTC3351_CHRG_INPUT_ILIM_SIZE - 1) << 8 | LTC3351_CHRG_INPUT_ILIM_SUBADDR)
//!@}
/*! @defgroup LTC3351_CAPPG CAPPG
 *  @ingroup LTC3351_register_map
 *  @brief CAPPG Bit Field
 *
 *  The capacitor voltage is above power good threshold
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 5
 *   - MSB: 5
 *   - MASK: 0x0020
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CAPPG_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_CAPPG "CAPPG"
#define LTC3351_CAPPG_SIZE 1u
#define LTC3351_CAPPG_OFFSET 5u
#define LTC3351_CAPPG_MASK 0x0020u
#define LTC3351_CAPPG_DEFAULT n/au
#define LTC3351_CAPPG_DECODE(register_data) (((register_data) & LTC3351_CAPPG_MASK) >> LTC3351_CAPPG_OFFSET)
#define LTC3351_CAPPG (LTC3351_CAPPG_OFFSET << 12 | (LTC3351_CAPPG_SIZE - 1) << 8 | LTC3351_CAPPG_SUBADDR)
//!@}
/*! @defgroup LTC3351_BOOST_EN BOOST_EN
 *  @ingroup LTC3351_register_map
 *  @brief BOOST_EN Bit Field
 *
 *  Indicates the boost is enabled
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 7
 *   - MSB: 7
 *   - MASK: 0x0080
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_BOOST_EN_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_BOOST_EN "BOOST_EN"
#define LTC3351_BOOST_EN_SIZE 1u
#define LTC3351_BOOST_EN_OFFSET 7u
#define LTC3351_BOOST_EN_MASK 0x0080u
#define LTC3351_BOOST_EN_DEFAULT n/au
#define LTC3351_BOOST_EN_DECODE(register_data) (((register_data) & LTC3351_BOOST_EN_MASK) >> LTC3351_BOOST_EN_OFFSET)
#define LTC3351_BOOST_EN (LTC3351_BOOST_EN_OFFSET << 12 | (LTC3351_BOOST_EN_SIZE - 1) << 8 | LTC3351_BOOST_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_BUCK_EN BUCK_EN
 *  @ingroup LTC3351_register_map
 *  @brief BUCK_EN Bit Field
 *
 *  Indicates the charger is enabled
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 8
 *   - MSB: 8
 *   - MASK: 0x0100
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_BUCK_EN_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_BUCK_EN "BUCK_EN"
#define LTC3351_BUCK_EN_SIZE 1u
#define LTC3351_BUCK_EN_OFFSET 8u
#define LTC3351_BUCK_EN_MASK 0x0100u
#define LTC3351_BUCK_EN_DEFAULT n/au
#define LTC3351_BUCK_EN_DECODE(register_data) (((register_data) & LTC3351_BUCK_EN_MASK) >> LTC3351_BUCK_EN_OFFSET)
#define LTC3351_BUCK_EN (LTC3351_BUCK_EN_OFFSET << 12 | (LTC3351_BUCK_EN_SIZE - 1) << 8 | LTC3351_BUCK_EN_SUBADDR)
//!@}
/*! @defgroup LTC3351_CHRG_CI CHRG_CI
 *  @ingroup LTC3351_register_map
 *  @brief CHRG_CI Bit Field
 *
 *  Indicates the charger is in constant current mode
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 9
 *   - MSB: 9
 *   - MASK: 0x0200
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_CHRG_CI_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_CHRG_CI "CHRG_CI"
#define LTC3351_CHRG_CI_SIZE 1u
#define LTC3351_CHRG_CI_OFFSET 9u
#define LTC3351_CHRG_CI_MASK 0x0200u
#define LTC3351_CHRG_CI_DEFAULT n/au
#define LTC3351_CHRG_CI_DECODE(register_data) (((register_data) & LTC3351_CHRG_CI_MASK) >> LTC3351_CHRG_CI_OFFSET)
#define LTC3351_CHRG_CI (LTC3351_CHRG_CI_OFFSET << 12 | (LTC3351_CHRG_CI_SIZE - 1) << 8 | LTC3351_CHRG_CI_SUBADDR)
//!@}
/*! @defgroup LTC3351_VINGD VINGD
 *  @ingroup LTC3351_register_map
 *  @brief VINGD Bit Field
 *
 *  Indicates the input voltage is inside the UV/OV range.
 *   - Register: @ref LTC3351_SYS_STATUS "SYS_STATUS"
 *   - CommandCode: 238
 *   - Size: 1
 *   - Offset: 11
 *   - MSB: 11
 *   - MASK: 0x0800
 *   - Access: R
 *   - Default: n/a
 */
//!@{
#define LTC3351_VINGD_SUBADDR LTC3351_SYS_STATUS_SUBADDR //!< @ref LTC3351_VINGD "VINGD"
#define LTC3351_VINGD_SIZE 1u
#define LTC3351_VINGD_OFFSET 11u
#define LTC3351_VINGD_MASK 0x0800u
#define LTC3351_VINGD_DEFAULT n/au
#define LTC3351_VINGD_DECODE(register_data) (((register_data) & LTC3351_VINGD_MASK) >> LTC3351_VINGD_OFFSET)
#define LTC3351_VINGD (LTC3351_VINGD_OFFSET << 12 | (LTC3351_VINGD_SIZE - 1) << 8 | LTC3351_VINGD_SUBADDR)
//!@}

#endif /* LTC3351_H_ */
