/*!*****************************************************************************
*
* LTC3351: Super Capacitor Backup Controller with HotSwap
*
* @verbatim
* LTC3351 supercap charger with hotswap
* @endverbatim
*
* http://www.linear.com/product/LTC3351
*
* http://www.linear.com/product/LTC3351#demoboards
*
* REVISION HISTORY
* $Revision: 164 $
* $Date: 2018-04-02 18:29:52 -0400 (Mon, 02 Apr 2018) $
*
* Copyright (c) 2018 Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
* The Linear Technology Linduino is not affiliated with the official Arduino
* team. However, the Linduino is only possible because of the Arduino team's
* commitment to the open-source community. Please, visit http://www.arduino.cc
* and http://store.arduino.cc, and consider a purchase that will help fund
* their ongoing work.
*
* Generated on: 2018-04-02
*
******************************************************************************/


/*! @file
 *  @ingroup LTC3351
 *  @brief LTC3351 library file defining data conversion macros and constants for the LTC3351.
 *
 *
 *  This file contains constants and real to integer/unsigned macros which can be used
 *  to represent real values in the source code, with automatic compile-time
 *  conversion to LTC3351 integer register scaling.
 *  Passing runtime variables to these macros should be avoided in embedded systems, as it
 *  results in runtime floating point calculations.
 *
 *  This file also contains integer/unsigned to real macros which can be used to convert from
 *  internal integer format to real values for display/debug. Invoking these macros results in
 *  runtime floating point calculations with associated high memory and execution penalty in
 *  small embedded systems.
 * @{
 */

#ifndef LTC3351_FORMATS_H_
#define LTC3351_FORMATS_H_

/*! @name Format Definitions
 *  Constants used by the macros below to convert between real and LTC3351 integer scaling.
 */
/*! @name Constants used in real/integer conversion macros below */
#define LTC3351_RSNSI 0.016
#define LTC3351_RSNSC 0.006
#define LTC3351_RTST 121
#define LTC3351_RT 71.5e3
#define LTC3351_CTL_CAP_SCALE_VALUE 1

/*! @name Use the macros below to convert between real and LTC3351 integer scaling. */
/*! Measured capacitor stack capacitance value. When CTL_CAP_SCALE_VALUE is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When CTL_CAP_SCALE_VALUE is set to 0 it is 336µF * RT/RTST per LSB.
 *   - Used with Bit Fields: cap_lo_lvl, meas_cap.
 */
#define LTC3351_CAP_FORMAT_R2U(x) (uint16_t)__LTC3351_ILINE__((0), ((3.36e-6 + 332.64e-6 * (1 - LTC3351_CTL_CAP_SCALE_VALUE)) * LTC3351_RT / LTC3351_RTST), (0), (1), x)
#define LTC3351_CAP_FORMAT_U2R(y) __LTC3351_RLINE__((0), (1), (0), ((3.36e-6 + 332.64e-6 * (1 - LTC3351_CTL_CAP_SCALE_VALUE)) * LTC3351_RT / LTC3351_RTST), (uint16_t)(y))

/*! This is used to program the capacitor voltage feedback loop's reference voltage. Only bits 3:0 are active. CAPFBREF = 37.5mV * vcapfb_dac + 637.5mV.
 *   - Used with Bit Field: vcapfb_dac.
 */
#define LTC3351_VCAPFB_DAC_FORMAT_R2U(x) (uint16_t)__LTC3351_ILINE__((0.6375), (0.6375 + 0.0375), (0), (1), x)
#define LTC3351_VCAPFB_DAC_FORMAT_U2R(y) __LTC3351_RLINE__((0), (1), (0.6375), (0.6375 + 0.0375), (uint16_t)(y))

/*! Measured voltage between CAP pins or CAP1 and CAPRTN.
 *   - Used with Bit Fields: vshunt, gpi_uv_lvl, gpi_ov_lvl, cap_uv_lvl, cap_ov_lvl, min_boost_cap_voltage, meas_gpi, lo_vcap, hi_vcap, meas_vcap1, meas_vcap2, meas_vcap3, meas_vcap4, hi_vcap_ch_bf, adc_val_bf.
 */
#define LTC3351_CELL_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (182.8e-6), (0), (1), x)
#define LTC3351_CELL_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (182.8e-6), (int16_t)(y))

/*! Measured input voltage.
 *   - Used with Bit Fields: vin_uv_lvl, vin_ov_lvl, meas_vin, adc_val_bf.
 */
#define LTC3351_VIN_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (2.19e-3), (0), (1), x)
#define LTC3351_VIN_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (2.19e-3), (int16_t)(y))

/*! Measured capacitor stack voltage.
 *   - Used with Bit Fields: vcap_uv_lvl, vcap_ov_lvl, meas_vcap, adc_val_bf.
 */
#define LTC3351_VCAP_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (1.46e-3), (0), (1), x)
#define LTC3351_VCAP_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (1.46e-3), (int16_t)(y))

/*! Measured output voltage
 *   - Used with Bit Fields: vout_uv_lvl, vout_ov_lvl, min_vout_hs_disable, meas_vout, adc_val_bf.
 */
#define LTC3351_VOUT_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (2.19e-3), (0), (1), x)
#define LTC3351_VOUT_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (2.19e-3), (int16_t)(y))

/*! Measured input current.
 *   - Used with Bit Fields: iin_oc_lvl, meas_iin.
 */
#define LTC3351_IIN_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (1.955e-6 / LTC3351_RSNSI), (0), (1), x)
#define LTC3351_IIN_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (1.955e-6 / LTC3351_RSNSI), (int16_t)(y))

/*! Measured die temperature.
 *   - Used with Bit Fields: dtemp_cold_lvl, dtemp_hot_lvl, meas_dtemp.
 */
#define LTC3351_DTEMP_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((-274), (-274 + 0.0296), (0), (1), x)
#define LTC3351_DTEMP_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (-274), (-274 + 0.0296), (int16_t)(y))

/*! Measured capacitor stack equivalent series resistance (ESR) value.
 *   - Used with Bit Fields: esr_hi_lvl, meas_esr.
 */
#define LTC3351_ESR_FORMAT_R2U(x) (uint16_t)__LTC3351_ILINE__((0), (LTC3351_RSNSC / 64), (0), (1), x)
#define LTC3351_ESR_FORMAT_U2R(y) __LTC3351_RLINE__((0), (1), (0), (LTC3351_RSNSC / 64), (uint16_t)(y))

/*! Measured Charge Current.
 *   - Used with Bit Fields: ichg_uc_lvl, meas_ichg.
 */
#define LTC3351_ICHARGE_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (1.955e-6 / LTC3351_RSNSC), (0), (1), x)
#define LTC3351_ICHARGE_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (1.955e-6 / LTC3351_RSNSC), (int16_t)(y))

/*! Capacitance and ESR Measurement Period: This register sets the period of repeated capacitance and ESR measurements.
 *   - Used with Bit Field: cap_esr_wait.
 */
#define LTC3351_CAP_PERIOD_FORMAT_R2U(x) (uint16_t)__LTC3351_ILINE__((0), (10), (0), (1), x)
#define LTC3351_CAP_PERIOD_FORMAT_U2R(y) __LTC3351_RLINE__((0), (1), (0), (10), (uint16_t)(y))

/*! Native ADC span.
 *   - Used with Bit Field: adc_val_bf.
 */
#define LTC3351_ADC_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (1), (0), (24270), x)
#define LTC3351_ADC_FORMAT_I2R(y) __LTC3351_RLINE__((0), (24270), (0), (1), (int16_t)(y))

/*! Unmodified capacitor data
 *   - Used with Bit Field: meas_cap.
 */
#define LTC3351_CAP_ZS_FORMAT_R2I(x) (int16_t)__LTC3351_ILINE__((0), (1), (0), (1), x)
#define LTC3351_CAP_ZS_FORMAT_I2R(y) __LTC3351_RLINE__((0), (1), (0), (1), (int16_t)(y))


/*! @name Private macros for use by formats above. */
#define __LTC3351_ROUND__(x) ((x) > 0 ? (x) + 0.5 : (x) - 0.5)
#define __LTC3351_ILINE__(x0,x1,y0,y1,x) __LTC3351_ROUND__((y0) + ((double)((y1) - (y0))/(double)((x1) - (x0))) * ((x) - (x0)))
#define __LTC3351_RLINE__(x0,x1,y0,y1,x) ((y0) + (double)((y1) - (y0))/(double)((x1) - (x0)) * ((x) - (x0)))
#define __LTC3351_BETWEEN_INCLUSIVE__(x0,x1,x) (((x) > (x0) && (x) < (x1)) || (x) == (x0) || (x) == (x1) ? 1 : 0)
#define __LTC3351_BELOW__(x0,x) ((x) < (x0) ? 1 : 0)
#define __LTC3351_ABOVE__(xn,x) ((x) > (xn) ? 1 : 0)


/*! @} */

#endif /* LTC3351_FORMATS_H_ */
