/*!*****************************************************************************
*
* LTC3351: Super Capacitor Backup Controller with HotSwap
*
* @verbatim
* LTC3351 supercap charger with hotswap
* @endverbatim
*
* http://www.linear.com/product/LTC3351
*
* http://www.linear.com/product/LTC3351#demoboards
*
* REVISION HISTORY
* $Revision: 164 $
* $Date: 2018-04-02 18:29:52 -0400 (Mon, 02 Apr 2018) $
*
* Copyright (c) 2018 Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
* The Linear Technology Linduino is not affiliated with the official Arduino
* team. However, the Linduino is only possible because of the Arduino team's
* commitment to the open-source community. Please, visit http://www.arduino.cc
* and http://store.arduino.cc, and consider a purchase that will help fund
* their ongoing work.
*
* Generated on: 2018-04-02
*
******************************************************************************/


/*! @file
 *  @ingroup LTC3351
 *  @brief Arduino Example
 *
 *  This is an example sketch to demonstrate use of the API with the Linduino.
 *  In addition to the sketch, the following files are required:
 *    LTC3351.c
 *    LTC3351.h
 *    LTC3351_formats.h
 *    LTC3351_reg_defs.h
 */

#include "LTC3351.h"
#include <Arduino.h>
#include "Linduino.h"

#include "UserInterface.h"

#include "LT_I2CBus.h"
#include "LT_SMBusPec.h"
static LT_SMBus *smbus = new LT_SMBusPec();

static inline int read_register(uint8_t address, uint8_t command_code, uint16_t *data, struct port_configuration *pc);
static inline int write_register(uint8_t address, uint8_t command_code, uint16_t data, struct port_configuration *pc);

LTC3351_chip_cfg_t LTC3351 =
{
  LTC3351_ADDR_09, //.address (7-bit)
  read_register,   //.read_register
  write_register,  //.write_register
  NULL             //.port_configuration not used
};

uint16_t data;

void setup()
{
  Serial.begin(115200);  //! Initialize the serial port to the PC
  while (!Serial);       //! Wait for serial port to be opened in the case of Leonardo USB Serial

  /* the API functions can be used to read and write individual bit fields
  within a command code */
  Serial.println(F("Using Read Register for the LTC3351_CTL_START_CAP_ESR_MEAS bit field"));
  LTC3351_read_register(&LTC3351, LTC3351_CTL_START_CAP_ESR_MEAS, &data);
  Serial.print(F("Read: "));
  Serial.println(data);

  Serial.println(F("\nUsing Read/Modify/Write Register for the LTC3351_CTL_START_CAP_ESR_MEAS bit field"));
  LTC3351_write_register(&LTC3351, LTC3351_CTL_START_CAP_ESR_MEAS, 1);
  Serial.print(F("Wrote: "));
  Serial.println(1);
  

  Serial.println(F("\nUsing Read Register for the LTC3351_CTL_START_CAP_ESR_MEAS bit field"));
  LTC3351_read_register(&LTC3351, LTC3351_CTL_START_CAP_ESR_MEAS, &data);
  Serial.print(F("Read: "));
  Serial.println(data);
  

  /* the API functions can also be used to read and write whole command codes */
  Serial.println(F("\nUsing Read Register for the LTC3351_CTL_REG command code"));
  LTC3351_read_register(&LTC3351, LTC3351_CTL_REG, &data);
  Serial.print(F("Read: "));
  Serial.println(data);

  Serial.println(F("\nUsing Read/Modify/Write Register for the LTC3351_VSHUNT command code"));
  LTC3351_write_register(&LTC3351, LTC3351_VSHUNT, (uint16_t)LTC3351_CELL_FORMAT_R2I(2.695));
  Serial.print(F("Wrote: "));
  Serial.println(LTC3351_CELL_FORMAT_I2R(LTC3351_CELL_FORMAT_R2I(2.695)));

  Serial.println(F("\nUsing Read Register for the LTC3351_CTL_REG command code"));
  LTC3351_read_register(&LTC3351, LTC3351_CTL_REG, &data);
  Serial.print(F("Read: "));
  Serial.println(data);
  Serial.print(F("Decoding bit field LTC3351_CTL_START_CAP_ESR_MEAS from command code data:"));
  Serial.println(LTC3351_CTL_START_CAP_ESR_MEAS_DECODE(data));

}

void loop()
{
  //Nothing left to do
}

/*! read_register function wraps C++ method LT_SMBus::readWord and places the returned data in *data.
 * Prototype: virtual uint16_t LT_SMBus::readWord(uint8_t address, uint8_t command);
 * Function should return 0 on success and a non-0 error code on failure. The API functions will return your error code.
 */
static inline int read_register(uint8_t address,              //!< IC's SMBus address (7-bit format).
                                uint8_t command_code,         //!< IC's Register address (SMBus command code) for read.
                                uint16_t *data,               //!< Memory location to store whole register data read from communication interface.
                                struct port_configuration *pc //!< Any necessary communication interface configuration information, such as a file descriptor or control register location.
                               )
{
  (void)pc;
  *data = smbus->readWord(address, command_code); //!< Store raw data from communication interface to location data.
  return 0; //LT_SMBus library unfortunately doesn't support error detection.
}

/*! write_register function wraps C++ method LT_SMBus::writeWord.
 * Prototype: virtual void LT_SMBus::writeWord(uint8_t address, uint8_t command, uint16_t data);
 * Function should return 0 on success and a non-0 error code on failure. The API functions will return your error code.
 */
static inline int write_register(uint8_t address,              //!< IC's SMBus address (7-bit format).
                                 uint8_t command_code,         //!< IC's Register address (SMBus command code) for write.
                                 uint16_t data,                //!< Whole register data to be written to communication interface.
                                 struct port_configuration *pc //!< Any necessary communication interface configuration information, such as a file descriptor or control register location.
                                )
{
  (void)pc;
  smbus->writeWord(address, command_code, data); //!< Write complete register data to communication interface.
  return 0; //LT_SMBus library unfortunately doesn't support error detection.
}
