/*!*****************************************************************************
*
* LTC3351: Super Capacitor Backup Controller with HotSwap
*
* @verbatim
* LTC3351 supercap charger with hotswap
* @endverbatim
*
* http://www.linear.com/product/LTC3351
*
* http://www.linear.com/product/LTC3351#demoboards
*
* REVISION HISTORY
* $Revision: 164 $
* $Date: 2018-04-02 18:29:52 -0400 (Mon, 02 Apr 2018) $
*
* Copyright (c) 2018 Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
* The Linear Technology Linduino is not affiliated with the official Arduino
* team. However, the Linduino is only possible because of the Arduino team's
* commitment to the open-source community. Please, visit http://www.arduino.cc
* and http://store.arduino.cc, and consider a purchase that will help fund
* their ongoing work.
*
* Generated on: 2018-04-02
*
******************************************************************************/


/*! @file
 *  @ingroup LTC3351
 *  @brief LTC3351 communication library core header file defining
 *  prototypes, data structures and constants used by LTC3351.c
 *
 *  Functions  matching  the  prototypes  of  @ref  smbus_write_register and @ref
 *  smbus_read_register  must  be  provided  to this API. They will implement the
 *  SMBus  read  and write transactions on your hardware. If the register size of
 *  the  LTC3351  is 8 bits, functions should be provided that implement SMBus
 *  read  byte and write byte. If the register size of the LTC3351 is 16 bits,
 *  functions  should  be provided that implement SMBus read word and write word.
 *  smbus_read_register  needs  to  store the value read from the LTC3351 into
 *  the  variable  data.  Both  functions  should return 0 on success and a non-0
 *  error  code  on  failure.  The  API functions will return your error codes on
 *  failure and a 0 on success.
 */

#ifndef LTC3351_H_
#define LTC3351_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "LTC3351_reg_defs.h"
#include "LTC3351_formats.h"
#include <stdlib.h>
#include <stdint.h>
#include <assert.h>

  // Type declarations

  /*! Incomplete declaration of struct containing any hardware-specific information to pass to read and write functions
      Complete definition if/as appropriate where smbus_read_register and smbus_write_register function definitions are completed. */
  struct port_configuration;

  /*! Prototype of user supplied SMBus write_word function. Should return 0 on success and a non-0 error code on failure. */
  typedef int (*smbus_write_register)(uint8_t address,              //!< Target IC's 7-bit SMBus address
                                      uint8_t command_code,         //!< Command code to be written to
                                      uint16_t data,                //!< Data to be written
                                      struct port_configuration *pc //!< Pointer to additional implementation-specific port configuration struct, if required.
                                     );
  /*! Prototype of user supplied SMBus read_word function. Should return 0 on success and a non-0 error code on failure. */
  typedef int (*smbus_read_register)(uint8_t address,              //!< Target IC's 7-bit SMBus address
                                     uint8_t command_code,         //!< command code to be read from
                                     uint16_t *data,               //!< Pointer to data destination
                                     struct port_configuration *pc //!< Pointer to additional implementation-specific port configuration struct, if required.
                                    );

  /*! Information required to access hardware SMBus port */
  typedef struct
  {
    uint8_t address; //!< Target IC's 7-bit SMBus address
    smbus_read_register read_register;             //!< Pointer to a user supplied smbus_read_register function
    smbus_write_register write_register;           //!< Pointer to a user supplied smbus_write_register function
    struct port_configuration *port_configuration; //!< Pointer to additional implementation-specific port configuration struct, if required.
  } LTC3351_chip_cfg_t;

  // function declarations
  /*! Function to modify a bit field within a register while preserving the unaddressed bit fields. Returns 0 on success. */
  int LTC3351_write_register(LTC3351_chip_cfg_t *chip, //!< Pointer to chip configuration struct
                             uint16_t registerinfo,    //!< Bit field name from LTC3351_regdefs.h
                             uint16_t data             //!< Data to be written
                            );
  /*! Retrieves a bit field data into *data. Right shifts the addressed portion down to the LSB position. Returns 0 on success. */
  int LTC3351_read_register(LTC3351_chip_cfg_t *chip, //!< Pointer to chip configuration struct
                            uint16_t registerinfo,    //!< Register name from LTC3351_regdefs.h
                            uint16_t *data            //!< Pointer to the data destination
                           );
  /*! Functions to modify LTC3351 power-on defaults. */
  void configure_LTC3351_reg(LTC3351_chip_cfg_t *); //!< Modify settings in LTC3351_reg_config.c
  void configure_LTC3351_bf(LTC3351_chip_cfg_t *);  //!< Modify settings in LTC3351_bf_config.c

#ifdef __cplusplus
}
#endif
#endif /* LTC3351_H_ */
