/*!*****************************************************************************
*
* LTC3351: Super Capacitor Backup Controller with HotSwap
*
* @verbatim
LTC3351 supercap charger with hotswap
* @endverbatim
*
* http://www.linear.com/product/LTC3351
*
* http://www.linear.com/product/LTC3351#demoboards
*
* REVISION HISTORY
* $Revision: 164 $
* $Date: 2018-04-02 18:29:52 -0400 (Mon, 02 Apr 2018) $
*
* Copyright (c) 2018 Analog Devices, Inc.
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification,
* are permitted provided that the following conditions are met:
*  - Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*  - Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*  - Neither the name of Analog Devices, Inc. nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*  - The use of this software may or may not infringe the patent rights
*    of one or more patent holders.  This license does not release you
*    from the requirement that you obtain separate licenses from these
*    patent holders to use this software.
*  - Use of the software either in source or binary form, must be run
*    on or directly connected to an Analog Devices Inc. component.
*
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
* The Linear Technology Linduino is not affiliated with the official Arduino
* team. However, the Linduino is only possible because of the Arduino team's
* commitment to the open-source community. Please, visit http://www.arduino.cc
* and http://store.arduino.cc, and consider a purchase that will help fund
* their ongoing work.
*
* Generated on: 2018-04-02
*
******************************************************************************/


/*! @file
 *  @ingroup LTC3351
 *  @brief Bit-field aligned modifier of power-on defaults
 *
 *  This is an example program to demonstrate use of the API by
 *  writing each writable bit-field in the LTC3351 back to its
 *  power-on default. The file can be changed easily to modify the LTC3351
 *  default behavior. This bit-field aligned configurator is somewhat simpler than
 *  the similar register based configurator, at the expense of program memory and 
 *  execution time.
 */

#include "LTC3351.h"

void configure_LTC3351_bf(LTC3351_chip_cfg_t *chip)
{
  LTC3351_write_register(chip, LTC3351_CTL_DISABLE_BALANCER, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_FORCE_ITST_ON, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_FORCE_CHARGER_OFF, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_FORCE_BOOST_OFF, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_HOTSWAP_DISABLE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_DISABLE_SHUNT, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_CAP_SCALE, LTC3351_CTL_CAP_SCALE_ENUM_LARGE_CAP);
  //LTC3351_write_register(chip, LTC3351_CTL_CAP_SCALE, LTC3351_CTL_CAP_SCALE_ENUM_SMALL_CAP);
  //LTC3351_write_register(chip, LTC3351_CTL_CAP_SCALE, 0u); //Max 1

  //LTC3351_write_register(chip, LTC3351_CTL_STOP_CAP_ESR_MEAS, LTC3351_CTL_STOP_CAP_ESR_MEAS_ENUM_STOP_MEASUREMENT);
  LTC3351_write_register(chip, LTC3351_CTL_STOP_CAP_ESR_MEAS, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_CTL_GPI_BUFFER_EN, 0u); //Max 1

  //LTC3351_write_register(chip, LTC3351_CTL_START_CAP_ESR_MEAS, LTC3351_CTL_START_CAP_ESR_MEAS_ENUM_START_MEASUREMENT);
  LTC3351_write_register(chip, LTC3351_CTL_START_CAP_ESR_MEAS, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_ESR_HI, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_CAP_LO, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_CAP_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_CAP_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_IIN_OC, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_ICHG_UC, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_DTEMP_HOT, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_DTEMP_COLD, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VOUT_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VOUT_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VCAP_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VCAP_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VIN_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_VIN_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_GPI_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_ALARM_GPI_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_CAP_PRECHARGE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_SHUNTING, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_BALANCING, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_POWER_RETURNED, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_POWER_FAILED, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_ESR_MEAS_ACTIVE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_CAP_MEAS_ACTIVE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_DISABLE_CHARGER, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_MEAS_FAILED, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_ESR_DONE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_CAP_DONE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_CAPESR_PENDING, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_MASK_MON_MEAS_ACTIVE, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_VCAPFB_DAC, LTC3351_VCAPFB_DAC_FORMAT_R2U(1.0125)); //This is used to program the capacitor voltage feedback loop's reference voltage. Only bits 3:0 are active. CAPFBREF = 37.5mV * vcapfb_dac + 637.5mV. MIN:0.6375, MAX:1.2.
  //LTC3351_write_register(chip, LTC3351_VCAPFB_DAC, 10u); //Max 15

  LTC3351_write_register(chip, LTC3351_VSHUNT, (uint16_t)LTC3351_CELL_FORMAT_R2I(2.6952032)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_VSHUNT, 14744u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VCAP4_EN, 1u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VCAP3_EN, 1u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VCAP2_EN, 1u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VCAP1_EN, 1u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VIN_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VCAP_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_VOUT_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_IIN_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_GPI_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_DTEMP_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_VIN_ICHG_EN, 1u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VCAP4_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VCAP3_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VCAP2_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VCAP1_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VIN_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VCAP_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_VOUT_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_IIN_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_GPI_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_DTEMP_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_BACKUP_ICHG_EN, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ADC_WAIT_VIN, 100u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ADC_WAIT_BACKUP, 100u); //Max 65535

  LTC3351_write_register(chip, LTC3351_GPI_UV_LVL, (uint16_t)LTC3351_CELL_FORMAT_R2I(0.0)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_GPI_UV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_GPI_OV_LVL, (uint16_t)LTC3351_CELL_FORMAT_R2I(0.0)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_GPI_OV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VIN_UV_LVL, (uint16_t)LTC3351_VIN_FORMAT_R2I(0.0)); //Measured input voltage. MIN:-71.76192, MAX:71.75973.
  //LTC3351_write_register(chip, LTC3351_VIN_UV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VIN_OV_LVL, (uint16_t)LTC3351_VIN_FORMAT_R2I(0.0)); //Measured input voltage. MIN:-71.76192, MAX:71.75973.
  //LTC3351_write_register(chip, LTC3351_VIN_OV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VCAP_UV_LVL, (uint16_t)LTC3351_VCAP_FORMAT_R2I(0.0)); //Measured capacitor stack voltage. MIN:-47.84128, MAX:47.83982.
  //LTC3351_write_register(chip, LTC3351_VCAP_UV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VCAP_OV_LVL, (uint16_t)LTC3351_VCAP_FORMAT_R2I(0.0)); //Measured capacitor stack voltage. MIN:-47.84128, MAX:47.83982.
  //LTC3351_write_register(chip, LTC3351_VCAP_OV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VOUT_UV_LVL, (uint16_t)LTC3351_VOUT_FORMAT_R2I(0.0)); //Measured output voltage MIN:-71.76192, MAX:71.75973.
  //LTC3351_write_register(chip, LTC3351_VOUT_UV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_VOUT_OV_LVL, (uint16_t)LTC3351_VOUT_FORMAT_R2I(0.0)); //Measured output voltage MIN:-71.76192, MAX:71.75973.
  //LTC3351_write_register(chip, LTC3351_VOUT_OV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_DTEMP_COLD_LVL, (uint16_t)LTC3351_DTEMP_FORMAT_R2I(-274.0)); //Measured die temperature. MIN:-1243.9328, MAX:695.903200001.
  //LTC3351_write_register(chip, LTC3351_DTEMP_COLD_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_DTEMP_HOT_LVL, (uint16_t)LTC3351_DTEMP_FORMAT_R2I(-274.0)); //Measured die temperature. MIN:-1243.9328, MAX:695.903200001.
  //LTC3351_write_register(chip, LTC3351_DTEMP_HOT_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ICHG_UC_LVL, (uint16_t)LTC3351_ICHARGE_FORMAT_R2I(0.0)); //Measured Charge Current. MIN:-10.6769066667, MAX:10.6765808333.
  //LTC3351_write_register(chip, LTC3351_ICHG_UC_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_IIN_OC_LVL, (uint16_t)LTC3351_IIN_FORMAT_R2I(0.0)); //Measured input current. MIN:-4.00384, MAX:4.0037178125.
  //LTC3351_write_register(chip, LTC3351_IIN_OC_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_CAP_UV_LVL, (uint16_t)LTC3351_CELL_FORMAT_R2I(0.0)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_CAP_UV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_CAP_OV_LVL, (uint16_t)LTC3351_CELL_FORMAT_R2I(0.0)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_CAP_OV_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_CAP_LO_LVL, LTC3351_CAP_FORMAT_R2U(0.0)); //Measured capacitor stack capacitance value. When CTL_CAP_SCALE_VALUE is set to 1, capacitance is 3.36µF * RT/RTST per LSB. When CTL_CAP_SCALE_VALUE is set to 0 it is 336µF * RT/RTST per LSB. MIN:0.0, MAX:130.116763636.
  //LTC3351_write_register(chip, LTC3351_CAP_LO_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ESR_HI_LVL, LTC3351_ESR_FORMAT_R2U(0.0)); //Measured capacitor stack equivalent series resistance (ESR) value. MIN:0.0, MAX:6.14390625.
  //LTC3351_write_register(chip, LTC3351_ESR_HI_LVL, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ESR_I_ON_SETTLING, 2u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ESR_I_OFF_SETTLING, 8u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ESR_I_OVERRIDE, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_CAP_I_ON_SETTLING, 8u); //Max 65535

  LTC3351_write_register(chip, LTC3351_CAP_DELTA_V_SETTING, 550u); //Max 65535

  LTC3351_write_register(chip, LTC3351_MIN_BOOST_CAP_VOLTAGE, (uint16_t)LTC3351_CELL_FORMAT_R2I(0.0)); //Measured voltage between CAP pins or CAP1 and CAPRTN. MIN:-5.9899904, MAX:5.9898076.
  //LTC3351_write_register(chip, LTC3351_MIN_BOOST_CAP_VOLTAGE, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_MIN_VOUT_HS_DISABLE, (uint16_t)LTC3351_VOUT_FORMAT_R2I(0.0)); //Measured output voltage MIN:-71.76192, MAX:71.75973.
  //LTC3351_write_register(chip, LTC3351_MIN_VOUT_HS_DISABLE, 0u); //Max 65535

  LTC3351_write_register(chip, LTC3351_ALARM_ESR_HI, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_CAP_LO, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_CAP_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_CAP_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_IIN_OC, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_ICHG_UC, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_DTEMP_HOT, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_DTEMP_COLD, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VOUT_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VOUT_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VCAP_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VCAP_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VIN_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_VIN_UV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_GPI_OV, 0u); //Max 1

  LTC3351_write_register(chip, LTC3351_ALARM_GPI_UV, 0u); //Max 1

}
