/*---------------------------------------------------------------------------*/
/* Filename: MAX6970.c                                                       */
/* Description: MAXQ2000 Firmware for the MAX6970EVKIT which uses the        */
/* MAXQ2000-KIT.                                                             */
/* Version: 0.1                                                              */
/* Author: Kien Mach                                                         */
/* Date: 9/14/2007                                                           */
/*---------------------------------------------------------------------------*/

#include "iomaxq200x.h"

/* Macros */
#define DATA0 0xAA
#define DATA1 0x55
#define DATA2 0xFF
#define DATA3 0x01
#define DATA4 0x02
#define DATA5 0x04
#define DATA6 0x08
#define DATA7 0x10
#define DATA8 0x20
#define DATA9 0x40
#define DATA10 0x80
#define DATA11 0x00
#define DATA12 0x01
#define DATA13 0x03
#define DATA14 0x07
#define DATA15 0x0F
#define DATA16 0x1F
#define DATA17 0x3F
#define DATA18 0x7F
#define DATA19 0xFF

/*------------------------Function Prototypes------------------------------*/
void getSample();
unsigned int sendSPI(unsigned int spib);

/*-------------------------Start of sendSPI()------------------------------*/

unsigned int sendSPI(unsigned int spib)
{
  SPIB = spib;           // Load the data to send
  while(SPICN_bit.STBY); // Loop until the data has been sent.
  SPICN_bit.SPIC = 0;    // Clear the SPI transfer complete flag.
  return SPIB;
}
/*--------------------------End of sendSPI()--------------------------------*/

/*------------------------Start of getSample()------------------------------*/
void getData(unsigned int seqData)
{
  unsigned int spiData;

  PO5_bit.bit4 = 0;               // /CS is on
  spiData=sendSPI(seqData);       // send data
  PO0_bit.bit0 = 0;               // /OE is on
  PO5_bit.bit4 = 1;               // /CS is off   
}
/*--------------------------End of getSample()------------------------------*/



/*----------------------------Start of Main()--------------------------------*/

void main(void)
{   
  int count, count2;
  long i;
  long TimeValue = 0x0000;
 
  /* Initialize Timer */ 
  /* Timer Control Register*/
  T2CNA2_bit.ET2=0;           //Disable Timer interupt
  T2CNA2_bit.TR2=0;           //Stop Timer2
  T2CNA2_bit.T2OE0=0;         //SET T2P pin: Port Data; T2PB pin: Port Data
  
  /* TIMER Configuration (T2CNA2) Register */
  T2CFG2_bit.CT=0;            //Selet Timer
  T2CFG2_bit.CCF=0;           //Select Compare function
  T2CFG2_bit.T2MD=1;          //Set 8-bit mode
  T2CFG2_bit.T2DIV=0;         //Timer 2 Clock Divide 1
  T2CFG2_bit.T2CI=0;          //No alternate input clock

  /* Global Interrupt enable - Globally */
  IC_bit.IGE=1;
  
  /*--------------------------Initialize SPI-------------------------------*/
  
  /* SPI Control (SPICN) Register */
  PD5_bit.bit4=1;             //Set Serial output pin /SS as output
  PD5_bit.bit5=1;             //Set Serial output pin SCLK as output
  PD5_bit.bit6=1;             //Set Serial output pin MOSI as output
  PD5_bit.bit7=0;             //Set Serial input pin MISO as input
  PD0_bit.bit0=1;             //Set Serial output pin /OE as output
  
  SPICN_bit.SPIEN=1;          //SPI enable
  SPICN_bit.MSTM=1;           //Master mode 
  SPICN_bit.MODFE=0;          //Mode fault enable - /SSEL used as GPIO
  SPICN_bit.MODF=0;           //Mode fault flag - cause interupt
  SPICN_bit.WCOL=0;           //Write collision flag
  SPICN_bit.ROVR=0;           //Receive overrun flag
  SPICN_bit.SPIC=0;           //SPI transfer complete
 
  /* SPI Configuration (SPICF) Register */
  SPICF_bit.CKPOL=0;          // Clock Polarity
  SPICF_bit.CKPHA=0;          // Clock Phase
  SPICF_bit.CHR=0;            // Character length bit = 8-bit
   
  /* SPI Clock Register */
  SPICK=0x00;                 //Configure SPI for rising edge
                              //SPI Baud Rate = SystemClock/(2*(SPICK+1)) = 8MHz
 
  while(SPICN_bit.STBY);     // Wait for SPI to finish
  
  PD7_bit.bit0=0;
  PD5_bit.bit3=0;
    
  while(1)
  {
     if(PI7_bit.bit0==0)            // If button is pressed
     {
        count = 1;                  // Initiate first set of LED sequence               
     }  
     if(count == 1)                 // 1st sequence
     {
        getData(DATA0);             // 0xAA
        for(i=0; i<500000; i++);    // Delay
        getData(DATA1);             // Inverse sequence, 0x55
        for(i=0; i<500000; i++);    // Delay 
        if(PI7_bit.bit0==0)         // If button is pressed
        {
           count = 2;               // Initiate second set of LED sequence
        }
     }   
     if(count == 2)                 // 2nd sequence
     {
        getData(DATA2);             // 0xFF
        for(i=0; i<1000000; i++);   // Wait for button to deboounce
        getData(DATA11);            // Inverse sequence, 0x00
        for(i=0; i<1000000; i++);   // Delay
        if(PI7_bit.bit0==0)         // If button is pressed
        {
           count = 3;               // Initiate third set of LED sequence
        }
     }
     if(count == 3)                // 3rd sequence
     {
        getData(DATA3);            // 0x01
        for(i=0; i<100000; i++);   // Delay
        getData(DATA4);            // 0x02
        for(i=0; i<100000; i++);   // Delay
        getData(DATA5);            // 0x04
        for(i=0; i<100000; i++);   // Delay
        getData(DATA6);            // 0x08
        for(i=0; i<100000; i++);   // Delay
        getData(DATA7);            // 0x10
        for(i=0; i<100000; i++);   // Delay
        getData(DATA8);            // 0x20
        for(i=0; i<100000; i++);   // Delay
        getData(DATA9);            // 0x40
        for(i=0; i<100000; i++);   // Delay
        getData(DATA10);           // 0x80
        for(i=0; i<100000; i++);   // Delay
        if(PI7_bit.bit0==0)        // If button is pressed
        {
           count = 4;              // Initiate fourth set of LED sequence
        }
     } 
     if(count == 4)                // 4th sequence
     {
        getData(DATA10);           // 0x80
        for(i=0; i<100000; i++);   // Delay
        getData(DATA9);            // 0x40
        for(i=0; i<100000; i++);   // Delay
        getData(DATA8);            // 0x20
        for(i=0; i<100000; i++);   // Delay
        getData(DATA7);            // 0x10
        for(i=0; i<100000; i++);   // Delay
        getData(DATA6);            // 0x08
        for(i=0; i<100000; i++);   // Delay
        getData(DATA5);            // 0x04
        for(i=0; i<100000; i++);   // Delay
        getData(DATA4);            // 0x02
        for(i=0; i<100000; i++);   // Delay
        getData(DATA3);            // 0x01
        for(i=0; i<100000; i++);   // Delay
        if(PI7_bit.bit0==0)        // If button is pressed
        {
           count = 5;              // Initiate first set of LED sequence
        }  
     }  
     if(count == 5)                // 5th sequence
     { 
        getData(DATA12);           // 0x01
        for(i=0; i<100000; i++);   // Delay
        getData(DATA13);           // 0x03
        for(i=0; i<100000; i++);   // Delay
        getData(DATA14);           // 0x07
        for(i=0; i<100000; i++);   // Delay
        getData(DATA15);           // 0x0F
        for(i=0; i<100000; i++);   // Delay
        getData(DATA16);           // 0x1F
        for(i=0; i<100000; i++);   // Delay
        getData(DATA17);           // 0x3F
        for(i=0; i<100000; i++);   // Delay
        getData(DATA18);           // 0x7F
        for(i=0; i<100000; i++);   // Delay
        getData(DATA19);           // 0xFF
        for(i=0; i<100000; i++);   // Delay
        if(PI7_bit.bit0==0)
        {
           count = 1;              // Initiate first set of LED sequence
        }  
     }
     
     
          
               
  }   
} 
 


