/* ========================================
 *
 * Copyright Analog Devices Inc, 2019
 * All Rights Reserved
 *
 * ========================================
*/

#include <smbalert.h>
#include <gpio.h>
#include <led.h>

CY_ISR(smbalert_intr_handler)
{
    gpio_clear_intr(SMBALERT_GPIO_PORT_PIN);
    
    if(gpio_read_value(SMBALERT_GPIO_PORT_PIN)) //High, no smbalert
    {
        set_led_state(ON);
    }
    else //Low, smbalert active
    {
        //This is where you might enter code to handle SMBAlerts.
        //By default, we do nothing and just blink an LED here to indicate the alert was received.
        
        set_led_state(BLINK);
    }
}

void configure_smbalert_interrupt()
{
    gpio_hsiom_set_config(SMBALERT_GPIO_PORT_PIN, HSIOM_MODE_GPIO, GPIO_DM_HIZ_DIGITAL, false);
    gpio_int_set_config(SMBALERT_GPIO_PORT_PIN, GPIO_INTR_BOTH);
    CyIntSetVector(CCG3_PORT3_INTR_NO, &smbalert_intr_handler);
    CyIntEnable(CCG3_PORT3_INTR_NO);
}

/* [] END OF FILE */
