/* ========================================
 *
 * Copyright Analog Devices Inc, 2019
 * All Rights Reserved
 *
 * ========================================
*/

#include <led.h>
#include <PGOOD_LED.h>
#include <gpio.h>
#include <timer.h>

LED_STATE led_state = OFF;

void set_led_state(LED_STATE state)
{
    if(led_state == state)
        return;
    
    led_state = state;
    
    switch(state)
    {
        case OFF:
            PGOOD_LED_Write(1);
            break;
        case ON:
            PGOOD_LED_Write(0);
            break;
        case BLINK:
            blink_led();
            break;
    }
}

void blink_led()
{
    if(led_state != BLINK)
        return;
    
    gpio_set_value (PGOOD_LED_GPIO_PORT_PIN, !(gpio_read_value (PGOOD_LED_GPIO_PORT_PIN)));
    
    timer_start (0, PGOOD_LED_TIMER_ID, PGOOD_LED_TIMER_PERIOD, pgood_led_timer_cb);
}

void pgood_led_timer_cb(uint8_t port, timer_id_t id)
{
    (void)port;
    (void)id;
    
    blink_led();
}

/* [] END OF FILE */
