/*******************************************************************************
* File Name: SMBALERTB.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_SMBALERTB_H) /* Pins SMBALERTB_H */
#define CY_PINS_SMBALERTB_H

#include "cytypes.h"
#include "cyfitter.h"
#include "SMBALERTB_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} SMBALERTB_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   SMBALERTB_Read(void);
void    SMBALERTB_Write(uint8 value);
uint8   SMBALERTB_ReadDataReg(void);
#if defined(SMBALERTB__PC) || (CY_PSOC4_4200L) 
    void    SMBALERTB_SetDriveMode(uint8 mode);
#endif
void    SMBALERTB_SetInterruptMode(uint16 position, uint16 mode);
uint8   SMBALERTB_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void SMBALERTB_Sleep(void); 
void SMBALERTB_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(SMBALERTB__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define SMBALERTB_DRIVE_MODE_BITS        (3)
    #define SMBALERTB_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - SMBALERTB_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the SMBALERTB_SetDriveMode() function.
         *  @{
         */
        #define SMBALERTB_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define SMBALERTB_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define SMBALERTB_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define SMBALERTB_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define SMBALERTB_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define SMBALERTB_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define SMBALERTB_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define SMBALERTB_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define SMBALERTB_MASK               SMBALERTB__MASK
#define SMBALERTB_SHIFT              SMBALERTB__SHIFT
#define SMBALERTB_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in SMBALERTB_SetInterruptMode() function.
     *  @{
     */
        #define SMBALERTB_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define SMBALERTB_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define SMBALERTB_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define SMBALERTB_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(SMBALERTB__SIO)
    #define SMBALERTB_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(SMBALERTB__PC) && (CY_PSOC4_4200L)
    #define SMBALERTB_USBIO_ENABLE               ((uint32)0x80000000u)
    #define SMBALERTB_USBIO_DISABLE              ((uint32)(~SMBALERTB_USBIO_ENABLE))
    #define SMBALERTB_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define SMBALERTB_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define SMBALERTB_USBIO_ENTER_SLEEP          ((uint32)((1u << SMBALERTB_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << SMBALERTB_USBIO_SUSPEND_DEL_SHIFT)))
    #define SMBALERTB_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << SMBALERTB_USBIO_SUSPEND_SHIFT)))
    #define SMBALERTB_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << SMBALERTB_USBIO_SUSPEND_DEL_SHIFT)))
    #define SMBALERTB_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(SMBALERTB__PC)
    /* Port Configuration */
    #define SMBALERTB_PC                 (* (reg32 *) SMBALERTB__PC)
#endif
/* Pin State */
#define SMBALERTB_PS                     (* (reg32 *) SMBALERTB__PS)
/* Data Register */
#define SMBALERTB_DR                     (* (reg32 *) SMBALERTB__DR)
/* Input Buffer Disable Override */
#define SMBALERTB_INP_DIS                (* (reg32 *) SMBALERTB__PC2)

/* Interrupt configuration Registers */
#define SMBALERTB_INTCFG                 (* (reg32 *) SMBALERTB__INTCFG)
#define SMBALERTB_INTSTAT                (* (reg32 *) SMBALERTB__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define SMBALERTB_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(SMBALERTB__SIO)
    #define SMBALERTB_SIO_REG            (* (reg32 *) SMBALERTB__SIO)
#endif /* (SMBALERTB__SIO_CFG) */

/* USBIO registers */
#if !defined(SMBALERTB__PC) && (CY_PSOC4_4200L)
    #define SMBALERTB_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define SMBALERTB_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define SMBALERTB_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define SMBALERTB_DRIVE_MODE_SHIFT       (0x00u)
#define SMBALERTB_DRIVE_MODE_MASK        (0x07u << SMBALERTB_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins SMBALERTB_H */


/* [] END OF FILE */
