/*******************************************************************************
* File Name: MUX_CTRL_SCBCLK.h
* Version 2.20
*
*  Description:
*   Provides the function and constant definitions for the clock component.
*
*  Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_CLOCK_MUX_CTRL_SCBCLK_H)
#define CY_CLOCK_MUX_CTRL_SCBCLK_H

#include <cytypes.h>
#include <cyfitter.h>


/***************************************
*        Function Prototypes
***************************************/
#if defined CYREG_PERI_DIV_CMD

void MUX_CTRL_SCBCLK_StartEx(uint32 alignClkDiv);
#define MUX_CTRL_SCBCLK_Start() \
    MUX_CTRL_SCBCLK_StartEx(MUX_CTRL_SCBCLK__PA_DIV_ID)

#else

void MUX_CTRL_SCBCLK_Start(void);

#endif/* CYREG_PERI_DIV_CMD */

void MUX_CTRL_SCBCLK_Stop(void);

void MUX_CTRL_SCBCLK_SetFractionalDividerRegister(uint16 clkDivider, uint8 clkFractional);

uint16 MUX_CTRL_SCBCLK_GetDividerRegister(void);
uint8  MUX_CTRL_SCBCLK_GetFractionalDividerRegister(void);

#define MUX_CTRL_SCBCLK_Enable()                         MUX_CTRL_SCBCLK_Start()
#define MUX_CTRL_SCBCLK_Disable()                        MUX_CTRL_SCBCLK_Stop()
#define MUX_CTRL_SCBCLK_SetDividerRegister(clkDivider, reset)  \
    MUX_CTRL_SCBCLK_SetFractionalDividerRegister((clkDivider), 0u)
#define MUX_CTRL_SCBCLK_SetDivider(clkDivider)           MUX_CTRL_SCBCLK_SetDividerRegister((clkDivider), 1u)
#define MUX_CTRL_SCBCLK_SetDividerValue(clkDivider)      MUX_CTRL_SCBCLK_SetDividerRegister((clkDivider) - 1u, 1u)


/***************************************
*             Registers
***************************************/
#if defined CYREG_PERI_DIV_CMD

#define MUX_CTRL_SCBCLK_DIV_ID     MUX_CTRL_SCBCLK__DIV_ID

#define MUX_CTRL_SCBCLK_CMD_REG    (*(reg32 *)CYREG_PERI_DIV_CMD)
#define MUX_CTRL_SCBCLK_CTRL_REG   (*(reg32 *)MUX_CTRL_SCBCLK__CTRL_REGISTER)
#define MUX_CTRL_SCBCLK_DIV_REG    (*(reg32 *)MUX_CTRL_SCBCLK__DIV_REGISTER)

#define MUX_CTRL_SCBCLK_CMD_DIV_SHIFT          (0u)
#define MUX_CTRL_SCBCLK_CMD_PA_DIV_SHIFT       (8u)
#define MUX_CTRL_SCBCLK_CMD_DISABLE_SHIFT      (30u)
#define MUX_CTRL_SCBCLK_CMD_ENABLE_SHIFT       (31u)

#define MUX_CTRL_SCBCLK_CMD_DISABLE_MASK       ((uint32)((uint32)1u << MUX_CTRL_SCBCLK_CMD_DISABLE_SHIFT))
#define MUX_CTRL_SCBCLK_CMD_ENABLE_MASK        ((uint32)((uint32)1u << MUX_CTRL_SCBCLK_CMD_ENABLE_SHIFT))

#define MUX_CTRL_SCBCLK_DIV_FRAC_MASK  (0x000000F8u)
#define MUX_CTRL_SCBCLK_DIV_FRAC_SHIFT (3u)
#define MUX_CTRL_SCBCLK_DIV_INT_MASK   (0xFFFFFF00u)
#define MUX_CTRL_SCBCLK_DIV_INT_SHIFT  (8u)

#else 

#define MUX_CTRL_SCBCLK_DIV_REG        (*(reg32 *)MUX_CTRL_SCBCLK__REGISTER)
#define MUX_CTRL_SCBCLK_ENABLE_REG     MUX_CTRL_SCBCLK_DIV_REG
#define MUX_CTRL_SCBCLK_DIV_FRAC_MASK  MUX_CTRL_SCBCLK__FRAC_MASK
#define MUX_CTRL_SCBCLK_DIV_FRAC_SHIFT (16u)
#define MUX_CTRL_SCBCLK_DIV_INT_MASK   MUX_CTRL_SCBCLK__DIVIDER_MASK
#define MUX_CTRL_SCBCLK_DIV_INT_SHIFT  (0u)

#endif/* CYREG_PERI_DIV_CMD */

#endif /* !defined(CY_CLOCK_MUX_CTRL_SCBCLK_H) */

/* [] END OF FILE */
