/*******************************************************************************
* File Name: HPD.h  
* Version 2.20
*
* Description:
*  This file contains Pin function prototypes and register defines
*
********************************************************************************
* Copyright 2008-2015, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_HPD_H) /* Pins HPD_H */
#define CY_PINS_HPD_H

#include "cytypes.h"
#include "cyfitter.h"
#include "HPD_aliases.h"


/***************************************
*     Data Struct Definitions
***************************************/

/**
* \addtogroup group_structures
* @{
*/
    
/* Structure for sleep mode support */
typedef struct
{
    uint32 pcState; /**< State of the port control register */
    uint32 sioState; /**< State of the SIO configuration */
    uint32 usbState; /**< State of the USBIO regulator */
} HPD_BACKUP_STRUCT;

/** @} structures */


/***************************************
*        Function Prototypes             
***************************************/
/**
* \addtogroup group_general
* @{
*/
uint8   HPD_Read(void);
void    HPD_Write(uint8 value);
uint8   HPD_ReadDataReg(void);
#if defined(HPD__PC) || (CY_PSOC4_4200L) 
    void    HPD_SetDriveMode(uint8 mode);
#endif
void    HPD_SetInterruptMode(uint16 position, uint16 mode);
uint8   HPD_ClearInterrupt(void);
/** @} general */

/**
* \addtogroup group_power
* @{
*/
void HPD_Sleep(void); 
void HPD_Wakeup(void);
/** @} power */


/***************************************
*           API Constants        
***************************************/
#if defined(HPD__PC) || (CY_PSOC4_4200L) 
    /* Drive Modes */
    #define HPD_DRIVE_MODE_BITS        (3)
    #define HPD_DRIVE_MODE_IND_MASK    (0xFFFFFFFFu >> (32 - HPD_DRIVE_MODE_BITS))

    /**
    * \addtogroup group_constants
    * @{
    */
        /** \addtogroup driveMode Drive mode constants
         * \brief Constants to be passed as "mode" parameter in the HPD_SetDriveMode() function.
         *  @{
         */
        #define HPD_DM_ALG_HIZ         (0x00u) /**< \brief High Impedance Analog   */
        #define HPD_DM_DIG_HIZ         (0x01u) /**< \brief High Impedance Digital  */
        #define HPD_DM_RES_UP          (0x02u) /**< \brief Resistive Pull Up       */
        #define HPD_DM_RES_DWN         (0x03u) /**< \brief Resistive Pull Down     */
        #define HPD_DM_OD_LO           (0x04u) /**< \brief Open Drain, Drives Low  */
        #define HPD_DM_OD_HI           (0x05u) /**< \brief Open Drain, Drives High */
        #define HPD_DM_STRONG          (0x06u) /**< \brief Strong Drive            */
        #define HPD_DM_RES_UPDWN       (0x07u) /**< \brief Resistive Pull Up/Down  */
        /** @} driveMode */
    /** @} group_constants */
#endif

/* Digital Port Constants */
#define HPD_MASK               HPD__MASK
#define HPD_SHIFT              HPD__SHIFT
#define HPD_WIDTH              1u

/**
* \addtogroup group_constants
* @{
*/
    /** \addtogroup intrMode Interrupt constants
     * \brief Constants to be passed as "mode" parameter in HPD_SetInterruptMode() function.
     *  @{
     */
        #define HPD_INTR_NONE      ((uint16)(0x0000u)) /**< \brief Disabled             */
        #define HPD_INTR_RISING    ((uint16)(0x5555u)) /**< \brief Rising edge trigger  */
        #define HPD_INTR_FALLING   ((uint16)(0xaaaau)) /**< \brief Falling edge trigger */
        #define HPD_INTR_BOTH      ((uint16)(0xffffu)) /**< \brief Both edge trigger    */
    /** @} intrMode */
/** @} group_constants */

/* SIO LPM definition */
#if defined(HPD__SIO)
    #define HPD_SIO_LPM_MASK       (0x03u)
#endif

/* USBIO definitions */
#if !defined(HPD__PC) && (CY_PSOC4_4200L)
    #define HPD_USBIO_ENABLE               ((uint32)0x80000000u)
    #define HPD_USBIO_DISABLE              ((uint32)(~HPD_USBIO_ENABLE))
    #define HPD_USBIO_SUSPEND_SHIFT        CYFLD_USBDEVv2_USB_SUSPEND__OFFSET
    #define HPD_USBIO_SUSPEND_DEL_SHIFT    CYFLD_USBDEVv2_USB_SUSPEND_DEL__OFFSET
    #define HPD_USBIO_ENTER_SLEEP          ((uint32)((1u << HPD_USBIO_SUSPEND_SHIFT) \
                                                        | (1u << HPD_USBIO_SUSPEND_DEL_SHIFT)))
    #define HPD_USBIO_EXIT_SLEEP_PH1       ((uint32)~((uint32)(1u << HPD_USBIO_SUSPEND_SHIFT)))
    #define HPD_USBIO_EXIT_SLEEP_PH2       ((uint32)~((uint32)(1u << HPD_USBIO_SUSPEND_DEL_SHIFT)))
    #define HPD_USBIO_CR1_OFF              ((uint32)0xfffffffeu)
#endif


/***************************************
*             Registers        
***************************************/
/* Main Port Registers */
#if defined(HPD__PC)
    /* Port Configuration */
    #define HPD_PC                 (* (reg32 *) HPD__PC)
#endif
/* Pin State */
#define HPD_PS                     (* (reg32 *) HPD__PS)
/* Data Register */
#define HPD_DR                     (* (reg32 *) HPD__DR)
/* Input Buffer Disable Override */
#define HPD_INP_DIS                (* (reg32 *) HPD__PC2)

/* Interrupt configuration Registers */
#define HPD_INTCFG                 (* (reg32 *) HPD__INTCFG)
#define HPD_INTSTAT                (* (reg32 *) HPD__INTSTAT)

/* "Interrupt cause" register for Combined Port Interrupt (AllPortInt) in GSRef component */
#if defined (CYREG_GPIO_INTR_CAUSE)
    #define HPD_INTR_CAUSE         (* (reg32 *) CYREG_GPIO_INTR_CAUSE)
#endif

/* SIO register */
#if defined(HPD__SIO)
    #define HPD_SIO_REG            (* (reg32 *) HPD__SIO)
#endif /* (HPD__SIO_CFG) */

/* USBIO registers */
#if !defined(HPD__PC) && (CY_PSOC4_4200L)
    #define HPD_USB_POWER_REG       (* (reg32 *) CYREG_USBDEVv2_USB_POWER_CTRL)
    #define HPD_CR1_REG             (* (reg32 *) CYREG_USBDEVv2_CR1)
    #define HPD_USBIO_CTRL_REG      (* (reg32 *) CYREG_USBDEVv2_USB_USBIO_CTRL)
#endif    
    
    
/***************************************
* The following code is DEPRECATED and 
* must not be used in new designs.
***************************************/
/**
* \addtogroup group_deprecated
* @{
*/
#define HPD_DRIVE_MODE_SHIFT       (0x00u)
#define HPD_DRIVE_MODE_MASK        (0x07u << HPD_DRIVE_MODE_SHIFT)
/** @} deprecated */

#endif /* End Pins HPD_H */


/* [] END OF FILE */
