# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Each version will have its own section containing a possible subset of the following subsections:
- Added: for new features.
- Changed: for changes in existing functionality.
- Deprecated: for soon-to-be removed features.
- Removed: for now removed features.
- Fixed: for any bug fixes.
- Security: in case of vulnerabilities.


## Unreleased

## 0.7.18 - 2026-1-27
### Changed
- Change CALPER value to 6 (64k Samples) when running phase sync cal

## 0.7.17 - 2026-1-12
### Changed
- Added 1us delay between aborting and starting phase sync
- Changed Semaphore reset instruction to WRMASK to prevent clearing other flags

## 0.7.16 - 2025-12-10
### Changed
- Removed RX Datapath resets to support 22bit SSI gain index

## 0.7.15 - 2024-10-16
### Changed
- Added semaphore for new FH LO Retune sequence

## 0.7.14 - 2024-10-16
### Changed
- NSS-3856: Phase sync stream now aborts any previous running phase sync in case one was still running.

## 0.7.13 - 2024-10-03
### Changed
- Changed time/location where RX streams take LO Retune semaphore to avoid the wrong channel taking the semaphore in very short frames

## 0.7.12 - 2024-07-12
### Changed
- Added Port Impedance Control

## 0.7.11 - 2024-03-22
### Changed
- Changed LSSI RX Sequence

## 0.7.10 - 2023-11-19
### Changed
- Changed LSSI TX Sequence

## 0.7.9 - 2021-12-03
### Changed
- Changed the timing of disable PFIR to comply with Day 17 timing.

## 0.7.8 - 2021-08-23
### Added
- NSS-3001: Dynamicaly  enable/disable Pfir

## 0.7.7 - 2021-07-28
### Fixed
- Using TX falling edge as "TX SSI interface disable" in LO Retune FH mode.

### Changed
- Use TX rising edge to enabled TX SSI interface in LO Retune FH mode.


## 0.7.6 - 2021-07-12
### Fixed
- NSS-2865: RX2 Channel gets stuck in Prime State.


## 0.7.5 - 2021-06-25
### Changed
- NSS-2799: changed from 1 frame delay to no frame delay in LO retune FH mode.


## 0.7.4 - 2021-06-07
### Added
- NSS-2730: Analog GPIO pins to control RX1/RX2 LNA switch.


## 0.7.3 - 2021-05-05
### Changed
- Only use A Registers in dual hop LO retune mode.
- Support retuning LO with multiple channel stream processors.
- NSS-2414: do not disable RX algorithms in TX streams.


## 0.7.2 - 2021-04-14
### Added
- NSS-2576: Analog GPIO pins to control TX1/TX2 antenna switch.

### Changed
- Use C0 SPI register map.

### Fixed
- NSS-2610: GPIO debug timing.
- Copy and paste issue of $IfRx1IntLo$


## 0.7.1 - 2021-03-06
### Changed
- Implemented a better way for semaphore in streams.


## 0.7.0 - 2021-03-05
### Changed
- Max stream number in each stream to 64.

### Fixed
- Timeout error from RX2 only profile
- RX1/RX2 streams concurrency contention issue
- GPIO debug issue


## 0.6.9 - 2021-03-01
### Fixed
- Small bump in Tx spectrum when ORx is enabled.

### Added
- Semaphore to protect GPIO debug from concurrency contention.


## 0.6.8 - 2021-02-26
### Changed
- C0: Remove phase sync from main stream.


## 0.6.7 - 2021-02-25
### Changed
- LO reconfig/PD bit position adjustment for hop mode.


## 0.6.6 - 2021-02-18
### Fixed
- RX MCS synchronization issue by not enabling and disabling QEC clocks in FH.


## 0.6.5 - 2021-02-18
### Fixed
- B0: an SPI spare register for B0 main stream used in FH.


## 0.6.4 - 2021-02-09
### Added
- Support for B0 firmware and C0 firmware.

## 0.6.4_C0    [NOTE: C0 stream is same as 0.6.3]
### Changed
- None

## 0.6.4_B0    [NOTE: B0 stream is based on 0.5.20]
### Added
- Pll2LockWait and PllPhaseSyncWait.

### Fixed
- The sequence of setting TIA profile in RX streams.
- NSS-2091: Difference in gain change behavior between LP/HP Rx ADC modes.
- The sequence of setting TIA profile in RX streams.
- NSS-2333: Force digital gain strobe in ORx streams.




## 0.6.3 - 2021-02-08   [NOTE: This version is for C0 chip only]
### Changed
- TIA and QEC profile mapping to support A/B port switch.


## 0.6.2 - 2021-02-05   [NOTE: This version is for C0 chip only]
### Fixed
- FH HOP1/2 Toggling conflict
- The sequence of setting TIA profile in RX streams.
- NSS-2091: Difference in gain change behavior between LP/HP Rx ADC modes.


## 0.6.1 - 2021-02-04   [NOTE: This version is for C0 chip only]
### Fixed
- FH Lo mapping bugfix.


## 0.6.0 - 2021-02-02   [NOTE: This version is for C0 chip only]
### Added
- Pll2LockWait and PllPhaseSyncWait.


## 0.5.21 - 2021-01-27  [NOTE: This version is for C0 chip only]
### Added
- NSS-2235 RX A/B port switch.
- NSS-2216 Dual hop support

### Fixed
- NSS-2333: Force digital gain strobe in ORx streams.


## 0.5.20 - 2021-01-18
### Fixed
- RX1 has 0 data when RX1 and RX2 are enabled at the exactly same time.


## 0.5.19 - 2021-01-14
### Added
- GPIO observation feature for debug.


## 0.5.18 - 2020-12-21
### Fixed
- NSS-2225: TDD RX1/RX2 same timing stream timeout issue.


## 0.5.17 - 2020-12-18
### Fixed
- Disable RFDC for ORx


## 0.5.16 - 2020-12-16
### Fixed
- Fix issue with interface drop for Tx long propagation delay (FH)


## 0.5.15 - 2020-12-10
### Added
- NB FIC control in ORx


## 0.5.14 - 2020-12-02
### Changed
- ORx stream does not need to check spare register for PFIR switch
- ORx global reset added


## 0.5.13 - 2020-11-25
### Fixed
- Fix issues in ORx 2 power up
- Fix issues in diversity mode

### Changed
- LO Mux power up moved to end of analog power up sequence with 240ns wait after


## 0.5.12 - 2020-11-20   (Works with FW B0_0.13.5.1/C0_0.14.3.1)
### Fixed
- A compilation issue related to ORx stream.


## 0.5.11 - 2020-11-19   (Broken. Do not use.)
### Added
- ORx support.


## 0.5.10 - 2020-11-11
### Fixed
- ORx triggering wrong arm interrupt.


## 0.5.9
### Fixed
- Don't power up TX DAC in partial power up stream 1B.
- B0 workaround to prevent bus lock up when streams poll DMA status
- Semaphore never unlocking work around

### Changed
- Ping-pong DMA B and powerdown tables added. Streams now check hop_toggle to get DMA address
- Channel streams now control frequency hopping SPI flags
- DMA in Rx streams moved to after LO buffer power up 
- 3us timeout after analog reduced to 1.5us
- Main stream only retunes LO in FH retune mode


## 0.5.8
### Fixed
- NSS-2026: Force digital gain strobe in case AGC delay enable is off.
- Temporary workaround for slicer 18 db issue.


## 0.5.7
### Fixed
- RX port A/B precompilation issue.
- Power on/off LVDS strobe/data and clock order.
- NSS-1963: Incorrect RX TIA Profile in Radio On state


## 0.5.6
### Fixed
- Stream hangup issue by increasing wait time in RX FH stream from 1 to 5.


## 0.5.5
### Fixed
- Stream hangup issue by adding WAIT 1 in RX FH stream.
- Clear RX LVDS FIFO before powering on pads.


## 0.5.4
### Fixed
- LO retune lock flag issue.


## 0.5.3
### Fixed
- NSS-1827: removed magnitude compensation PFIR control in stream.


## 0.5.2
### Changed
- Updated process for Rx/Rx hop edge handler. AFE power up is now aligned to hop edge trigger
- Removed LO output power up from main stream. Lo output power up is now sync'd with Rx power up
- Added semaphore in FH slow/normal mode if PLL retune is required at hop edge.


## 0.5.1
### Added
- NSS-1589: Implemented controls for SSIPowerDownModes.

### Changed
- Move ARM interrupt from TX stream 16 to 1E.


## 0.5.0
### Changed
- Same as 0.4.5


## 0.4.5
### Changed
- DMA locations for stream processor


## 0.4.4
### Added
- ADRV9003-1367: Added SCIC resets to prevent corrupt state during ASR modes


## 0.4.3
### Fixed
- Tx stream interrupts ARM twice in FH mode.
- Tx attenuator ramps down twice in FH mode.


## 0.4.2
### Changed
- NSS-1644: Use rxb1/2 spare_register_2 bit1 to control RX_NBF_PGOBS_DSEL


## 0.4.1
### Changed
- DLL name from Adi.Adrv9001.StreamGen to AnalogDevices.Adrv9001.StreamGen


## 0.4.0
### Added
- Implemented frequency hopping streams.
- Added stream 1D for tx1 and tx2 to power up DAC Bias.


## 0.3.8
### Changed
- Moved main stream from 0x20040000 to 0x20044000

### Fixed
- Use main stream preprocessor semaphore to fix RX QEC mutex issue.


## 0.3.7
### Changed
- NSS-1203: Use main stream to implement RX1/RX2 QEC mutual exclusion.


## 0.3.6
### Fixed
- TX I and Q data paths are unmasked at different time when TX is enabled.


## 0.3.5
### Changed
- Disable magnitude compensation PFIR to save power when RX power down.
- Move "restore TX attenuation" from TX Power up to TX power down.


## 0.3.4
### Changed
- Save and restore Tx attenuation mode and attenuation to fix stream lockup issue.


## 0.3.3
### Changed
- Change stream timeout to be longer to fix time out issue.


## 0.3.2
### Added
- Capability to dynamically switch which ADC to power up in RX power up/ down streams (Rx1/2HpAdc preprocessor directives no longer needed)

### Changed
- Moved unmasking ADC from datapath after configure algorithms streams, this might enable reduction of wait delay prior to unmasking ADC

### Removed
- `Rx1HpAdc` and `Rx2HpAdc`

### Fixed
- Error in RX2 power up procedure, datapath is now unmasked from ADC first and from interface second just as Rx1


## 0.3.1
### Changed
- Updated assembly to use new settings
- New `Adrv9001Settings` fields
    - `pllPowerUpWait` => `pllLockWait`
    - `txPowerUpWait` => `delay_80ns`

### Removed
- `Rx1CSSI` and `Rx2CSSI`

### Fixed
- Error in RX2 power up procedure, datapath is now unmasked from ADC first and from interface second just as Rx1


## 0.3.0
### Added
- New `Adrv9001Settings` fields
    - pllPowerUpWait
    - ldoPowerUpWait
    - txPowerUpWait
    - delay_1us

### Changed
- Migrated to B0
- Added global reset during RX/TX power down streams
- Incorporated changes in ADRV9003-1065 ( RX QEC related)


## 0.2.11
### Changed
- Assembly verion 1.0.0.0


## 0.2.10
### Fixed
- Error where TX2 stream proc was improperly writing to TX1 registers


## 0.2.9
### Added
- All remaining Programmable delay enables to include timing parameters
- Added conditional calls to streams that power up LDO and PLL for power savings modes
- Added interrupts at the start of TX/RX enable rise/fall streams
- Added ARM interrupts from hop streams in main stream processor
- Edited PLL retune stream to wait for 750us instead of 250us
- Added comments, if uncommented can be used for debugging, which of the DMAs and substreams executed (using bits in SW_SPARE_10 and SW_SPARE_11)


## 0.2.8
### Added
- Programmable delay between RX analog power up and unmasking interface.
- Power down upconverter in TX enable low streams

### Fixed
- PFIR is now disabled prior to PFIR bank switching and enabled after. This is to avoid seeing large glitch during switch.
- 3us delay added between RX LO buffer power up ( last analog power up instruction) and unmasking of ADC. To avoid smaller glitch seen at Rx output.
- RX QEC datapath filter reset now issued prior to unmasking ADC. This is to avoid small attenuated data section observed at RX output.
- BBDC correction is masked when Rx is off, to avoid DC being injected into the path during the flush period.


## 0.2.7
### Fixed
- SG 0.2.6 version number readback incorrectly


## 0.2.6
### Changed
- `AssembleStreamImage(string outputDir, bool ot)` changed to `AssembleStreamImageUtility(string outputDir, bool ot)`
- `void AssembleStreamImage()` changed to `byte[] AssembleStreamImage()` and returns stream binary as a byte array


## 0.2.5
### Added
- ORx enable rise/fall streams in Rx stream processor now interrupt ARM
- RX Enable Rise stream checks a spare register to know which PFIR bank to switch to

### Fixed
- Disable LP ADC clocks in RX enable low stream
- Wait timing errors. Better to use ARM clk instead of REF_CLK for small wait times as REF_CLK has upto 1us uncertainty
- Typos


## 0.2.4
### Added
- static method `Device.Version_Get`

### Fixed


## 0.2.3
### Fixed
- No longer enabling debug mode on RX interface when RX enable goes low
- Rx1 and Rx2 now both use PFIR bank A for Rx enable High
- Rx1 and Rx2 now both switch to PFIR bank D for Rx enable Low ( to force zeros out of the interface)

## 0.2.2
###	Added
- NBF_PGOBS_DSEL bit now set when switching to RX

### Fixed
- TIA and ADC profile now set appropriately for LP and HP ADCs

## 0.1.6
### Fixed
- Updated Rx1 and Rx2 stream source code to remove writes to RXQEC_RDY_GEN_ENABLE bits. Not needed in A0.
- Updated generate_stream.bat to pass templateSettings.json to compiler

## 0.1.5
### Fixed
- Typos for token substitution


## 0.1.4
### Fixed
- Generated streams no longer all 0xFF


## 0.1.3
### Changed
- Updated stream templates


## 0.1.2
### Added
- Device.AssembleStreamAndWriteToDisk

### Changed
- Adrv9001Settings members are now public

### Removed
- Adrv9001Settings_t


## 0.1.1
### Changed
- Changed namespace from AnalogDevices to AnalogDevices.StreamGen


## 0.1.0
### Added
- Preprocessor Directives for Stream binary Compiler

### Changed
- Modified "streamSize" for all stream processors
- Modified "streamBinaryBase" and "numOfStreams" for main stream processor

### Removed
- `Removed stream processor support for ADRV9010 and ADRV9025 devices`

### Fixed
- Fixed a stream generator bug
