// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       AXI AXI_ADRV9001_SSI Driver
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

#ifndef AXI_ADRV9001_SSI_REGS_H
#define AXI_ADRV9001_SSI_REGS_H

#define AXI_ADRV9001_SSI_RX_OFFSET_0 0x4000
#define AXI_ADRV9001_SSI_RX_OFFSET_1 0x5000
#define AXI_ADRV9001_SSI_TX_OFFSET_0 0x6000
#define AXI_ADRV9001_SSI_TX_OFFSET_1 0x7000
#define AXI_ADRV9001_SSI_OFFSET_0 0x4000
#define AXI_ADRV9001_SSI_OFFSET_1 0x5000
#define AXI_ADRV9001_SSI_OFFSET_2 0x6000
#define AXI_ADRV9001_SSI_OFFSET_3 0x7000
#define AXI_ADRV9001_SSI_ID_0 0x0
#define AXI_ADRV9001_SSI_ID_1 0x1
#define AXI_ADRV9001_SSI_ID_2 0x2
#define AXI_ADRV9001_SSI_ID_3 0x3
#define AXI_ADRV9001_SSI_TYPE_CMOS 0x434d4f53
#define AXI_ADRV9001_SSI_TYPE_LVDS 0x4c564453
#define AXI_ADRV9001_SSI_TYPE_GPIO 0x4750494f
#define AXI_ADRV9001_SSI_SINGLE_LANE 0x0
#define AXI_ADRV9001_SSI_MULTIPLE_LANES 0x1
#define AXI_ADRV9001_SSI_NUM_OF_BITS_02 0x0
#define AXI_ADRV9001_SSI_NUM_OF_BITS_08 0x1
#define AXI_ADRV9001_SSI_NUM_OF_BITS_16 0x2
#define AXI_ADRV9001_SSI_NUM_OF_BITS_24 0x3
#define AXI_ADRV9001_SSI_NUM_OF_BITS_32 0x4
#define AXI_ADRV9001_SSI_NUM_OF_BITS_64 0x5
#define AXI_ADRV9001_SSI_STRB_TYPE_LEVEL 0x1
#define AXI_ADRV9001_SSI_STRB_TYPE_PULSE 0x0
#define AXI_ADRV9001_SSI_MODE_CMOS 0x1
#define AXI_ADRV9001_SSI_MODE_LVDS 0x0
#define AXI_ADRV9001_SSI_CMOS_1L_PS_02X1 0x4000
#define AXI_ADRV9001_SSI_CMOS_1L_LS_02X1 0x4100
#define AXI_ADRV9001_SSI_CMOS_1L_PS_08X1 0x4010
#define AXI_ADRV9001_SSI_CMOS_1L_LS_08X1 0x4110
#define AXI_ADRV9001_SSI_CMOS_1L_PS_16X1 0x4020
#define AXI_ADRV9001_SSI_CMOS_1L_LS_16X1 0x4120
#define AXI_ADRV9001_SSI_CMOS_1L_PS_32X1 0x4040
#define AXI_ADRV9001_SSI_CMOS_1L_LS_32X1 0x4140
#define AXI_ADRV9001_SSI_CMOS_4L_PS_32X1 0x4240
#define AXI_ADRV9001_SSI_CMOS_4L_LS_32X1 0x4340
#define AXI_ADRV9001_SSI_CMOS_1L_PS_64X1 0x4050
#define AXI_ADRV9001_SSI_CMOS_1L_LS_64X1 0x4150
#define AXI_ADRV9001_SSI_CMOS_4L_PS_64X1 0x4250
#define AXI_ADRV9001_SSI_CMOS_4L_LS_64X1 0x4350
#define AXI_ADRV9001_SSI_LVDS_1L_PS_24X1 0x30
#define AXI_ADRV9001_SSI_LVDS_1L_LS_24X1 0x130
#define AXI_ADRV9001_SSI_LVDS_2L_PS_24X1 0x230
#define AXI_ADRV9001_SSI_LVDS_2L_LS_24X1 0x330
#define AXI_ADRV9001_SSI_LVDS_1L_PS_32X1 0x40
#define AXI_ADRV9001_SSI_LVDS_1L_LS_32X1 0x140
#define AXI_ADRV9001_SSI_LVDS_2L_PS_32X1 0x240
#define AXI_ADRV9001_SSI_LVDS_2L_LS_32X1 0x340
#define AXI_ADRV9001_SSI_LVDS_1L_PS_64X1 0x50
#define AXI_ADRV9001_SSI_LVDS_1L_LS_64X1 0x150
#define AXI_ADRV9001_SSI_LVDS_2L_PS_64X1 0x250
#define AXI_ADRV9001_SSI_LVDS_2L_LS_64X1 0x350
#define AXI_ADRV9001_SSI_DATA_RATE_SDR 0x1
#define AXI_ADRV9001_SSI_DATA_RATE_DDR 0x0
#define AXI_ADRV9001_SSI_BIT_ORDER_LSB_FIRST 0x1
#define AXI_ADRV9001_SSI_BIT_ORDER_MSB_FIRST 0x0
#define AXI_ADRV9001_SSI_IQ_ORDER_Q_FIRST 0x1
#define AXI_ADRV9001_SSI_IQ_ORDER_I_FIRST 0x0
#define AXI_ADRV9001_SSI_EDGE_FALLING 0x1
#define AXI_ADRV9001_SSI_EDGE_RISING 0x0
#define AXI_ADRV9001_SSI_CLK_SEL_RX 0x1
#define AXI_ADRV9001_SSI_CLK_SEL_TX 0x0
#define AXI_ADRV9001_SSI_DATA_SEL_DMA 0x0
#define AXI_ADRV9001_SSI_DATA_SEL_RX2TX_LB 0x1
#define AXI_ADRV9001_SSI_DATA_SEL_ZERO 0x2
#define AXI_ADRV9001_SSI_DATA_SEL_PATTERN 0x3
#define AXI_ADRV9001_SSI_DATA_SEL_NIBBLE_RAMP 0x4
#define AXI_ADRV9001_SSI_DATA_SEL_RAMP 0x5
#define AXI_ADRV9001_SSI_DATA_SEL_PRBS15 0x6
#define AXI_ADRV9001_SSI_DATA_SEL_PRBS7 0x7
#define AXI_ADRV9001_SSI_DATA_SEL_FS_X8 0x8
#define AXI_ADRV9001_SSI_DELAY_LANE_0 0x0
#define AXI_ADRV9001_SSI_DELAY_LANE_1 0x1
#define AXI_ADRV9001_SSI_DELAY_LANE_2 0x2
#define AXI_ADRV9001_SSI_DELAY_LANE_3 0x3
#define AXI_ADRV9001_SSI_DELAY_STROBE 0x4
#define AXI_ADRV9001_SSI_DELAY_CLOCK 0x5
#define AXI_ADRV9001_SSI_DELAY_INT_CLOCK 0x6
#define AXI_ADRV9001_SSI_DELAY_EXT_CLOCK 0x7

#define AXI_ADRV9001_SSI_REG_CMOS_LVDS_ID_ADDR 0x0000
#define AXI_ADRV9001_SSI_CMOS_LVDS_ID_ADDR 0x0000
#define AXI_ADRV9001_SSI_CMOS_LVDS_ID_POS 0
#define AXI_ADRV9001_SSI_CMOS_LVDS_ID_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_CONTROL_ADDR 0x0004
#define AXI_ADRV9001_SSI_NUM_OF_BITS_ADDR 0x0004
#define AXI_ADRV9001_SSI_NUM_OF_BITS_POS 4
#define AXI_ADRV9001_SSI_NUM_OF_BITS_MASK 0x0007
#define AXI_ADRV9001_SSI_LSTRB1_PSTRB0_ADDR 0x0004
#define AXI_ADRV9001_SSI_LSTRB1_PSTRB0_POS 8
#define AXI_ADRV9001_SSI_LSTRB1_PSTRB0_MASK 0x0001
#define AXI_ADRV9001_SSI_MLANE1_SLANE0_ADDR 0x0004
#define AXI_ADRV9001_SSI_MLANE1_SLANE0_POS 9
#define AXI_ADRV9001_SSI_MLANE1_SLANE0_MASK 0x0001
#define AXI_ADRV9001_SSI_SDR1_DDR0_ADDR 0x0004
#define AXI_ADRV9001_SSI_SDR1_DDR0_POS 10
#define AXI_ADRV9001_SSI_SDR1_DDR0_MASK 0x0001
#define AXI_ADRV9001_SSI_LSB1_MSB0_ADDR 0x0004
#define AXI_ADRV9001_SSI_LSB1_MSB0_POS 11
#define AXI_ADRV9001_SSI_LSB1_MSB0_MASK 0x0001
#define AXI_ADRV9001_SSI_Q1_I0_ADDR 0x0004
#define AXI_ADRV9001_SSI_Q1_I0_POS 12
#define AXI_ADRV9001_SSI_Q1_I0_MASK 0x0001
#define AXI_ADRV9001_SSI_FALL1_RISE0_ADDR 0x0004
#define AXI_ADRV9001_SSI_FALL1_RISE0_POS 13
#define AXI_ADRV9001_SSI_FALL1_RISE0_MASK 0x0001
#define AXI_ADRV9001_SSI_CMOS1_LVDS0_ADDR 0x0004
#define AXI_ADRV9001_SSI_CMOS1_LVDS0_POS 14
#define AXI_ADRV9001_SSI_CMOS1_LVDS0_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_IO_CONTROL_ADDR 0x0008
#define AXI_ADRV9001_SSI_CLK_SEL_ADDR 0x0008
#define AXI_ADRV9001_SSI_CLK_SEL_POS 0
#define AXI_ADRV9001_SSI_CLK_SEL_MASK 0x0001
#define AXI_ADRV9001_SSI_CLK_MSB_ADDR 0x0008
#define AXI_ADRV9001_SSI_CLK_MSB_POS 1
#define AXI_ADRV9001_SSI_CLK_MSB_MASK 0x0001
#define AXI_ADRV9001_SSI_CLK_ENB_ADDR 0x0008
#define AXI_ADRV9001_SSI_CLK_ENB_POS 2
#define AXI_ADRV9001_SSI_CLK_ENB_MASK 0x0001
#define AXI_ADRV9001_SSI_BUF_ENABLE_ADDR 0x0008
#define AXI_ADRV9001_SSI_BUF_ENABLE_POS 8
#define AXI_ADRV9001_SSI_BUF_ENABLE_MASK 0x003f

#define AXI_ADRV9001_SSI_REG_INIT_ADDR 0x000c
#define AXI_ADRV9001_SSI_INIT_ADDR 0x000c
#define AXI_ADRV9001_SSI_INIT_POS 0
#define AXI_ADRV9001_SSI_INIT_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_SS_CONTROL_ADDR 0x0010
#define AXI_ADRV9001_SSI_SS_RATIO_ADDR 0x0010
#define AXI_ADRV9001_SSI_SS_RATIO_POS 0
#define AXI_ADRV9001_SSI_SS_RATIO_MASK 0x0007
#define AXI_ADRV9001_SSI_OBS_SS_RATIO_ADDR 0x0010
#define AXI_ADRV9001_SSI_OBS_SS_RATIO_POS 4
#define AXI_ADRV9001_SSI_OBS_SS_RATIO_MASK 0x0007
#define AXI_ADRV9001_SSI_SS_MODE_ADDR 0x0010
#define AXI_ADRV9001_SSI_SS_MODE_POS 8
#define AXI_ADRV9001_SSI_SS_MODE_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_DATA_SEL_ADDR 0x0020
#define AXI_ADRV9001_SSI_DATA_SEL_ADDR 0x0020
#define AXI_ADRV9001_SSI_DATA_SEL_POS 0
#define AXI_ADRV9001_SSI_DATA_SEL_MASK 0x000f

#define AXI_ADRV9001_SSI_REG_DATA_PAT_0_ADDR 0x0030
#define AXI_ADRV9001_SSI_DATA_PAT_0_ADDR 0x0030
#define AXI_ADRV9001_SSI_DATA_PAT_0_POS 0
#define AXI_ADRV9001_SSI_DATA_PAT_0_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_DATA_PAT_1_ADDR 0x0034
#define AXI_ADRV9001_SSI_DATA_PAT_1_ADDR 0x0034
#define AXI_ADRV9001_SSI_DATA_PAT_1_POS 0
#define AXI_ADRV9001_SSI_DATA_PAT_1_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_DATA_0_ADDR 0x0040
#define AXI_ADRV9001_SSI_DATA_0_ADDR 0x0040
#define AXI_ADRV9001_SSI_DATA_0_POS 0
#define AXI_ADRV9001_SSI_DATA_0_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_DATA_1_ADDR 0x0044
#define AXI_ADRV9001_SSI_DATA_1_ADDR 0x0044
#define AXI_ADRV9001_SSI_DATA_1_POS 0
#define AXI_ADRV9001_SSI_DATA_1_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_STATUS_ADDR 0x0060
#define AXI_ADRV9001_SSI_FRM_OOS_ADDR 0x0060
#define AXI_ADRV9001_SSI_FRM_OOS_POS 0
#define AXI_ADRV9001_SSI_FRM_OOS_MASK 0x0001
#define AXI_ADRV9001_SSI_FRM_ERR_ADDR 0x0060
#define AXI_ADRV9001_SSI_FRM_ERR_POS 1
#define AXI_ADRV9001_SSI_FRM_ERR_MASK 0x0001
#define AXI_ADRV9001_SSI_MON_OOS_ADDR 0x0060
#define AXI_ADRV9001_SSI_MON_OOS_POS 2
#define AXI_ADRV9001_SSI_MON_OOS_MASK 0x0001
#define AXI_ADRV9001_SSI_MON_ERR_ADDR 0x0060
#define AXI_ADRV9001_SSI_MON_ERR_POS 3
#define AXI_ADRV9001_SSI_MON_ERR_MASK 0x0001
#define AXI_ADRV9001_SSI_LB_OVF_ADDR 0x0060
#define AXI_ADRV9001_SSI_LB_OVF_POS 8
#define AXI_ADRV9001_SSI_LB_OVF_MASK 0x0001
#define AXI_ADRV9001_SSI_LB_UNF_ADDR 0x0060
#define AXI_ADRV9001_SSI_LB_UNF_POS 9
#define AXI_ADRV9001_SSI_LB_UNF_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_ALIGN_SEL_ADDR 0x0064
#define AXI_ADRV9001_SSI_ALIGN_SEL_ADDR 0x0064
#define AXI_ADRV9001_SSI_ALIGN_SEL_POS 0
#define AXI_ADRV9001_SSI_ALIGN_SEL_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_DELAY_UNLOCKED_ADDR 0x0070
#define AXI_ADRV9001_SSI_DELAY_UNLOCKED_ADDR 0x0070
#define AXI_ADRV9001_SSI_DELAY_UNLOCKED_POS 0
#define AXI_ADRV9001_SSI_DELAY_UNLOCKED_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_DELAY_CONTROL_ADDR 0x0080
#define AXI_ADRV9001_SSI_REG_DELAY_CONTROL_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_SSI_WRDELAY_ADDR 0x0080
#define AXI_ADRV9001_SSI_WRDELAY_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_SSI_WRDELAY_POS 0
#define AXI_ADRV9001_SSI_WRDELAY_MASK 0x001f
#define AXI_ADRV9001_SSI_RDDELAY_ADDR 0x0080
#define AXI_ADRV9001_SSI_RDDELAY_ADDR_OFFSET 0x0004
#define AXI_ADRV9001_SSI_RDDELAY_POS 8
#define AXI_ADRV9001_SSI_RDDELAY_MASK 0x001f

#define AXI_ADRV9001_SSI_REG_DELAY_SWEEP_ADDR 0x00c0
#define AXI_ADRV9001_SSI_DELAY_SWEEP_ADDR 0x00c0
#define AXI_ADRV9001_SSI_DELAY_SWEEP_POS 0
#define AXI_ADRV9001_SSI_DELAY_SWEEP_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_TIMER_ADDR 0x0100
#define AXI_ADRV9001_SSI_TIMER_ADDR 0x0100
#define AXI_ADRV9001_SSI_TIMER_POS 0
#define AXI_ADRV9001_SSI_TIMER_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_CLK_MON_ADDR 0x0104
#define AXI_ADRV9001_SSI_CLK_MON_COUNT_ADDR 0x0104
#define AXI_ADRV9001_SSI_CLK_MON_COUNT_POS 0
#define AXI_ADRV9001_SSI_CLK_MON_COUNT_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_MCS_LATENCY_ADDR 0x0108
#define AXI_ADRV9001_SSI_MCS_LATENCY_COUNT_ADDR 0x0108
#define AXI_ADRV9001_SSI_MCS_LATENCY_COUNT_POS 0
#define AXI_ADRV9001_SSI_MCS_LATENCY_COUNT_MASK 0xffff
#define AXI_ADRV9001_SSI_MCS_LATENCY_BUSY_ADDR 0x0108
#define AXI_ADRV9001_SSI_MCS_LATENCY_BUSY_POS 16
#define AXI_ADRV9001_SSI_MCS_LATENCY_BUSY_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_MCS_DELAY_ADDR 0x010c
#define AXI_ADRV9001_SSI_MCS_DELAY_COUNT_ADDR 0x010c
#define AXI_ADRV9001_SSI_MCS_DELAY_COUNT_POS 0
#define AXI_ADRV9001_SSI_MCS_DELAY_COUNT_MASK 0x0007

#define AXI_ADRV9001_SSI_REG_MCS_STROBE_ADDR 0x0110
#define AXI_ADRV9001_SSI_MCS_STROBE_ADDR 0x0110
#define AXI_ADRV9001_SSI_MCS_STROBE_POS 0
#define AXI_ADRV9001_SSI_MCS_STROBE_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_MCS_DATA_ADDR 0x0114
#define AXI_ADRV9001_SSI_MCS_DATA_ADDR 0x0114
#define AXI_ADRV9001_SSI_MCS_DATA_POS 0
#define AXI_ADRV9001_SSI_MCS_DATA_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_MCS_BSTROBE_ADDR 0x0118
#define AXI_ADRV9001_SSI_MCS_BSTROBE_ADDR 0x0118
#define AXI_ADRV9001_SSI_MCS_BSTROBE_POS 0
#define AXI_ADRV9001_SSI_MCS_BSTROBE_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_MCS_BDATA_ADDR 0x011c
#define AXI_ADRV9001_SSI_MCS_BDATA_ADDR 0x011c
#define AXI_ADRV9001_SSI_MCS_BDATA_POS 0
#define AXI_ADRV9001_SSI_MCS_BDATA_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_DATA_PAT_CTL_ADDR 0x0120
#define AXI_ADRV9001_SSI_DATA_PAT_PULSE_ADDR 0x0120
#define AXI_ADRV9001_SSI_DATA_PAT_PULSE_POS 0
#define AXI_ADRV9001_SSI_DATA_PAT_PULSE_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_DATA_PAT_START_ADDR 0x0124
#define AXI_ADRV9001_SSI_DATA_PAT_START_ADDR 0x0124
#define AXI_ADRV9001_SSI_DATA_PAT_START_POS 0
#define AXI_ADRV9001_SSI_DATA_PAT_START_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_DATA_PAT_LATENCY_ADDR 0x0128
#define AXI_ADRV9001_SSI_DATA_PAT_LATENCY_ADDR 0x0128
#define AXI_ADRV9001_SSI_DATA_PAT_LATENCY_POS 0
#define AXI_ADRV9001_SSI_DATA_PAT_LATENCY_MASK 0xffffffff

#define AXI_ADRV9001_SSI_REG_MASTER_ENABLE_ADDR 0x0140
#define AXI_ADRV9001_SSI_MASTER_ENABLE_ADDR 0x0140
#define AXI_ADRV9001_SSI_MASTER_ENABLE_POS 0
#define AXI_ADRV9001_SSI_MASTER_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_OBS_MASTER_ENABLE_ADDR 0x0140
#define AXI_ADRV9001_SSI_OBS_MASTER_ENABLE_POS 1
#define AXI_ADRV9001_SSI_OBS_MASTER_ENABLE_MASK 0x0001

#define AXI_ADRV9001_SSI_REG_INTR_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_FRM_OOS_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_FRM_OOS_ENABLE_POS 0
#define AXI_ADRV9001_SSI_INTR_FRM_OOS_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_INTR_FRM_ERR_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_FRM_ERR_ENABLE_POS 1
#define AXI_ADRV9001_SSI_INTR_FRM_ERR_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_INTR_MON_OOS_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_MON_OOS_ENABLE_POS 2
#define AXI_ADRV9001_SSI_INTR_MON_OOS_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_INTR_MON_ERR_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_MON_ERR_ENABLE_POS 3
#define AXI_ADRV9001_SSI_INTR_MON_ERR_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_INTR_LB_OVF_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_LB_OVF_ENABLE_POS 8
#define AXI_ADRV9001_SSI_INTR_LB_OVF_ENABLE_MASK 0x0001
#define AXI_ADRV9001_SSI_INTR_LB_UNF_ENABLE_ADDR 0x0204
#define AXI_ADRV9001_SSI_INTR_LB_UNF_ENABLE_POS 9
#define AXI_ADRV9001_SSI_INTR_LB_UNF_ENABLE_MASK 0x0001


#endif

// **********************************************************************************
// **********************************************************************************

