## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ZCU102 IPI block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set board_id 102
set device_ref_clk_freq_mhz 199.980026

## PSU

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ zynq_ultra_ps_e && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu
apply_bd_automation -rule xilinx.com:bd_rule:zynq_ultra_ps_e \
    -config {apply_board_preset "1"} [get_bd_cells sys_cpu]
lappend ip_param_list config.psu__use__m_axi_gp0 1
lappend ip_param_list config.psu__use__m_axi_gp1 0
lappend ip_param_list config.psu__use__m_axi_gp2 1
lappend ip_param_list config.psu__maxigp2__data_width 32
lappend ip_param_list config.psu__fpga_pl0_enable 1
lappend ip_param_list config.psu__crl_apb__pl0_ref_ctrl__srcsel {rpll}
lappend ip_param_list config.psu__crl_apb__pl0_ref_ctrl__freqmhz 100
lappend ip_param_list config.psu__fpga_pl1_enable 1
lappend ip_param_list config.psu__crl_apb__pl1_ref_ctrl__srcsel {rpll}
lappend ip_param_list config.psu__crl_apb__pl1_ref_ctrl__freqmhz 300
lappend ip_param_list config.psu__fpga_pl2_enable 1
lappend ip_param_list config.psu__crl_apb__pl2_ref_ctrl__srcsel {rpll}
lappend ip_param_list config.psu__crl_apb__pl2_ref_ctrl__freqmhz 200
lappend ip_param_list config.psu__use__irq0 1
lappend ip_param_list config.psu__gpio_emio__peripheral__enable 1
lappend ip_param_list config.psu__use__m_axi_gp1 1
lappend ip_param_list config.psu__use__s_axi_gp0 1
set_property -dict $ip_param_list [get_bd_cells sys_cpu]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/pl_clk0]
connect_bd_net -net sys_delay_clk [get_bd_pins sys_cpu/pl_clk1]
connect_bd_net -net sys_dev_ref_clk [get_bd_pins sys_cpu/pl_clk2]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/maxihpm0_fpd_aclk]

## AXILite Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu_resetgen
connect_bd_net [get_bd_pins sys_cpu/pl_resetn0] [get_bd_pins sys_cpu_resetgen/ext_reset_in]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu_resetgen/slowest_sync_clk]  
connect_bd_net -net axilite_resetn [get_bd_pins sys_cpu_resetgen/peripheral_aresetn]

## AXILite Interconnect

add_axilite_cpu sys_cpu/m_axi_hpm0_fpd

## Memory (PL-DDR)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ ddr4 && is_axi == 1 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_ddr
lappend ip_param_list config.c0_clock_board_interface user_si570_sysclk
lappend ip_param_list config.c0_ddr4_board_interface ddr4_sdram
lappend ip_param_list config.reset_board_interface reset
lappend ip_param_list config.c0.ddr4_timeperiod 833
lappend ip_param_list config.c0.ddr4_inputclockperiod 3332
lappend ip_param_list config.c0.ddr4_memorypart mt40a256m16ge-075e
lappend ip_param_list config.c0.bank_group_width 1
lappend ip_param_list config.c0.ddr4_datawidth 16
lappend ip_param_list config.c0.ddr4_caslatency 18
lappend ip_param_list config.c0.ddr4_caswritelatency 12
lappend ip_param_list config.c0.ddr4_axidatawidth 128
lappend ip_param_list config.c0.ddr4_axiaddresswidth 29
lappend ip_param_list config.addn_ui_clkout1_freq_hz none
set_property -dict $ip_param_list [get_bd_cells sys_ddr]
make_bd_intf_pins_external -name pl_ddr_refclk [get_bd_intf_pins sys_ddr/c0_sys_clk]
make_bd_pins_external -name pl_ddr_reset [get_bd_pins sys_ddr/sys_rst]
make_bd_intf_pins_external -name pl_ddr [get_bd_intf_pins sys_ddr/c0_ddr4]
set_property config.freq_hz 300120000 [get_bd_intf_ports pl_ddr_refclk]
connect_bd_net -net aximm_clk [get_bd_pins sys_ddr/c0_ddr4_ui_clk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/maxihpm0_lpd_aclk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/maxihpm1_fpd_aclk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/saxihpc0_fpd_aclk]
connect_bd_net -net sys_status_1 [get_bd_pins sys_ddr/c0_init_calib_complete]

## AXIMM Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_ddr_resetgen
connect_bd_net [get_bd_pins sys_ddr/c0_ddr4_ui_clk_sync_rst] [get_bd_pins sys_ddr_resetgen/ext_reset_in]
connect_bd_net -net axilite_resetn [get_bd_pins sys_ddr_resetgen/aux_reset_in]
connect_bd_net -net aximm_clk [get_bd_pins sys_ddr_resetgen/slowest_sync_clk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_ddr_resetgen/peripheral_aresetn]
connect_bd_net -net aximm_resetn [get_bd_pins sys_ddr/c0_ddr4_aresetn]
connect_bd_net -net sys_status_0 [get_bd_pins sys_ddr_resetgen/interconnect_aresetn]

## AXIMM Interconnect

add_aximm_memory 0x80000000 sys_ddr/c0_ddr4_s_axi
add_cpu_addrmap axi_mem
add_aximm_peripheral sys_cpu/m_axi_hpm0_lpd

## Interrupts

connect_bd_net -net axilite_interrupt [get_bd_pins sys_cpu/pl_ps_irq0]

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
set_property config.num_ports 1 [get_bd_cells sys_intrs]

set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_status
set_property config.num_ports 2 [get_bd_cells sys_status]
connect_bd_net -net sys_status_0 [get_bd_pins sys_status/in0]
connect_bd_net -net sys_status_1 [get_bd_pins sys_status/in1]

## System Identifier

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.intr_width 1
lappend ip_param_list config.status_width 2
lappend ip_param_list config.gpio_in_width 7
lappend ip_param_list config.board_id $board_id
lappend ip_param_list config.memory_id $ps_ddr_size
lappend ip_param_list config.sys_version 0x2
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]  
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
connect_bd_net -net axilite_interrupt [get_bd_pins axi_sysid/axilite_sys_intr]
connect_bd_net [get_bd_pins sys_status/dout] [get_bd_pins axi_sysid/status]
connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins axi_sysid/axilite_sys_in_intr]
make_bd_pins_external -name gpio_in [get_bd_pins axi_sysid/gpio_in]
add_axilite_peripheral axi_sysid/axilite
add_cpu_addrmap axi_sysid
add_interrupt axi_sysid/axilite_intr

## PS Memory Interface

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_m1page && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_psm
connect_bd_net -net aximm_clk [get_bd_pins sys_psm/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_psm/aximm_resetn]
connect_bd_net -net axilite_clk [get_bd_pins sys_psm/clk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_psm/resetn]
connect_bd_net [get_bd_pins axi_sysid/pg_sel] [get_bd_pins sys_psm/pg_in]
connect_bd_net [get_bd_pins sys_psm/pg_out] [get_bd_pins axi_sysid/pg]

set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_psm_xc_m
set_property config.num_si 1 [get_bd_cells sys_psm_xc_m]
set_property config.num_mi 1 [get_bd_cells sys_psm_xc_m]
connect_bd_net -net aximm_clk [get_bd_pins sys_psm_xc_m/aclk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_psm_xc_m/aresetn]
connect_bd_intf_net [get_bd_intf_pins sys_cpu/m_axi_hpm1_fpd] [get_bd_intf_pins sys_psm_xc_m/s00_axi]
connect_bd_intf_net [get_bd_intf_pins sys_psm_xc_m/m00_axi] [get_bd_intf_pins sys_psm/aximm_pg]

set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_psm_xc_s
set_property config.num_si 1 [get_bd_cells sys_psm_xc_s]
set_property config.num_mi 1 [get_bd_cells sys_psm_xc_s]
connect_bd_net -net aximm_clk [get_bd_pins sys_psm_xc_s/aclk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_psm_xc_s/aresetn]
connect_bd_intf_net [get_bd_intf_pins sys_psm_xc_s/m00_axi] [get_bd_intf_pins sys_cpu/s_axi_hpc0_fpd]
connect_bd_intf_net [get_bd_intf_pins sys_psm/aximm] [get_bd_intf_pins sys_psm_xc_s/s00_axi]

add_addr_seg 0x000000000 sys_psm/aximm sys_cpu/saxigp0/hpc0_ddr_low ddr_low
add_addr_seg 0x800000000 sys_psm/aximm sys_cpu/saxigp0/hpc0_ddr_high ddr_high
add_addr_seg 0x0c0000000 sys_psm/aximm sys_cpu/saxigp0/hpc0_qspi qspi
add_addr_seg 0x0e0000000 sys_psm/aximm sys_cpu/saxigp0/hpc0_pcie_low pcie
add_addr_seg 0x0ff000000 sys_psm/aximm sys_cpu/saxigp0/hpc0_lps_ocm ocm

add_addr_map 0xb0000000 sys_cpu/m_axi_hpm1_fpd sys_psm/aximm_pg
append_cpu_addrmap 0xb0000000 0x00000000 axi_mem_pg

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

