## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       VPK120 block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

## Defaults

set ps_ddr_size 4
set board_id 120

## PSU + NoC init

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ versal_cips && upgrade_versions == ""}]
lappend ip_param_list design_flow {full system}
lappend ip_param_list board_preset yes
lappend ip_param_list debug_config jtag
lappend ip_param_list pl_clocks 3
lappend ip_param_list pl_resets 1
lappend ip_param_list mc_type lpddr
lappend ip_param_list num_mc_lpddr 1
lappend ip_param_list configure_noc {add new axi noc}
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu
apply_bd_automation -rule xilinx.com:bd_rule:cips -config $ip_param_list [get_bd_cells sys_cpu]

## PSU modifications

set ip_param_list {}
lappend ip_param_list pmc_crp_pl0_ref_ctrl_freqmhz 100
lappend ip_param_list pmc_crp_pl1_ref_ctrl_freqmhz 350
lappend ip_param_list pmc_crp_pl2_ref_ctrl_freqmhz 225
lappend ip_param_list ps_irq_usage {{CH0 1} {CH1 0}}
lappend ip_param_list ps_mio22 {{DIRECTION in} {USAGE GPIO}}
lappend ip_param_list ps_ttc1_peripheral_enable 1
lappend ip_param_list ps_ttc1_waveout {{ENABLE 1} {IO {PS_MIO 21}}}
lappend ip_param_list ps_use_m_axi_fpd 1
lappend ip_param_list ps_use_m_axi_lpd 1
set_property config.ps_pmc_config $ip_param_list [get_bd_cells sys_cpu]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/pl0_ref_clk]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/m_axi_fpd_aclk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/pl1_ref_clk]
connect_bd_net -net aximm_clk [get_bd_pins sys_cpu/m_axi_lpd_aclk]

## AXILite Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu_resetgen
connect_bd_net [get_bd_pins sys_cpu/pl0_resetn] [get_bd_pins sys_cpu_resetgen/ext_reset_in]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu_resetgen/slowest_sync_clk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_cpu_resetgen/peripheral_aresetn]

## AXIMM Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_mem_resetgen
connect_bd_net [get_bd_pins sys_cpu/pl0_resetn] [get_bd_pins sys_mem_resetgen/ext_reset_in]
connect_bd_net -net aximm_clk [get_bd_pins sys_mem_resetgen/slowest_sync_clk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_mem_resetgen/peripheral_aresetn]

## NoC modifications

set_property name sys_ddr [get_bd_cells axi_noc_0]
set_property name ps_ddr_clk [get_bd_intf_ports lpddr4_clk1]
set_property name ps_ddr_io_0 [get_bd_intf_ports ch0_lpddr4_trip1]
set_property name ps_ddr_io_1 [get_bd_intf_ports ch1_lpddr4_trip1]

set ip_param_list {}
lappend ip_param_list config.num_clks 7
lappend ip_param_list config.num_si 7
set_property -dict $ip_param_list [get_bd_cells sys_ddr]

set noc_param_list {read_bw {500}}
append noc_param_list { write_bw {500}}
append noc_param_list { read_avg_burst {4}}
append noc_param_list { write_avg_burst {4}}

set ip_param_list {}
lappend ip_param_list MC_0 $noc_param_list
set ip_param_list [list config.connections $ip_param_list]
set_property -dict $ip_param_list [get_bd_intf_pins sys_ddr/s06_axi]

connect_bd_net -net aximm_clk [get_bd_pins sys_ddr/aclk6]

## PL DDR

set noc_param_list {read_bw {400}}
append noc_param_list { write_bw {14000}}
append noc_param_list { read_avg_burst {4}}
append noc_param_list { write_avg_burst {256}}

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_noc && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_pl_ddr_0
lappend ip_param_list config.controllertype lpddr4_sdram
lappend ip_param_list config.ch0_lpddr4_0_board_interface ch0_lpddr4_trip2
lappend ip_param_list config.ch1_lpddr4_0_board_interface ch1_lpddr4_trip2
lappend ip_param_list config.sys_clk0_board_interface lpddr4_clk2
lappend ip_param_list config.mc_chan_region0 ddr_ch1
lappend ip_param_list config.mc1_flipped_pinout true
lappend ip_param_list config.mc_inputclk0_period 4992
lappend ip_param_list config.mc_memory_timeperiod0 512
lappend ip_param_list config.mc_no_channels dual
lappend ip_param_list config.num_mi 0
lappend ip_param_list config.num_si 1
lappend ip_param_list config.num_mcp 1
set_property -dict $ip_param_list [get_bd_cells sys_pl_ddr_0]

set ip_param_list {}
lappend ip_param_list MC_0 $noc_param_list
set ip_param_list [list config.connections $ip_param_list]
set_property -dict $ip_param_list [get_bd_intf_pins sys_pl_ddr_0/s00_axi]

make_bd_intf_pins_external -name pl_ddr_0_io_0 [get_bd_intf_pins sys_pl_ddr_0/ch0_lpddr4_0]
make_bd_intf_pins_external -name pl_ddr_0_io_1 [get_bd_intf_pins sys_pl_ddr_0/ch1_lpddr4_0]
make_bd_intf_pins_external -name pl_ddr_0_clk [get_bd_intf_pins sys_pl_ddr_0/sys_clk0]
connect_bd_net -net aximm_clk [get_bd_pins sys_pl_ddr_0/aclk0]

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_noc && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_pl_ddr_1
lappend ip_param_list config.controllertype lpddr4_sdram
lappend ip_param_list config.ch0_lpddr4_0_board_interface ch0_lpddr4_trip3
lappend ip_param_list config.ch1_lpddr4_0_board_interface ch1_lpddr4_trip3
lappend ip_param_list config.sys_clk0_board_interface lpddr4_clk3
lappend ip_param_list config.mc_chan_region0 ddr_ch2
lappend ip_param_list config.mc1_flipped_pinout true
lappend ip_param_list config.mc_inputclk0_period 4992
lappend ip_param_list config.mc_memory_timeperiod0 512
lappend ip_param_list config.mc_no_channels dual
lappend ip_param_list config.num_mi 0
lappend ip_param_list config.num_si 1
lappend ip_param_list config.num_mcp 1
set_property -dict $ip_param_list [get_bd_cells sys_pl_ddr_1]

set ip_param_list {}
lappend ip_param_list MC_0 $noc_param_list
set ip_param_list [list config.connections $ip_param_list]
set_property -dict $ip_param_list [get_bd_intf_pins sys_pl_ddr_1/s00_axi]

make_bd_intf_pins_external -name pl_ddr_1_io_0 [get_bd_intf_pins sys_pl_ddr_1/ch0_lpddr4_0]
make_bd_intf_pins_external -name pl_ddr_1_io_1 [get_bd_intf_pins sys_pl_ddr_1/ch1_lpddr4_0]
make_bd_intf_pins_external -name pl_ddr_1_clk [get_bd_intf_pins sys_pl_ddr_1/sys_clk0]
connect_bd_net -net aximm_clk [get_bd_pins sys_pl_ddr_1/aclk0]

## AXI Register Access

set axilite_addr 0xA4000000
set axilite_mask 0x00ffffff
add_axilite_cpu sys_cpu/m_axi_fpd

## Interrupts

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
set_property config.num_ports 1 [get_bd_cells sys_intrs]

## System Identifier

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.intr_width 1
lappend ip_param_list config.status_width 1
lappend ip_param_list config.gpio_in_width 6
lappend ip_param_list config.gpio_out_width 4
lappend ip_param_list config.board_id $board_id
lappend ip_param_list config.memory_id $ps_ddr_size
lappend ip_param_list config.sys_version 0x2
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
connect_bd_net [get_bd_pins axi_sysid/axilite_sys_intr] [get_bd_pins sys_cpu/pl_ps_irq0]
connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins axi_sysid/axilite_sys_in_intr]
make_bd_pins_external -name status [get_bd_pins axi_sysid/status]
make_bd_pins_external -name gpio_out [get_bd_pins axi_sysid/gpio_out]
make_bd_pins_external -name gpio_in [get_bd_pins axi_sysid/gpio_in]
add_axilite_peripheral axi_sysid/axilite
add_cpu_addrmap axi_sysid
add_interrupt axi_sysid/axilite_intr

## Interleave

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_m2intlv && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_m2intlv
connect_bd_net -net axilite_clk [get_bd_pins axi_m2intlv/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m2intlv/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_m2intlv/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_m2intlv/aximm_resetn]
add_axilite_peripheral axi_m2intlv/axilite
add_cpu_addrmap axi_mintlv
add_interrupt axi_m2intlv/axilite_intr

## Page

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_m1page && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_m1page
connect_bd_net -net axilite_clk [get_bd_pins axi_m1page/clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m1page/resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_m1page/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_m1page/aximm_resetn]
connect_bd_net [get_bd_pins axi_sysid/pg_sel] [get_bd_pins axi_m1page/pg_in]
connect_bd_net [get_bd_pins axi_m1page/pg_out] [get_bd_pins axi_sysid/pg]
connect_bd_intf_net [get_bd_intf_pins axi_m1page/aximm] [get_bd_intf_pins sys_ddr/s06_axi]

## Interconnect

set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_ddr_xc
set_property config.num_si 1 [get_bd_cells sys_ddr_xc]
set_property config.num_mi 2 [get_bd_cells sys_ddr_xc]
connect_bd_net -net aximm_clk [get_bd_pins sys_ddr_xc/aclk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_ddr_xc/aresetn]
connect_bd_intf_net [get_bd_intf_pins sys_cpu/m_axi_lpd] [get_bd_intf_pins sys_ddr_xc/s00_axi]
connect_bd_intf_net [get_bd_intf_pins sys_ddr_xc/m00_axi] [get_bd_intf_pins axi_m2intlv/aximm]
connect_bd_intf_net [get_bd_intf_pins sys_ddr_xc/m01_axi] [get_bd_intf_pins axi_m1page/aximm_pg]

## Samples DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rx2dma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_rx2dma
connect_bd_net -net axilite_clk [get_bd_pins axi_rx2dma/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_rx2dma/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_rx2dma/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_rx2dma/aximm_resetn]
add_axilite_peripheral axi_rx2dma/axilite
add_interrupt axi_rx2dma/axilite_intr

## Memory Interconnects

set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv pl_ddr_0_xc
create_bd_cell -type ip -vlnv $ip_vlnv pl_ddr_1_xc
set_property config.num_si 2 [get_bd_cells pl_ddr_0_xc]
set_property config.num_si 2 [get_bd_cells pl_ddr_1_xc]

connect_bd_net -net aximm_clk [get_bd_pins pl_ddr_0_xc/aclk]
connect_bd_net -net aximm_clk [get_bd_pins pl_ddr_1_xc/aclk]
connect_bd_net -net aximm_resetn [get_bd_pins pl_ddr_0_xc/aresetn]
connect_bd_net -net aximm_resetn [get_bd_pins pl_ddr_1_xc/aresetn]

connect_bd_intf_net [get_bd_intf_pins pl_ddr_0_xc/m00_axi] [get_bd_intf_pins sys_pl_ddr_0/s00_axi]
connect_bd_intf_net [get_bd_intf_pins pl_ddr_1_xc/m00_axi] [get_bd_intf_pins sys_pl_ddr_1/s00_axi]
connect_bd_intf_net [get_bd_intf_pins axi_m2intlv/aximm_0] [get_bd_intf_pins pl_ddr_0_xc/s00_axi]
connect_bd_intf_net [get_bd_intf_pins axi_rx2dma/aximm_0] [get_bd_intf_pins pl_ddr_0_xc/s01_axi]
connect_bd_intf_net [get_bd_intf_pins axi_m2intlv/aximm_1] [get_bd_intf_pins pl_ddr_1_xc/s00_axi]
connect_bd_intf_net [get_bd_intf_pins axi_rx2dma/aximm_1] [get_bd_intf_pins pl_ddr_1_xc/s01_axi]

set_property config.m_addr_0 0x0 [get_bd_cells axi_m2intlv]
set_property config.m_addr_1 0x0 [get_bd_cells axi_m2intlv]

add_cpu_addrmap axi_dma_rx_0 0x0000
add_cpu_addrmap axi_dma_rx_1 0x1000

add_addr_map 0x80000000 sys_cpu/m_axi_lpd axi_m2intlv/aximm
add_addr_map 0x90000000 sys_cpu/m_axi_lpd axi_m1page/aximm_pg
append_cpu_addrmap 0x80000000 0x00000000 axi_dmem
append_cpu_addrmap 0x90000000 0x00000000 axi_pmem
add_addr_seg 0x50000000000 axi_m2intlv/aximm_0 sys_pl_ddr_0/s00_axi/c0_ddr_ch1 intlv_0
add_addr_seg 0x60000000000 axi_m2intlv/aximm_1 sys_pl_ddr_1/s00_axi/c0_ddr_ch2 intlv_1
add_addr_seg 0x50000000000 axi_rx2dma/aximm_0 sys_pl_ddr_0/s00_axi/c0_ddr_ch1 dma_0
add_addr_seg 0x60000000000 axi_rx2dma/aximm_1 sys_pl_ddr_1/s00_axi/c0_ddr_ch2 dma_1

set_property range 4G [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_m2intlv/aximm_0]]
set_property range 4G [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_m2intlv/aximm_1]]
set_property range 4G [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_rx2dma/aximm_0]]
set_property range 4G [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_rx2dma/aximm_1]]

assign_bd_address

## ##################################################################################
## ##################################################################################

connect_bd_net [get_bd_pins sys_cpu/pl2_ref_clk] [get_bd_pins axi_rx2dma/rx_clk]

save_bd_design

## ##################################################################################
## ##################################################################################

