## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       MicroZed ADSX IO
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property -dict {PACKAGE_PIN K17     IOSTANDARD LVCMOS18}    [get_ports mzed_mosi_clk]           ;   ## P11.JX2.48   JX2_LVDS_11_P   IO_L12P_T1_MRCC_35          BH27    IO_L12P_T1U_N10_GC_67
set_property -dict {PACKAGE_PIN K18     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[0]}]     ;   ## P11.JX2.50   JX2_LVDS_11_N   IO_L12N_T1_MRCC_35          BJ27    IO_L12N_T1U_N11_GC_67
set_property -dict {PACKAGE_PIN C20     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[1]}]     ;   ## P11.JX2.17   JX2_LVDS_0_P    IO_L1P_T0_AD0P_35           BP23    IO_L1P_T0L_N0_DBC_67
set_property -dict {PACKAGE_PIN B20     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[2]}]     ;   ## P11.JX2.19   JX2_LVDS_0_N    IO_L1N_T0_AD0N_35           BP22    IO_L1N_T0L_N1_DBC_67
set_property -dict {PACKAGE_PIN B19     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[3]}]     ;   ## P11.JX2.18   JX2_LVDS_1_P    IO_L2P_T0_AD8P_35           BN26    IO_L2P_T0L_N2_67
set_property -dict {PACKAGE_PIN A20     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[4]}]     ;   ## P11.JX2.20   JX2_LVDS_1_N    IO_L2N_T0_AD8N_35           BP26    IO_L2N_T0L_N3_67
set_property -dict {PACKAGE_PIN E17     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[5]}]     ;   ## P11.JX2.23   JX2_LVDS_2_P    IO_L3P_T0_DQS_AD1P_35       BN24    IO_L3P_T0L_N4_AD15P_67
set_property -dict {PACKAGE_PIN D18     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[6]}]     ;   ## P11.JX2.25   JX2_LVDS_2_N    IO_L3N_T0_DQS_AD1N_35       BP24    IO_L3N_T0L_N5_AD15N_67
set_property -dict {PACKAGE_PIN D19     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[7]}]     ;   ## P11.JX2.24   JX2_LVDS_3_P    IO_L4P_T0_35                BM25    IO_L4P_T0U_N6_DBC_AD7P_67
set_property -dict {PACKAGE_PIN D20     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[8]}]     ;   ## P11.JX2.26   JX2_LVDS_3_N    IO_L4N_T0_35                BN25    IO_L4N_T0U_N7_DBC_AD7N_67
set_property -dict {PACKAGE_PIN E18     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[9]}]     ;   ## P11.JX2.29   JX2_LVDS_4_P    IO_L5P_T0_AD9P_35           BM24    IO_L5P_T0U_N8_AD14P_67
set_property -dict {PACKAGE_PIN E19     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[10]}]    ;   ## P11.JX2.31   JX2_LVDS_4_N    IO_L5N_T0_AD9N_35           BM23    IO_L5N_T0U_N9_AD14N_67
set_property -dict {PACKAGE_PIN F16     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[11]}]    ;   ## P11.JX2.30   JX2_LVDS_5_P    IO_L6P_T0_35                BM22    IO_L6P_T0U_N10_AD6P_67
set_property -dict {PACKAGE_PIN F17     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[12]}]    ;   ## P11.JX2.32   JX2_LVDS_5_N    IO_L6N_T0_VREF_35           BN22    IO_L6N_T0U_N11_AD6N_67
set_property -dict {PACKAGE_PIN L19     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[13]}]    ;   ## P11.JX2.35   JX2_LVDS_6_P    IO_L9P_T1_DQS_AD3P_35       BL28    IO_L7P_T1L_N0_QBC_AD13P_67
set_property -dict {PACKAGE_PIN L20     IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[14]}]    ;   ## P11.JX2.37   JX2_LVDS_6_N    IO_L9N_T1_DQS_AD3N_35       BM27    IO_L7N_T1L_N1_QBC_AD13N_67
set_property -dict {PACKAGE_PIN H16     IOSTANDARD LVCMOS18}    [get_ports mzed_miso_clk]           ;   ## P11.JX2.53   JX2_LVDS_12_P   IO_L13P_T2_MRCC_35          BH26    IO_L13P_T2L_N0_GC_QBC_67
set_property -dict {PACKAGE_PIN H17     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[0]}]     ;   ## P11.JX2.55   JX2_LVDS_12_N   IO_L13N_T2_MRCC_35          BH25    IO_L13N_T2L_N1_GC_QBC_67
set_property -dict {PACKAGE_PIN J18     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[1]}]     ;   ## P11.JX2.54   JX2_LVDS_13_P   IO_L14P_T2_AD4P_SRCC_35     BJ24    IO_L14P_T2L_N2_GC_67
set_property -dict {PACKAGE_PIN H18     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[2]}]     ;   ## P11.JX2.56   JX2_LVDS_13_N   IO_L14N_T2_AD4N_SRCC_35     BJ23    IO_L14N_T2L_N3_GC_67
set_property -dict {PACKAGE_PIN G17     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[3]}]     ;   ## P11.JX2.61   JX2_LVDS_14_P   IO_L16P_T2_35               BG28    IO_L15P_T2L_N4_AD11P_67
set_property -dict {PACKAGE_PIN G18     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[4]}]     ;   ## P11.JX2.63   JX2_LVDS_14_N   IO_L16N_T2_35               BG27    IO_L15N_T2L_N5_AD11N_67
set_property -dict {PACKAGE_PIN F19     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[5]}]     ;   ## P11.JX2.62   JX2_LVDS_15_P   IO_L15P_T2_DQS_AD12P_35     BF27    IO_L16P_T2U_N6_QBC_AD3P_67
set_property -dict {PACKAGE_PIN F20     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[6]}]     ;   ## P11.JX2.64   JX2_LVDS_15_N   IO_L15N_T2_DQS_AD12N_35     BF26    IO_L16N_T2U_N7_QBC_AD3N_67
set_property -dict {PACKAGE_PIN G19     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[7]}]     ;   ## P11.JX2.67   JX2_LVDS_16_P   IO_L18P_T2_AD13P_35         BF25    IO_L17P_T2U_N8_AD10P_67
set_property -dict {PACKAGE_PIN G20     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[8]}]     ;   ## P11.JX2.69   JX2_LVDS_16_N   IO_L18N_T2_AD13N_35         BG25    IO_L17N_T2U_N9_AD10N_67
set_property -dict {PACKAGE_PIN J20     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[9]}]     ;   ## P11.JX2.68   JX2_LVDS_17_P   IO_L17P_T2_AD5P_35          BG24    IO_L18P_T2U_N10_AD2P_67
set_property -dict {PACKAGE_PIN H20     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[10]}]    ;   ## P11.JX2.70   JX2_LVDS_17_N   IO_L17N_T2_AD5N_35          BH24    IO_L18N_T2U_N11_AD2N_67
set_property -dict {PACKAGE_PIN K14     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[11]}]    ;   ## P11.JX2.73   JX2_LVDS_18_P   IO_L20P_T3_AD6P_35          BL23    IO_L19P_T3L_N0_DBC_AD9P_67
set_property -dict {PACKAGE_PIN J14     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[12]}]    ;   ## P11.JX2.75   JX2_LVDS_18_N   IO_L20N_T3_AD6N_35          BL22    IO_L19N_T3L_N1_DBC_AD9N_67
set_property -dict {PACKAGE_PIN H15     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[13]}]    ;   ## P11.JX2.74   JX2_LVDS_19_P   IO_L19P_T3_35               BK24    IO_L20P_T3L_N2_AD1P_67
set_property -dict {PACKAGE_PIN G15     IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[14]}]    ;   ## P11.JX2.76   JX2_LVDS_19_N   IO_L19N_T3_VREF_35          BK23    IO_L20N_T3L_N3_AD1N_67
set_property -dict {PACKAGE_PIN N15     IOSTANDARD LVCMOS18}    [get_ports mzed_slave_status]       ;   ## P11.JX2.81   JX2_LVDS_20_P   IO_L21P_T3_DQS_AD14P_35     BJ22    IO_L21P_T3L_N4_AD8P_67
set_property -dict {PACKAGE_PIN N16     IOSTANDARD LVCMOS18}    [get_ports mzed_slave_errors]       ;   ## P11.JX2.83   JX2_LVDS_20_N   IO_L21N_T3_DQS_AD14N_35     BK21    IO_L21N_T3L_N5_AD8N_67

set_property -dict {PACKAGE_PIN U18     IOSTANDARD LVCMOS18}    [get_ports adsx_miso_clk]           ;   ## P10.JX1.42   JX1_LVDS_11_P   IO_L12P_T1_MRCC_34          BK33    IO_L12P_T1U_N10_GC_64
set_property -dict {PACKAGE_PIN U19     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[0]}]     ;   ## P10.JX1.44   JX1_LVDS_11_N   IO_L12N_T1_MRCC_34          BL33    IO_L12N_T1U_N11_GC_64
set_property -dict {PACKAGE_PIN T11     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[1]}]     ;   ## P10.JX1.11   JX1_LVDS_0_P    IO_L1P_T0_34                BM28    IO_L1P_T0L_N0_DBC_64
set_property -dict {PACKAGE_PIN T10     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[2]}]     ;   ## P10.JX1.13   JX1_LVDS_0_N    IO_L1N_T0_34                BM29    IO_L1N_T0L_N1_DBC_64
set_property -dict {PACKAGE_PIN P14     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[3]}]     ;   ## P10.JX1.24   JX1_LVDS_5_P    IO_L6P_T0_34                BN32    IO_L6P_T0U_N10_AD6P_64
set_property -dict {PACKAGE_PIN R14     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[4]}]     ;   ## P10.JX1.26   JX1_LVDS_5_N    IO_L6N_T0_VREF_34           BP32    IO_L6N_T0U_N11_AD6N_64
set_property -dict {PACKAGE_PIN Y16     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[5]}]     ;   ## P10.JX1.29   JX1_LVDS_6_P    IO_L7P_T1_34                BM34    IO_L7P_T1L_N0_QBC_AD13P_64
set_property -dict {PACKAGE_PIN Y17     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[6]}]     ;   ## P10.JX1.31   JX1_LVDS_6_N    IO_L7N_T1_34                BN35    IO_L7N_T1L_N1_QBC_AD13N_64
set_property -dict {PACKAGE_PIN W14     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[7]}]     ;   ## P10.JX1.30   JX1_LVDS_7_P    IO_L8P_T1_34                BN34    IO_L8P_T1L_N2_AD5P_64
set_property -dict {PACKAGE_PIN Y14     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[8]}]     ;   ## P10.JX1.32   JX1_LVDS_7_N    IO_L8N_T1_34                BP34    IO_L8N_T1L_N3_AD5N_64
set_property -dict {PACKAGE_PIN T16     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[9]}]     ;   ## P10.JX1.35   JX1_LVDS_8_P    IO_L9P_T1_DQS_34            BL32    IO_L9P_T1L_N4_AD12P_64
set_property -dict {PACKAGE_PIN U17     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[10]}]    ;   ## P10.JX1.37   JX1_LVDS_8_N    IO_L9N_T1_DQS_34            BM33    IO_L9N_T1L_N5_AD12N_64
set_property -dict {PACKAGE_PIN V15     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[11]}]    ;   ## P10.JX1.36   JX1_LVDS_9_P    IO_L10P_T1_34               BL35    IO_L10P_T1U_N6_QBC_AD4P_64
set_property -dict {PACKAGE_PIN W15     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[12]}]    ;   ## P10.JX1.38   JX1_LVDS_9_N    IO_L10N_T1_34               BM35    IO_L10N_T1U_N7_QBC_AD4N_64
set_property -dict {PACKAGE_PIN U14     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[13]}]    ;   ## P10.JX1.41   JX1_LVDS_10_P   IO_L11P_T1_SRCC_34          BK31    IO_L11P_T1U_N8_GC_64
set_property -dict {PACKAGE_PIN U15     IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[14]}]    ;   ## P10.JX1.43   JX1_LVDS_10_N   IO_L11N_T1_SRCC_34          BL31    IO_L11N_T1U_N9_GC_64
set_property -dict {PACKAGE_PIN N20     IOSTANDARD LVCMOS18}    [get_ports adsx_mosi_clk]           ;   ## P10.JX1.48   JX1_LVDS_13_P   IO_L14P_T2_SRCC_34          BJ33    IO_L14P_T2L_N2_GC_64
set_property -dict {PACKAGE_PIN P20     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[0]}]     ;   ## P10.JX1.50   JX1_LVDS_13_N   IO_L14N_T2_SRCC_34          BJ34    IO_L14N_T2L_N3_GC_64
set_property -dict {PACKAGE_PIN T20     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[1]}]     ;   ## P10.JX1.53   JX1_LVDS_14_P   IO_L15P_T2_DQS_34           BG34    IO_L15P_T2L_N4_AD11P_64
set_property -dict {PACKAGE_PIN U20     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[2]}]     ;   ## P10.JX1.55   JX1_LVDS_14_N   IO_L15N_T2_DQS_34           BG35    IO_L15N_T2L_N5_AD11N_64
set_property -dict {PACKAGE_PIN V20     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[3]}]     ;   ## P10.JX1.54   JX1_LVDS_15_P   IO_L16P_T2_34               BK34    IO_L16P_T2U_N6_QBC_AD3P_64
set_property -dict {PACKAGE_PIN W20     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[4]}]     ;   ## P10.JX1.56   JX1_LVDS_15_N   IO_L16N_T2_34               BK35    IO_L16N_T2U_N7_QBC_AD3N_64
set_property -dict {PACKAGE_PIN Y18     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[5]}]     ;   ## P10.JX1.61   JX1_LVDS_16_P   IO_L17P_T2_34               BF35    IO_L17P_T2U_N8_AD10P_64
set_property -dict {PACKAGE_PIN Y19     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[6]}]     ;   ## P10.JX1.63   JX1_LVDS_16_N   IO_L17N_T2_34               BF36    IO_L17N_T2U_N9_AD10N_64
set_property -dict {PACKAGE_PIN V16     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[7]}]     ;   ## P10.JX1.62   JX1_LVDS_17_P   IO_L18P_T2_34               BH34    IO_L18P_T2U_N10_AD2P_64
set_property -dict {PACKAGE_PIN W16     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[8]}]     ;   ## P10.JX1.64   JX1_LVDS_17_N   IO_L18N_T2_34               BH35    IO_L18N_T2U_N11_AD2N_64
set_property -dict {PACKAGE_PIN R16     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[9]}]     ;   ## P10.JX1.67   JX1_LVDS_18_P   IO_L19P_T3_34               BG29    IO_L19P_T3L_N0_DBC_AD9P_64
set_property -dict {PACKAGE_PIN R17     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[10]}]    ;   ## P10.JX1.69   JX1_LVDS_18_N   IO_L19N_T3_VREF_34          BG30    IO_L19N_T3L_N1_DBC_AD9N_64
set_property -dict {PACKAGE_PIN T17     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[11]}]    ;   ## P10.JX1.68   JX1_LVDS_19_P   IO_L20P_T3_34               BH29    IO_L20P_T3L_N2_AD1P_64
set_property -dict {PACKAGE_PIN R18     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[12]}]    ;   ## P10.JX1.70   JX1_LVDS_19_N   IO_L20N_T3_34               BH30    IO_L20N_T3L_N3_AD1N_64
set_property -dict {PACKAGE_PIN V17     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[13]}]    ;   ## P10.JX1.73   JX1_LVDS_20_P   IO_L21P_T3_DQS_34           BF31    IO_L21P_T3L_N4_AD8P_64
set_property -dict {PACKAGE_PIN V18     IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[14]}]    ;   ## P10.JX1.75   JX1_LVDS_20_N   IO_L21N_T3_DQS_34           BG32    IO_L21N_T3L_N5_AD8N_64
set_property -dict {PACKAGE_PIN W18     IOSTANDARD LVCMOS18}    [get_ports adsx_master_status]      ;   ## P10.JX1.74   JX1_LVDS_21_P   IO_L22P_T3_34               BJ29    IO_L22P_T3U_N6_DBC_AD0P_64
set_property -dict {PACKAGE_PIN W19     IOSTANDARD LVCMOS18}    [get_ports adsx_master_errors]      ;   ## P10.JX1.76   JX1_LVDS_21_N   IO_L22N_T3_34               BK30    IO_L22N_T3U_N7_DBC_AD0N_64


set_property -dict {PACKAGE_PIN T15     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_gpout]         ;   ## P10.JX1.25   JX1_LVDS_4_N    IO_L5N_T0_34                NA      CONFIG_MZ_INT, ADP5589ACPZ-02.C8 (PROGRAM_B, ADP5589ACPZ-02.C1)
set_property -dict {PACKAGE_PIN G14     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_init_b]        ;   ## P11.JX2.13   JX2_SE_0        IO_0_35                     BB15    INIT_B_0 (DS8)
set_property -dict {PACKAGE_PIN J15     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_sel]           ;   ## P11.JX2.14   JX2_SE_1        IO_25_35                    NA      CONFIG_SEL (S5)
set_property -dict {PACKAGE_PIN K16     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_done]          ;   ## P11.JX2.88   JX2_LVDS_23_P   IO_L24P_T3_AD15P_35         BB14    DONE_0, CONFIG_DONE (DS11)
set_property -dict {PACKAGE_PIN J16     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_mode]          ;   ## P11.JX2.90   JX2_LVDS_23_N   IO_L24N_T3_AD15N_35         BA15    M0_0, CONFIG_M0 (R107)
set_property -dict {PACKAGE_PIN R19     IOSTANDARD LVCMOS18}    [get_ports mzed_dcfg_cclk]          ;   ## P10.JX1.09   JX1_SE_0        IO_0_34                     BD14    CCLK_0, MICROZED_CCLK
set_property -dict {PACKAGE_PIN T19     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[0]}]    ;   ## P10.JX1.10   JX1_SE_1        IO_25_34                    AW15    D00_MOSI_0, MICROZED_D00
set_property -dict {PACKAGE_PIN T12     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[1]}]    ;   ## P10.JX1.12   JX1_LVDS_1_P    IO_L2P_T0_34                AY15    D01_DIN_0, MICROZED_D01
set_property -dict {PACKAGE_PIN U12     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[2]}]    ;   ## P10.JX1.14   JX1_LVDS_1_N    IO_L2N_T0_34                AY14    D02_0, MICROZED_D02
set_property -dict {PACKAGE_PIN U13     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[3]}]    ;   ## P10.JX1.17   JX1_LVDS_2_P    IO_L3P_T0_DQS_PUDC_B_34     AY13    D03_0, MICROZED_D03
set_property -dict {PACKAGE_PIN V13     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[4]}]    ;   ## P10.JX1.19   JX1_LVDS_2_N    IO_L3N_T0_DQS_34            BE45    IO_L22P_T3U_N6_DBC_AD0P_D04_65, MICROZED_D04
set_property -dict {PACKAGE_PIN V12     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[5]}]    ;   ## P10.JX1.18   JX1_LVDS_3_P    IO_L4P_T0_34                BE46    IO_L22N_T3U_N7_DBC_AD0N_D05_65, MICROZED_D05
set_property -dict {PACKAGE_PIN W13     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[6]}]    ;   ## P10.JX1.20   JX1_LVDS_3_N    IO_L4N_T0_34                BF42    IO_L21P_T3L_N4_AD8P_D06_65, MICROZED_D06
set_property -dict {PACKAGE_PIN T14     IOSTANDARD LVCMOS18}    [get_ports {mzed_dcfg_cdata[7]}]    ;   ## P10.JX1.23   JX1_LVDS_4_P    IO_L5P_T0_34                BF43    IO_L21N_T3L_N5_AD8N_D07_65, MICROZED_D07

set_property -dict {PACKAGE_PIN P15     IOSTANDARD LVCMOS18}    [get_ports mzed2adsx_reset]         ;   ## P10.JX1.82   JX1_LVDS_23_P   IO_L24P_T3_34               BH31    IO_L24P_T3U_N10_64
set_property -dict {PACKAGE_PIN P16     IOSTANDARD LVCMOS18}    [get_ports mzed2adsx_clk_sel]       ;   ## P10.JX1.84   JX1_LVDS_23_N   IO_L24N_T3_34               BJ31    IO_L24N_T3U_N11_64
set_property -dict {PACKAGE_PIN M19     IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_status]        ;   ## P11.JX2.36   JX2_LVDS_7_P    IO_L7P_T1_AD2P_35           BL27    IO_L8P_T1L_N2_AD5P_67
set_property -dict {PACKAGE_PIN M20     IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_loc]           ;   ## P11.JX2.38   JX2_LVDS_7_N    IO_L7N_T1_AD2N_35           BL26    IO_L8N_T1L_N3_AD5N_67
set_property -dict {PACKAGE_PIN N17     IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_intr]          ;   ## P10.JX1.81   JX1_LVDS_22_P   IO_L23P_T3_34               BF32    IO_L23P_T3U_N8_64
set_property -dict {PACKAGE_PIN M17     IOSTANDARD LVCMOS18}    [get_ports master_resetn]           ;   ## P11.JX2.41   JX2_LVDS_8_P    IO_L8P_T1_AD10P_35          BJ28    IO_L9P_T1L_N4_AD12P_67
set_property -dict {PACKAGE_PIN M18     IOSTANDARD LVCMOS18}    [get_ports slave_resetn]            ;   ## P11.JX2.43   JX2_LVDS_8_N    IO_L8N_T1_AD10N_35          BK28    IO_L9N_T1L_N5_AD12N_67

set_property -dict {PACKAGE_PIN M14     IOSTANDARD LVCMOS18}    [get_ports i2c_scl]                 ;   ## P11.JX2.87   JX2_LVDS_22_P   IO_L23P_T3_35               NA      MICROZED_SCL
set_property -dict {PACKAGE_PIN M15     IOSTANDARD LVCMOS18}    [get_ports i2c_sda]                 ;   ## P11.JX2.89   JX2_LVDS_22_N   IO_L23N_T3_35               NA      MICROZED_SDA

set_property IODELAY_GROUP axi_mzed_c2c_phy_group [get_cells -hierarchical -filter {name =~ *axi_mzed*IDELAY*}]
set_property IODELAY_GROUP axi_adsx_c2c_phy_group [get_cells -hierarchical -filter {name =~ *axi_adsx*IDELAY*}]

set_property bitstream.general.compress true [current_design]

## ##################################################################################
## ##################################################################################
