## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       MicroZed IPI block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

## PS7

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ processing_system7 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu
lappend ip_param_list CONFIG.PCW_PRESET_BANK0_VOLTAGE {LVCMOS 3.3V}
lappend ip_param_list CONFIG.PCW_PRESET_BANK1_VOLTAGE {LVCMOS 1.8V}
lappend ip_param_list CONFIG.PCW_PACKAGE_NAME {clg400}
lappend ip_param_list CONFIG.PCW_USE_M_AXI_GP0 {0}
lappend ip_param_list CONFIG.PCW_USE_M_AXI_GP1 {0}
lappend ip_param_list CONFIG.PCW_CRYSTAL_PERIPHERAL_FREQMHZ {33.333333}
lappend ip_param_list CONFIG.PCW_APU_CLK_RATIO_ENABLE {6:2:1}
lappend ip_param_list CONFIG.PCW_CPU_PERIPHERAL_CLKSRC {ARM PLL}
lappend ip_param_list CONFIG.PCW_DDR_PERIPHERAL_CLKSRC {DDR PLL}
lappend ip_param_list CONFIG.PCW_QSPI_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_ENET0_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_SDIO_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_UART_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_TTC0_CLK0_PERIPHERAL_CLKSRC {CPU_1X}
lappend ip_param_list CONFIG.PCW_TTC0_CLK1_PERIPHERAL_CLKSRC {CPU_1X}
lappend ip_param_list CONFIG.PCW_TTC0_CLK2_PERIPHERAL_CLKSRC {CPU_1X}
lappend ip_param_list CONFIG.PCW_APU_PERIPHERAL_FREQMHZ {667}
lappend ip_param_list CONFIG.PCW_UIPARAM_ACT_DDR_FREQ_MHZ {533.333333}
lappend ip_param_list CONFIG.PCW_ENET0_PERIPHERAL_FREQMHZ {1000 Mbps}
lappend ip_param_list CONFIG.PCW_SDIO_PERIPHERAL_FREQMHZ {25}
lappend ip_param_list CONFIG.PCW_QSPI_PERIPHERAL_FREQMHZ {200.000000}
lappend ip_param_list CONFIG.PCW_UART_PERIPHERAL_FREQMHZ {50}
lappend ip_param_list CONFIG.PCW_USB0_PERIPHERAL_FREQMHZ {60}
lappend ip_param_list CONFIG.PCW_TTC0_CLK0_PERIPHERAL_FREQMHZ {111.111115}
lappend ip_param_list CONFIG.PCW_TTC0_CLK1_PERIPHERAL_FREQMHZ {111.111115}
lappend ip_param_list CONFIG.PCW_TTC0_CLK2_PERIPHERAL_FREQMHZ {111.111115}
lappend ip_param_list CONFIG.PCW_FCLK0_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_FCLK1_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_FCLK2_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_FCLK3_PERIPHERAL_CLKSRC {IO PLL}
lappend ip_param_list CONFIG.PCW_FCLK_CLK0_BUF {true}
lappend ip_param_list CONFIG.PCW_FCLK_CLK1_BUF {false}
lappend ip_param_list CONFIG.PCW_FCLK_CLK2_BUF {false}
lappend ip_param_list CONFIG.PCW_FCLK_CLK3_BUF {false}
lappend ip_param_list CONFIG.PCW_FPGA0_PERIPHERAL_FREQMHZ {100}
lappend ip_param_list CONFIG.PCW_FPGA1_PERIPHERAL_FREQMHZ {100}
lappend ip_param_list CONFIG.PCW_FPGA2_PERIPHERAL_FREQMHZ {33.333333}
lappend ip_param_list CONFIG.PCW_FPGA3_PERIPHERAL_FREQMHZ {50}
lappend ip_param_list CONFIG.PCW_EN_CLK0_PORT {1}
lappend ip_param_list CONFIG.PCW_EN_CLK1_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_CLK2_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_CLK3_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_RST0_PORT {1}
lappend ip_param_list CONFIG.PCW_EN_RST1_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_RST2_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_RST3_PORT {0}
lappend ip_param_list CONFIG.PCW_EN_DDR {1}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_MEMORY_TYPE {DDR 3}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_PARTNO {MT41K256M16 RE-125}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DEVICE_CAPACITY {4096 MBits}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BUS_WIDTH {32 Bit}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BL {8}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_T_FAW {40.0}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_T_RC {48.75}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_CWL {6}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DRAM_WIDTH {16 Bits}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_T_RAS_MIN {35.0}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_SPEED_BIN {DDR3_1066F}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_CLOCK_0_LENGTH_MM {54.14}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_CLOCK_1_LENGTH_MM {54.14}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_CLOCK_2_LENGTH_MM {39.7}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_CLOCK_3_LENGTH_MM {39.7}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQ_0_LENGTH_MM {49.59}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQ_1_LENGTH_MM {51.74}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQ_2_LENGTH_MM {50.32}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQ_3_LENGTH_MM {48.55}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_0_LENGTH_MM {50.05}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_1_LENGTH_MM {50.43}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_2_LENGTH_MM {50.10}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_3_LENGTH_MM {50.01}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_TRAIN_DATA_EYE {1}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_TRAIN_WRITE_LEVEL {1}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_TRAIN_READ_GATE {1}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_TO_CLK_DELAY_0 {-0.073}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_TO_CLK_DELAY_1 {-0.072}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_TO_CLK_DELAY_2 {0.024}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_DQS_TO_CLK_DELAY_3 {0.023}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BOARD_DELAY0 {0.294}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BOARD_DELAY1 {0.298}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BOARD_DELAY2 {0.338}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_BOARD_DELAY3 {0.334}
lappend ip_param_list CONFIG.PCW_UIPARAM_DDR_USE_INTERNAL_VREF {0}
lappend ip_param_list CONFIG.PCW_QSPI_GRP_SINGLE_SS_IO {MIO 1 .. 6}
lappend ip_param_list CONFIG.PCW_USB0_RESET_IO {MIO 7}
lappend ip_param_list CONFIG.PCW_QSPI_GRP_FBCLK_IO {MIO 8}
lappend ip_param_list CONFIG.PCW_ENET0_ENET0_IO {MIO 16 .. 27}
lappend ip_param_list CONFIG.PCW_USB0_USB0_IO {MIO 28 .. 39}
lappend ip_param_list CONFIG.PCW_SD0_SD0_IO {MIO 40 .. 45}
lappend ip_param_list CONFIG.PCW_SD0_GRP_CD_IO {MIO 46}
lappend ip_param_list CONFIG.PCW_UART1_UART1_IO {MIO 48 .. 49}
lappend ip_param_list CONFIG.PCW_SD0_GRP_WP_IO {MIO 50}
lappend ip_param_list CONFIG.PCW_ENET0_GRP_MDIO_IO {MIO 52 .. 53}
lappend ip_param_list CONFIG.PCW_TTC0_TTC0_IO {EMIO}
lappend ip_param_list CONFIG.PCW_QSPI_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_QSPI_GRP_FBCLK_ENABLE {1}
lappend ip_param_list CONFIG.PCW_QSPI_GRP_SINGLE_SS_ENABLE {1}
lappend ip_param_list CONFIG.PCW_USB0_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_USB0_RESET_ENABLE {1}
lappend ip_param_list CONFIG.PCW_ENET0_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_ENET0_GRP_MDIO_ENABLE {1}
lappend ip_param_list CONFIG.PCW_ENET0_RESET_ENABLE {0}
lappend ip_param_list CONFIG.PCW_SD0_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_SD0_GRP_CD_ENABLE {1}
lappend ip_param_list CONFIG.PCW_SD0_GRP_WP_ENABLE {1}
lappend ip_param_list CONFIG.PCW_UART1_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_GPIO_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_GPIO_MIO_GPIO_ENABLE {1}
lappend ip_param_list CONFIG.PCW_GPIO_EMIO_GPIO_ENABLE {0}
lappend ip_param_list CONFIG.PCW_TTC0_PERIPHERAL_ENABLE {1}
lappend ip_param_list CONFIG.PCW_I2C_RESET_ENABLE {0}
lappend ip_param_list CONFIG.PCW_MIO_0_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_1_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_2_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_3_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_4_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_5_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_6_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_7_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_8_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_9_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_10_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_11_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_12_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_13_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_14_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_15_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_16_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_17_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_18_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_19_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_20_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_21_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_22_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_23_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_24_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_25_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_26_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_27_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_28_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_29_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_30_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_31_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_32_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_33_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_34_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_35_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_36_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_37_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_38_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_39_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_40_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_41_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_42_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_43_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_44_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_45_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_46_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_47_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_48_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_49_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_50_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_51_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_52_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_53_PULLUP {disabled}
lappend ip_param_list CONFIG.PCW_MIO_0_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_1_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_2_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_3_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_4_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_5_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_6_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_7_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_8_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_9_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_10_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_11_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_12_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_13_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_14_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_15_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_16_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_17_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_18_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_19_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_20_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_21_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_22_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_23_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_24_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_25_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_26_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_27_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_28_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_29_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_30_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_31_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_32_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_33_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_34_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_35_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_36_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_37_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_38_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_39_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_40_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_41_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_42_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_43_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_44_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_45_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_46_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_47_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_48_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_49_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_50_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_51_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_52_SLEW {slow}
lappend ip_param_list CONFIG.PCW_MIO_53_SLEW {slow}
set_property -dict $ip_param_list [get_bd_cells sys_cpu]

## Customization

set ip_param_list {}
lappend ip_param_list config.pcw_use_m_axi_gp0 1
lappend ip_param_list config.pcw_use_m_axi_gp1 1
lappend ip_param_list config.pcw_en_clk0_port 1
lappend ip_param_list config.pcw_en_rst0_port 1
lappend ip_param_list config.pcw_fpga0_peripheral_freqmhz 100
lappend ip_param_list config.pcw_en_clk1_port 1
lappend ip_param_list config.pcw_fpga1_peripheral_freqmhz 200
lappend ip_param_list config.pcw_use_fabric_interrupt 1
lappend ip_param_list config.pcw_irq_f2p_intr 1
lappend ip_param_list config.pcw_i2c0_peripheral_enable 1
lappend ip_param_list config.pcw_use_s_axi_hp0 1
lappend ip_param_list config.pcw_s_axi_hp0_data_width 32
set_property -dict $ip_param_list [get_bd_cells sys_cpu]
make_bd_intf_pins_external -name ps7_ddr [get_bd_intf_pins sys_cpu/ddr]
make_bd_intf_pins_external -name ps7_i2c [get_bd_intf_pins sys_cpu/iic_0]
make_bd_intf_pins_external -name ps7_io [get_bd_intf_pins sys_cpu/fixed_io]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/fclk_clk0]
connect_bd_net -net sys_200m_clk [get_bd_pins sys_cpu/fclk_clk1]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/m_axi_gp0_aclk]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/m_axi_gp1_aclk]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu/s_axi_hp0_aclk]

## AXILite Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_cpu_resetgen
connect_bd_net [get_bd_pins sys_cpu/fclk_reset0_n] [get_bd_pins sys_cpu_resetgen/ext_reset_in]
connect_bd_net -net axilite_clk [get_bd_pins sys_cpu_resetgen/slowest_sync_clk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_cpu_resetgen/peripheral_aresetn]

## AXILite Interconnect

add_axilite_cpu sys_cpu/m_axi_gp0

## inter-device control

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_dcntrl && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dcntrl
connect_bd_net -net axilite_resetn [get_bd_pins axi_dcntrl/axilite_resetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_dcntrl/axilite_clk]
set axilite_addr 0x40000000
add_axilite_peripheral axi_dcntrl/axilite_s
add_cpu_addrmap axi_mzed_main
make_bd_pins_external -name adsx2mzed_status [get_bd_pins axi_dcntrl/dev_status]
make_bd_pins_external -name mzed_slave_status [get_bd_pins axi_dcntrl/slave_status]
make_bd_pins_external -name adsx_master_resetn [get_bd_pins axi_dcntrl/remote_master_resetn]
make_bd_pins_external -name mzed_slave_resetn [get_bd_pins axi_dcntrl/slave_resetn]

## inter-device interface (mzed-master)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_chip2chip && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_mzed
lappend ip_param_list config.c_master_fpga 1
lappend ip_param_list config.c_common_clk 0
lappend ip_param_list config.c_include_axilite 1
lappend ip_param_list config.c_interface_mode 1
lappend ip_param_list config.c_use_diff_clk false
lappend ip_param_list config.c_use_diff_io false
set_property -dict $ip_param_list [get_bd_cells axi_mzed]
make_bd_pins_external -name mzed_miso_clk [get_bd_pins axi_mzed/axi_c2c_selio_rx_clk_in]
make_bd_pins_external -name mzed_miso_data [get_bd_pins axi_mzed/axi_c2c_selio_rx_data_in]
make_bd_pins_external -name mzed_mosi_clk [get_bd_pins axi_mzed/axi_c2c_selio_tx_clk_out]
make_bd_pins_external -name mzed_mosi_data [get_bd_pins axi_mzed/axi_c2c_selio_tx_data_out]
make_bd_pins_external -name mzed_master_status [get_bd_pins axi_mzed/axi_c2c_link_status_out]
make_bd_pins_external -name mzed_master_errors [get_bd_pins axi_mzed/axi_c2c_multi_bit_error_out]
connect_bd_net [get_bd_pins axi_mzed/axi_c2c_link_status_out] [get_bd_pins axi_dcntrl/master_status]
connect_bd_net [get_bd_pins axi_dcntrl/master_resetn] [get_bd_pins axi_mzed/s_aresetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_mzed/s_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_mzed/s_axi_lite_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_mzed/axi_c2c_phy_clk]
connect_bd_net -net sys_200m_clk [get_bd_pins axi_mzed/idelay_ref_clk]
connect_bd_intf_net [get_bd_intf_pins axi_dcntrl/axilite_m] [get_bd_intf_pins axi_mzed/s_axi_lite]
add_addr_map 0x00000000 axi_dcntrl/axilite_m axi_mzed/s_axi_lite
set_property range 16M [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_dcntrl/axilite_m]]
set_property config.freq_hz 100000000 [get_bd_ports mzed_miso_clk]

## inter-device interface (mzed-slave)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_chip2chip && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adsx
lappend ip_param_list config.c_master_fpga 0
lappend ip_param_list config.c_common_clk 0
lappend ip_param_list config.c_include_axilite 2
lappend ip_param_list config.c_interface_mode 1
lappend ip_param_list config.c_m_axi_id_width 0
lappend ip_param_list config.c_m_axi_wuser_width 0
lappend ip_param_list config.c_use_diff_clk false
lappend ip_param_list config.c_use_diff_io false
set_property -dict $ip_param_list [get_bd_cells axi_adsx]
make_bd_pins_external -name adsx_mosi_clk [get_bd_pins axi_adsx/axi_c2c_selio_rx_clk_in]
make_bd_pins_external -name adsx_mosi_data [get_bd_pins axi_adsx/axi_c2c_selio_rx_data_in]
make_bd_pins_external -name adsx_miso_clk [get_bd_pins axi_adsx/axi_c2c_selio_tx_clk_out]
make_bd_pins_external -name adsx_miso_data [get_bd_pins axi_adsx/axi_c2c_selio_tx_data_out]
make_bd_pins_external -name adsx_slave_status [get_bd_pins axi_adsx/axi_c2c_link_status_out]
make_bd_pins_external -name adsx_slave_errors [get_bd_pins axi_adsx/axi_c2c_multi_bit_error_out]
connect_bd_net [get_bd_pins axi_dcntrl/remote_slave_resetn] [get_bd_pins axi_adsx/m_aresetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx/m_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx/m_axi_lite_aclk]
connect_bd_net -net sys_200m_clk [get_bd_pins axi_adsx/idelay_ref_clk]

## adsx-sink (mzed-slave)

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_gpio && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adsx_gpio
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx_gpio/s_axi_aclk]
connect_bd_net [get_bd_pins axi_dcntrl/slave_resetn] [get_bd_pins axi_adsx_gpio/s_axi_aresetn]
connect_bd_intf_net [get_bd_intf_pins axi_adsx/m_axi_lite] [get_bd_intf_pins axi_adsx_gpio/s_axi]
make_bd_intf_pins_external -name adsx_gpio [get_bd_intf_pins axi_adsx_gpio/gpio]
add_addr_map 0x0 axi_adsx/m_axi_lite axi_adsx_gpio/s_axi

## Interrupts

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
set_property config.num_ports 1 [get_bd_cells sys_intrs]

## System Identifier

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.intr_width 1
lappend ip_param_list config.status_width 8
lappend ip_param_list config.control_width 2
lappend ip_param_list config.gpio_in_width 2
lappend ip_param_list config.gpio_out_width 2
lappend ip_param_list config.board_id 7010
lappend ip_param_list config.memory_id 1
lappend ip_param_list config.sys_version 0x2
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
make_bd_pins_external -name sysid_status [get_bd_pins axi_sysid/status]
make_bd_pins_external -name sysid_gpio_out [get_bd_pins axi_sysid/gpio_out]
make_bd_pins_external -name sysid_gpio_in [get_bd_pins axi_sysid/gpio_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
connect_bd_net -net axilite_interrupt [get_bd_pins axi_sysid/axilite_sys_intr]
connect_bd_net [get_bd_pins axi_sysid/axilite_sys_intr] [get_bd_pins sys_cpu/irq_f2p]
connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins axi_sysid/axilite_sys_in_intr]
connect_bd_net [get_bd_pins axi_sysid/control] [get_bd_pins axi_dcntrl/control_in]
connect_bd_net [get_bd_pins axi_sysid/pg_sel] [get_bd_pins axi_dcntrl/pg_in]
set axilite_addr [expr (0x41000000 - 0x10000)]
add_axilite_peripheral axi_sysid/axilite
add_cpu_addrmap axi_mzed_sysid
add_interrupt axi_sysid/axilite_intr

## Transmit DMA (device configuration)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_txdma
set_property config.aximm_dw 32 [get_bd_cells axi_txdma]
set_property config.axis_dw 8 [get_bd_cells axi_txdma]
set_property config.axis_sw 1 [get_bd_cells axi_txdma]
connect_bd_net -net axilite_clk [get_bd_pins axi_txdma/tx_clk]
connect_bd_net -net axilite_clk [get_bd_pins axi_txdma/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_txdma/axilite_resetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_txdma/aximm_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_txdma/aximm_resetn]
connect_bd_net [get_bd_pins axi_txdma/tx_mtrig_out] [get_bd_pins axi_txdma/tx_mtrig_in]
add_axilite_peripheral axi_txdma/axilite
add_cpu_addrmap axi_mzed_txdma
add_interrupt axi_txdma/axilite_intr

## Device Configuration

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_dcfg && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dcfg
connect_bd_net -net axilite_clk [get_bd_pins axi_dcfg/dcfg_clk]
connect_bd_net -net axilite_clk [get_bd_pins axi_dcfg/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dcfg/axilite_resetn]
connect_bd_net [get_bd_pins axi_dcfg/trig] [get_bd_pins axi_txdma/trig]
connect_bd_net [get_bd_pins axi_dcfg/dcfg_resetn] [get_bd_pins axi_txdma/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_dcfg/dcfg] [get_bd_intf_pins axi_txdma/tx]
make_bd_pins_external -name mzed_dcfg_sel [get_bd_pins axi_dcfg/dcfg_sel]
make_bd_pins_external -name mzed_dcfg_mode [get_bd_pins axi_dcfg/dcfg_mode]
make_bd_pins_external -name mzed_dcfg_init_b [get_bd_pins axi_dcfg/dcfg_init_b]
make_bd_pins_external -name mzed_dcfg_done [get_bd_pins axi_dcfg/dcfg_done]
make_bd_pins_external -name mzed_dcfg_cclk [get_bd_pins axi_dcfg/dcfg_cclk]
make_bd_pins_external -name mzed_dcfg_cdata [get_bd_pins axi_dcfg/dcfg_cdata]
make_bd_pins_external -name mzed_dcfg_gpout [get_bd_pins axi_dcfg/dcfg_gpout]
connect_bd_net [get_bd_ports mzed_dcfg_done] [get_bd_pins axi_dcntrl/cfg_status]
add_axilite_peripheral axi_dcfg/axilite
add_cpu_addrmap axi_mzed_dcfg
add_interrupt axi_dcfg/axilite_intr

## Memory Page (ps7 and dcfg)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_m2page && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_m2page
lappend ip_param_list config.aw 29
lappend ip_param_list config.dw 32
lappend ip_param_list config.sw 4
set_property -dict $ip_param_list [get_bd_cells axi_m2page]
set_property config.m_addr_1 0x20000000 [get_bd_cells axi_m2page]
connect_bd_net -net axilite_clk [get_bd_pins axi_m2page/clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m2page/resetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_m2page/aximm_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m2page/aximm_resetn]
connect_bd_net [get_bd_pins axi_dcntrl/pg_out] [get_bd_pins axi_m2page/pg_in]
connect_bd_net [get_bd_pins axi_m2page/pg_out] [get_bd_pins axi_sysid/pg]
connect_bd_intf_net [get_bd_intf_pins axi_m2page/aximm_0] [get_bd_intf_pins axi_mzed/s_axi]

## Memory Interconnect (ps7-master)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_aximm_xc_0
lappend ip_param_list config.num_si 1
lappend ip_param_list config.num_mi 1
set_property -dict $ip_param_list [get_bd_cells sys_aximm_xc_0]
connect_bd_net -net axilite_clk [get_bd_pins sys_aximm_xc_0/aclk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_aximm_xc_0/aresetn]
connect_bd_intf_net [get_bd_intf_pins sys_cpu/m_axi_gp1] [get_bd_intf_pins sys_aximm_xc_0/s00_axi]
connect_bd_intf_net [get_bd_intf_pins sys_aximm_xc_0/m00_axi] [get_bd_intf_pins axi_m2page/aximm_pg]

## Memory Interconnect (ps7-slave)

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_aximm_xc_1
lappend ip_param_list config.num_si 3
lappend ip_param_list config.num_mi 1
set_property -dict $ip_param_list [get_bd_cells sys_aximm_xc_1]
connect_bd_net -net axilite_clk [get_bd_pins sys_aximm_xc_1/aclk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_aximm_xc_1/aresetn]
connect_bd_intf_net [get_bd_intf_pins sys_aximm_xc_1/m00_axi] [get_bd_intf_pins sys_cpu/s_axi_hp0]
connect_bd_intf_net [get_bd_intf_pins axi_m2page/aximm_1] [get_bd_intf_pins sys_aximm_xc_1/s00_axi]
connect_bd_intf_net [get_bd_intf_pins axi_txdma/aximm] [get_bd_intf_pins sys_aximm_xc_1/s01_axi]
connect_bd_intf_net [get_bd_intf_pins axi_adsx/m_axi] [get_bd_intf_pins sys_aximm_xc_1/s02_axi]

## MM Addressing

add_addr_map 0x80000000 sys_cpu/m_axi_gp1 axi_m2page/aximm_pg
add_addr_map 0x00000000 axi_m2page/aximm_0 axi_mzed/s_axi
add_addr_map 0x00000000 axi_m2page/aximm_1 sys_cpu/s_axi_hp0
add_addr_map 0x00000000 axi_txdma/aximm sys_cpu/s_axi_hp0
add_addr_map 0x00000000 axi_adsx/m_axi sys_cpu/s_axi_hp0
set_property range 512M [get_bd_addr_segs -of_objects [get_bd_intf_pins axi_m2page/aximm_0]]

## ADSX Interrupt

set_property config.intr_width 4 [get_bd_cells axi_sysid]
set_property config.num_ports 4 [get_bd_cells sys_intrs]
make_bd_pins_external -name adsx2mzed_intr [get_bd_pins sys_intrs/in3]

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

