## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       Common block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
set_property config.num_ports 1 [get_bd_cells sys_intrs]

set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_status
set_property config.num_ports 2 [get_bd_cells sys_status]
connect_bd_net -net sys_status_0 [get_bd_pins sys_status/in0]
connect_bd_net -net sys_status_1 [get_bd_pins sys_status/in1]

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.intr_width 1
lappend ip_param_list config.status_width 2
lappend ip_param_list config.gpio_in_width 7
lappend ip_param_list config.board_id $board_id
lappend ip_param_list config.memory_id $ps_ddr_size
lappend ip_param_list config.sys_version 0x2
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]  
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
connect_bd_net -net axilite_interrupt [get_bd_pins axi_sysid/axilite_sys_intr]
connect_bd_net [get_bd_pins sys_status/dout] [get_bd_pins axi_sysid/status]
connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins axi_sysid/axilite_sys_in_intr]
make_bd_pins_external -name gpio_in [get_bd_pins axi_sysid/gpio_in]
add_axilite_peripheral axi_sysid/axilite
add_cpu_addrmap axi_sysid
add_interrupt axi_sysid/axilite_intr

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

