## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       MicroZed ADSX IO
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property -dict {PACKAGE_PIN BH27    IOSTANDARD LVCMOS18}    [get_ports mzed_mosi_clk]           ;   ## P11.JX2.48   JX2_LVDS_11_P   IO_L12P_T1U_N10_GC_67       K17     IO_L12P_T1_MRCC_35
set_property -dict {PACKAGE_PIN BJ27    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[0]}]     ;   ## P11.JX2.50   JX2_LVDS_11_N   IO_L12N_T1U_N11_GC_67       K18     IO_L12N_T1_MRCC_35
set_property -dict {PACKAGE_PIN BP23    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[1]}]     ;   ## P11.JX2.17   JX2_LVDS_0_P    IO_L1P_T0L_N0_DBC_67        C20     IO_L1P_T0_AD0P_35
set_property -dict {PACKAGE_PIN BP22    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[2]}]     ;   ## P11.JX2.19   JX2_LVDS_0_N    IO_L1N_T0L_N1_DBC_67        B20     IO_L1N_T0_AD0N_35
set_property -dict {PACKAGE_PIN BN26    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[3]}]     ;   ## P11.JX2.18   JX2_LVDS_1_P    IO_L2P_T0L_N2_67            B19     IO_L2P_T0_AD8P_35
set_property -dict {PACKAGE_PIN BP26    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[4]}]     ;   ## P11.JX2.20   JX2_LVDS_1_N    IO_L2N_T0L_N3_67            A20     IO_L2N_T0_AD8N_35
set_property -dict {PACKAGE_PIN BN24    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[5]}]     ;   ## P11.JX2.23   JX2_LVDS_2_P    IO_L3P_T0L_N4_AD15P_67      E17     IO_L3P_T0_DQS_AD1P_35
set_property -dict {PACKAGE_PIN BP24    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[6]}]     ;   ## P11.JX2.25   JX2_LVDS_2_N    IO_L3N_T0L_N5_AD15N_67      D18     IO_L3N_T0_DQS_AD1N_35
set_property -dict {PACKAGE_PIN BM25    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[7]}]     ;   ## P11.JX2.24   JX2_LVDS_3_P    IO_L4P_T0U_N6_DBC_AD7P_67   D19     IO_L4P_T0_35
set_property -dict {PACKAGE_PIN BN25    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[8]}]     ;   ## P11.JX2.26   JX2_LVDS_3_N    IO_L4N_T0U_N7_DBC_AD7N_67   D20     IO_L4N_T0_35
set_property -dict {PACKAGE_PIN BM24    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[9]}]     ;   ## P11.JX2.29   JX2_LVDS_4_P    IO_L5P_T0U_N8_AD14P_67      E18     IO_L5P_T0_AD9P_35
set_property -dict {PACKAGE_PIN BM23    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[10]}]    ;   ## P11.JX2.31   JX2_LVDS_4_N    IO_L5N_T0U_N9_AD14N_67      E19     IO_L5N_T0_AD9N_35
set_property -dict {PACKAGE_PIN BM22    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[11]}]    ;   ## P11.JX2.30   JX2_LVDS_5_P    IO_L6P_T0U_N10_AD6P_67      F16     IO_L6P_T0_35
set_property -dict {PACKAGE_PIN BN22    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[12]}]    ;   ## P11.JX2.32   JX2_LVDS_5_N    IO_L6N_T0U_N11_AD6N_67      F17     IO_L6N_T0_VREF_35
set_property -dict {PACKAGE_PIN BL28    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[13]}]    ;   ## P11.JX2.35   JX2_LVDS_6_P    IO_L7P_T1L_N0_QBC_AD13P_67  L19     IO_L9P_T1_DQS_AD3P_35
set_property -dict {PACKAGE_PIN BM27    IOSTANDARD LVCMOS18}    [get_ports {mzed_mosi_data[14]}]    ;   ## P11.JX2.37   JX2_LVDS_6_N    IO_L7N_T1L_N1_QBC_AD13N_67  L20     IO_L9N_T1_DQS_AD3N_35
set_property -dict {PACKAGE_PIN BH26    IOSTANDARD LVCMOS18}    [get_ports mzed_miso_clk]           ;   ## P11.JX2.53   JX2_LVDS_12_P   IO_L13P_T2L_N0_GC_QBC_67    H16     IO_L13P_T2_MRCC_35
set_property -dict {PACKAGE_PIN BH25    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[0]}]     ;   ## P11.JX2.55   JX2_LVDS_12_N   IO_L13N_T2L_N1_GC_QBC_67    H17     IO_L13N_T2_MRCC_35
set_property -dict {PACKAGE_PIN BJ24    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[1]}]     ;   ## P11.JX2.54   JX2_LVDS_13_P   IO_L14P_T2L_N2_GC_67        J18     IO_L14P_T2_AD4P_SRCC_35     
set_property -dict {PACKAGE_PIN BJ23    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[2]}]     ;   ## P11.JX2.56   JX2_LVDS_13_N   IO_L14N_T2L_N3_GC_67        H18     IO_L14N_T2_AD4N_SRCC_35     
set_property -dict {PACKAGE_PIN BG28    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[3]}]     ;   ## P11.JX2.61   JX2_LVDS_14_P   IO_L15P_T2L_N4_AD11P_67     G17     IO_L16P_T2_35               
set_property -dict {PACKAGE_PIN BG27    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[4]}]     ;   ## P11.JX2.63   JX2_LVDS_14_N   IO_L15N_T2L_N5_AD11N_67     G18     IO_L16N_T2_35               
set_property -dict {PACKAGE_PIN BF27    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[5]}]     ;   ## P11.JX2.62   JX2_LVDS_15_P   IO_L16P_T2U_N6_QBC_AD3P_67  F19     IO_L15P_T2_DQS_AD12P_35     
set_property -dict {PACKAGE_PIN BF26    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[6]}]     ;   ## P11.JX2.64   JX2_LVDS_15_N   IO_L16N_T2U_N7_QBC_AD3N_67  F20     IO_L15N_T2_DQS_AD12N_35     
set_property -dict {PACKAGE_PIN BF25    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[7]}]     ;   ## P11.JX2.67   JX2_LVDS_16_P   IO_L17P_T2U_N8_AD10P_67     G19     IO_L18P_T2_AD13P_35         
set_property -dict {PACKAGE_PIN BG25    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[8]}]     ;   ## P11.JX2.69   JX2_LVDS_16_N   IO_L17N_T2U_N9_AD10N_67     G20     IO_L18N_T2_AD13N_35         
set_property -dict {PACKAGE_PIN BG24    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[9]}]     ;   ## P11.JX2.68   JX2_LVDS_17_P   IO_L18P_T2U_N10_AD2P_67     J20     IO_L17P_T2_AD5P_35          
set_property -dict {PACKAGE_PIN BH24    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[10]}]    ;   ## P11.JX2.70   JX2_LVDS_17_N   IO_L18N_T2U_N11_AD2N_67     H20     IO_L17N_T2_AD5N_35          
set_property -dict {PACKAGE_PIN BL23    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[11]}]    ;   ## P11.JX2.73   JX2_LVDS_18_P   IO_L19P_T3L_N0_DBC_AD9P_67  K14     IO_L20P_T3_AD6P_35          
set_property -dict {PACKAGE_PIN BL22    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[12]}]    ;   ## P11.JX2.75   JX2_LVDS_18_N   IO_L19N_T3L_N1_DBC_AD9N_67  J14     IO_L20N_T3_AD6N_35          
set_property -dict {PACKAGE_PIN BK24    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[13]}]    ;   ## P11.JX2.74   JX2_LVDS_19_P   IO_L20P_T3L_N2_AD1P_67      H15     IO_L19P_T3_35               
set_property -dict {PACKAGE_PIN BK23    IOSTANDARD LVCMOS18}    [get_ports {mzed_miso_data[14]}]    ;   ## P11.JX2.76   JX2_LVDS_19_N   IO_L20N_T3L_N3_AD1N_67      G15     IO_L19N_T3_VREF_35          
set_property -dict {PACKAGE_PIN BJ22    IOSTANDARD LVCMOS18}    [get_ports mzed_slave_status]       ;   ## P11.JX2.81   JX2_LVDS_20_P   IO_L21P_T3L_N4_AD8P_67      N15     IO_L21P_T3_DQS_AD14P_35     
set_property -dict {PACKAGE_PIN BK21    IOSTANDARD LVCMOS18}    [get_ports mzed_slave_errors]       ;   ## P11.JX2.83   JX2_LVDS_20_N   IO_L21N_T3L_N5_AD8N_67      N16     IO_L21N_T3_DQS_AD14N_35     

set_property -dict {PACKAGE_PIN BK33    IOSTANDARD LVCMOS18}    [get_ports adsx_miso_clk]           ;   ## P10.JX1.42   JX1_LVDS_11_P   IO_L12P_T1U_N10_GC_64       U18     IO_L12P_T1_MRCC_34
set_property -dict {PACKAGE_PIN BL33    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[0]}]     ;   ## P10.JX1.44   JX1_LVDS_11_N   IO_L12N_T1U_N11_GC_64       U19     IO_L12N_T1_MRCC_34
set_property -dict {PACKAGE_PIN BM28    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[1]}]     ;   ## P10.JX1.11   JX1_LVDS_0_P    IO_L1P_T0L_N0_DBC_64        T11     IO_L1P_T0_34
set_property -dict {PACKAGE_PIN BM29    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[2]}]     ;   ## P10.JX1.13   JX1_LVDS_0_N    IO_L1N_T0L_N1_DBC_64        T10     IO_L1N_T0_34
set_property -dict {PACKAGE_PIN BN32    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[3]}]     ;   ## P10.JX1.24   JX1_LVDS_5_P    IO_L6P_T0U_N10_AD6P_64      P14     IO_L6P_T0_34
set_property -dict {PACKAGE_PIN BP32    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[4]}]     ;   ## P10.JX1.26   JX1_LVDS_5_N    IO_L6N_T0U_N11_AD6N_64      R14     IO_L6N_T0_VREF_34
set_property -dict {PACKAGE_PIN BM34    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[5]}]     ;   ## P10.JX1.29   JX1_LVDS_6_P    IO_L7P_T1L_N0_QBC_AD13P_64  Y16     IO_L7P_T1_34
set_property -dict {PACKAGE_PIN BN35    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[6]}]     ;   ## P10.JX1.31   JX1_LVDS_6_N    IO_L7N_T1L_N1_QBC_AD13N_64  Y17     IO_L7N_T1_34
set_property -dict {PACKAGE_PIN BN34    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[7]}]     ;   ## P10.JX1.30   JX1_LVDS_7_P    IO_L8P_T1L_N2_AD5P_64       W14     IO_L8P_T1_34
set_property -dict {PACKAGE_PIN BP34    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[8]}]     ;   ## P10.JX1.32   JX1_LVDS_7_N    IO_L8N_T1L_N3_AD5N_64       Y14     IO_L8N_T1_34
set_property -dict {PACKAGE_PIN BL32    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[9]}]     ;   ## P10.JX1.35   JX1_LVDS_8_P    IO_L9P_T1L_N4_AD12P_64      T16     IO_L9P_T1_DQS_34
set_property -dict {PACKAGE_PIN BM33    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[10]}]    ;   ## P10.JX1.37   JX1_LVDS_8_N    IO_L9N_T1L_N5_AD12N_64      U17     IO_L9N_T1_DQS_34
set_property -dict {PACKAGE_PIN BL35    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[11]}]    ;   ## P10.JX1.36   JX1_LVDS_9_P    IO_L10P_T1U_N6_QBC_AD4P_64  V15     IO_L10P_T1_34
set_property -dict {PACKAGE_PIN BM35    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[12]}]    ;   ## P10.JX1.38   JX1_LVDS_9_N    IO_L10N_T1U_N7_QBC_AD4N_64  W15     IO_L10N_T1_34
set_property -dict {PACKAGE_PIN BK31    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[13]}]    ;   ## P10.JX1.41   JX1_LVDS_10_P   IO_L11P_T1U_N8_GC_64        U14     IO_L11P_T1_SRCC_34
set_property -dict {PACKAGE_PIN BL31    IOSTANDARD LVCMOS18}    [get_ports {adsx_miso_data[14]}]    ;   ## P10.JX1.43   JX1_LVDS_10_N   IO_L11N_T1U_N9_GC_64        U15     IO_L11N_T1_SRCC_34
set_property -dict {PACKAGE_PIN BJ33    IOSTANDARD LVCMOS18}    [get_ports adsx_mosi_clk]           ;   ## P10.JX1.48   JX1_LVDS_13_P   IO_L14P_T2L_N2_GC_64        N20     IO_L14P_T2_SRCC_34
set_property -dict {PACKAGE_PIN BJ34    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[0]}]     ;   ## P10.JX1.50   JX1_LVDS_13_N   IO_L14N_T2L_N3_GC_64        P20     IO_L14N_T2_SRCC_34
set_property -dict {PACKAGE_PIN BG34    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[1]}]     ;   ## P10.JX1.53   JX1_LVDS_14_P   IO_L15P_T2L_N4_AD11P_64     T20     IO_L15P_T2_DQS_34
set_property -dict {PACKAGE_PIN BG35    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[2]}]     ;   ## P10.JX1.55   JX1_LVDS_14_N   IO_L15N_T2L_N5_AD11N_64     U20     IO_L15N_T2_DQS_34
set_property -dict {PACKAGE_PIN BK34    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[3]}]     ;   ## P10.JX1.54   JX1_LVDS_15_P   IO_L16P_T2U_N6_QBC_AD3P_64  V20     IO_L16P_T2_34
set_property -dict {PACKAGE_PIN BK35    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[4]}]     ;   ## P10.JX1.56   JX1_LVDS_15_N   IO_L16N_T2U_N7_QBC_AD3N_64  W20     IO_L16N_T2_34
set_property -dict {PACKAGE_PIN BF35    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[5]}]     ;   ## P10.JX1.61   JX1_LVDS_16_P   IO_L17P_T2U_N8_AD10P_64     Y18     IO_L17P_T2_34
set_property -dict {PACKAGE_PIN BF36    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[6]}]     ;   ## P10.JX1.63   JX1_LVDS_16_N   IO_L17N_T2U_N9_AD10N_64     Y19     IO_L17N_T2_34
set_property -dict {PACKAGE_PIN BH34    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[7]}]     ;   ## P10.JX1.62   JX1_LVDS_17_P   IO_L18P_T2U_N10_AD2P_64     V16     IO_L18P_T2_34
set_property -dict {PACKAGE_PIN BH35    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[8]}]     ;   ## P10.JX1.64   JX1_LVDS_17_N   IO_L18N_T2U_N11_AD2N_64     W16     IO_L18N_T2_34
set_property -dict {PACKAGE_PIN BG29    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[9]}]     ;   ## P10.JX1.67   JX1_LVDS_18_P   IO_L19P_T3L_N0_DBC_AD9P_64  R16     IO_L19P_T3_34
set_property -dict {PACKAGE_PIN BG30    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[10]}]    ;   ## P10.JX1.69   JX1_LVDS_18_N   IO_L19N_T3L_N1_DBC_AD9N_64  R17     IO_L19N_T3_VREF_34
set_property -dict {PACKAGE_PIN BH29    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[11]}]    ;   ## P10.JX1.68   JX1_LVDS_19_P   IO_L20P_T3L_N2_AD1P_64      T17     IO_L20P_T3_34
set_property -dict {PACKAGE_PIN BH30    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[12]}]    ;   ## P10.JX1.70   JX1_LVDS_19_N   IO_L20N_T3L_N3_AD1N_64      R18     IO_L20N_T3_34
set_property -dict {PACKAGE_PIN BF31    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[13]}]    ;   ## P10.JX1.73   JX1_LVDS_20_P   IO_L21P_T3L_N4_AD8P_64      V17     IO_L21P_T3_DQS_34
set_property -dict {PACKAGE_PIN BG32    IOSTANDARD LVCMOS18}    [get_ports {adsx_mosi_data[14]}]    ;   ## P10.JX1.75   JX1_LVDS_20_N   IO_L21N_T3L_N5_AD8N_64      V18     IO_L21N_T3_DQS_34
set_property -dict {PACKAGE_PIN BJ29    IOSTANDARD LVCMOS18}    [get_ports adsx_master_status]      ;   ## P10.JX1.74   JX1_LVDS_21_P   IO_L22P_T3U_N6_DBC_AD0P_64  W18     IO_L22P_T3_34
set_property -dict {PACKAGE_PIN BK30    IOSTANDARD LVCMOS18}    [get_ports adsx_master_errors]      ;   ## P10.JX1.76   JX1_LVDS_21_N   IO_L22N_T3U_N7_DBC_AD0N_64  W19     IO_L22N_T3_34

set_property -dict {PACKAGE_PIN BH31    IOSTANDARD LVCMOS18}    [get_ports mzed2adsx_reset]         ;   ## P10.JX1.82   JX1_LVDS_23_P   IO_L24P_T3U_N10_64          P15     IO_L24P_T3_34
set_property -dict {PACKAGE_PIN BJ31    IOSTANDARD LVCMOS18}    [get_ports mzed2adsx_clk_sel]       ;   ## P10.JX1.84   JX1_LVDS_23_N   IO_L24N_T3U_N11_64          P16     IO_L24N_T3_34
set_property -dict {PACKAGE_PIN BL27    IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_status]        ;   ## P11.JX2.36   JX2_LVDS_7_P    IO_L8P_T1L_N2_AD5P_67       M19     IO_L7P_T1_AD2P_35
set_property -dict {PACKAGE_PIN BL26    IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_loc]           ;   ## P11.JX2.38   JX2_LVDS_7_N    IO_L8N_T1L_N3_AD5N_67       M20     IO_L7N_T1_AD2N_35
set_property -dict {PACKAGE_PIN BF32    IOSTANDARD LVCMOS18}    [get_ports adsx2mzed_intr]          ;   ## P10.JX1.81   JX1_LVDS_22_P   IO_L23P_T3U_N8_64           N17     IO_L23P_T3_34
set_property -dict {PACKAGE_PIN BJ28    IOSTANDARD LVCMOS18}    [get_ports master_resetn]           ;   ## P11.JX2.41   JX2_LVDS_8_P    IO_L9P_T1L_N4_AD12P_67      M17     IO_L8P_T1_AD10P_35
set_property -dict {PACKAGE_PIN BK28    IOSTANDARD LVCMOS18}    [get_ports slave_resetn]            ;   ## P11.JX2.43   JX2_LVDS_8_N    IO_L9N_T1L_N5_AD12N_67      M18     IO_L8N_T1_AD10N_35

set_property -dict {PACKAGE_PIN G18     IOSTANDARD LVDS}        [get_ports adsx_clk_p]              ;   ## IO_L11P_T1U_N8_GC_71
set_property -dict {PACKAGE_PIN G17     IOSTANDARD LVDS}        [get_ports adsx_clk_n]              ;   ## IO_L11N_T1U_N9_GC_71
set_property -dict {PACKAGE_PIN G21     IOSTANDARD LVCMOS18}    [get_ports adsx_clk_enable]         ;   ## IO_L10P_T1U_N6_QBC_AD4P_71

set_property -dict {PACKAGE_PIN L18     IOSTANDARD LVCMOS18}    [get_ports {gpio_dip[0]}]           ;   ## IO_L2N_T0L_N3_71 (S8, 05-06)
set_property -dict {PACKAGE_PIN L19     IOSTANDARD LVCMOS18}    [get_ports {gpio_dip[1]}]           ;   ## IO_L2P_T0L_N2_71 (S8, 04-07)
set_property -dict {PACKAGE_PIN L20     IOSTANDARD LVCMOS18}    [get_ports {gpio_dip[2]}]           ;   ## IO_L3N_T0L_N5_AD15N_71 (S8, 03-08)
set_property -dict {PACKAGE_PIN L21     IOSTANDARD LVCMOS18}    [get_ports {gpio_dip[3]}]           ;   ## IO_L3P_T0L_N4_AD15P_71 (S8, 02-09)
set_property -dict {PACKAGE_PIN K18     IOSTANDARD LVCMOS18}    [get_ports {gpio_dip[4]}]           ;   ## IO_L4N_T0U_N7_DBC_AD7N_71 (S8, 01-10)
set_property -dict {PACKAGE_PIN BH54    IOSTANDARD LVCMOS18}    [get_ports {gpio_pb[0]}]            ;   ## IO_L16P_T2U_N6_QBC_AD3P_66 (S6)
set_property -dict {PACKAGE_PIN BJ54    IOSTANDARD LVCMOS18}    [get_ports {gpio_pb[1]}]            ;   ## IO_L16N_T2U_N7_QBC_AD3N_66 (S7)
set_property -dict {PACKAGE_PIN BF47    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[0]}]           ;   ## IO_L22P_T3U_N6_DBC_AD0P_66 (DS1)
set_property -dict {PACKAGE_PIN BE50    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[1]}]           ;   ## IO_L23N_T3U_N9_66 (DS2)
set_property -dict {PACKAGE_PIN BE49    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[2]}]           ;   ## IO_L23P_T3U_N8_66 (DS3)
set_property -dict {PACKAGE_PIN BE51    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[3]}]           ;   ## IO_L24N_T3U_N11_66 (DS4)
set_property -dict {PACKAGE_PIN BD51    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[4]}]           ;   ## IO_L24P_T3U_N10_66 (DS5)
set_property -dict {PACKAGE_PIN BL48    IOSTANDARD LVCMOS18}    [get_ports {gpio_led[5]}]           ;   ## IO_T1U_N12_66 (DS6)

set_property -dict {PACKAGE_PIN B16     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[0]}]    ;   ## IO_L24P_T3U_N10_71
set_property -dict {PACKAGE_PIN A16     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[1]}]    ;   ## IO_L24N_T3U_N11_71
set_property -dict {PACKAGE_PIN A19     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[2]}]    ;   ## IO_L23P_T3U_N8_71
set_property -dict {PACKAGE_PIN A18     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[3]}]    ;   ## IO_L23N_T3U_N9_71
set_property -dict {PACKAGE_PIN A21     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[4]}]    ;   ## IO_L22P_T3U_N6_DBC_AD0P_71
set_property -dict {PACKAGE_PIN A20     IOSTANDARD LVCMOS18}    [get_ports {xcvr_refclk_sel[5]}]    ;   ## IO_L22N_T3U_N7_DBC_AD0N_71
set_property -dict {PACKAGE_PIN BF48    IOSTANDARD LVCMOS18}    [get_ports pca9545_reset]           ;   ## IO_L22N_T3U_N7_DBC_AD0N_66
set_property -dict {PACKAGE_PIN BF51    IOSTANDARD LVCMOS18}    [get_ports ad9528_vcxo_sel]         ;   ## IO_L21P_T3L_N4_AD8P_66
set_property -dict {PACKAGE_PIN BF52    IOSTANDARD LVCMOS18}    [get_ports ad9528_resetn]           ;   ## IO_L21N_T3L_N5_AD8N_66

set_property -dict {PACKAGE_PIN E19     IOSTANDARD LVCMOS18}    [get_ports {gpio_sma[0]}]           ;   ## IO_L14P_T2L_N2_GC_71 (SMA_J2)
set_property -dict {PACKAGE_PIN E18     IOSTANDARD LVCMOS18}    [get_ports {gpio_sma[1]}]           ;   ## IO_L14N_T2L_N3_GC_71 (SMA_J3)
set_property -dict {PACKAGE_PIN BH51    IOSTANDARD LVCMOS18}    [get_ports {gpio_sma[2]}]           ;   ## IO_L11P_T1U_N8_GC_66 (SMA_J4)
set_property -dict {PACKAGE_PIN BJ51    IOSTANDARD LVCMOS18}    [get_ports {gpio_sma[3]}]           ;   ## IO_L11N_T1U_N9_GC_66 (SMA_J5)
set_property -dict {PACKAGE_PIN BN51    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[0]}]           ;   ## IO_L2N_T0L_N3_66 (HEADER_GPIO00)
set_property -dict {PACKAGE_PIN BN50    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[1]}]           ;   ## IO_L2P_T0L_N2_66 (HEADER_GPIO01)
set_property -dict {PACKAGE_PIN BN49    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[2]}]           ;   ## IO_L3N_T0L_N5_AD15N_66 (HEADER_GPIO02)
set_property -dict {PACKAGE_PIN BM48    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[3]}]           ;   ## IO_L3P_T0L_N4_AD15P_66 (HEADER_GPIO03)
set_property -dict {PACKAGE_PIN BM50    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[4]}]           ;   ## IO_L4N_T0U_N7_DBC_AD7N_66 (HEADER_GPIO04)
set_property -dict {PACKAGE_PIN BM49    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[5]}]           ;   ## IO_L4P_T0U_N6_DBC_AD7P_66 (HEADER_GPIO05)
set_property -dict {PACKAGE_PIN BM52    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[6]}]           ;   ## IO_L5N_T0U_N9_AD14N_66 (HEADER_GPIO06)
set_property -dict {PACKAGE_PIN BL51    IOSTANDARD LVCMOS18}    [get_ports {gpio_hdr[7]}]           ;   ## IO_L5P_T0U_N8_AD14P_66 (HEADER_GPIO07)

set_property DIFF_TERM_ADV TERM_100 [get_ports adsx_clk_p]
set_property DIFF_TERM_ADV TERM_100 [get_ports adsx_clk_n]

set_property IODELAY_GROUP axi_mzed_c2c_phy_group [get_cells -hierarchical -filter {name =~ *axi_mzed*IDELAY*}]
set_property IODELAY_GROUP axi_adsx_c2c_phy_group [get_cells -hierarchical -filter {name =~ *axi_adsx*IDELAY*}]

set_property LOC BITSLICE_CONTROL_X0Y0 [get_cells -hierarchical -filter {name =~ *axi_adsx*IDELAYCTRL*}]
set_property LOC BITSLICE_CONTROL_X0Y24 [get_cells -hierarchical -filter {name =~ *axi_mzed*IDELAYCTRL*}]

set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports -filter {name =~ mzed_miso_data*}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports -filter {name =~ mzed_mosi_data*}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports -filter {name =~ adsx_miso_data*}]
set_property UNAVAILABLE_DURING_CALIBRATION TRUE [get_ports -filter {name =~ adsx_mosi_data*}]

set_property bitstream.general.compress true [current_design]

## ##################################################################################
## ##################################################################################
