## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADSX IPI block design
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

## Reset

create_bd_port -dir I -type rst mzed2adsx_reset
set_property config.polarity active_high [get_bd_ports mzed2adsx_reset]

## Clocking

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ clk_wiz && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_clk
lappend ip_param_list config.mmcm_bandwidth OPTIMIZED
lappend ip_param_list config.num_out_clks 4
lappend ip_param_list config.clkout1_used true
lappend ip_param_list config.clkout1_requested_out_freq 100.000
lappend ip_param_list config.clkout2_used true
lappend ip_param_list config.clkout2_requested_out_freq 100.000
lappend ip_param_list config.clkout3_used true
lappend ip_param_list config.clkout3_requested_out_freq 100.000
lappend ip_param_list config.clkout4_used true
lappend ip_param_list config.clkout4_requested_out_freq 300.000
lappend ip_param_list config.optimize_clocking_structure_en true
lappend ip_param_list config.prim_source differential_clock_capable_pin
lappend ip_param_list config.use_inclk_stopped true
set_property -dict $ip_param_list [get_bd_cells sys_clk]
make_bd_intf_pins_external -name adsx_clk [get_bd_intf_pins sys_clk/clk_in1_d]
connect_bd_net [get_bd_ports mzed2adsx_reset] [get_bd_pins sys_clk/reset]
connect_bd_net -net hbm_ref_clk [get_bd_pins sys_clk/clk_out1]
connect_bd_net -net axilite_clk [get_bd_pins sys_clk/clk_out2]
connect_bd_net -net aximm_clk [get_bd_pins sys_clk/clk_out3]
connect_bd_net -net sys_ref_clk [get_bd_pins sys_clk/clk_out4]
make_bd_pins_external -name adsx2mzed_status [get_bd_pins sys_clk/locked]
make_bd_pins_external -name adsx2mzed_loc [get_bd_pins sys_clk/input_clk_stopped]

## AXILite Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_axilite_rstgen
connect_bd_net [get_bd_ports mzed2adsx_reset] [get_bd_pins sys_axilite_rstgen/ext_reset_in]
connect_bd_net [get_bd_pins sys_clk/locked] [get_bd_pins sys_axilite_rstgen/dcm_locked]
connect_bd_net -net axilite_clk [get_bd_pins sys_axilite_rstgen/slowest_sync_clk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_axilite_rstgen/peripheral_aresetn]

## AXIMM Reset

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ proc_sys_reset && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_aximm_rstgen
connect_bd_net [get_bd_ports mzed2adsx_reset] [get_bd_pins sys_aximm_rstgen/ext_reset_in]
connect_bd_net [get_bd_pins sys_clk/locked] [get_bd_pins sys_aximm_rstgen/dcm_locked]
connect_bd_net -net aximm_clk [get_bd_pins sys_aximm_rstgen/slowest_sync_clk]
connect_bd_net -net aximm_resetn [get_bd_pins sys_aximm_rstgen/peripheral_aresetn]

## MicroZed Interface (Slave)

set ip_vlnv [get_ipdefs -all -filter {name =~ xpm_cdc_gen && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_mzed_reset
set_property CONFIG.CDC_TYPE xpm_cdc_async_rst [get_bd_cells sys_mzed_reset]
make_bd_pins_external -name slave_resetn [get_bd_pins sys_mzed_reset/src_arst]
connect_bd_net -net axilite_clk [get_bd_pins sys_mzed_reset/dest_clk]

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_chip2chip && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_mzed
lappend ip_param_list config.c_master_fpga 0
lappend ip_param_list config.c_common_clk 0
lappend ip_param_list config.c_include_axilite 2
lappend ip_param_list config.c_interface_mode 1
lappend ip_param_list config.c_m_axi_id_width 0
lappend ip_param_list config.c_m_axi_wuser_width 0
lappend ip_param_list config.c_use_diff_clk false
lappend ip_param_list config.c_use_diff_io false
set_property -dict $ip_param_list [get_bd_cells axi_mzed]
connect_bd_net -net axilite_clk [get_bd_pins axi_mzed/m_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_mzed/m_axi_lite_aclk]
connect_bd_net -net sys_ref_clk [get_bd_pins axi_mzed/idelay_ref_clk]
connect_bd_net [get_bd_pins sys_mzed_reset/dest_arst] [get_bd_pins axi_mzed/m_aresetn]
make_bd_pins_external -name mzed_mosi_clk [get_bd_pins axi_mzed/axi_c2c_selio_rx_clk_in]
make_bd_pins_external -name mzed_mosi_data [get_bd_pins axi_mzed/axi_c2c_selio_rx_data_in]
make_bd_pins_external -name mzed_miso_clk [get_bd_pins axi_mzed/axi_c2c_selio_tx_clk_out]
make_bd_pins_external -name mzed_miso_data [get_bd_pins axi_mzed/axi_c2c_selio_tx_data_out]
make_bd_pins_external -name mzed_slave_status [get_bd_pins axi_mzed/axi_c2c_link_status_out]
make_bd_pins_external -name mzed_slave_errors [get_bd_pins axi_mzed/axi_c2c_multi_bit_error_out]

## MicroZed Interface (Master)

set ip_vlnv [get_ipdefs -all -filter {name =~ xpm_cdc_gen && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_adsx_reset
set_property CONFIG.CDC_TYPE xpm_cdc_async_rst [get_bd_cells sys_adsx_reset]
make_bd_pins_external -name master_resetn [get_bd_pins sys_adsx_reset/src_arst]
connect_bd_net -net axilite_clk [get_bd_pins sys_adsx_reset/dest_clk]

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_chip2chip && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adsx
lappend ip_param_list config.c_master_fpga 1
lappend ip_param_list config.c_common_clk 0
lappend ip_param_list config.c_include_axilite 1
lappend ip_param_list config.c_interface_mode 1
lappend ip_param_list config.c_use_diff_clk false
lappend ip_param_list config.c_use_diff_io false
set_property -dict $ip_param_list [get_bd_cells axi_adsx]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx/s_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx/s_axi_lite_aclk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx/axi_c2c_phy_clk]
connect_bd_net -net sys_ref_clk [get_bd_pins axi_adsx/idelay_ref_clk]
connect_bd_net [get_bd_pins sys_adsx_reset/dest_arst] [get_bd_pins axi_adsx/s_aresetn]
make_bd_pins_external -name adsx_miso_clk [get_bd_pins axi_adsx/axi_c2c_selio_rx_clk_in]
make_bd_pins_external -name adsx_miso_data [get_bd_pins axi_adsx/axi_c2c_selio_rx_data_in]
make_bd_pins_external -name adsx_mosi_clk [get_bd_pins axi_adsx/axi_c2c_selio_tx_clk_out]
make_bd_pins_external -name adsx_mosi_data [get_bd_pins axi_adsx/axi_c2c_selio_tx_data_out]
make_bd_pins_external -name adsx_master_status [get_bd_pins axi_adsx/axi_c2c_link_status_out]
make_bd_pins_external -name adsx_master_errors [get_bd_pins axi_adsx/axi_c2c_multi_bit_error_out]

set ip_vlnv [get_ipdefs -all -filter {name =~ jtag_axi && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adsx_jtag
set_property config.protocol 2 [get_bd_cells axi_adsx_jtag]
connect_bd_net -net axilite_clk [get_bd_pins axi_adsx_jtag/aclk]
connect_bd_net [get_bd_pins sys_adsx_reset/dest_arst] [get_bd_pins axi_adsx_jtag/aresetn]
connect_bd_intf_net [get_bd_intf_pins axi_adsx_jtag/m_axi] [get_bd_intf_pins axi_adsx/s_axi_lite]
add_addr_map 0x0 axi_adsx_jtag/m_axi axi_adsx/s_axi_lite

## AXILite Interconnect

add_axilite_cpu axi_mzed/m_axi_lite

## Interrupts

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ xlconcat && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_intrs
set_property config.num_ports 1 [get_bd_cells sys_intrs]

## System Identifier

set ip_param_list {}
set ip_vlnv [get_ipdefs -all -filter {name =~ axi_sysid && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_sysid
lappend ip_param_list config.intr_width 1
lappend ip_param_list config.status_width 4
lappend ip_param_list config.control_width 4
lappend ip_param_list config.gpio_in_width 7
lappend ip_param_list config.pwm_out_width 6
lappend ip_param_list config.board_id 10
lappend ip_param_list config.memory_id 8
lappend ip_param_list config.sys_version 0x2
lappend ip_param_list config.sys_info_1 [gen_build_id]
lappend ip_param_list config.sys_build [gen_build_version]
set_property -dict $ip_param_list [get_bd_cells axi_sysid]
connect_bd_net -net axilite_clk [get_bd_pins axi_sysid/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_sysid/axilite_resetn]
connect_bd_net [get_bd_pins sys_intrs/dout] [get_bd_pins axi_sysid/axilite_sys_in_intr]
make_bd_pins_external -name adsx2mzed_intr [get_bd_pins axi_sysid/axilite_sys_intr]
make_bd_pins_external -name adsx_gpio_in [get_bd_pins axi_sysid/gpio_in]
make_bd_pins_external -name adsx_gpio_out [get_bd_pins axi_sysid/pwm_out]
make_bd_pins_external -name adsx_cntrl_out [get_bd_pins axi_sysid/control]
make_bd_pins_external -name adsx_status_in [get_bd_pins axi_sysid/status]
set axilite_addr 0x0
add_axilite_peripheral axi_sysid/axilite
add_cpu_addrmap axi_sysid
add_interrupt axi_sysid/axilite_intr

## HBM

set ip_vlnv [get_ipdefs -all -filter {name =~ hbm && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv sys_mem
set_property config.user_hbm_density 8GB [get_bd_cells sys_mem]
connect_bd_net -net hbm_ref_clk [get_bd_pins sys_mem/hbm_ref_clk_0]
connect_bd_net -net hbm_ref_clk [get_bd_pins sys_mem/hbm_ref_clk_1]
connect_bd_net -net axilite_clk [get_bd_pins sys_mem/apb_0_pclk]
connect_bd_net -net axilite_clk [get_bd_pins sys_mem/apb_1_pclk]
connect_bd_net -net axilite_resetn [get_bd_pins sys_mem/apb_0_preset_n]
connect_bd_net -net axilite_resetn [get_bd_pins sys_mem/apb_1_preset_n]

## HBM APB

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_apb_bridge && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_hbm
set_property config.c_apb_num_slaves 2 [get_bd_cells axi_hbm]
connect_bd_net -net axilite_clk [get_bd_pins axi_hbm/s_axi_aclk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_hbm/s_axi_aresetn]
connect_bd_intf_net [get_bd_intf_pins axi_hbm/apb_m] [get_bd_intf_pins sys_mem/sapb_0]
connect_bd_intf_net [get_bd_intf_pins axi_hbm/apb_m2] [get_bd_intf_pins sys_mem/sapb_1]

## HBM Interleave

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_m16intlv && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_m16intlv
connect_bd_net -net axilite_clk [get_bd_pins axi_m16intlv/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m16intlv/axilite_resetn]
connect_bd_net -net axilite_clk [get_bd_pins axi_m16intlv/aximm_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_m16intlv/aximm_resetn]
add_axilite_peripheral axi_m16intlv/axilite
add_cpu_addrmap axi_mintlv
add_interrupt axi_m16intlv/axilite_intr

## HBM MZed Interconnect

set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv m16intlv_xc
set_property config.num_si 1 [get_bd_cells m16intlv_xc]
set_property config.num_mi 1 [get_bd_cells m16intlv_xc]
connect_bd_net -net aximm_clk [get_bd_pins m16intlv_xc/aclk]
connect_bd_net -net aximm_resetn [get_bd_pins m16intlv_xc/aresetn]
connect_bd_intf_net [get_bd_intf_pins axi_mzed/m_axi] [get_bd_intf_pins m16intlv_xc/s00_axi]
connect_bd_intf_net [get_bd_intf_pins m16intlv_xc/m00_axi] [get_bd_intf_pins axi_m16intlv/aximm]

## HBM Interconnects

for {set n 0} {$n < 16} {incr n} {

    set m2 [format "%02d" $n]
    set s2 [format "%02d" [expr (($n * 2) + 1)]]
    set a40 [format "0x%llx" [expr ($n * 0x20000000)]]
    set ip_vlnv [get_ipdefs -all -filter {name =~ smartconnect && upgrade_versions == ""}]
    create_bd_cell -type ip -vlnv $ip_vlnv intlv_xc_$m2
    set_property config.num_si 1 [get_bd_cells intlv_xc_$m2]
    connect_bd_intf_net [get_bd_intf_pins axi_m16intlv/aximm_$m2] [get_bd_intf_pins intlv_xc_$m2/s00_axi]
    connect_bd_intf_net [get_bd_intf_pins intlv_xc_$m2/m00_axi] [get_bd_intf_pins sys_mem/saxi_$s2]
    connect_bd_net -net axilite_clk [get_bd_pins intlv_xc_$m2/aclk]
    connect_bd_net -net axilite_resetn [get_bd_pins intlv_xc_$m2/aresetn]
    connect_bd_net -net axilite_clk [get_bd_pins sys_mem/axi_${s2}_aclk]
    connect_bd_net -net axilite_resetn [get_bd_pins sys_mem/axi_${s2}_areset_n]
    set_property config.m_addr_$m2 $a40 [get_bd_cells axi_m16intlv]
}

## Memory Mappings

assign_bd_address

## MZed Memory

add_aximm_memory 0x0 axi_adsx/s_axi

set_property config.num_clks 2 [get_bd_cells sys_aximm_xc]
connect_bd_net -net axilite_clk [get_bd_pins sys_aximm_xc/aclk1]

## ##################################################################################
## ##################################################################################

save_bd_design

## ##################################################################################
## ##################################################################################

