## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Rev.A ZCU102
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property -dict {PACKAGE_PIN Y4    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_clk_lssi_clk_p]        ; ##  G06 FMC_HPC0_LA00_CC_P  IO_L13P_T2L_N0_GC_QBC_66            rx1_dclk_out+
set_property -dict {PACKAGE_PIN Y3    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_nc_lssi_clk_n]         ; ##  G07 FMC_HPC0_LA00_CC_N  IO_L13N_T2L_N1_GC_QBC_66            rx1_dclk_out-
set_property -dict {PACKAGE_PIN V2    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_strobe_lssi_strobe_p]  ; ##  H07 FMC_HPC0_LA02_P     IO_L23P_T3U_N8_66                   rx1_strobe_out+
set_property -dict {PACKAGE_PIN V1    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_nc_lssi_strobe_n]      ; ##  H08 FMC_HPC0_LA02_N     IO_L23N_T3U_N9_66                   rx1_strobe_out-
set_property -dict {PACKAGE_PIN Y2    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_data1_lssi_data0_p]    ; ##  G09 FMC_HPC0_LA03_P     IO_L22P_T3U_N6_DBC_AD0P_66          rx1_idata_out+
set_property -dict {PACKAGE_PIN Y1    IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_data0_lssi_data0_n]    ; ##  G10 FMC_HPC0_LA03_N     IO_L22N_T3U_N7_DBC_AD0N_66          rx1_idata_out-
set_property -dict {PACKAGE_PIN AA2   IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_data3_lssi_data1_p]    ; ##  H10 FMC_HPC0_LA04_P     IO_L21P_T3L_N4_AD8P_66              rx1_qdata_out+
set_property -dict {PACKAGE_PIN AA1   IOSTANDARD  LVDS}     [get_ports d0_rx0_cssi_data2_lssi_data1_n]    ; ##  H11 FMC_HPC0_LA04_N     IO_L21N_T3L_N5_AD8N_66              rx1_qdata_out-
set_property -dict {PACKAGE_PIN P11   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_clk_lssi_clk_p]        ; ##  D20 FMC_HPC0_LA17_CC_P  IO_L13P_T2L_N0_GC_QBC_67            rx2_dclk_out+
set_property -dict {PACKAGE_PIN N11   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_nc_lssi_clk_n]         ; ##  D21 FMC_HPC0_LA17_CC_N  IO_L13N_T2L_N1_GC_QBC_67            rx2_dclk_out-
set_property -dict {PACKAGE_PIN P12   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_strobe_lssi_strobe_p]  ; ##  H25 FMC_HPC0_LA21_P     IO_L21P_T3L_N4_AD8P_67              rx2_strobe_out+
set_property -dict {PACKAGE_PIN N12   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_nc_lssi_strobe_n]      ; ##  H26 FMC_HPC0_LA21_N     IO_L21N_T3L_N5_AD8N_67              rx2_strobe_out-
set_property -dict {PACKAGE_PIN N13   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_data1_lssi_data0_p]    ; ##  G21 FMC_HPC0_LA20_P     IO_L22P_T3U_N6_DBC_AD0P_67          rx2_idata_out+
set_property -dict {PACKAGE_PIN M13   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_data0_lssi_data0_n]    ; ##  G22 FMC_HPC0_LA20_N     IO_L22N_T3U_N7_DBC_AD0N_67          rx2_idata_out-
set_property -dict {PACKAGE_PIN L13   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_data3_lssi_data1_p]    ; ##  H22 FMC_HPC0_LA19_P     IO_L23P_T3U_N8_67                   rx2_qdata_out+
set_property -dict {PACKAGE_PIN K13   IOSTANDARD  LVDS}     [get_ports d0_rx1_cssi_data2_lssi_data1_n]    ; ##  H23 FMC_HPC0_LA19_N     IO_L23N_T3U_N9_67                   rx2_qdata_out-
set_property -dict {PACKAGE_PIN AB4   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_refclk_lssi_refclk_p]  ; ##  D08 FMC_HPC0_LA01_CC_P  IO_L16P_T2U_N6_QBC_AD3P_66          dgpio_13/tx1_dclk_out+
set_property -dict {PACKAGE_PIN AC4   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_nc_lssi_refclk_n]      ; ##  D09 FMC_HPC0_LA01_CC_N  IO_L16N_T2U_N7_QBC_AD3N_66          dgpio_12/tx1_dclk_out-
set_property -dict {PACKAGE_PIN U5    IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_clk_lssi_clk_p]        ; ##  H13 FMC_HPC0_LA07_P     IO_L18P_T2U_N10_AD2P_66             tx1_dclk_in+
set_property -dict {PACKAGE_PIN U4    IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_nc_lssi_clk_n]         ; ##  H14 FMC_HPC0_LA07_N     IO_L18N_T2U_N11_AD2N_66             tx1_dclk_in-
set_property -dict {PACKAGE_PIN AC2   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_strobe_lssi_strobe_p]  ; ##  C10 FMC_HPC0_LA06_P     IO_L19P_T3L_N0_DBC_AD9P_66          tx1_strobe_in+
set_property -dict {PACKAGE_PIN AC1   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_nc_lssi_strobe_n]      ; ##  C11 FMC_HPC0_LA06_N     IO_L19N_T3L_N1_DBC_AD9N_66          tx1_strobe_in-
set_property -dict {PACKAGE_PIN V4    IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_data1_lssi_data0_p]    ; ##  G12 FMC_HPC0_LA08_P     IO_L17P_T2U_N8_AD10P_66             tx1_idata_in+
set_property -dict {PACKAGE_PIN V3    IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_data0_lssi_data0_n]    ; ##  G13 FMC_HPC0_LA08_N     IO_L17N_T2U_N9_AD10N_66             tx1_idata_in-
set_property -dict {PACKAGE_PIN AB3   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_data3_lssi_data1_p]    ; ##  D11 FMC_HPC0_LA05_P     IO_L20P_T3L_N2_AD1P_66              tx1_qdata_in+
set_property -dict {PACKAGE_PIN AC3   IOSTANDARD  LVDS}     [get_ports d0_tx0_cssi_data2_lssi_data1_n]    ; ##  D12 FMC_HPC0_LA05_N     IO_L20N_T3L_N3_AD1N_66              tx1_qdata_in-
set_property -dict {PACKAGE_PIN N9    IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_refclk_lssi_refclk_p]  ; ##  C22 FMC_HPC0_LA18_CC_P  IO_L16P_T2U_N6_QBC_AD3P_67          dgpio_15/tx2_dclk_out+
set_property -dict {PACKAGE_PIN N8    IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_nc_lssi_refclk_n]      ; ##  C23 FMC_HPC0_LA18_CC_N  IO_L16N_T2U_N7_QBC_AD3N_67          dgpio_14/tx2_dclk_out-
set_property -dict {PACKAGE_PIN M15   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_clk_lssi_clk_p]        ; ##  G24 FMC_HPC0_LA22_P     IO_L20P_T3L_N2_AD1P_67              tx2_dclk_in+
set_property -dict {PACKAGE_PIN M14   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_nc_lssi_clk_n]         ; ##  G25 FMC_HPC0_LA22_N     IO_L20N_T3L_N3_AD1N_67              tx2_dclk_in-
set_property -dict {PACKAGE_PIN L12   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_strobe_lssi_strobe_p]  ; ##  H28 FMC_HPC0_LA24_P     IO_L18P_T2U_N10_AD2P_67             tx2_strobe_in+
set_property -dict {PACKAGE_PIN K12   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_nc_lssi_strobe_n]      ; ##  H29 FMC_HPC0_LA24_N     IO_L18N_T2U_N11_AD2N_67             tx2_strobe_in-
set_property -dict {PACKAGE_PIN L16   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_data1_lssi_data0_p]    ; ##  D23 FMC_HPC0_LA23_P     IO_L19P_T3L_N0_DBC_AD9P_67          tx2_idata_in+
set_property -dict {PACKAGE_PIN K16   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_data0_lssi_data0_n]    ; ##  D24 FMC_HPC0_LA23_N     IO_L19N_T3L_N1_DBC_AD9N_67          tx2_idata_in-
set_property -dict {PACKAGE_PIN M11   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_data3_lssi_data1_p]    ; ##  G27 FMC_HPC0_LA25_P     IO_L17P_T2U_N8_AD10P_67             tx2_qdata_in+
set_property -dict {PACKAGE_PIN L11   IOSTANDARD  LVDS}     [get_ports d0_tx1_cssi_data2_lssi_data1_n]    ; ##  G28 FMC_HPC0_LA25_N     IO_L17N_T2U_N9_AD10N_67             tx2_qdata_in-
set_property -dict {PACKAGE_PIN AE5   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_clk_lssi_clk_p]        ; ##  G06 FMC_HPC1_LA00_CC_P  IO_L13P_T2L_N0_GC_QBC_65            rx1_dclk_out+
set_property -dict {PACKAGE_PIN AF5   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_nc_lssi_clk_n]         ; ##  G07 FMC_HPC1_LA00_CC_N  IO_L13N_T2L_N1_GC_QBC_65            rx1_dclk_out-
set_property -dict {PACKAGE_PIN AD2   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_strobe_lssi_strobe_p]  ; ##  H07 FMC_HPC1_LA02_P     IO_L23P_T3U_N8_I2C_SCLK_65          rx1_strobe_out+
set_property -dict {PACKAGE_PIN AD1   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_nc_lssi_strobe_n]      ; ##  H08 FMC_HPC1_LA02_N     IO_L23N_T3U_N9_65                   rx1_strobe_out-
set_property -dict {PACKAGE_PIN AH1   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_data1_lssi_data0_p]    ; ##  G09 FMC_HPC1_LA03_P     IO_L22P_T3U_N6_DBC_AD0P_65          rx1_idata_out+
set_property -dict {PACKAGE_PIN AJ1   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_data0_lssi_data0_n]    ; ##  G10 FMC_HPC1_LA03_N     IO_L22N_T3U_N7_DBC_AD0N_65          rx1_idata_out-
set_property -dict {PACKAGE_PIN AF2   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_data3_lssi_data1_p]    ; ##  H10 FMC_HPC1_LA04_P     IO_L21P_T3L_N4_AD8P_65              rx1_qdata_out+
set_property -dict {PACKAGE_PIN AF1   IOSTANDARD  LVDS}     [get_ports d1_rx0_cssi_data2_lssi_data1_n]    ; ##  H11 FMC_HPC1_LA04_N     IO_L21N_T3L_N5_AD8N_65              rx1_qdata_out-
set_property -dict {PACKAGE_PIN Y5    IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_clk_lssi_clk_p]        ; ##  D20 FMC_HPC1_LA17_CC_P  IO_L14P_T2L_N2_GC_66                rx2_dclk_out+
set_property -dict {PACKAGE_PIN AA5   IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_nc_lssi_clk_n]         ; ##  D21 FMC_HPC1_LA17_CC_N  IO_L14N_T2L_N3_GC_66                rx2_dclk_out-
set_property -dict {PACKAGE_PIN AC12  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_strobe_lssi_strobe_p]  ; ##  H25 FMC_HPC1_LA21_P     IO_L1P_T0L_N0_DBC_66                rx2_strobe_out+
set_property -dict {PACKAGE_PIN AC11  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_nc_lssi_strobe_n]      ; ##  H26 FMC_HPC1_LA21_N     IO_L1N_T0L_N1_DBC_66                rx2_strobe_out-
set_property -dict {PACKAGE_PIN AB11  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_data1_lssi_data0_p]    ; ##  G21 FMC_HPC1_LA20_P     IO_L2P_T0L_N2_66                    rx2_idata_out+
set_property -dict {PACKAGE_PIN AB10  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_data0_lssi_data0_n]    ; ##  G22 FMC_HPC1_LA20_N     IO_L2N_T0L_N3_66                    rx2_idata_out-
set_property -dict {PACKAGE_PIN AA11  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_data3_lssi_data1_p]    ; ##  H22 FMC_HPC1_LA19_P     IO_L3P_T0L_N4_AD15P_66              rx2_qdata_out+
set_property -dict {PACKAGE_PIN AA10  IOSTANDARD  LVDS}     [get_ports d1_rx1_cssi_data2_lssi_data1_n]    ; ##  H23 FMC_HPC1_LA19_N     IO_L3N_T0L_N5_AD15N_66              rx2_qdata_out-
set_property -dict {PACKAGE_PIN AJ6   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_refclk_lssi_refclk_p]  ; ##  D08 FMC_HPC1_LA01_CC_P  IO_L16P_T2U_N6_QBC_AD3P_65          dgpio_13/tx1_dclk_out+
set_property -dict {PACKAGE_PIN AJ5   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_nc_lssi_refclk_n]      ; ##  D09 FMC_HPC1_LA01_CC_N  IO_L16N_T2U_N7_QBC_AD3N_65          dgpio_12/tx1_dclk_out-
set_property -dict {PACKAGE_PIN AD4   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_clk_lssi_clk_p]        ; ##  H13 FMC_HPC1_LA07_P     IO_L18P_T2U_N10_AD2P_65             tx1_dclk_in+
set_property -dict {PACKAGE_PIN AE4   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_nc_lssi_clk_n]         ; ##  H14 FMC_HPC1_LA07_N     IO_L18N_T2U_N11_AD2N_65             tx1_dclk_in-
set_property -dict {PACKAGE_PIN AH2   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_strobe_lssi_strobe_p]  ; ##  C10 FMC_HPC1_LA06_P     IO_L19P_T3L_N0_DBC_AD9P_65          tx1_strobe_in+
set_property -dict {PACKAGE_PIN AJ2   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_nc_lssi_strobe_n]      ; ##  C11 FMC_HPC1_LA06_N     IO_L19N_T3L_N1_DBC_AD9N_65          tx1_strobe_in-
set_property -dict {PACKAGE_PIN AE3   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_data1_lssi_data0_p]    ; ##  G12 FMC_HPC1_LA08_P     IO_L17P_T2U_N8_AD10P_65             tx1_idata_in+
set_property -dict {PACKAGE_PIN AF3   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_data0_lssi_data0_n]    ; ##  G13 FMC_HPC1_LA08_N     IO_L17N_T2U_N9_AD10N_65             tx1_idata_in-
set_property -dict {PACKAGE_PIN AG3   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_data3_lssi_data1_p]    ; ##  D11 FMC_HPC1_LA05_P     IO_L20P_T3L_N2_AD1P_65              tx1_qdata_in+
set_property -dict {PACKAGE_PIN AH3   IOSTANDARD  LVDS}     [get_ports d1_tx0_cssi_data2_lssi_data1_n]    ; ##  D12 FMC_HPC1_LA05_N     IO_L20N_T3L_N3_AD1N_65              tx1_qdata_in-
set_property -dict {PACKAGE_PIN Y8    IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_refclk_lssi_refclk_p]  ; ##  C22 FMC_HPC1_LA18_CC_P  IO_L11N_T1U_N9_GC_66                dgpio_15/tx2_dclk_out+
set_property -dict {PACKAGE_PIN Y7    IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_nc_lssi_refclk_n]      ; ##  C23 FMC_HPC1_LA18_CC_N  IO_L11N_T1U_N9_GC_66                dgpio_14/tx2_dclk_out-
set_property -dict {PACKAGE_PIN AF11  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_clk_lssi_clk_p]        ; ##  G24 FMC_HPC1_LA22_P     IO_L4P_T0U_N6_DBC_AD7P_SMBALERT_65  tx2_dclk_in+
set_property -dict {PACKAGE_PIN AG11  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_nc_lssi_clk_n]         ; ##  G25 FMC_HPC1_LA22_N     IO_L4N_T0U_N7_DBC_AD7N_65           tx2_dclk_in-
set_property -dict {PACKAGE_PIN AH12  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_strobe_lssi_strobe_p]  ; ##  H28 FMC_HPC1_LA24_P     IO_L2P_T0L_N2_65                    tx2_strobe_in+
set_property -dict {PACKAGE_PIN AH11  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_nc_lssi_strobe_n]      ; ##  H29 FMC_HPC1_LA24_N     IO_L2N_T0L_N3_65                    tx2_strobe_in-
set_property -dict {PACKAGE_PIN AE12  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_data1_lssi_data0_p]    ; ##  D23 FMC_HPC1_LA23_P     IO_L3P_T0L_N4_AD15P_65              tx2_idata_in+
set_property -dict {PACKAGE_PIN AF12  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_data0_lssi_data0_n]    ; ##  D24 FMC_HPC1_LA23_N     IO_L3N_T0L_N5_AD15N_65              tx2_idata_in-
set_property -dict {PACKAGE_PIN AE10  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_data3_lssi_data1_p]    ; ##  G27 FMC_HPC1_LA25_P     IO_L1P_T0L_N0_DBC_65                tx2_qdata_in+
set_property -dict {PACKAGE_PIN AF10  IOSTANDARD  LVDS}     [get_ports d1_tx1_cssi_data2_lssi_data1_n]    ; ##  G28 FMC_HPC1_LA25_N     IO_L1N_T0L_N1_DBC_65                tx2_qdata_in-

set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_clk_lssi_clk_p]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_nc_lssi_clk_n]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_strobe_lssi_strobe_p]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_nc_lssi_strobe_n]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_data1_lssi_data0_p]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_data0_lssi_data0_n]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_data3_lssi_data1_p]
set_property diff_term_adv term_100 [get_ports d0_rx0_cssi_data2_lssi_data1_n]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_clk_lssi_clk_p]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_nc_lssi_clk_n]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_strobe_lssi_strobe_p]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_nc_lssi_strobe_n]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_data1_lssi_data0_p]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_data0_lssi_data0_n]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_data3_lssi_data1_p]
set_property diff_term_adv term_100 [get_ports d0_rx1_cssi_data2_lssi_data1_n]
set_property diff_term_adv term_100 [get_ports d0_tx0_cssi_refclk_lssi_refclk_p]
set_property diff_term_adv term_100 [get_ports d0_tx0_cssi_nc_lssi_refclk_n]
set_property diff_term_adv term_100 [get_ports d0_tx1_cssi_refclk_lssi_refclk_p]
set_property diff_term_adv term_100 [get_ports d0_tx1_cssi_nc_lssi_refclk_n]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_clk_lssi_clk_p]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_nc_lssi_clk_n]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_strobe_lssi_strobe_p]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_nc_lssi_strobe_n]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_data1_lssi_data0_p]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_data0_lssi_data0_n]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_data3_lssi_data1_p]
set_property diff_term_adv term_100 [get_ports d1_rx0_cssi_data2_lssi_data1_n]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_clk_lssi_clk_p]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_nc_lssi_clk_n]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_strobe_lssi_strobe_p]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_nc_lssi_strobe_n]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_data1_lssi_data0_p]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_data0_lssi_data0_n]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_data3_lssi_data1_p]
set_property diff_term_adv term_100 [get_ports d1_rx1_cssi_data2_lssi_data1_n]
set_property diff_term_adv term_100 [get_ports d1_tx0_cssi_refclk_lssi_refclk_p]
set_property diff_term_adv term_100 [get_ports d1_tx0_cssi_nc_lssi_refclk_n]
set_property diff_term_adv term_100 [get_ports d1_tx1_cssi_refclk_lssi_refclk_p]
set_property diff_term_adv term_100 [get_ports d1_tx1_cssi_nc_lssi_refclk_n]

create_clock -name d0_rx0_clk_in -period 2.00 [get_ports d0_rx0_cssi_clk_lssi_clk_p]
create_clock -name d0_rx1_clk_in -period 2.00 [get_ports d0_rx1_cssi_clk_lssi_clk_p]
create_clock -name d0_tx0_ref_clk_in -period 2.00 [get_ports d0_tx0_cssi_refclk_lssi_refclk_p]
create_clock -name d0_tx1_ref_clk_in -period 2.00 [get_ports d0_tx1_cssi_refclk_lssi_refclk_p]

create_clock -name d1_rx0_clk_in -period 2.00 [get_ports d1_rx0_cssi_clk_lssi_clk_p]
create_clock -name d1_rx1_clk_in -period 2.00 [get_ports d1_rx1_cssi_clk_lssi_clk_p]
create_clock -name d1_tx0_ref_clk_in -period 2.00 [get_ports d1_tx0_cssi_refclk_lssi_refclk_p]
create_clock -name d1_tx1_ref_clk_in -period 2.00 [get_ports d1_tx1_cssi_refclk_lssi_refclk_p]

set_false_path -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk/CLR}]
set_false_path -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk_resetn/CLR}]

set_max_delay 2 -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk/CLR}]
set_max_delay 2 -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk_resetn/CLR}]

## ##################################################################################
## ##################################################################################
