// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       ADRV9001 Rev.A ZCU102
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module adrv9001x2_zcu102 (

    // pl ddr

    output  wire          pl_ddr_act_n,
    output  wire  [16:0]  pl_ddr_adr,
    output  wire  [ 1:0]  pl_ddr_ba,
    output  wire          pl_ddr_bg,
    output  wire          pl_ddr_ck_c,
    output  wire          pl_ddr_ck_t,
    output  wire          pl_ddr_cke,
    output  wire          pl_ddr_cs_n,
    inout   wire  [ 1:0]  pl_ddr_dm_n,
    inout   wire  [15:0]  pl_ddr_dq,
    inout   wire  [ 1:0]  pl_ddr_dqs_c,
    inout   wire  [ 1:0]  pl_ddr_dqs_t,
    output  wire          pl_ddr_odt,
    input   wire          pl_ddr_refclk_clk_n,
    input   wire          pl_ddr_refclk_clk_p,
    output  wire          pl_ddr_reset_n,
    input   wire          pl_ddr_reset,

    // platform gpio

    input   wire  [ 3:0]  gpio_sw,
    input   wire  [ 2:0]  gpio_pb,
    output  wire  [ 3:0]  gpio_led,

    // spi

    output  wire  [ 2:0]  spi_ssn,
    output  wire          spi_sclk,
    inout   wire          spi_mosi,
    input   wire          spi_miso,

    // reference & monitor clocks

    inout   wire  [ 1:0]  trig,

    // adrv9001 io
 
    input   wire          d0_rx0_cssi_clk_lssi_clk_p,
    input   wire          d0_rx0_cssi_nc_lssi_clk_n,
    input   wire          d0_rx0_cssi_strobe_lssi_strobe_p,
    input   wire          d0_rx0_cssi_nc_lssi_strobe_n,
    input   wire          d0_rx0_cssi_data1_lssi_data0_p,
    input   wire          d0_rx0_cssi_data0_lssi_data0_n,
    input   wire          d0_rx0_cssi_data3_lssi_data1_p,
    input   wire          d0_rx0_cssi_data2_lssi_data1_n,
    input   wire          d0_rx1_cssi_clk_lssi_clk_p,
    input   wire          d0_rx1_cssi_nc_lssi_clk_n,
    input   wire          d0_rx1_cssi_strobe_lssi_strobe_p,
    input   wire          d0_rx1_cssi_nc_lssi_strobe_n,
    input   wire          d0_rx1_cssi_data1_lssi_data0_p,
    input   wire          d0_rx1_cssi_data0_lssi_data0_n,
    input   wire          d0_rx1_cssi_data3_lssi_data1_p,
    input   wire          d0_rx1_cssi_data2_lssi_data1_n,
    input   wire          d0_tx0_cssi_refclk_lssi_refclk_p,
    input   wire          d0_tx0_cssi_nc_lssi_refclk_n,
    output  wire          d0_tx0_cssi_clk_lssi_clk_p,
    output  wire          d0_tx0_cssi_nc_lssi_clk_n,
    output  wire          d0_tx0_cssi_strobe_lssi_strobe_p,
    output  wire          d0_tx0_cssi_nc_lssi_strobe_n,
    output  wire          d0_tx0_cssi_data1_lssi_data0_p,
    output  wire          d0_tx0_cssi_data0_lssi_data0_n,
    output  wire          d0_tx0_cssi_data3_lssi_data1_p,
    output  wire          d0_tx0_cssi_data2_lssi_data1_n,
    input   wire          d0_tx1_cssi_refclk_lssi_refclk_p,
    input   wire          d0_tx1_cssi_nc_lssi_refclk_n,
    output  wire          d0_tx1_cssi_clk_lssi_clk_p,
    output  wire          d0_tx1_cssi_nc_lssi_clk_n,
    output  wire          d0_tx1_cssi_strobe_lssi_strobe_p,
    output  wire          d0_tx1_cssi_nc_lssi_strobe_n,
    output  wire          d0_tx1_cssi_data1_lssi_data0_p,
    output  wire          d0_tx1_cssi_data0_lssi_data0_n,
    output  wire          d0_tx1_cssi_data3_lssi_data1_p,
    output  wire          d0_tx1_cssi_data2_lssi_data1_n,
    output  wire          d0_rx0_enable,
    output  wire          d0_rx1_enable,
    output  wire          d0_tx0_enable,
    output  wire          d0_tx1_enable,
    inout   wire  [11:0]  d0_dgpio,
    output  wire          d0_mode,
    output  wire          d0_resetb,
    input   wire          d0_gp_int,
    input   wire          d0_dev_clk,

    // adrv9001 io
 
    input   wire          d1_rx0_cssi_clk_lssi_clk_p,
    input   wire          d1_rx0_cssi_nc_lssi_clk_n,
    input   wire          d1_rx0_cssi_strobe_lssi_strobe_p,
    input   wire          d1_rx0_cssi_nc_lssi_strobe_n,
    input   wire          d1_rx0_cssi_data1_lssi_data0_p,
    input   wire          d1_rx0_cssi_data0_lssi_data0_n,
    input   wire          d1_rx0_cssi_data3_lssi_data1_p,
    input   wire          d1_rx0_cssi_data2_lssi_data1_n,
    input   wire          d1_rx1_cssi_clk_lssi_clk_p,
    input   wire          d1_rx1_cssi_nc_lssi_clk_n,
    input   wire          d1_rx1_cssi_strobe_lssi_strobe_p,
    input   wire          d1_rx1_cssi_nc_lssi_strobe_n,
    input   wire          d1_rx1_cssi_data1_lssi_data0_p,
    input   wire          d1_rx1_cssi_data0_lssi_data0_n,
    input   wire          d1_rx1_cssi_data3_lssi_data1_p,
    input   wire          d1_rx1_cssi_data2_lssi_data1_n,
    input   wire          d1_tx0_cssi_refclk_lssi_refclk_p,
    input   wire          d1_tx0_cssi_nc_lssi_refclk_n,
    output  wire          d1_tx0_cssi_clk_lssi_clk_p,
    output  wire          d1_tx0_cssi_nc_lssi_clk_n,
    output  wire          d1_tx0_cssi_strobe_lssi_strobe_p,
    output  wire          d1_tx0_cssi_nc_lssi_strobe_n,
    output  wire          d1_tx0_cssi_data1_lssi_data0_p,
    output  wire          d1_tx0_cssi_data0_lssi_data0_n,
    output  wire          d1_tx0_cssi_data3_lssi_data1_p,
    output  wire          d1_tx0_cssi_data2_lssi_data1_n,
    input   wire          d1_tx1_cssi_refclk_lssi_refclk_p,
    input   wire          d1_tx1_cssi_nc_lssi_refclk_n,
    output  wire          d1_tx1_cssi_clk_lssi_clk_p,
    output  wire          d1_tx1_cssi_nc_lssi_clk_n,
    output  wire          d1_tx1_cssi_strobe_lssi_strobe_p,
    output  wire          d1_tx1_cssi_nc_lssi_strobe_n,
    output  wire          d1_tx1_cssi_data1_lssi_data0_p,
    output  wire          d1_tx1_cssi_data0_lssi_data0_n,
    output  wire          d1_tx1_cssi_data3_lssi_data1_p,
    output  wire          d1_tx1_cssi_data2_lssi_data1_n,
    output  wire          d1_rx0_enable,
    output  wire          d1_rx1_enable,
    output  wire          d1_tx0_enable,
    output  wire          d1_tx1_enable,
    inout   wire  [11:0]  d1_dgpio,
    output  wire          d1_mode,
    output  wire          d1_resetb,
    input   wire          d1_gp_int,
    input   wire          d1_dev_clk,

    // system io
 
    input   wire          vadj_err,
    output  wire          status,
    output  wire          fan_tach,
    input   wire          ref_clk_p,
    input   wire          ref_clk_n,
    input   wire          mcs_in_p,
    input   wire          mcs_in_n,
    output  wire          mcs_out);

    // ipi-system

    system i_system (
        .control                              ({fan_tach, status}),
        .dio_1_dev_clk                        (d1_dev_clk),
        .dio_1_dgpio                          (d1_dgpio),
        .dio_1_gp_int                         (d1_gp_int),
        .dio_1_mode                           (d1_mode),
        .dio_1_resetb                         (d1_resetb),
        .dio_1_rx0_cssi_clk_lssi_clk_p        (d1_rx0_cssi_clk_lssi_clk_p),
        .dio_1_rx0_cssi_data0_lssi_data0_n    (d1_rx0_cssi_data0_lssi_data0_n),
        .dio_1_rx0_cssi_data1_lssi_data0_p    (d1_rx0_cssi_data1_lssi_data0_p),
        .dio_1_rx0_cssi_data2_lssi_data1_n    (d1_rx0_cssi_data2_lssi_data1_n),
        .dio_1_rx0_cssi_data3_lssi_data1_p    (d1_rx0_cssi_data3_lssi_data1_p),
        .dio_1_rx0_cssi_gpio_enb              (),
        .dio_1_rx0_cssi_gpio_in               (8'd0),
        .dio_1_rx0_cssi_gpio_out              (),
        .dio_1_rx0_cssi_nc_lssi_clk_n         (d1_rx0_cssi_nc_lssi_clk_n),
        .dio_1_rx0_cssi_nc_lssi_strobe_n      (d1_rx0_cssi_nc_lssi_strobe_n),
        .dio_1_rx0_cssi_strobe_lssi_strobe_p  (d1_rx0_cssi_strobe_lssi_strobe_p),
        .dio_1_rx0_enable                     (d1_rx0_enable),
        .dio_1_rx1_cssi_clk_lssi_clk_p        (d1_rx1_cssi_clk_lssi_clk_p),
        .dio_1_rx1_cssi_data0_lssi_data0_n    (d1_rx1_cssi_data0_lssi_data0_n),
        .dio_1_rx1_cssi_data1_lssi_data0_p    (d1_rx1_cssi_data1_lssi_data0_p),
        .dio_1_rx1_cssi_data2_lssi_data1_n    (d1_rx1_cssi_data2_lssi_data1_n),
        .dio_1_rx1_cssi_data3_lssi_data1_p    (d1_rx1_cssi_data3_lssi_data1_p),
        .dio_1_rx1_cssi_gpio_enb              (),
        .dio_1_rx1_cssi_gpio_in               (8'd0),
        .dio_1_rx1_cssi_gpio_out              (),
        .dio_1_rx1_cssi_nc_lssi_clk_n         (d1_rx1_cssi_nc_lssi_clk_n),
        .dio_1_rx1_cssi_nc_lssi_strobe_n      (d1_rx1_cssi_nc_lssi_strobe_n),
        .dio_1_rx1_cssi_strobe_lssi_strobe_p  (d1_rx1_cssi_strobe_lssi_strobe_p),
        .dio_1_rx1_enable                     (d1_rx1_enable),
        .dio_1_tx0_cssi_clk_lssi_clk_p        (d1_tx0_cssi_clk_lssi_clk_p),
        .dio_1_tx0_cssi_data0_lssi_data0_n    (d1_tx0_cssi_data0_lssi_data0_n),
        .dio_1_tx0_cssi_data1_lssi_data0_p    (d1_tx0_cssi_data1_lssi_data0_p),
        .dio_1_tx0_cssi_data2_lssi_data1_n    (d1_tx0_cssi_data2_lssi_data1_n),
        .dio_1_tx0_cssi_data3_lssi_data1_p    (d1_tx0_cssi_data3_lssi_data1_p),
        .dio_1_tx0_cssi_gpio_enb              (),
        .dio_1_tx0_cssi_gpio_in               (10'd0),
        .dio_1_tx0_cssi_gpio_out              (),
        .dio_1_tx0_cssi_nc_lssi_clk_n         (d1_tx0_cssi_nc_lssi_clk_n),
        .dio_1_tx0_cssi_nc_lssi_refclk_n      (d1_tx0_cssi_nc_lssi_refclk_n),
        .dio_1_tx0_cssi_nc_lssi_strobe_n      (d1_tx0_cssi_nc_lssi_strobe_n),
        .dio_1_tx0_cssi_refclk_lssi_refclk_p  (d1_tx0_cssi_refclk_lssi_refclk_p),
        .dio_1_tx0_cssi_strobe_lssi_strobe_p  (d1_tx0_cssi_strobe_lssi_strobe_p),
        .dio_1_tx0_enable                     (d1_tx0_enable),
        .dio_1_tx1_cssi_clk_lssi_clk_p        (d1_tx1_cssi_clk_lssi_clk_p),
        .dio_1_tx1_cssi_data0_lssi_data0_n    (d1_tx1_cssi_data0_lssi_data0_n),
        .dio_1_tx1_cssi_data1_lssi_data0_p    (d1_tx1_cssi_data1_lssi_data0_p),
        .dio_1_tx1_cssi_data2_lssi_data1_n    (d1_tx1_cssi_data2_lssi_data1_n),
        .dio_1_tx1_cssi_data3_lssi_data1_p    (d1_tx1_cssi_data3_lssi_data1_p),
        .dio_1_tx1_cssi_gpio_enb              (),
        .dio_1_tx1_cssi_gpio_in               (10'd0),
        .dio_1_tx1_cssi_gpio_out              (),
        .dio_1_tx1_cssi_nc_lssi_clk_n         (d1_tx1_cssi_nc_lssi_clk_n),
        .dio_1_tx1_cssi_nc_lssi_refclk_n      (d1_tx1_cssi_nc_lssi_refclk_n),
        .dio_1_tx1_cssi_nc_lssi_strobe_n      (d1_tx1_cssi_nc_lssi_strobe_n),
        .dio_1_tx1_cssi_refclk_lssi_refclk_p  (d1_tx1_cssi_refclk_lssi_refclk_p),
        .dio_1_tx1_cssi_strobe_lssi_strobe_p  (d1_tx1_cssi_strobe_lssi_strobe_p),
        .dio_1_tx1_enable                     (d1_tx1_enable),
        .dio_dev_clk                          (d0_dev_clk),
        .dio_dgpio                            (d0_dgpio),
        .dio_gp_int                           (d0_gp_int),
        .dio_mode                             (d0_mode),
        .dio_resetb                           (d0_resetb),
        .dio_rx0_cssi_clk_lssi_clk_p          (d0_rx0_cssi_clk_lssi_clk_p),
        .dio_rx0_cssi_data0_lssi_data0_n      (d0_rx0_cssi_data0_lssi_data0_n),
        .dio_rx0_cssi_data1_lssi_data0_p      (d0_rx0_cssi_data1_lssi_data0_p),
        .dio_rx0_cssi_data2_lssi_data1_n      (d0_rx0_cssi_data2_lssi_data1_n),
        .dio_rx0_cssi_data3_lssi_data1_p      (d0_rx0_cssi_data3_lssi_data1_p),
        .dio_rx0_cssi_gpio_enb                (),
        .dio_rx0_cssi_gpio_in                 (8'd0),
        .dio_rx0_cssi_gpio_out                (),
        .dio_rx0_cssi_nc_lssi_clk_n           (d0_rx0_cssi_nc_lssi_clk_n),
        .dio_rx0_cssi_nc_lssi_strobe_n        (d0_rx0_cssi_nc_lssi_strobe_n),
        .dio_rx0_cssi_strobe_lssi_strobe_p    (d0_rx0_cssi_strobe_lssi_strobe_p),
        .dio_rx0_enable                       (d0_rx0_enable),
        .dio_rx1_cssi_clk_lssi_clk_p          (d0_rx1_cssi_clk_lssi_clk_p),
        .dio_rx1_cssi_data0_lssi_data0_n      (d0_rx1_cssi_data0_lssi_data0_n),
        .dio_rx1_cssi_data1_lssi_data0_p      (d0_rx1_cssi_data1_lssi_data0_p),
        .dio_rx1_cssi_data2_lssi_data1_n      (d0_rx1_cssi_data2_lssi_data1_n),
        .dio_rx1_cssi_data3_lssi_data1_p      (d0_rx1_cssi_data3_lssi_data1_p),
        .dio_rx1_cssi_gpio_enb                (),
        .dio_rx1_cssi_gpio_in                 (8'd0),
        .dio_rx1_cssi_gpio_out                (),
        .dio_rx1_cssi_nc_lssi_clk_n           (d0_rx1_cssi_nc_lssi_clk_n),
        .dio_rx1_cssi_nc_lssi_strobe_n        (d0_rx1_cssi_nc_lssi_strobe_n),
        .dio_rx1_cssi_strobe_lssi_strobe_p    (d0_rx1_cssi_strobe_lssi_strobe_p),
        .dio_rx1_enable                       (d0_rx1_enable),
        .dio_tx0_cssi_clk_lssi_clk_p          (d0_tx0_cssi_clk_lssi_clk_p),
        .dio_tx0_cssi_data0_lssi_data0_n      (d0_tx0_cssi_data0_lssi_data0_n),
        .dio_tx0_cssi_data1_lssi_data0_p      (d0_tx0_cssi_data1_lssi_data0_p),
        .dio_tx0_cssi_data2_lssi_data1_n      (d0_tx0_cssi_data2_lssi_data1_n),
        .dio_tx0_cssi_data3_lssi_data1_p      (d0_tx0_cssi_data3_lssi_data1_p),
        .dio_tx0_cssi_gpio_enb                (),
        .dio_tx0_cssi_gpio_in                 (10'd0),
        .dio_tx0_cssi_gpio_out                (),
        .dio_tx0_cssi_nc_lssi_clk_n           (d0_tx0_cssi_nc_lssi_clk_n),
        .dio_tx0_cssi_nc_lssi_refclk_n        (d0_tx0_cssi_nc_lssi_refclk_n),
        .dio_tx0_cssi_nc_lssi_strobe_n        (d0_tx0_cssi_nc_lssi_strobe_n),
        .dio_tx0_cssi_refclk_lssi_refclk_p    (d0_tx0_cssi_refclk_lssi_refclk_p),
        .dio_tx0_cssi_strobe_lssi_strobe_p    (d0_tx0_cssi_strobe_lssi_strobe_p),
        .dio_tx0_enable                       (d0_tx0_enable),
        .dio_tx1_cssi_clk_lssi_clk_p          (d0_tx1_cssi_clk_lssi_clk_p),
        .dio_tx1_cssi_data0_lssi_data0_n      (d0_tx1_cssi_data0_lssi_data0_n),
        .dio_tx1_cssi_data1_lssi_data0_p      (d0_tx1_cssi_data1_lssi_data0_p),
        .dio_tx1_cssi_data2_lssi_data1_n      (d0_tx1_cssi_data2_lssi_data1_n),
        .dio_tx1_cssi_data3_lssi_data1_p      (d0_tx1_cssi_data3_lssi_data1_p),
        .dio_tx1_cssi_gpio_enb                (),
        .dio_tx1_cssi_gpio_in                 (10'd0),
        .dio_tx1_cssi_gpio_out                (),
        .dio_tx1_cssi_nc_lssi_clk_n           (d0_tx1_cssi_nc_lssi_clk_n),
        .dio_tx1_cssi_nc_lssi_refclk_n        (d0_tx1_cssi_nc_lssi_refclk_n),
        .dio_tx1_cssi_nc_lssi_strobe_n        (d0_tx1_cssi_nc_lssi_strobe_n),
        .dio_tx1_cssi_refclk_lssi_refclk_p    (d0_tx1_cssi_refclk_lssi_refclk_p),
        .dio_tx1_cssi_strobe_lssi_strobe_p    (d0_tx1_cssi_strobe_lssi_strobe_p),
        .dio_tx1_enable                       (d0_tx1_enable),
        .gpio_in                              ({gpio_pb, gpio_sw}),
        .gpio_out                             (gpio_led),
        .pl_ddr_act_n                         (pl_ddr_act_n),
        .pl_ddr_adr                           (pl_ddr_adr),
        .pl_ddr_ba                            (pl_ddr_ba),
        .pl_ddr_bg                            (pl_ddr_bg),
        .pl_ddr_ck_c                          (pl_ddr_ck_c),
        .pl_ddr_ck_t                          (pl_ddr_ck_t),
        .pl_ddr_cke                           (pl_ddr_cke),
        .pl_ddr_cs_n                          (pl_ddr_cs_n),
        .pl_ddr_dm_n                          (pl_ddr_dm_n),
        .pl_ddr_dq                            (pl_ddr_dq),
        .pl_ddr_dqs_c                         (pl_ddr_dqs_c),
        .pl_ddr_dqs_t                         (pl_ddr_dqs_t),
        .pl_ddr_odt                           (pl_ddr_odt),
        .pl_ddr_refclk_clk_n                  (pl_ddr_refclk_clk_n),
        .pl_ddr_refclk_clk_p                  (pl_ddr_refclk_clk_p),
        .pl_ddr_reset                         (pl_ddr_reset),
        .pl_ddr_reset_n                       (pl_ddr_reset_n),
        .spi_miso                             (spi_miso),
        .spi_mosi                             (spi_mosi),
        .spi_sclk                             (spi_sclk),
        .spi_ssn                              (spi_ssn),
        .sys_1_mcs_in_n                       (1'd0),
        .sys_1_mcs_in_p                       (1'd0),
        .sys_1_mcs_out_n                      (),
        .sys_1_mcs_out_p                      (),
        .sys_1_ref_clk_n                      (1'd0),
        .sys_1_ref_clk_p                      (1'd0),
        .sys_mcs_in_n                         (mcs_in_n),
        .sys_mcs_in_p                         (mcs_in_p),
        .sys_mcs_out_n                        (),
        .sys_mcs_out_p                        (mcs_out),
        .sys_ref_clk_n                        (ref_clk_n),
        .sys_ref_clk_p                        (ref_clk_p),
        .trig                                 (trig),
        .vadj_err                             (vadj_err));

endmodule

// **********************************************************************************
// **********************************************************************************
