## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Rev.A ZCU102
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set mode [lindex $argv 0]
if {($mode ne "mll") && ($mode ne "mcc")} {
    return -code error [format "ERROR: mode $mode NOT supported!"]
}

source ../../../bin/vivado_include.tcl

create_project adrv9001cc_zcu102 $mode -part xczu9eg-ffvb1156-2-e -force
set_property board_part xilinx.com:zcu102:part0:3.3 [current_project]
msg_settings none

set_property ip_repo_paths {../../../library} [current_fileset]
update_ip_catalog

set ip_core_list {}
lappend ip_core_list ../../../library/axi_dma
lappend ip_core_list ../../../library/axi_mspi
lappend ip_core_list ../../../library/axi_sysid
lappend ip_core_list ../../../library/axi_txdma
lappend ip_core_list ../../../library/axi_rxdma
lappend ip_core_list ../../../library/axi_m1page
lappend ip_core_list ../../../library/axi_adrv9001

set ps_ddr_size 4

create_bd_design system
source ../../common/hdl/zcu102_bd.tcl
source ../../adrv9001_common/hdl/adrv9001_bd.tcl

if {$mode eq "mll"} {
    set params_int $PLATFORM_X1_MLL_ZCU102_REVB
    set params_str [gen_system_id {ADRV9001 ZCU102 LVDS-COMMON-CLOCK}]
    set_property config.axi_adrv9001_mcs_out_cmos1_lvds0 0 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_rx0_gpio2_cmos1_lvds0 0 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_tx0_gpio2_cmos1_lvds0 0 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_rx1_gpio2_cmos1_lvds0 0 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_tx1_gpio2_cmos1_lvds0 0 [get_bd_cells axi_adrv9001]
}

if {$mode eq "mcc"} {
    set params_int $PLATFORM_X1_MCC_ZCU102_REVB
    set params_str [gen_system_id {ADRV9001 ZCU102 CMOS-COMMON-CLOCK}]
    set_property config.axi_adrv9001_mcs_out_cmos1_lvds0 1 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_rx0_gpio2_cmos1_lvds0 1 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_tx0_gpio2_cmos1_lvds0 1 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_rx1_gpio2_cmos1_lvds0 1 [get_bd_cells axi_adrv9001]
    set_property config.axi_adrv9001_tx1_gpio2_cmos1_lvds0 1 [get_bd_cells axi_adrv9001]
}

set_property config.sys_params $params_int [get_bd_cells axi_sysid]
set_property config.sys_info_0 $params_str [get_bd_cells axi_sysid]
set_property config.axi_adrv9001_device_type ULTRASCALE [get_bd_cells axi_adrv9001]
connect_bd_net [get_bd_pins axi_adrv9001/tx_clk_resetn_out] [get_bd_pins axi_adrv9001/tx_clk_resetn_in]
connect_bd_net [get_bd_pins axi_adrv9001/tx_phy_resetn_out] [get_bd_pins axi_adrv9001/tx_phy_resetn_in]
connect_bd_net [get_bd_pins axi_adrv9001/tx_dp_resetn_out] [get_bd_pins axi_adrv9001/tx_dp_resetn_in]
connect_bd_net [get_bd_pins axi_adrv9001/rx_clk_resetn_out] [get_bd_pins axi_adrv9001/rx_clk_resetn_in]
connect_bd_net [get_bd_pins axi_adrv9001/rx_phy_resetn_out] [get_bd_pins axi_adrv9001/rx_phy_resetn_in]
connect_bd_net [get_bd_pins axi_adrv9001/rx_dp_resetn_out] [get_bd_pins axi_adrv9001/rx_dp_resetn_in]

set_property config.axi_adrv9001_tx0_refclk_disable 1 [get_bd_cells axi_adrv9001]
set_property config.axi_adrv9001_tx1_refclk_disable 1 [get_bd_cells axi_adrv9001]

save_bd_design
generate_address_map ../../adrv9001_common/sw/adrv9001cc_zcu102.h

set project_source_list {}
lappend project_source_list adrv9001cc_zcu102.v
lappend project_source_list ../../common/hdl/zcu102_constr.xdc
lappend project_source_list ../../adrv9001_zcu102/hdl/adrv9001_zcu102_lvds_constr.xdc
lappend project_source_list ../../adrv9001_zcu102/hdl/adrv9001_zcu102_cmos_constr.xdc
lappend project_source_list ../../adrv9001_zcu102/hdl/adrv9001_zcu102_ssi0_cmos_constr.xdc
lappend project_source_list ../../adrv9001_zcu102/hdl/adrv9001_zcu102_ssi1_cmos_constr.xdc
lappend project_source_list adrv9001cc_zcu102_constr.xdc
lappend project_source_list adrv9001cc_zcu102_ssi0_lvds_constr.xdc
lappend project_source_list adrv9001cc_zcu102_ssi1_lvds_constr.xdc
set ip_file_list $project_source_list
add_files -norecurse -fileset [get_filesets sources_1] $ip_file_list
set_property synth_checkpoint_mode none [get_files system.bd]
set_property top adrv9001cc_zcu102 [current_fileset]

generate_target {synthesis implementation} [get_files system.bd]

if {$mode eq "mll"} {
    set_property is_enabled false [get_files  *adrv9001_zcu102_cmos_constr.xdc]
    set_property is_enabled false [get_files  *adrv9001_zcu102_ssi0_cmos_constr.xdc]
    set_property is_enabled false [get_files  *adrv9001_zcu102_ssi1_cmos_constr.xdc]
}

if {$mode eq "mcc"} {
    set_property is_enabled false [get_files  *adrv9001_zcu102_lvds_constr.xdc]
    set_property is_enabled false [get_files  *adrv9001cc_zcu102_ssi0_lvds_constr.xdc]
    set_property is_enabled false [get_files  *adrv9001cc_zcu102_ssi1_lvds_constr.xdc]
}

set_property steps.write_bitstream.args.bin_file true [get_runs impl_1]

launch_runs synth_1 -jobs 8
wait_on_run synth_1
launch_runs impl_1 -to_step write_bitstream -jobs 8
wait_on_run impl_1

if {[get_property stats.wns [get_runs impl_1]] < 0.0} {
    return -code error [format "ERROR: Timing Constraints (setup) NOT met!"]
}

if {[get_property stats.whs [get_runs impl_1]] < 0.0} {
    return -code error [format "ERROR: Timing Constraints (hold) NOT met!"]
}

write_hw_platform -fixed -include_bit -force $mode/adrv9001cc_zcu102_$mode.xsa
file copy -force $mode/adrv9001cc_zcu102.runs/impl_1/adrv9001cc_zcu102.bit $mode/adrv9001cc_zcu102_$mode.bit

## ##################################################################################
## ##################################################################################
