## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Rev.A ZCU102
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## ADRV9001 Common

set_property -dict {PACKAGE_PIN W5    IOSTANDARD  LVCMOS18} [get_ports rx0_enable]      ; ##  C14  FMC_HPC0_LA10_P      IO_L15P_T2L_N4_AD11P_66       rx1_enable
set_property -dict {PACKAGE_PIN K15   IOSTANDARD  LVCMOS18} [get_ports rx1_enable]      ; ##  D27  FMC_HPC0_LA26_N      IO_L24N_T3U_N11_67            rx2_enable
set_property -dict {PACKAGE_PIN W2    IOSTANDARD  LVCMOS18} [get_ports tx0_enable]      ; ##  D14  FMC_HPC0_LA09_P      IO_L24P_T3U_N10_66            tx1_enable
set_property -dict {PACKAGE_PIN U9    IOSTANDARD  LVCMOS18} [get_ports tx1_enable]      ; ##  G30  FMC_HPC0_LA29_P      IO_L9P_T1L_N4_AD12P_67        tx2_enable
set_property -dict {PACKAGE_PIN Y12   IOSTANDARD  LVCMOS18} [get_ports {dgpio[0]}]      ; ##  G18  FMC_HPC0_LA16_P      IO_L5P_T0U_N8_AD14P_66        dgpio_0
set_property -dict {PACKAGE_PIN AA12  IOSTANDARD  LVCMOS18} [get_ports {dgpio[1]}]      ; ##  G19  FMC_HPC0_LA16_N      IO_L5N_T0U_N9_AD14N_66        dgpio_1
set_property -dict {PACKAGE_PIN Y9    IOSTANDARD  LVCMOS18} [get_ports {dgpio[2]}]      ; ##  H20  FMC_HPC0_LA15_N      IO_L6N_T0U_N11_AD6N_66        dgpio_2
set_property -dict {PACKAGE_PIN AB5   IOSTANDARD  LVCMOS18} [get_ports {dgpio[3]}]      ; ##  H17  FMC_HPC0_LA11_N      IO_L10N_T1U_N7_QBC_AD4N_66    dgpio_3
set_property -dict {PACKAGE_PIN W1    IOSTANDARD  LVCMOS18} [get_ports {dgpio[4]}]      ; ##  D15  FMC_HPC0_LA09_N      IO_L24N_T3U_N11_66            dgpio_4
set_property -dict {PACKAGE_PIN W4    IOSTANDARD  LVCMOS18} [get_ports {dgpio[5]}]      ; ##  C15  FMC_HPC0_LA10_N      IO_L15N_T2L_N5_AD11N_66       dgpio_5
set_property -dict {PACKAGE_PIN M10   IOSTANDARD  LVCMOS18} [get_ports {dgpio[6]}]      ; ##  C26  FMC_HPC0_LA27_P      IO_L15P_T2L_N4_AD11P_67       dgpio_6
set_property -dict {PACKAGE_PIN L15   IOSTANDARD  LVCMOS18} [get_ports {dgpio[7]}]      ; ##  D26  FMC_HPC0_LA26_P      IO_L24P_T3U_N10_67            dgpio_7
set_property -dict {PACKAGE_PIN T7    IOSTANDARD  LVCMOS18} [get_ports {dgpio[8]}]      ; ##  H31  FMC_HPC0_LA28_P      IO_L10P_T1U_N6_QBC_AD4P_67    dgpio_8
set_property -dict {PACKAGE_PIN T6    IOSTANDARD  LVCMOS18} [get_ports {dgpio[9]}]      ; ##  H32  FMC_HPC0_LA28_N      IO_L10N_T1U_N7_QBC_AD4N_67    dgpio_9
set_property -dict {PACKAGE_PIN AB6   IOSTANDARD  LVCMOS18} [get_ports {dgpio[10]}]     ; ##  H16  FMC_HPC0_LA11_P      IO_L10P_T1U_N6_QBC_AD4P_66    dgpio_10
set_property -dict {PACKAGE_PIN L10   IOSTANDARD  LVCMOS18} [get_ports {dgpio[11]}]     ; ##  C27  FMC_HPC0_LA27_N      IO_L15N_T2L_N5_AD11N_67       dgpio_11
set_property -dict {PACKAGE_PIN AB8   IOSTANDARD  LVCMOS18} [get_ports mode]            ; ##  D17  FMC_HPC0_LA13_P      IO_L8P_T1L_N2_AD5P_66         mode
set_property -dict {PACKAGE_PIN AC8   IOSTANDARD  LVCMOS18} [get_ports resetb]          ; ##  D18  FMC_HPC0_LA13_N      IO_L8N_T1L_N3_AD5N_66         reset_trx
set_property -dict {PACKAGE_PIN V6    IOSTANDARD  LVCMOS18} [get_ports gp_int]          ; ##  H34  FMC_HPC0_LA30_P      IO_L8P_T1L_N2_AD5P_67         gp_int
set_property -dict {PACKAGE_PIN AA7   IOSTANDARD  LVCMOS18} [get_ports dev_clk]         ; ##  H04  FMC_HPC0_CLK0_M2C_P  IO_L12P_T1U_N10_GC_66         dev_clk_out
set_property -dict {PACKAGE_PIN U11   IOSTANDARD  LVDS}     [get_ports mcs_in_p]        ; ##  H37  FMC_HPC0_LA32_P      IO_L6P_T0U_N10_AD6P_67        fpga_mcs_in+
set_property -dict {PACKAGE_PIN T11   IOSTANDARD  LVDS}     [get_ports mcs_in_n]        ; ##  H38  FMC_HPC0_LA32_N      IO_L6N_T0U_N11_AD6N_67        fpga_mcs_in-
set_property -dict {PACKAGE_PIN T8    IOSTANDARD  LVDS}     [get_ports ref_clk_p]       ; ##  G02  FMC_HPC0_CLK1_M2C_P  IO_L12P_T1U_N10_GC_67         fpga_ref_clk+
set_property -dict {PACKAGE_PIN R8    IOSTANDARD  LVDS}     [get_ports ref_clk_n]       ; ##  G03  FMC_HPC0_CLK1_M2C_N  IO_L12N_T1U_N11_GC_67         fpga_ref_clk-
set_property -dict {PACKAGE_PIN V8    IOSTANDARD  LVCMOS18} [get_ports vadj_err]        ; ##  G33  FMC_HPC0_LA31_P      IO_L7P_T1L_N0_QBC_AD13P_67    vadj_err
set_property -dict {PACKAGE_PIN V7    IOSTANDARD  LVCMOS18} [get_ports status]          ; ##  G34  FMC_HPC0_LA31_N      IO_L7N_T1L_N1_QBC_AD13N_67    platform_status
set_property -dict {PACKAGE_PIN AA6   IOSTANDARD  LVCMOS18} [get_ports fan_tach]        ; ##  H05  FMC_HPC0_CLK0_M2C_N  IO_L12N_T1U_N11_GC_66         fan_tach

set_property -dict {PACKAGE_PIN Y10   IOSTANDARD  LVCMOS18} [get_ports spi_ssn]         ; ##  H19  FMC_HPC0_LA15_P      IO_L6P_T0U_N10_AD6P_66        spi_en
set_property -dict {PACKAGE_PIN W7    IOSTANDARD  LVCMOS18} [get_ports spi_sclk]        ; ##  G15  FMC_HPC0_LA12_P      IO_L9P_T1L_N4_AD12P_66        spi_clk
set_property -dict {PACKAGE_PIN U8    IOSTANDARD  LVCMOS18} [get_ports spi_mosi]        ; ##  G31  FMC_HPC0_LA29_N      IO_L9N_T1L_N5_AD12N_67        spi_dio
set_property -dict {PACKAGE_PIN W6    IOSTANDARD  LVCMOS18} [get_ports spi_miso]        ; ##  G16  FMC_HPC0_LA12_N      IO_L9N_T1L_N5_AD12N_66        spi_do

set_property -dict {PACKAGE_PIN H16   IOSTANDARD  LVCMOS33} [get_ports {trig[0]}]       ; ##  J3.20 PROTO_HEADER        IO_L11P_AD9P_50
set_property -dict {PACKAGE_PIN G16   IOSTANDARD  LVCMOS33} [get_ports {trig[1]}]       ; ##  J3.18 PROTO_HEADER        IO_L11N_AD9N_50

set_property diff_term_adv term_100 [get_ports ref_clk_p]
set_property diff_term_adv term_100 [get_ports ref_clk_n]
set_property diff_term_adv term_100 [get_ports mcs_in_p]
set_property diff_term_adv term_100 [get_ports mcs_in_n]

## ##################################################################################
## ##################################################################################
## ADRV9001 Clocks

create_clock -name dev_clk_in -period 52.083 [get_ports dev_clk]
create_clock -name ref_clk_in -period 26.041 [get_ports ref_clk_p]

set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_clkgen/i_mux_clk/I1}]]

## ##################################################################################
## ##################################################################################

set_property CLOCK_DELAY_GROUP TX0_B66_X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_mux_clk/O}]]
set_property CLOCK_DELAY_GROUP TX0_B66_X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_hs_clk/O}]]
set_property CLOCK_DELAY_GROUP TX0_B66_X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_clk/O}]]
set_property USER_CLOCK_ROOT X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_mux_clk/O}]]
set_property USER_CLOCK_ROOT X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_hs_clk/O}]]
set_property USER_CLOCK_ROOT X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx0*i_clk/O}]]
set_property LOC BUFGCE_X0Y68     [get_cells -hierarchical -filter {name =~ *i_tx0*i_hs_clk}]
set_property LOC BUFGCE_DIV_X0Y10 [get_cells -hierarchical -filter {name =~ *i_tx0*i_clk}]

set_property CLOCK_DELAY_GROUP TX1_B67_X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_mux_clk/O}]]
set_property CLOCK_DELAY_GROUP TX1_B67_X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_hs_clk/O}]]
set_property CLOCK_DELAY_GROUP TX1_B67_X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_clk/O}]]
set_property USER_CLOCK_ROOT X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_mux_clk/O}]]
set_property USER_CLOCK_ROOT X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_hs_clk/O}]]
set_property USER_CLOCK_ROOT X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_tx1*i_clk/O}]]
set_property LOC BUFGCE_X0Y74     [get_cells -hierarchical -filter {name =~ *i_tx1*i_hs_clk}]
set_property LOC BUFGCE_DIV_X0Y14 [get_cells -hierarchical -filter {name =~ *i_tx1*i_clk}]

set_property CLOCK_DELAY_GROUP RX0_B66_X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx0*i_hs_clk/O}]]
set_property CLOCK_DELAY_GROUP RX0_B66_X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx0*i_clk/O}]]
set_property USER_CLOCK_ROOT X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx0*i_hs_clk/O}]]
set_property USER_CLOCK_ROOT X3Y2 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx0*i_clk/O}]]
set_property LOC BUFGCE_X0Y66     [get_cells -hierarchical -filter {name =~ *i_rx0*i_hs_clk}]
set_property LOC BUFGCE_DIV_X0Y8  [get_cells -hierarchical -filter {name =~ *i_rx0*i_clk}]

set_property CLOCK_DELAY_GROUP RX1_B67_X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx1*i_hs_clk/O}]]
set_property CLOCK_DELAY_GROUP RX1_B67_X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx1*i_clk/O}]]
set_property USER_CLOCK_ROOT X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx1*i_hs_clk/O}]]
set_property USER_CLOCK_ROOT X3Y3 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_rx1*i_clk/O}]]
set_property LOC BUFGCE_X0Y72     [get_cells -hierarchical -filter {name =~ *i_rx1*i_hs_clk}]
set_property LOC BUFGCE_DIV_X0Y12 [get_cells -hierarchical -filter {name =~ *i_rx1*i_clk}]

## ##################################################################################
## ##################################################################################
## General

set_property bitstream.general.compress true [current_design]

## ##################################################################################
## ##################################################################################

