// **********************************************************************************
// **********************************************************************************
// ----------------------------------------------------------------------------------
// ################
// ##   ###########   Analog Devices Inc.
// ##      ########
// ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
// ##            ##   This file is the confidential and proprietary property of ADI.
// ##         #####   Possession or use of this file requires a written license.
// ##      ########   The licensing information may be found at: www.analog.com
// ##   ###########
// ################
// ----------------------------------------------------------------------------------
// Description:       ADRV9001 Rev.A ZCU102
// ----------------------------------------------------------------------------------
// **********************************************************************************
// **********************************************************************************

`timescale 1ps/1ps

module adrv9001cc_zcu102 (

    // pl ddr

    output  wire          pl_ddr_act_n,
    output  wire  [16:0]  pl_ddr_adr,
    output  wire  [ 1:0]  pl_ddr_ba,
    output  wire          pl_ddr_bg,
    output  wire          pl_ddr_ck_c,
    output  wire          pl_ddr_ck_t,
    output  wire          pl_ddr_cke,
    output  wire          pl_ddr_cs_n,
    inout   wire  [ 1:0]  pl_ddr_dm_n,
    inout   wire  [15:0]  pl_ddr_dq,
    inout   wire  [ 1:0]  pl_ddr_dqs_c,
    inout   wire  [ 1:0]  pl_ddr_dqs_t,
    output  wire          pl_ddr_odt,
    input   wire          pl_ddr_refclk_clk_n,
    input   wire          pl_ddr_refclk_clk_p,
    output  wire          pl_ddr_reset_n,
    input   wire          pl_ddr_reset,

    // platform gpio

    input   wire  [ 3:0]  gpio_sw,
    input   wire  [ 2:0]  gpio_pb,
    output  wire  [ 3:0]  gpio_led,

    // spi

    output  wire          spi_ssn,
    output  wire          spi_sclk,
    inout   wire          spi_mosi,
    input   wire          spi_miso,

    // reference & monitor clocks

    inout   wire  [ 1:0]  trig,

    // adrv9001 io
 
    input   wire          rx0_cssi_clk_lssi_clk_p,
    input   wire          rx0_cssi_nc_lssi_clk_n,
    input   wire          rx0_cssi_strobe_lssi_strobe_p,
    input   wire          rx0_cssi_nc_lssi_strobe_n,
    input   wire          rx0_cssi_data1_lssi_data0_p,
    input   wire          rx0_cssi_data0_lssi_data0_n,
    input   wire          rx0_cssi_data3_lssi_data1_p,
    input   wire          rx0_cssi_data2_lssi_data1_n,
    input   wire          rx1_cssi_clk_lssi_clk_p,
    input   wire          rx1_cssi_nc_lssi_clk_n,
    input   wire          rx1_cssi_strobe_lssi_strobe_p,
    input   wire          rx1_cssi_nc_lssi_strobe_n,
    input   wire          rx1_cssi_data1_lssi_data0_p,
    input   wire          rx1_cssi_data0_lssi_data0_n,
    input   wire          rx1_cssi_data3_lssi_data1_p,
    input   wire          rx1_cssi_data2_lssi_data1_n,
    inout   wire          tx0_cssi_refclk_lssi_refclk_p,
    inout   wire          tx0_cssi_nc_lssi_refclk_n,
    output  wire          tx0_cssi_clk_lssi_clk_p,
    output  wire          tx0_cssi_nc_lssi_clk_n,
    output  wire          tx0_cssi_strobe_lssi_strobe_p,
    output  wire          tx0_cssi_nc_lssi_strobe_n,
    output  wire          tx0_cssi_data1_lssi_data0_p,
    output  wire          tx0_cssi_data0_lssi_data0_n,
    output  wire          tx0_cssi_data3_lssi_data1_p,
    output  wire          tx0_cssi_data2_lssi_data1_n,
    inout   wire          tx1_cssi_refclk_lssi_refclk_p,
    inout   wire          tx1_cssi_nc_lssi_refclk_n,
    output  wire          tx1_cssi_clk_lssi_clk_p,
    output  wire          tx1_cssi_nc_lssi_clk_n,
    output  wire          tx1_cssi_strobe_lssi_strobe_p,
    output  wire          tx1_cssi_nc_lssi_strobe_n,
    output  wire          tx1_cssi_data1_lssi_data0_p,
    output  wire          tx1_cssi_data0_lssi_data0_n,
    output  wire          tx1_cssi_data3_lssi_data1_p,
    output  wire          tx1_cssi_data2_lssi_data1_n,
    output  wire          rx0_enable,
    output  wire          rx1_enable,
    output  wire          tx0_enable,
    output  wire          tx1_enable,
    inout   wire  [11:0]  dgpio,
    output  wire          mode,
    output  wire          resetb,
    input   wire          gp_int,
    input   wire          dev_clk,

    // system io
 
    input   wire          vadj_err,
    output  wire          status,
    output  wire          fan_tach,
    input   wire          ref_clk_p,
    input   wire          ref_clk_n,
    input   wire          mcs_in_p,
    input   wire          mcs_in_n,
    output  wire          mcs_out_p,
    output  wire          mcs_out_n);

    // internal signals

    wire          [ 9:0]  tx0_cssi_gpio_enb;
    wire          [ 9:0]  tx0_cssi_gpio_in;
    wire          [ 9:0]  tx0_cssi_gpio_out;
    wire          [ 9:0]  tx1_cssi_gpio_enb;
    wire          [ 9:0]  tx1_cssi_gpio_in;
    wire          [ 9:0]  tx1_cssi_gpio_out;

    // ref clocks as gpio

    assign tx0_cssi_gpio_in[9:2] = 8'd0;
    assign tx0_cssi_gpio_in[1] = tx0_cssi_nc_lssi_refclk_n;
    assign tx0_cssi_gpio_in[0] = tx0_cssi_refclk_lssi_refclk_p;

    assign tx0_cssi_refclk_lssi_refclk_p = (tx0_cssi_gpio_enb[0] == 1'd1) ? tx0_cssi_gpio_out[0] : 1'bz;
    assign tx0_cssi_nc_lssi_refclk_n = (tx0_cssi_gpio_enb[1] == 1'd1) ? tx0_cssi_gpio_out[1] : 1'bz;

    assign tx1_cssi_gpio_in[9:2] = 8'd0;
    assign tx1_cssi_gpio_in[0] = tx1_cssi_refclk_lssi_refclk_p;
    assign tx1_cssi_gpio_in[1] = tx1_cssi_nc_lssi_refclk_n;

    assign tx1_cssi_refclk_lssi_refclk_p = (tx1_cssi_gpio_enb[0] == 1'd1) ? tx1_cssi_gpio_out[0] : 1'bz;
    assign tx1_cssi_nc_lssi_refclk_n = (tx1_cssi_gpio_enb[1] == 1'd1) ? tx1_cssi_gpio_out[1] : 1'bz;

    // ipi-system

    system i_system (
        .control                            ({fan_tach, status}),
        .dio_dev_clk                        (dev_clk),
        .dio_dgpio                          (dgpio),
        .dio_gp_int                         (gp_int),
        .dio_mode                           (mode),
        .dio_resetb                         (resetb),
        .dio_rx0_cssi_clk_lssi_clk_p        (rx0_cssi_clk_lssi_clk_p),
        .dio_rx0_cssi_data0_lssi_data0_n    (rx0_cssi_data0_lssi_data0_n),
        .dio_rx0_cssi_data1_lssi_data0_p    (rx0_cssi_data1_lssi_data0_p),
        .dio_rx0_cssi_data2_lssi_data1_n    (rx0_cssi_data2_lssi_data1_n),
        .dio_rx0_cssi_data3_lssi_data1_p    (rx0_cssi_data3_lssi_data1_p),
        .dio_rx0_cssi_gpio_enb              (),
        .dio_rx0_cssi_gpio_in               (8'd0),
        .dio_rx0_cssi_gpio_out              (),
        .dio_rx0_cssi_nc_lssi_clk_n         (rx0_cssi_nc_lssi_clk_n),
        .dio_rx0_cssi_nc_lssi_strobe_n      (rx0_cssi_nc_lssi_strobe_n),
        .dio_rx0_cssi_strobe_lssi_strobe_p  (rx0_cssi_strobe_lssi_strobe_p),
        .dio_rx0_enable                     (rx0_enable),
        .dio_rx1_cssi_clk_lssi_clk_p        (rx1_cssi_clk_lssi_clk_p),
        .dio_rx1_cssi_data0_lssi_data0_n    (rx1_cssi_data0_lssi_data0_n),
        .dio_rx1_cssi_data1_lssi_data0_p    (rx1_cssi_data1_lssi_data0_p),
        .dio_rx1_cssi_data2_lssi_data1_n    (rx1_cssi_data2_lssi_data1_n),
        .dio_rx1_cssi_data3_lssi_data1_p    (rx1_cssi_data3_lssi_data1_p),
        .dio_rx1_cssi_gpio_enb              (),
        .dio_rx1_cssi_gpio_in               (8'd0),
        .dio_rx1_cssi_gpio_out              (),
        .dio_rx1_cssi_nc_lssi_clk_n         (rx1_cssi_nc_lssi_clk_n),
        .dio_rx1_cssi_nc_lssi_strobe_n      (rx1_cssi_nc_lssi_strobe_n),
        .dio_rx1_cssi_strobe_lssi_strobe_p  (rx1_cssi_strobe_lssi_strobe_p),
        .dio_rx1_enable                     (rx1_enable),
        .dio_tx0_cssi_clk_lssi_clk_p        (tx0_cssi_clk_lssi_clk_p),
        .dio_tx0_cssi_data0_lssi_data0_n    (tx0_cssi_data0_lssi_data0_n),
        .dio_tx0_cssi_data1_lssi_data0_p    (tx0_cssi_data1_lssi_data0_p),
        .dio_tx0_cssi_data2_lssi_data1_n    (tx0_cssi_data2_lssi_data1_n),
        .dio_tx0_cssi_data3_lssi_data1_p    (tx0_cssi_data3_lssi_data1_p),
        .dio_tx0_cssi_gpio_enb              (tx0_cssi_gpio_enb),
        .dio_tx0_cssi_gpio_in               (tx0_cssi_gpio_in),
        .dio_tx0_cssi_gpio_out              (tx0_cssi_gpio_out),
        .dio_tx0_cssi_nc_lssi_clk_n         (tx0_cssi_nc_lssi_clk_n),
        .dio_tx0_cssi_nc_lssi_refclk_n      (1'd0),
        .dio_tx0_cssi_nc_lssi_strobe_n      (tx0_cssi_nc_lssi_strobe_n),
        .dio_tx0_cssi_refclk_lssi_refclk_p  (1'd0),
        .dio_tx0_cssi_strobe_lssi_strobe_p  (tx0_cssi_strobe_lssi_strobe_p),
        .dio_tx0_enable                     (tx0_enable),
        .dio_tx1_cssi_clk_lssi_clk_p        (tx1_cssi_clk_lssi_clk_p),
        .dio_tx1_cssi_data0_lssi_data0_n    (tx1_cssi_data0_lssi_data0_n),
        .dio_tx1_cssi_data1_lssi_data0_p    (tx1_cssi_data1_lssi_data0_p),
        .dio_tx1_cssi_data2_lssi_data1_n    (tx1_cssi_data2_lssi_data1_n),
        .dio_tx1_cssi_data3_lssi_data1_p    (tx1_cssi_data3_lssi_data1_p),
        .dio_tx1_cssi_gpio_enb              (tx1_cssi_gpio_enb),
        .dio_tx1_cssi_gpio_in               (tx1_cssi_gpio_in),
        .dio_tx1_cssi_gpio_out              (tx1_cssi_gpio_out),
        .dio_tx1_cssi_nc_lssi_clk_n         (tx1_cssi_nc_lssi_clk_n),
        .dio_tx1_cssi_nc_lssi_refclk_n      (1'd0),
        .dio_tx1_cssi_nc_lssi_strobe_n      (tx1_cssi_nc_lssi_strobe_n),
        .dio_tx1_cssi_refclk_lssi_refclk_p  (1'd0),
        .dio_tx1_cssi_strobe_lssi_strobe_p  (tx1_cssi_strobe_lssi_strobe_p),
        .dio_tx1_enable                     (tx1_enable),
        .gpio_in                            ({gpio_pb, gpio_sw}),
        .gpio_out                           (gpio_led),
        .pl_ddr_act_n                       (pl_ddr_act_n),
        .pl_ddr_adr                         (pl_ddr_adr),
        .pl_ddr_ba                          (pl_ddr_ba),
        .pl_ddr_bg                          (pl_ddr_bg),
        .pl_ddr_ck_c                        (pl_ddr_ck_c),
        .pl_ddr_ck_t                        (pl_ddr_ck_t),
        .pl_ddr_cke                         (pl_ddr_cke),
        .pl_ddr_cs_n                        (pl_ddr_cs_n),
        .pl_ddr_dm_n                        (pl_ddr_dm_n),
        .pl_ddr_dq                          (pl_ddr_dq),
        .pl_ddr_dqs_c                       (pl_ddr_dqs_c),
        .pl_ddr_dqs_t                       (pl_ddr_dqs_t),
        .pl_ddr_odt                         (pl_ddr_odt),
        .pl_ddr_refclk_clk_n                (pl_ddr_refclk_clk_n),
        .pl_ddr_refclk_clk_p                (pl_ddr_refclk_clk_p),
        .pl_ddr_reset                       (pl_ddr_reset),
        .pl_ddr_reset_n                     (pl_ddr_reset_n),
        .spi_sclk                           (spi_sclk),
        .spi_ssn                            (spi_ssn),
        .spi_miso                           (spi_miso),
        .spi_mosi                           (spi_mosi),
        .sys_mcs_in_n                       (mcs_in_n),
        .sys_mcs_in_p                       (mcs_in_p),
        .sys_mcs_out_n                      (mcs_out_n),
        .sys_mcs_out_p                      (mcs_out_p),
        .sys_ref_clk_n                      (ref_clk_n),
        .sys_ref_clk_p                      (ref_clk_p),
        .trig                               (trig),
        .vadj_err                           (vadj_err));

endmodule

// **********************************************************************************
// **********************************************************************************
