## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Rev.A ZC706
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################
## ADRV9001 Common

set_property -dict {PACKAGE_PIN AC14  IOSTANDARD  LVCMOS25} [get_ports rx0_enable]      ; ##  C14  FMC_LPC_LA10_P     IO_L19P_T3_10       rx1_enable
set_property -dict {PACKAGE_PIN AK30  IOSTANDARD  LVCMOS25} [get_ports rx1_enable]      ; ##  D27  FMC_LPC_LA26_N     IO_L20N_T3_12       rx2_enable
set_property -dict {PACKAGE_PIN AH14  IOSTANDARD  LVCMOS25} [get_ports tx0_enable]      ; ##  D14  FMC_LPC_LA09_P     IO_L8P_T1_10        tx1_enable
set_property -dict {PACKAGE_PIN AE25  IOSTANDARD  LVCMOS25} [get_ports tx1_enable]      ; ##  G30  FMC_LPC_LA29_P     IO_L18P_T2_12       tx2_enable
set_property -dict {PACKAGE_PIN AE18  IOSTANDARD  LVCMOS25} [get_ports {dgpio[0]}]      ; ##  G18  FMC_LPC_LA16_P     IO_L17P_T2_10       dgpio_0
set_property -dict {PACKAGE_PIN AE17  IOSTANDARD  LVCMOS25} [get_ports {dgpio[1]}]      ; ##  G19  FMC_LPC_LA16_N     IO_L17N_T2_10       dgpio_1
set_property -dict {PACKAGE_PIN AB14  IOSTANDARD  LVCMOS25} [get_ports {dgpio[2]}]      ; ##  H20  FMC_LPC_LA15_N     IO_L22N_T3_10       dgpio_2
set_property -dict {PACKAGE_PIN AK16  IOSTANDARD  LVCMOS25} [get_ports {dgpio[3]}]      ; ##  H17  FMC_LPC_LA11_N     IO_L4N_T0_10        dgpio_3
set_property -dict {PACKAGE_PIN AH13  IOSTANDARD  LVCMOS25} [get_ports {dgpio[4]}]      ; ##  D15  FMC_LPC_LA09_N     IO_L8N_T1_10        dgpio_4
set_property -dict {PACKAGE_PIN AC13  IOSTANDARD  LVCMOS25} [get_ports {dgpio[5]}]      ; ##  C15  FMC_LPC_LA10_N     IO_L19N_T3_VREF_10  dgpio_5
set_property -dict {PACKAGE_PIN AJ28  IOSTANDARD  LVCMOS25} [get_ports {dgpio[6]}]      ; ##  C26  FMC_LPC_LA27_P     IO_L21P_T3_DQS_12   dgpio_6
set_property -dict {PACKAGE_PIN AJ30  IOSTANDARD  LVCMOS25} [get_ports {dgpio[7]}]      ; ##  D26  FMC_LPC_LA26_P     IO_L20P_T3_12       dgpio_7
set_property -dict {PACKAGE_PIN AD25  IOSTANDARD  LVCMOS25} [get_ports {dgpio[8]}]      ; ##  H31  FMC_LPC_LA28_P     IO_L10P_T1_12       dgpio_8
set_property -dict {PACKAGE_PIN AE26  IOSTANDARD  LVCMOS25} [get_ports {dgpio[9]}]      ; ##  H32  FMC_LPC_LA28_N     IO_L10N_T1_12       dgpio_9
set_property -dict {PACKAGE_PIN AJ16  IOSTANDARD  LVCMOS25} [get_ports {dgpio[10]}]     ; ##  H16  FMC_LPC_LA11_P     IO_L4P_T0_10        dgpio_10
set_property -dict {PACKAGE_PIN AJ29  IOSTANDARD  LVCMOS25} [get_ports {dgpio[11]}]     ; ##  C27  FMC_LPC_LA27_N     IO_L21N_T3_DQS_12   dgpio_11
set_property -dict {PACKAGE_PIN AH17  IOSTANDARD  LVCMOS25} [get_ports mode]            ; ##  D17  FMC_LPC_LA13_P     IO_L6P_T0_10        mode
set_property -dict {PACKAGE_PIN AH16  IOSTANDARD  LVCMOS25} [get_ports resetb]          ; ##  D18  FMC_LPC_LA13_N     IO_L6N_T0_VREF_10   reset_trx
set_property -dict {PACKAGE_PIN AB29  IOSTANDARD  LVCMOS25} [get_ports gp_int]          ; ##  H34  FMC_LPC_LA30_P     IO_L2P_T0_12        gp_int
set_property -dict {PACKAGE_PIN AG17  IOSTANDARD  LVCMOS25} [get_ports dev_clk]         ; ##  H04  FMC_LPC_CLK0_M2C_P IO_L13P_T2_MRCC_10  dev_clk_out
set_property -dict {PACKAGE_PIN Y26   IOSTANDARD  LVDS_25}  [get_ports mcs_in_p]        ; ##  H37  FMC_LPC_LA32_P     IO_L3P_T0_DQS_12    fpga_mcs_in+
set_property -dict {PACKAGE_PIN Y27   IOSTANDARD  LVDS_25}  [get_ports mcs_in_n]        ; ##  H38  FMC_LPC_LA32_N     IO_L3N_T0_DQS_12    fpga_mcs_in-
set_property -dict {PACKAGE_PIN AC28  IOSTANDARD  LVDS_25}  [get_ports ref_clk_p]       ; ##  G02  FMC_LPC_CLK1_M2C_P IO_L12P_T1_MRCC_12  fpga_ref_clk+
set_property -dict {PACKAGE_PIN AD28  IOSTANDARD  LVDS_25}  [get_ports ref_clk_n]       ; ##  G03  FMC_LPC_CLK1_M2C_N IO_L12N_T1_MRCC_12  fpga_ref_clk-
set_property -dict {PACKAGE_PIN AC29  IOSTANDARD  LVCMOS25} [get_ports vadj_err]        ; ##  G33  FMC_LPC_LA31_P     IO_L9P_T1_DQS_12    vadj_err
set_property -dict {PACKAGE_PIN AD29  IOSTANDARD  LVCMOS25} [get_ports status]          ; ##  G34  FMC_LPC_LA31_N     IO_L9N_T1_DQS_12    platform_status
set_property -dict {PACKAGE_PIN AG16  IOSTANDARD  LVCMOS25} [get_ports fan_tach]        ; ##  H05  FMC_LPC_CLK0_M2C_N IO_L13N_T2_MRCC_10  fan_tach

set_property -dict {PACKAGE_PIN AB15  IOSTANDARD  LVCMOS25} [get_ports spi_ssn]         ; ##  H19  FMC_LPC_LA15_P     IO_L22P_T3_10       spi_en
set_property -dict {PACKAGE_PIN AD16  IOSTANDARD  LVCMOS25} [get_ports spi_sclk]        ; ##  G15  FMC_LPC_LA12_P     IO_L18P_T2_10       spi_clk
set_property -dict {PACKAGE_PIN AF25  IOSTANDARD  LVCMOS25} [get_ports spi_mosi]        ; ##  G31  FMC_LPC_LA29_N     IO_L18N_T2_12       spi_dio
set_property -dict {PACKAGE_PIN AD15  IOSTANDARD  LVCMOS25} [get_ports spi_miso]        ; ##  G16  FMC_LPC_LA12_N     IO_L18N_T2_10       spi_do

set_property -dict {PACKAGE_PIN AD18  IOSTANDARD  LVCMOS25} [get_ports {trig[0]}]       ; ##  J67 USER_SMA_CLOCK_P
set_property -dict {PACKAGE_PIN AD19  IOSTANDARD  LVCMOS25} [get_ports {trig[1]}]       ; ##  J68 USER_SMA_CLOCK_N

set_property diff_term true [get_ports ref_clk_p]
set_property diff_term true [get_ports ref_clk_n]
set_property diff_term true [get_ports mcs_in_p]
set_property diff_term true [get_ports mcs_in_n]

## ##################################################################################
## ##################################################################################
## ADRV9001 Placer

set_property loc IDELAY_X0Y75 [get_cells -hierarchical -filter {name =~ *axi_adrv9001/inst/i_tx0*i_delay_ext_clk}]
set_property loc IDELAY_X0Y73 [get_cells -hierarchical -filter {name =~ *axi_adrv9001/inst/i_tx0*i_delay_clk}]
set_property loc IDELAY_X0Y175 [get_cells -hierarchical -filter {name =~ *axi_adrv9001/inst/i_tx1*i_delay_ext_clk}]
set_property loc IDELAY_X0Y173 [get_cells -hierarchical -filter {name =~ *axi_adrv9001/inst/i_tx1*i_delay_clk}]

## ##################################################################################
## ##################################################################################
## ADRV9001 Clocks

create_clock -name rx0_clk_in -period 2.00 [get_ports rx0_cssi_clk_lssi_clk_p]
create_clock -name rx1_clk_in -period 2.00 [get_ports rx1_cssi_clk_lssi_clk_p]
create_clock -name dev_clk_in -period 52.083 [get_ports dev_clk]
create_clock -name ref_clk_in -period 26.041 [get_ports ref_clk_p]
create_clock -name rx0_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001/rx0_clk}]]
create_clock -name rx1_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001/rx1_clk}]]
create_clock -name tx0_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001/tx0_clk}]]
create_clock -name tx1_clk -period 8.00 [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *axi_adrv9001/tx1_clk}]]

set_property CLOCK_DEDICATED_ROUTE FALSE [get_nets -of_objects [get_pins -hierarchical -filter {name =~ *i_clkgen/i_mux_clk/I1}]]

## ##################################################################################
## ##################################################################################
## General

set_property bitstream.general.compress true [current_design]

## ##################################################################################
## ##################################################################################

