## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Rev.A ZCU102
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property -dict {PACKAGE_PIN P11   IOSTANDARD  LVDS}   [get_ports rx1_cssi_clk_lssi_clk_p]         ; ##  D20  FMC_HPC0_LA17_CC_P       IO_L13P_T2L_N0_GC_QBC_67      rx2_dclk_out+
set_property -dict {PACKAGE_PIN N11   IOSTANDARD  LVDS}   [get_ports rx1_cssi_nc_lssi_clk_n]          ; ##  D21  FMC_HPC0_LA17_CC_N       IO_L13N_T2L_N1_GC_QBC_67      rx2_dclk_out-
set_property -dict {PACKAGE_PIN P12   IOSTANDARD  LVDS}   [get_ports rx1_cssi_strobe_lssi_strobe_p]   ; ##  H25  FMC_HPC0_LA21_P          IO_L21P_T3L_N4_AD8P_67        rx2_strobe_out+
set_property -dict {PACKAGE_PIN N12   IOSTANDARD  LVDS}   [get_ports rx1_cssi_nc_lssi_strobe_n]       ; ##  H26  FMC_HPC0_LA21_N          IO_L21N_T3L_N5_AD8N_67        rx2_strobe_out-
set_property -dict {PACKAGE_PIN N13   IOSTANDARD  LVDS}   [get_ports rx1_cssi_data1_lssi_data0_p]     ; ##  G21  FMC_HPC0_LA20_P          IO_L22P_T3U_N6_DBC_AD0P_67    rx2_idata_out+
set_property -dict {PACKAGE_PIN M13   IOSTANDARD  LVDS}   [get_ports rx1_cssi_data0_lssi_data0_n]     ; ##  G22  FMC_HPC0_LA20_N          IO_L22N_T3U_N7_DBC_AD0N_67    rx2_idata_out-
set_property -dict {PACKAGE_PIN L13   IOSTANDARD  LVDS}   [get_ports rx1_cssi_data3_lssi_data1_p]     ; ##  H22  FMC_HPC0_LA19_P          IO_L23P_T3U_N8_67             rx2_qdata_out+
set_property -dict {PACKAGE_PIN K13   IOSTANDARD  LVDS}   [get_ports rx1_cssi_data2_lssi_data1_n]     ; ##  H23  FMC_HPC0_LA19_N          IO_L23N_T3U_N9_67             rx2_qdata_out-
set_property -dict {PACKAGE_PIN N9    IOSTANDARD  LVDS}   [get_ports tx1_cssi_refclk_lssi_refclk_p]   ; ##  C22  FMC_HPC0_LA18_CC_P       IO_L16P_T2U_N6_QBC_AD3P_67    dgpio_15_tx2_dclk_out+
set_property -dict {PACKAGE_PIN N8    IOSTANDARD  LVDS}   [get_ports tx1_cssi_nc_lssi_refclk_n]       ; ##  C23  FMC_HPC0_LA18_CC_N       IO_L16N_T2U_N7_QBC_AD3N_67    dgpio_14_tx2_dclk_out-
set_property -dict {PACKAGE_PIN M15   IOSTANDARD  LVDS}   [get_ports tx1_cssi_clk_lssi_clk_p]         ; ##  G24  FMC_HPC0_LA22_P          IO_L20P_T3L_N2_AD1P_67        tx2_dclk_in+
set_property -dict {PACKAGE_PIN M14   IOSTANDARD  LVDS}   [get_ports tx1_cssi_nc_lssi_clk_n]          ; ##  G25  FMC_HPC0_LA22_N          IO_L20N_T3L_N3_AD1N_67        tx2_dclk_in-
set_property -dict {PACKAGE_PIN L12   IOSTANDARD  LVDS}   [get_ports tx1_cssi_strobe_lssi_strobe_p]   ; ##  H28  FMC_HPC0_LA24_P          IO_L18P_T2U_N10_AD2P_67       tx2_strobe_in+
set_property -dict {PACKAGE_PIN K12   IOSTANDARD  LVDS}   [get_ports tx1_cssi_nc_lssi_strobe_n]       ; ##  H29  FMC_HPC0_LA24_N          IO_L18N_T2U_N11_AD2N_67       tx2_strobe_in-
set_property -dict {PACKAGE_PIN L16   IOSTANDARD  LVDS}   [get_ports tx1_cssi_data1_lssi_data0_p]     ; ##  D23  FMC_HPC0_LA23_P          IO_L19P_T3L_N0_DBC_AD9P_67    tx2_idata_in+
set_property -dict {PACKAGE_PIN K16   IOSTANDARD  LVDS}   [get_ports tx1_cssi_data0_lssi_data0_n]     ; ##  D24  FMC_HPC0_LA23_N          IO_L19N_T3L_N1_DBC_AD9N_67    tx2_idata_in-
set_property -dict {PACKAGE_PIN M11   IOSTANDARD  LVDS}   [get_ports tx1_cssi_data3_lssi_data1_p]     ; ##  G27  FMC_HPC0_LA25_P          IO_L17P_T2U_N8_AD10P_67       tx2_qdata_in+
set_property -dict {PACKAGE_PIN L11   IOSTANDARD  LVDS}   [get_ports tx1_cssi_data2_lssi_data1_n]     ; ##  G28  FMC_HPC0_LA25_N          IO_L17N_T2U_N9_AD10N_67       tx2_qdata_in-

set_property diff_term_adv term_100 [get_ports rx1_cssi_clk_lssi_clk_p]
set_property diff_term_adv term_100 [get_ports rx1_cssi_nc_lssi_clk_n]
set_property diff_term_adv term_100 [get_ports rx1_cssi_strobe_lssi_strobe_p]
set_property diff_term_adv term_100 [get_ports rx1_cssi_nc_lssi_strobe_n]
set_property diff_term_adv term_100 [get_ports rx1_cssi_data1_lssi_data0_p]
set_property diff_term_adv term_100 [get_ports rx1_cssi_data0_lssi_data0_n]
set_property diff_term_adv term_100 [get_ports rx1_cssi_data3_lssi_data1_p]
set_property diff_term_adv term_100 [get_ports rx1_cssi_data2_lssi_data1_n]
set_property diff_term_adv term_100 [get_ports tx1_cssi_refclk_lssi_refclk_p]
set_property diff_term_adv term_100 [get_ports tx1_cssi_nc_lssi_refclk_n]

create_clock -name rx1_clk_in -period 2.00 [get_ports rx1_cssi_clk_lssi_clk_p]
create_clock -name tx1_ref_clk_in -period 2.00 [get_ports tx1_cssi_refclk_lssi_refclk_p]

set_false_path -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk/CLR}]
set_false_path -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk_resetn/CLR}]

set_max_delay 2 -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk/CLR}]
set_max_delay 2 -to [get_pins -hier -filter {name =~ *axi_adrv9001*i_clk_resetn/CLR}]

## ##################################################################################
## ##################################################################################
