## ##################################################################################
## ##################################################################################
## ----------------------------------------------------------------------------------
## ################
## ##   ###########   Analog Devices Inc.
## ##      ########
## ##         #####   Copyright (c) 2019 Analog Devices Inc. All rights reserved.
## ##            ##   This file is the confidential and proprietary property of ADI.
## ##         #####   Possession or use of this file requires a written license.
## ##      ########   The licensing information may be found at: www.analog.com
## ##   ###########
## ################
## ----------------------------------------------------------------------------------
## Description:       ADRV9001 Embedded System Peripherals
## ----------------------------------------------------------------------------------
## ##################################################################################
## ##################################################################################

set_property config.num_of_slaves 3 [get_bd_cells axi_mspi]
set_property left 2 [get_bd_ports spi_ssn]

## ##################################################################################
## ##################################################################################
## AXI-ADRV9001

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_adrv9001 && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_adrv9001_1
set_property config.axi_adrv9001_instance_id 1 [get_bd_cells axi_adrv9001_1]
set_property config.axi_adrv9001_rx0_iodelay_ctrl_enable 0 [get_bd_cells axi_adrv9001_1]
make_bd_pins_external -name sys_1_ref_clk_p [get_bd_pins axi_adrv9001_1/sys_ref_clk_p]
make_bd_pins_external -name sys_1_ref_clk_n [get_bd_pins axi_adrv9001_1/sys_ref_clk_n]
make_bd_pins_external -name sys_1_mcs_in_p [get_bd_pins axi_adrv9001_1/sys_mcs_in_p]
make_bd_pins_external -name sys_1_mcs_in_n [get_bd_pins axi_adrv9001_1/sys_mcs_in_n]
make_bd_pins_external -name sys_1_mcs_out_p [get_bd_pins axi_adrv9001_1/sys_mcs_out_p]
make_bd_pins_external -name sys_1_mcs_out_n [get_bd_pins axi_adrv9001_1/sys_mcs_out_n]
make_bd_pins_external -name dio_1_rx0_cssi_clk_lssi_clk_p [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_clk_lssi_clk_p]
make_bd_pins_external -name dio_1_rx0_cssi_nc_lssi_clk_n [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_nc_lssi_clk_n]
make_bd_pins_external -name dio_1_rx0_cssi_strobe_lssi_strobe_p [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_strobe_lssi_strobe_p]
make_bd_pins_external -name dio_1_rx0_cssi_nc_lssi_strobe_n [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_nc_lssi_strobe_n]
make_bd_pins_external -name dio_1_rx0_cssi_data1_lssi_data0_p [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_data1_lssi_data0_p]
make_bd_pins_external -name dio_1_rx0_cssi_data0_lssi_data0_n [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_data0_lssi_data0_n]
make_bd_pins_external -name dio_1_rx0_cssi_data3_lssi_data1_p [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_data3_lssi_data1_p]
make_bd_pins_external -name dio_1_rx0_cssi_data2_lssi_data1_n [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_data2_lssi_data1_n]
make_bd_pins_external -name dio_1_rx0_cssi_gpio_in [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_gpio_in]
make_bd_pins_external -name dio_1_rx0_cssi_gpio_out [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_gpio_out]
make_bd_pins_external -name dio_1_rx0_cssi_gpio_enb [get_bd_pins axi_adrv9001_1/dio_rx0_cssi_gpio_enb]
make_bd_pins_external -name dio_1_rx1_cssi_clk_lssi_clk_p [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_clk_lssi_clk_p]
make_bd_pins_external -name dio_1_rx1_cssi_nc_lssi_clk_n [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_nc_lssi_clk_n]
make_bd_pins_external -name dio_1_rx1_cssi_strobe_lssi_strobe_p [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_strobe_lssi_strobe_p]
make_bd_pins_external -name dio_1_rx1_cssi_nc_lssi_strobe_n [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_nc_lssi_strobe_n]
make_bd_pins_external -name dio_1_rx1_cssi_data1_lssi_data0_p [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_data1_lssi_data0_p]
make_bd_pins_external -name dio_1_rx1_cssi_data0_lssi_data0_n [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_data0_lssi_data0_n]
make_bd_pins_external -name dio_1_rx1_cssi_data3_lssi_data1_p [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_data3_lssi_data1_p]
make_bd_pins_external -name dio_1_rx1_cssi_data2_lssi_data1_n [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_data2_lssi_data1_n]
make_bd_pins_external -name dio_1_rx1_cssi_gpio_in [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_gpio_in]
make_bd_pins_external -name dio_1_rx1_cssi_gpio_out [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_gpio_out]
make_bd_pins_external -name dio_1_rx1_cssi_gpio_enb [get_bd_pins axi_adrv9001_1/dio_rx1_cssi_gpio_enb]
make_bd_pins_external -name dio_1_tx0_cssi_refclk_lssi_refclk_p [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_refclk_lssi_refclk_p]
make_bd_pins_external -name dio_1_tx0_cssi_nc_lssi_refclk_n [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_nc_lssi_refclk_n]
make_bd_pins_external -name dio_1_tx0_cssi_clk_lssi_clk_p [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_clk_lssi_clk_p]
make_bd_pins_external -name dio_1_tx0_cssi_nc_lssi_clk_n [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_nc_lssi_clk_n]
make_bd_pins_external -name dio_1_tx0_cssi_strobe_lssi_strobe_p [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_strobe_lssi_strobe_p]
make_bd_pins_external -name dio_1_tx0_cssi_nc_lssi_strobe_n [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_nc_lssi_strobe_n]
make_bd_pins_external -name dio_1_tx0_cssi_data1_lssi_data0_p [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_data1_lssi_data0_p]
make_bd_pins_external -name dio_1_tx0_cssi_data0_lssi_data0_n [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_data0_lssi_data0_n]
make_bd_pins_external -name dio_1_tx0_cssi_data3_lssi_data1_p [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_data3_lssi_data1_p]
make_bd_pins_external -name dio_1_tx0_cssi_data2_lssi_data1_n [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_data2_lssi_data1_n]
make_bd_pins_external -name dio_1_tx0_cssi_gpio_in [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_gpio_in]
make_bd_pins_external -name dio_1_tx0_cssi_gpio_out [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_gpio_out]
make_bd_pins_external -name dio_1_tx0_cssi_gpio_enb [get_bd_pins axi_adrv9001_1/dio_tx0_cssi_gpio_enb]
make_bd_pins_external -name dio_1_tx1_cssi_refclk_lssi_refclk_p [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_refclk_lssi_refclk_p]
make_bd_pins_external -name dio_1_tx1_cssi_nc_lssi_refclk_n [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_nc_lssi_refclk_n]
make_bd_pins_external -name dio_1_tx1_cssi_clk_lssi_clk_p [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_clk_lssi_clk_p]
make_bd_pins_external -name dio_1_tx1_cssi_nc_lssi_clk_n [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_nc_lssi_clk_n]
make_bd_pins_external -name dio_1_tx1_cssi_strobe_lssi_strobe_p [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_strobe_lssi_strobe_p]
make_bd_pins_external -name dio_1_tx1_cssi_nc_lssi_strobe_n [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_nc_lssi_strobe_n]
make_bd_pins_external -name dio_1_tx1_cssi_data1_lssi_data0_p [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_data1_lssi_data0_p]
make_bd_pins_external -name dio_1_tx1_cssi_data0_lssi_data0_n [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_data0_lssi_data0_n]
make_bd_pins_external -name dio_1_tx1_cssi_data3_lssi_data1_p [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_data3_lssi_data1_p]
make_bd_pins_external -name dio_1_tx1_cssi_data2_lssi_data1_n [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_data2_lssi_data1_n]
make_bd_pins_external -name dio_1_tx1_cssi_gpio_in [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_gpio_in]
make_bd_pins_external -name dio_1_tx1_cssi_gpio_out [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_gpio_out]
make_bd_pins_external -name dio_1_tx1_cssi_gpio_enb [get_bd_pins axi_adrv9001_1/dio_tx1_cssi_gpio_enb]
make_bd_pins_external -name dio_1_rx0_enable [get_bd_pins axi_adrv9001_1/dio_rx0_enable]
make_bd_pins_external -name dio_1_rx1_enable [get_bd_pins axi_adrv9001_1/dio_rx1_enable]
make_bd_pins_external -name dio_1_tx0_enable [get_bd_pins axi_adrv9001_1/dio_tx0_enable]
make_bd_pins_external -name dio_1_tx1_enable [get_bd_pins axi_adrv9001_1/dio_tx1_enable]
make_bd_pins_external -name dio_1_dgpio [get_bd_pins axi_adrv9001_1/dio_dgpio]
make_bd_pins_external -name dio_1_mode [get_bd_pins axi_adrv9001_1/dio_mode]
make_bd_pins_external -name dio_1_resetb [get_bd_pins axi_adrv9001_1/dio_resetb]
make_bd_pins_external -name dio_1_gp_int [get_bd_pins axi_adrv9001_1/dio_gp_int]
make_bd_pins_external -name dio_1_dev_clk [get_bd_pins axi_adrv9001_1/dio_dev_clk]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_adrv9001_1/gpio_clk]
connect_bd_net [get_bd_pins axi_adrv9001/dev_out_clk] [get_bd_pins axi_adrv9001_1/dev_clk]
connect_bd_net [get_bd_pins axi_adrv9001/mcs_int_out] [get_bd_pins axi_adrv9001_1/mcs_int_in]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk] [get_bd_pins axi_adrv9001_1/tdd_clk]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_resetn] [get_bd_pins axi_adrv9001_1/tdd_resetn]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_genb] [get_bd_pins axi_adrv9001_1/tdd_genb]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_state] [get_bd_pins axi_adrv9001_1/tdd_state]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_last] [get_bd_pins axi_adrv9001_1/tdd_last]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_clk_cnt] [get_bd_pins axi_adrv9001_1/tdd_clk_cnt]
connect_bd_net [get_bd_pins axi_adrv9001/tdd_out_frm_cnt] [get_bd_pins axi_adrv9001_1/tdd_frm_cnt]
connect_bd_net [get_bd_pins axi_adrv9001/tx_menb_out] [get_bd_pins axi_adrv9001_1/tx_menb_in]
connect_bd_net [get_bd_pins axi_adrv9001/rx_menb_out] [get_bd_pins axi_adrv9001_1/rx_menb_in]
connect_bd_net [get_bd_pins axi_adrv9001/orx_menb_out] [get_bd_pins axi_adrv9001_1/orx_menb_in]
connect_bd_net -net sys_delay_clk [get_bd_pins axi_adrv9001_1/sys_delay_clk]
connect_bd_net -net axilite_clk [get_bd_pins axi_adrv9001_1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_adrv9001_1/axilite_resetn]
add_axilite_peripheral axi_adrv9001_1/axilite
add_cpu_addrmap axi_adrv9001_1
add_interrupt axi_adrv9001_1/axilite_intr

## ##################################################################################
## ##################################################################################
## TX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_tx0
set_property config.instance_id 10 [get_bd_cells axi_dma_1_tx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_tx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx0_clk] [get_bd_pins axi_dma_1_tx0/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx0_resetn] [get_bd_pins axi_dma_1_tx0/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/tx0] [get_bd_intf_pins axi_dma_1_tx0/tx]
connect_bd_net [get_bd_pins axi_dma_tx0/tx_mtrig_out] [get_bd_pins axi_dma_1_tx0/tx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_tx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_tx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_tx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_tx0/aximm_resetn]
add_axilite_peripheral axi_dma_1_tx0/axilite
add_cpu_addrmap axi_dma_1_tx0
add_aximm_peripheral axi_dma_1_tx0/aximm
add_interrupt axi_dma_1_tx0/axilite_intr

## ##################################################################################
## ##################################################################################
## TX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_txdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_tx1
set_property config.instance_id 11 [get_bd_cells axi_dma_1_tx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_tx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx1_clk] [get_bd_pins axi_dma_1_tx1/tx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/tx1_resetn] [get_bd_pins axi_dma_1_tx1/tx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/tx1] [get_bd_intf_pins axi_dma_1_tx1/tx]
connect_bd_net [get_bd_pins axi_dma_tx1/tx_mtrig_out] [get_bd_pins axi_dma_1_tx1/tx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_tx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_tx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_tx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_tx1/aximm_resetn]
add_axilite_peripheral axi_dma_1_tx1/axilite
add_cpu_addrmap axi_dma_1_tx1
add_aximm_peripheral axi_dma_1_tx1/aximm
add_interrupt axi_dma_1_tx1/axilite_intr

## ##################################################################################
## ##################################################################################
## RX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_rx0
set_property config.instance_id 12 [get_bd_cells axi_dma_1_rx0]
set_property config.rsd_dw 64 [get_bd_cells axi_dma_1_rx0]
set_property config.axis_dw 64 [get_bd_cells axi_dma_1_rx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_rx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_clk] [get_bd_pins axi_dma_1_rx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_resetn] [get_bd_pins axi_dma_1_rx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/rx0] [get_bd_intf_pins axi_dma_1_rx0/rx]
connect_bd_net [get_bd_pins axi_dma_rx0/rx_mtrig_out] [get_bd_pins axi_dma_1_rx0/rx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_rx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_rx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_rx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_rx0/aximm_resetn]
add_axilite_peripheral axi_dma_1_rx0/axilite
add_cpu_addrmap axi_dma_1_rx0
add_aximm_peripheral axi_dma_1_rx0/aximm
add_interrupt axi_dma_1_rx0/axilite_intr

## ##################################################################################
## ##################################################################################
## RX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_rx1
set_property config.instance_id 13 [get_bd_cells axi_dma_1_rx1]
set_property config.rsd_dw 64 [get_bd_cells axi_dma_1_rx1]
set_property config.axis_dw 64 [get_bd_cells axi_dma_1_rx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_rx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_clk] [get_bd_pins axi_dma_1_rx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_resetn] [get_bd_pins axi_dma_1_rx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/rx1] [get_bd_intf_pins axi_dma_1_rx1/rx]
connect_bd_net [get_bd_pins axi_dma_rx1/rx_mtrig_out] [get_bd_pins axi_dma_1_rx1/rx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_rx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_rx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_rx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_rx1/aximm_resetn]
add_axilite_peripheral axi_dma_1_rx1/axilite
add_cpu_addrmap axi_dma_1_rx1
add_aximm_peripheral axi_dma_1_rx1/aximm
add_interrupt axi_dma_1_rx1/axilite_intr

## ##################################################################################
## ##################################################################################
## ORX0-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_orx0
set_property config.instance_id 14 [get_bd_cells axi_dma_1_orx0]
set_property config.rsd_dw 64 [get_bd_cells axi_dma_1_orx0]
set_property config.axis_dw 64 [get_bd_cells axi_dma_1_orx0]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_orx0/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_clk] [get_bd_pins axi_dma_1_orx0/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx0_resetn] [get_bd_pins axi_dma_1_orx0/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/orx0] [get_bd_intf_pins axi_dma_1_orx0/rx]
connect_bd_net [get_bd_pins axi_dma_orx0/rx_mtrig_out] [get_bd_pins axi_dma_1_orx0/rx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_orx0/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_orx0/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_orx0/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_orx0/aximm_resetn]
add_axilite_peripheral axi_dma_1_orx0/axilite
add_cpu_addrmap axi_dma_1_orx0
add_aximm_peripheral axi_dma_1_orx0/aximm
add_interrupt axi_dma_1_orx0/axilite_intr

## ##################################################################################
## ##################################################################################
## ORX1-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_orx1
set_property config.instance_id 15 [get_bd_cells axi_dma_1_orx1]
set_property config.rsd_dw 64 [get_bd_cells axi_dma_1_orx1]
set_property config.axis_dw 64 [get_bd_cells axi_dma_1_orx1]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_orx1/trig]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_clk] [get_bd_pins axi_dma_1_orx1/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001_1/rx1_resetn] [get_bd_pins axi_dma_1_orx1/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/orx1] [get_bd_intf_pins axi_dma_1_orx1/rx]
connect_bd_net [get_bd_pins axi_dma_orx1/rx_mtrig_out] [get_bd_pins axi_dma_1_orx1/rx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_orx1/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_orx1/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_orx1/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_orx1/aximm_resetn]
add_axilite_peripheral axi_dma_1_orx1/axilite
add_cpu_addrmap axi_dma_1_orx1
add_aximm_peripheral axi_dma_1_orx1/aximm
add_interrupt axi_dma_1_orx1/axilite_intr

## ##################################################################################
## ##################################################################################
## GAIN-DMA

set ip_vlnv [get_ipdefs -all -filter {name =~ axi_rxdma && upgrade_versions == ""}]
create_bd_cell -type ip -vlnv $ip_vlnv axi_dma_1_gain
set_property config.instance_id 16 [get_bd_cells axi_dma_1_gain]
set_property config.rsd_dw 8 [get_bd_cells axi_dma_1_gain]
set_property config.axis_dw 8 [get_bd_cells axi_dma_1_gain]
connect_bd_net [get_bd_pins axi_adrv9001/trig_out] [get_bd_pins axi_dma_1_gain/trig]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_out_clk] [get_bd_pins axi_dma_1_gain/rx_clk]
connect_bd_net [get_bd_pins axi_adrv9001/gpio_resetn] [get_bd_pins axi_dma_1_gain/rx_resetn]
connect_bd_intf_net [get_bd_intf_pins axi_adrv9001_1/gpio_gain] [get_bd_intf_pins axi_dma_1_gain/rx]
connect_bd_net [get_bd_pins axi_dma_1_gain/rx_mtrig_out] [get_bd_pins axi_dma_1_gain/rx_mtrig_in]
connect_bd_net -net axilite_clk [get_bd_pins axi_dma_1_gain/axilite_clk]
connect_bd_net -net axilite_resetn [get_bd_pins axi_dma_1_gain/axilite_resetn]
connect_bd_net -net aximm_clk [get_bd_pins axi_dma_1_gain/aximm_clk]
connect_bd_net -net aximm_resetn [get_bd_pins axi_dma_1_gain/aximm_resetn]
add_axilite_peripheral axi_dma_1_gain/axilite
add_cpu_addrmap axi_dma_1_gain
add_aximm_peripheral axi_dma_1_gain/aximm
add_interrupt axi_dma_1_gain/axilite_intr

## ##################################################################################
## ##################################################################################

