# ADRV9001 Projects

## Contents

* [Introduction](#introduction)
* [Features](#features)
* [Hardware](#hardware)
* [Building and running](#build)
* [HDL](#hdl)
  * [Address and Interrupt Map](#hdl-map)
  * [Base System](#hdl-base)
  * [ADRV9001 Add-On System](#hdl-add-on)
* [Software](#software)

## <a name="introduction"></a>Introduction

This document is intended to provide a general overview of the ADRV9001 evaluation platforms. It consists of the following hardware components and engineering disciplines. Its main purpose is to provide an evaluation platform for the ADRV9001 device using commercially available development systems from IntelFPGA and/or Xilinx. As such, it leverages as much as possible, the vendor provided cores, drivers and infrastructure. Thus, while the underlying hardware and HDL design supports a complete system level prototype, the overall portability experience may appear rudimentary, especially to avid software experts.

## <a name="features"></a>Features

* Embedded system architecture with IP peripherals, allows plug-n-play.
* Interfaces to ADRV9001, and provides a simple digital samples interface in HDL and software.
* Programmable internal clocks (GPIO, MCS and TDD).
* Master/slave, multiple instances and ssi interfaces.
* 2 Receive, 2 Transmit and 2 Observation channels.
* Long, short strobes for samples delineation.
* Single and double data rates.
* 1, 2 and 4  lanes. 
* 2, 8, 16, 24, 32 and 64 bits.
* Transmit clock select between reference and receive clocks.
* Interface delay calibration for optimal sampling.
* Multi-chip synchronization.
* Receive MCS to strobe latency reporting.
* Transmit MCS to strobe latecny programming.
* Transmit to receive loopback latency measurement.
* Test patterns monitoring and generation.
* Programmable enable generation.
* Synchronous capture and tramsit across all channels.
* Multiple trigger mechanism (MCS, GPIO, SMA, TDD).
* GPIO gain capture.
* GPIO slave SPI.
* Fast frequency hopping, spi AXIMM interface.
* Fully programmable DMA, streaming mode.
* LVDS and CMOS modes.

## <a name="hardware"></a>Hardware

The hardware components of this system include the following:

1. One of the following development boards
   1. Xilinx [ZCU102](https://www.xilinx.com/products/boards-and-kits/ek-u1-zcu102-g.html)
   2. Xilinx [ZC706](https://www.xilinx.com/products/boards-and-kits/ek-z7-zc706-g.html)
   3. IntelFPGA [Arria 10 SoC](https://www.intel.com/content/www/us/en/programmable/products/boards_and_kits/dev-kits/altera/arria-10-soc-development-kit.html)
2. ADRV9001 FMC evaluation board

* The Xilinx Zynq device featured in ZC706 do NOT support the IO voltage specifications of ADRV9001, use it at your own risk.
* The IntelFPGA Arria 10 SoC development board is NOT fully FMC standard compliant, only a subset of the features of the device and interface core can be used.

The FPGA hosts the linux operating system and the interface core for the ADRV9001 device. It also provides the necessary frame work to setup, monitor and data transfer between a remote host and the device.

## <a name="build"></a>Building and running

To build all supported platforms and projects:

```
[some-directory] unzip <downloaded-repository-zip-file>
[some-directory] make
```

To build specific platform/projects:

```
[some-directory] unzip <downloaded-repository-zip-file>
[some-directory] make -C projects/adrv9001_zc706/hdl
```

You may also build specific configurations:

```
[some-directory] make -C projects/adrv9001_zc706/hdl lvds
```

This assumes your OS supports unzip, make, perl, TCL, Xilinx Vivado or IntelFPGA Quartus. The setup of your OS enviornment to support the build process is beyond the scope of this user guide.

As of this writing, we are using Vivado version 2019.2.1.

## <a name="hdl"></a>HDL

The FPGA design, and thus the platform, is an embedded system design. The main processor is a variant of the ARM core. In Xilinx devices, this is referred to as processing system (PS) and in IntelFPGA devices, hard processor system (HPS). This includes commonly used peripherals, such as DDR, IIC, USB, Ethernet, and Interrupt Controller.

The HDL design consists of two parts.
1. Base design, carrier specific (ZCU102, ZC706, or Arria 10 Soc)
2. Add-On design, ADRV9001 specific (interface and DMA cores)

The integrated design architecture along with the address maps and interrupt tree is shown below. The base and add-on designs are independently structured such that the add-on system may be ported to a different base system easily.

![ADRV9001 Platform Block Diagram](docs/adrv9001_platform.png)

Notes:

1. This is a conceptual block diagram with a small amount of artistic freedom.
2. The AXI is a point to point interconnect and is not a bus.
3. Some of these instances may or may not be present in a platform.
4. The complete list of instances, their address map and interrupt numbers are given in the table below.
5. In most cases, interconnect ports are limitted to 16, and some projects may have cascaded interconnects.
6. The interrupt also has a limitation of 16, if the project instantiates more than 16 peripherals, an interrupt controller is used.

### <a name="hdl-map"></a>Address and Interrupt Map

---
| Instance        | ADRV9001-ZC706     | ADRV9001-x2-ZC706  |
| --------------- | ------------------ | ------------------ |
| PL-DDR          | 0x80000000 (NA)    | 0x80000000 (NA)    |
| AXI-MSPI        | 0x44a00000 (0)     | 0x44a00000 (0)     |
| AXI-SYSID       | 0x43000000 (1)     | 0x43000000 (1)     |
| AXI-ADRV9001    | 0x43010000 (2)     | 0x43010000 (2)     |
| AXI-DMA-TX0     | 0x43020000 (3)     | 0x43020000 (3)     |
| AXI-DMA-TX1     | 0x43030000 (4)     | 0x43030000 (4)     |
| AXI-DMA-RX0     | 0x43040000 (5)     | 0x43040000 (5)     |
| AXI-DMA-RX1     | 0x43050000 (6)     | 0x43050000 (6)     |
| AXI-DMA-ORX0    | 0x43060000 (7)     | 0x43060000 (7)     |
| AXI-DMA-ORX1    | 0x43070000 (8)     | 0x43070000 (8)     |
| AXI-DMA-GAIN    | 0x43080000 (9)     | 0x43080000 (9)     |
| AXI-CLKGEN      | 0x43100000 (10)    | 0x43100000 (10)    |
| AXI-ADRV9001-1  | NA                 | 0x43110000 (11.0)  |
| AXI-DMA-TX0-1   | NA                 | 0x43120000 (11.1)  |
| AXI-DMA-TX1-1   | NA                 | 0x43130000 (11.2)  |
| AXI-DMA-RX0-1   | NA                 | 0x43140000 (11.3)  |
| AXI-DMA-RX1-1   | NA                 | 0x43150000 (11.4)  |
| AXI-DMA-ORX0-1  | NA                 | 0x43160000 (11.5)  |
| AXI-DMA-ORX1-1  | NA                 | 0x43170000 (11.6)  |
| AXI-DMA-GAIN-1  | NA                 | 0x43180000 (11.7)  |

---

### <a name="hdl-base"></a>Base System

This consists of the processing core and all peripheral associated with this carrier. It is one of the following (detailed documentation may be found in the provided links):

1. [Zynq Processing System 7](https://www.xilinx.com/products/intellectual-property/processing_system7.html)
2. [Zynq UltraScale+ MPSoC Processing System IP](https://www.xilinx.com/products/intellectual-property/zynq-ultra-ps-e.html)
3. [Intel Arria 10 Hard Processor System](https://www.intel.com/content/www/us/en/programmable/documentation/sfo1410070178831.html)
4. [MicroBlaze](https://www.xilinx.com/products/intellectual-property/microblazecore.html)
5. [NIOS-II](https://www.intel.com/content/www/us/en/products/programmable/processor/nios-ii.html)

In some of the development boards, the fabric supports its own DDR interface. In these boards, the fabric DDR controller is used as the data memory and the processor DDR controller is dedicated to other peripherals. The DDR controller is the device vendor IP core (detailed documentation may be found in the provided links).

1. [Xilinx MIG Controller](https://www.xilinx.com/products/intellectual-property/mig.html)
2. [IntelFPGA External Memory Interface](https://www.intel.com/content/www/us/en/programmable/support/support-resources/external-memory.html)

### <a name="hdl-add-on"></a>ADRV9001 Add-On System

The ADRV9001 add-on system consists of peripheral cores dedicated to the evaluation of the device. It has the following IP cores.

1. [AXI\_MSPI](../../library/axi_mspi/README.md) handles the SPI interface to the device.
2. [AXI\_ADRV9001](../../library/axi_adrv9001/README.md) interfaces to the non-SPI I/O of the device. It is complementary to the device in functionality and provides a simple AXIS interface for the digital samples. All the platform requires is the DMA cores to stream data in and out of the DDR memory.
3. [AXI\_TXDMA](../../library/axi_txdma/README.md) streams data from DDR memory to the AXI\_ADRV9001 core. There are two TXDMA instances one for each of the channels supported by the device.
4. [AXI\_RXDMA](../../library/axi_rxdma/README.md) receives digital samples from the AXI\_ADRV9001 interface and streams them to the DDR memory. There are five instances of RXDMA core in the design. They corresponds to the two channels in the device, two optional observation path channels and one for the GPIO based AGC data.
5. [AXI\_SYSID](../../library/axi_sysid/README.md) is a passive system identification peripheral mainly for handling of general purpose IO, build and platform identification. The build ID is auto generated everytime a compilation is required. It also handles the platform VERSION independent of the individual IP core versions.

## <a name="software"></a>Software

